/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.drawing.geometry.TSExpTransform;
import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.event.TSEPropertyChangeEvent;
import com.tomsawyer.editor.event.TSEPropertyChangeEventData;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.inspector.TSEInspectable;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.event.TSChildEventSource;
import com.tomsawyer.util.TSProperty;
import com.tomsawyer.util.TSSystem;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public abstract class TSEObjectUI
implements Cloneable,
TSEInspectable,
TSChildEventSource {
    public static final TSEColor DEFAULT_SELECTED_COLOR = new TSEColor(new Color(0, 153, 255));
    TSEColor selectedColor = null;

    public TSEObjectUI() {
        this.reset();
    }

    public void reset() {
        this.setSelectedColor(this.getDefaultSelectedColor());
    }

    protected abstract void nullifyOwner();

    public Object clone() {
        try {
            TSEObjectUI tSEObjectUI = (TSEObjectUI)super.clone();
            tSEObjectUI.nullifyOwner();
            tSEObjectUI.reset();
            tSEObjectUI.copy(this);
            return tSEObjectUI;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        if (!tSEObjectUI.getClass().isInstance(this)) {
            throw new ClassCastException(tSEObjectUI.getClass().getName());
        }
        this.setSelectedColor(tSEObjectUI.getSelectedColor());
    }

    public void onOwnerInserted() {
    }

    public void onOwnerRemoved() {
    }

    public void onOwnerDiscarded() {
    }

    public abstract void draw(TSEGraphics var1);

    public abstract void drawSelected(TSEGraphics var1);

    public abstract void drawOutline(TSEGraphics var1);

    public abstract void drawSelectedOutline(TSEGraphics var1);

    public abstract TSEObject getOwner();

    public abstract double getLeft();

    public abstract double getRight();

    public abstract double getTop();

    public abstract double getBottom();

    public double getWidth() {
        return this.getRight() - this.getLeft();
    }

    public double getHeight() {
        return this.getTop() - this.getBottom();
    }

    public double getCenterX() {
        return this.getLeft() + this.getWidth() / 2.0;
    }

    public double getCenterY() {
        return this.getBottom() + this.getHeight() / 2.0;
    }

    public TSConstSize getSize() {
        return new TSConstSize(this.getWidth(), this.getHeight());
    }

    public TSConstRect getBounds() {
        return new TSConstRect(this.getLeft(), this.getBottom(), this.getRight(), this.getTop());
    }

    public abstract TSConstRect getInvalidRegion(TSTransform var1, TSExpTransform var2);

    public abstract boolean intersects(double var1, double var3, double var5, double var7);

    public boolean intersects(TSConstRect tSConstRect) {
        return this.intersects(tSConstRect.getLeft(), tSConstRect.getBottom(), tSConstRect.getRight(), tSConstRect.getTop());
    }

    public TSTransform getLocalToMainGraphWindowTransform() {
        if (this.getOwner() == null) {
            throw new IllegalStateException("UI has no owner");
        }
        TSEGraph tSEGraph = (TSEGraph)this.getOwner().getOwnerGraph();
        if (tSEGraph == null) {
            throw new IllegalStateException("UI's owner not in graph");
        }
        TSEGraph tSEGraph2 = (TSEGraph)tSEGraph.getMainDisplayGraph();
        if (tSEGraph2 == null) {
            throw new IllegalStateException("main display graph not available from graph");
        }
        if (tSEGraph2.getGraphWindow() == null) {
            throw new IllegalStateException("graph window not available from main display graph");
        }
        return TSTransform.compose(tSEGraph2.getGraphWindow().getTransform(), tSEGraph.getLocalToMainDisplayGraphTransform());
    }

    public void getInspectorPropertyIDs(List list) {
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        return null;
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        return 0;
    }

    public List getProperties() {
        return new Vector();
    }

    public TSProperty getProperty(String string) {
        if (string == null) {
            return null;
        }
        Iterator iterator = this.getProperties().iterator();
        while (iterator.hasNext()) {
            TSProperty tSProperty = (TSProperty)iterator.next();
            if (!string.equals(tSProperty.getName())) continue;
            return tSProperty;
        }
        return null;
    }

    public List getChangedProperties() {
        return new Vector();
    }

    public void setProperty(TSProperty tSProperty) {
    }

    public void firePropertyChangedEvent(String string, Object object, Object object2) {
        if (this.getOwner() != null && this.getOwner().getOwnerGraph() != null && !TSSystem.equals(object, object2)) {
            this.getOwner().getOwnerGraph().fireEvent(new TSEPropertyChangeEvent(1L, new TSEPropertyChangeEventData(this, new TSProperty(string, object), new TSProperty(string, object2))));
        }
    }

    public Object getParentEventSource() {
        return this.getOwner();
    }

    public TSEColor parseColor(String string) {
        TSEColor tSEColor = string.startsWith("#") ? new TSEColor(Color.decode(string)) : new TSEColor(string);
        return tSEColor;
    }

    public TSEColor getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(TSEColor tSEColor) {
        this.selectedColor = tSEColor;
    }

    public TSEColor getDefaultSelectedColor() {
        return DEFAULT_SELECTED_COLOR;
    }
}

