/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.drawing.TSNodeLabel;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.drawing.geometry.TSSize;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEResourceBundleWrapper;
import com.tomsawyer.editor.TSESolidObject;
import com.tomsawyer.editor.event.TSEPropertyChangeEvent;
import com.tomsawyer.editor.event.TSEPropertyChangeEventData;
import com.tomsawyer.editor.event.TSESelectionChangeEvent;
import com.tomsawyer.editor.event.TSESelectionChangeEventData;
import com.tomsawyer.editor.g9;
import com.tomsawyer.editor.inspector.TSEInspectable;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorProperty;
import com.tomsawyer.editor.inspector.TSENumericInspectorProperty;
import com.tomsawyer.editor.ui.TSEDefaultLabelUI;
import com.tomsawyer.editor.ui.TSELabelUI;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.TSSystem;
import java.net.URL;
import java.util.List;

public class TSENodeLabel
extends TSNodeLabel
implements TSESolidObject,
TSEInspectable {
    public static TSEInspectorPropertyID NAME_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Name"), class$java$lang$String == null ? (class$java$lang$String = TSENodeLabel.class$("java.lang.String")) : class$java$lang$String);
    public static TSEInspectorPropertyID URL_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("URL"), class$java$lang$String == null ? (class$java$lang$String = TSENodeLabel.class$("java.lang.String")) : class$java$lang$String);
    public static TSEInspectorPropertyID X_CENTER_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("X_Center"), class$java$lang$Double == null ? (class$java$lang$Double = TSENodeLabel.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID Y_CENTER_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Y_Center"), class$java$lang$Double == null ? (class$java$lang$Double = TSENodeLabel.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID WIDTH_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Width"), class$java$lang$Double == null ? (class$java$lang$Double = TSENodeLabel.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID HEIGHT_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Height"), class$java$lang$Double == null ? (class$java$lang$Double = TSENodeLabel.class$("java.lang.Double")) : class$java$lang$Double);
    public static TSEInspectorPropertyID RESIZABILITY_ID = new TSEInspectorPropertyID(TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Resizability"), class$java$lang$Integer == null ? (class$java$lang$Integer = TSENodeLabel.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static final String NO_FIT_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("No_Fit");
    public static final String TIGHT_FIT_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Tight_Fit");
    public static final String TIGHT_WIDTH_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Tight_Width");
    public static final String TIGHT_HEIGHT_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Tight_Height");
    public static final String TIGHT_FIT_PRESERVE_ASPECT_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Tight_Fit_Preserve_Aspect");
    public static final String PRESERVE_ASPECT_STRING = TSEResourceBundleWrapper.getSystemLabelBundle().getStringSafely("Preserve_Aspect");
    TSELabelUI labelUI;
    boolean selected;
    boolean dragged;
    double aspectRatio;
    int resizability;
    URL url;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Integer;

    protected TSENodeLabel() {
    }

    protected void initGraphObject() {
        super.initGraphObject();
        this.setResizability(this.getDefaultResizability());
        this.setUI(this.newLabelUI());
    }

    protected TSELabelUI newLabelUI() {
        return new TSEDefaultLabelUI();
    }

    public TSEObjectUI getUI() {
        return this.labelUI;
    }

    public TSELabelUI getLabelUI() {
        return this.labelUI;
    }

    public void setUI(TSEObjectUI tSEObjectUI) {
        if (tSEObjectUI instanceof TSELabelUI) {
            this.labelUI = (TSELabelUI)tSEObjectUI;
            this.labelUI.setOwner(this);
        }
    }

    public void setTag(Object object) {
        super.setTag(object);
        if (this.labelUI != null) {
            this.labelUI.onTextChanged(this.getText());
        }
    }

    public void onInsert(TSGraphObject tSGraphObject) {
        super.onInsert(tSGraphObject);
        if (this.getUI() != null) {
            this.getUI().onOwnerInserted();
        }
    }

    public void onRemove(TSGraphObject tSGraphObject) {
        this.setSelected(false);
        if (this.getUI() != null) {
            this.getUI().onOwnerRemoved();
        }
        super.onRemove(tSGraphObject);
    }

    public void onDiscard(TSGraphObject tSGraphObject) {
        if (this.getUI() != null) {
            this.getUI().onOwnerDiscarded();
        }
        super.onDiscard(tSGraphObject);
    }

    public void setSelected(boolean bl) {
        if (bl == this.selected || bl && !this.isViewable()) {
            return;
        }
        TSENode tSENode = (TSENode)this.getOwner();
        if (tSENode == null) {
            throw new IllegalStateException("label has no owner");
        }
        TSEGraph tSEGraph = (TSEGraph)tSENode.getOwner();
        if (tSEGraph == null) {
            throw new IllegalStateException("owner node has no owner");
        }
        TSESelectionChangeEvent tSESelectionChangeEvent = new TSESelectionChangeEvent(8L, new TSESelectionChangeEventData(this, bl));
        if (tSEGraph.fireEvent(tSESelectionChangeEvent, true)) {
            if (bl) {
                this.selected = true;
                tSEGraph.selectedNodeLabelsList.add(this);
            } else {
                this.selected = false;
                tSEGraph.selectedNodeLabelsList.remove(this);
            }
            tSEGraph.fireEvent(tSESelectionChangeEvent);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setDragged(boolean bl) {
        this.dragged = bl;
    }

    public boolean isDragged() {
        return this.dragged;
    }

    public void copy(Object object, boolean bl) {
        super.copy(object, bl);
        if (object instanceof TSENodeLabel) {
            TSENodeLabel tSENodeLabel = (TSENodeLabel)object;
            this.url = tSENodeLabel.getURL();
            this.setResizability(tSENodeLabel.getResizability());
            boolean bl2 = (this.getResizability() & 0x1000000) != 0;
            this.setResizability(this.getResizability() | 0x1000000);
            this.setUI((TSELabelUI)tSENodeLabel.getUI().clone());
            if (!bl2) {
                this.setResizability(this.getResizability() & ~0x1000000);
            }
        }
        this.selected = false;
        this.dragged = false;
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(NAME_ID);
        list.add(URL_ID);
        if (this.labelUI != null) {
            this.labelUI.getInspectorPropertyIDs(list);
        }
        if ((this.getResizability() & 0x1000000) == 0) {
            list.add(RESIZABILITY_ID);
        }
        list.add(WIDTH_ID);
        list.add(HEIGHT_ID);
        list.add(X_CENTER_ID);
        list.add(Y_CENTER_ID);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        TSEInspectorProperty tSEInspectorProperty;
        if (tSEInspectorPropertyID.equals(NAME_ID)) {
            return new TSEInspectorProperty(this.getText());
        }
        if (tSEInspectorPropertyID.equals(URL_ID)) {
            if (this.getURL() != null) {
                return new TSEInspectorProperty(this.getURL().toExternalForm());
            }
            return new TSEInspectorProperty(new String());
        }
        if (this.labelUI != null && (tSEInspectorProperty = this.labelUI.getInspectorProperty(tSEInspectorPropertyID)) != null) {
            return tSEInspectorProperty;
        }
        if (tSEInspectorPropertyID.equals(RESIZABILITY_ID)) {
            tSEInspectorProperty = new g9(this);
            ((TSEKeyValueInspectorProperty)tSEInspectorProperty).put(NO_FIT_STRING, new Integer(0));
            ((TSEKeyValueInspectorProperty)tSEInspectorProperty).put(TIGHT_FIT_STRING, new Integer(1 | 2));
            ((TSEKeyValueInspectorProperty)tSEInspectorProperty).put(TIGHT_WIDTH_STRING, new Integer(1));
            ((TSEKeyValueInspectorProperty)tSEInspectorProperty).put(TIGHT_HEIGHT_STRING, new Integer(2));
            ((TSEKeyValueInspectorProperty)tSEInspectorProperty).put(TIGHT_FIT_PRESERVE_ASPECT_STRING, new Integer(1 | 2 | 4));
            ((TSEKeyValueInspectorProperty)tSEInspectorProperty).put(PRESERVE_ASPECT_STRING, new Integer(4));
            return tSEInspectorProperty;
        }
        if (tSEInspectorPropertyID.equals(X_CENTER_ID)) {
            return new TSENumericInspectorProperty((Number)new Double(this.getLocalCenterX()), new Double(-999999.0), new Double(999999.0));
        }
        if (tSEInspectorPropertyID.equals(Y_CENTER_ID)) {
            return new TSENumericInspectorProperty((Number)new Double(this.getLocalCenterY()), new Double(-999999.0), new Double(999999.0));
        }
        if (tSEInspectorPropertyID.equals(WIDTH_ID)) {
            int n = this.getResizability();
            if ((n & 0x1000000) != 0 || (n & 1) != 0) {
                return new TSEInspectorProperty((Object)new Double(this.getLocalWidth()), false);
            }
            return new TSENumericInspectorProperty((Number)new Double(this.getLocalWidth()), new Double(this.getMinimumWidth()), new Double(99999.0));
        }
        if (tSEInspectorPropertyID.equals(HEIGHT_ID)) {
            int n = this.getResizability();
            if ((n & 0x1000000) != 0 || (n & 2) != 0) {
                return new TSEInspectorProperty((Object)new Double(this.getLocalHeight()), false);
            }
            return new TSENumericInspectorProperty((Number)new Double(this.getLocalHeight()), new Double(this.getMinimumHeight()), new Double(99999.0));
        }
        return null;
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        if (tSEInspectorPropertyID.equals(NAME_ID)) {
            this.setText((String)tSEInspectorProperty.getValue());
            return 2;
        }
        if (tSEInspectorPropertyID.equals(URL_ID)) {
            URL uRL = TSSystem.getValidatedURL((String)tSEInspectorProperty.getValue());
            this.setURL(uRL);
            return 2;
        }
        if (this.labelUI != null) {
            int n = this.labelUI.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
            if (n != 0) {
                return n;
            }
        }
        if (tSEInspectorPropertyID.equals(RESIZABILITY_ID) && tSEInspectorProperty instanceof g9) {
            ((g9)tSEInspectorProperty).a(this);
            return 2;
        }
        if (tSEInspectorPropertyID.equals(X_CENTER_ID)) {
            this.setLocalCenterX((Double)tSEInspectorProperty.getValue());
            return 1;
        }
        if (tSEInspectorPropertyID.equals(Y_CENTER_ID)) {
            this.setLocalCenterY((Double)tSEInspectorProperty.getValue());
            return 1;
        }
        if (tSEInspectorPropertyID.equals(WIDTH_ID)) {
            double d = (Double)tSEInspectorProperty.getValue();
            this.setLocalWidth(d);
            return 2;
        }
        if (tSEInspectorPropertyID.equals(HEIGHT_ID)) {
            double d = (Double)tSEInspectorProperty.getValue();
            this.setLocalHeight(d);
            return 2;
        }
        return 0;
    }

    public TSRect adjustBounds(double d, double d2, double d3, double d4, TSRect tSRect) {
        return super.adjustBounds(d, d2, d3, d4, null);
    }

    public TSSize adjustSize(double d, double d2, TSSize tSSize) {
        double d3 = d;
        double d4 = d2;
        int n = this.getResizability();
        if ((n & 0x1000000) != 0) {
            d3 = this.getLocalWidth();
            d4 = this.getLocalHeight();
        } else {
            double d5 = this.getMinimumWidth();
            double d6 = this.getMinimumHeight();
            double d7 = this.getAspectRatio();
            d3 = (n & 1) != 0 ? Math.max(d5, this.getTightWidth()) : Math.max(d5, d);
            d4 = (n & 2) != 0 ? Math.max(d6, this.getTightHeight()) : Math.max(d6, d2);
            if ((n & 4) != 0) {
                if ((n & 8) != 0) {
                    if (d4 * d7 > d3) {
                        d4 = d3 / d7;
                    } else {
                        d3 = d4 * d7;
                    }
                } else if (d4 * d7 > d3) {
                    d3 = d4 * d7;
                } else {
                    d4 = d3 / d7;
                }
                if (d3 < d5) {
                    d4 *= d5 / d3;
                    d3 = d5;
                }
                if (d4 < d6) {
                    d3 *= d6 / d4;
                    d4 = d6;
                }
            }
        }
        if (tSSize == null) {
            tSSize = new TSSize(d3, d4);
        } else {
            tSSize.setSize(d3, d4);
        }
        return tSSize;
    }

    public double getMinimumWidth() {
        double d = 1.0;
        if (this.getUI() != null) {
            return Math.max(this.getLabelUI().getMinimumWidth(), d);
        }
        return d;
    }

    public double getMinimumHeight() {
        double d = 1.0;
        if (this.getUI() != null) {
            return Math.max(this.getLabelUI().getMinimumHeight(), d);
        }
        return d;
    }

    public double getTightWidth() {
        if (this.getUI() != null) {
            return Math.max(this.getLabelUI().getTightWidth(), this.getMinimumWidth());
        }
        return this.getMinimumWidth();
    }

    public double getTightHeight() {
        if (this.getUI() != null) {
            return Math.max(this.getLabelUI().getTightHeight(), this.getMinimumHeight());
        }
        return this.getMinimumHeight();
    }

    public void resize() {
        this.setLocalAdjustedSize(this.getLocalWidth(), this.getLocalHeight());
    }

    public void setAdjustedBounds(double d, double d2, double d3, double d4) {
        TSRect tSRect = this.adjustBounds(d, d2, d3, d4, null);
        this.setBounds(tSRect);
    }

    public void setAdjustedBounds(TSRect tSRect) {
        this.setAdjustedBounds(tSRect.getLeft(), tSRect.getBottom(), tSRect.getRight(), tSRect.getTop());
    }

    public void setLocalAdjustedSize(double d, double d2) {
        TSSize tSSize = this.adjustSize(d, d2, null);
        this.setLocalSize(tSSize);
    }

    public void setLocalAdjustedSize(TSSize tSSize) {
        this.setLocalAdjustedSize(tSSize.getWidth(), tSSize.getHeight());
    }

    public void setAdjustedSize(double d, double d2) {
        this.setLocalAdjustedSize(d, d2);
    }

    public void setAdjustedSize(TSSize tSSize) {
        this.setAdjustedSize(tSSize.getWidth(), tSSize.getHeight());
    }

    public int getDefaultResizability() {
        return 1 | 2;
    }

    public void setResizability(int n) {
        int n2 = this.resizability;
        this.aspectRatio = this.getLocalWidth() / this.getLocalHeight();
        this.resizability = n;
        this.resize();
        if (this.getOwnerGraph() != null && n2 != n) {
            this.getOwnerGraph().fireEvent(new TSEPropertyChangeEvent(2L, new TSEPropertyChangeEventData(this, new Integer(n2), new Integer(n))));
        }
    }

    public int getResizability() {
        return this.resizability;
    }

    public void setAspectRatio(double d) {
        this.aspectRatio = d;
        this.resize();
    }

    public double getAspectRatio() {
        return this.aspectRatio;
    }

    public String getToolTipText() {
        return this.getText();
    }

    public URL getURL() {
        return this.url;
    }

    public void setURL(URL uRL) {
        URL uRL2 = this.url;
        this.url = uRL;
        if (this.getOwnerGraph() != null) {
            this.getOwnerGraph().fireEvent(new TSEPropertyChangeEvent(4L, new TSEPropertyChangeEventData(this, uRL2, uRL)));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

