/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.event.TSEViewportChangeEvent;
import com.tomsawyer.editor.event.TSEViewportChangeEventData;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JLayeredPane;
import javax.swing.JToolTip;

public class TSEInnerCanvas
extends JLayeredPane
implements Autoscroll {
    private TSEGraphWindow graphWindow;
    public Insets insets;

    public TSEInnerCanvas(TSEGraphWindow tSEGraphWindow) {
        this.graphWindow = tSEGraphWindow;
        this.insets = new Insets(20, 20, 20, 20);
    }

    public TSEGraphWindow getGraphWindow() {
        return this.graphWindow;
    }

    public JToolTip createToolTip() {
        return this.graphWindow.createToolTip();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.graphWindow.getToolTipText(mouseEvent);
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return this.graphWindow.getToolTipLocation(mouseEvent);
    }

    public void paintComponent(Graphics graphics) {
        if (this.graphWindow.doubleBuffer != null) {
            graphics.drawImage(this.graphWindow.doubleBuffer, 0, 0, this.graphWindow);
        }
        graphics.setClip(0, 0, this.getWidth() + 1, this.getHeight() + 1);
        this.graphWindow.currentTool.paint(this.graphWindow.newGraphics(graphics));
    }

    public void setSize(Dimension dimension) {
        if (dimension != null) {
            this.setSize(dimension.width, dimension.height);
        }
    }

    public void setSize(int n, int n2) {
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        super.setSize(n, n2);
        this.adjustBuffers(n3, n4, n, n2);
    }

    public void setBounds(Rectangle rectangle) {
        if (rectangle != null) {
            this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        super.setBounds(n, n2, n3, n4);
        this.adjustBuffers(n5, n6, n3, n4);
    }

    void adjustBuffers(int n, int n2, int n3, int n4) {
        n3 = Math.max(1, n3);
        n4 = Math.max(1, n4);
        boolean bl = n3 <= n;
        boolean bl2 = n4 <= n2;
        this.graphWindow.doubleBuffer = this.graphWindow.doubleBuffer != null && this.graphWindow.doubleBuffer instanceof BufferedImage && bl && bl2 ? ((BufferedImage)this.graphWindow.doubleBuffer).getSubimage(0, 0, n3, n4) : this.createImage(n3, n4);
        TSConstRect tSConstRect = this.graphWindow.getTransform().getWorldBounds();
        this.graphWindow.transform.setDeviceSize(n3, n4);
        this.graphWindow.growWorkBounds();
        this.graphWindow.onResize(n3, n4);
        if (this.graphWindow.getGraph().numberOfNodes() == 0) {
            this.graphWindow.centerGraph(true);
        } else {
            this.graphWindow.drawGraph();
        }
        this.graphWindow.updateScrollBarValues();
        TSConstRect tSConstRect2 = this.graphWindow.getTransform().getWorldBounds();
        this.graphWindow.getGraph().fireEvent(new TSEViewportChangeEvent(2L, new TSEViewportChangeEventData((Object)this.graphWindow, tSConstRect, tSConstRect2)));
    }

    public Insets getAutoscrollInsets() {
        return this.insets;
    }

    public void autoscroll(Point point) {
        TSEGraphWindow tSEGraphWindow = this.getGraphWindow();
        Rectangle rectangle = tSEGraphWindow.getTransform().getDeviceBounds();
        int n = 0;
        int n2 = 0;
        if (point.x < rectangle.x + this.insets.left) {
            n = -20;
        } else if (point.x > rectangle.x + rectangle.width - this.insets.right) {
            n = 20;
        }
        if (point.y < rectangle.y + this.insets.top) {
            n2 = -20;
        } else if (point.y > rectangle.y + rectangle.height - this.insets.bottom) {
            n2 = 20;
        }
        tSEGraphWindow.scrollBy(n, n2, true);
    }
}

