/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class TSECursorManager {
    private static Hashtable cursors = new Hashtable(1);
    private static String cursorDir = "com/tomsawyer/editor/cursors";
    private static String userCursorDir = null;
    private static Properties cursorProperties;
    private static final String CURSOR_DOT_PREFIX = "Cursor.";
    private static final String DOT_FILE_SUFFIX = ".File";
    private static final String DEFAULT_SUFFIX = ".Default";
    private static final String DOT_HOTSPOT_SUFFIX = ".HotSpot";
    private static final String DOT_NAME_SUFFIX = ".Name";
    private static Cursor cursorInstance;
    private static boolean propertiesFileAvailable;
    static /* synthetic */ Class class$java$awt$Cursor;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSECursorManager;

    TSECursorManager() {
    }

    public static void setCursorDir(String string) {
        cursorDir = string;
    }

    public static String getCursorDir() {
        return cursorDir;
    }

    public static void setUserCursorDir(String string) {
        userCursorDir = string;
    }

    public static String getUserCursorDir() {
        return userCursorDir;
    }

    public static Cursor getCursor(String string, int n) {
        Cursor cursor = null;
        if (string != null) {
            cursor = (Cursor)cursors.get(string);
        }
        if (cursor == null) {
            if (propertiesFileAvailable && string != null) {
                cursor = TSECursorManager.getCursorFromFile(string);
            }
            if (cursor == null) {
                cursor = Cursor.getPredefinedCursor(n);
            }
            if (cursor == null) {
                cursor = Cursor.getPredefinedCursor(0);
            }
            cursors.put("Cursor..Default", cursor);
        }
        return cursor;
    }

    private static Cursor createStandardCursor(String string) {
        Cursor cursor;
        try {
            String string2 = string.substring(string.indexOf(".") + 1);
            Field field = (class$java$awt$Cursor == null ? (class$java$awt$Cursor = TSECursorManager.class$("java.awt.Cursor")) : class$java$awt$Cursor).getField(string2);
            int n = field.getInt(cursorInstance);
            cursor = Cursor.getPredefinedCursor(n);
        }
        catch (Exception exception) {
            cursor = null;
        }
        return cursor;
    }

    private static Cursor createCustomCursor(String string, String string2) {
        String string3;
        String string4 = CURSOR_DOT_PREFIX + string;
        String string5 = cursorProperties.getProperty(string4 + DOT_NAME_SUFFIX);
        if (string5 == null) {
            string5 = string;
        }
        if ((string3 = cursorProperties.getProperty(string4 + DOT_HOTSPOT_SUFFIX)) == null) {
            System.err.println("No hotspot property defined for cursor: " + string);
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
        if (stringTokenizer.countTokens() != 2) {
            System.err.println("Failed to parse hotspot property for cursor: " + string);
            return null;
        }
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(stringTokenizer.nextToken());
            n2 = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Failed to parse hotspot property for cursor: " + string);
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        URL uRL = (class$com$tomsawyer$editor$TSECursorManager == null ? (class$com$tomsawyer$editor$TSECursorManager = TSECursorManager.class$("com.tomsawyer.editor.TSECursorManager")) : class$com$tomsawyer$editor$TSECursorManager).getResource("/" + TSECursorManager.getCursorDir() + "/" + string2);
        if (uRL == null && TSECursorManager.getUserCursorDir() != null) {
            uRL = (class$com$tomsawyer$editor$TSECursorManager == null ? (class$com$tomsawyer$editor$TSECursorManager = TSECursorManager.class$("com.tomsawyer.editor.TSECursorManager")) : class$com$tomsawyer$editor$TSECursorManager).getResource("/" + TSECursorManager.getUserCursorDir() + "/" + string2);
        }
        Image image = toolkit.getImage(uRL);
        Cursor cursor = toolkit.createCustomCursor(image, new Point(n, n2), string5);
        return cursor;
    }

    private static Cursor getCursorFromFile(String string) {
        String string2;
        boolean bl;
        Cursor cursor = null;
        if (cursorProperties == null) {
            try {
                TSECursorManager.loadCursorProperties();
            }
            catch (Exception exception) {
                System.err.println("Exception: " + exception.getClass() + " " + exception.getMessage() + " occurred while loading: " + "cursors.properties file");
                propertiesFileAvailable = false;
                return null;
            }
        }
        String string3 = CURSOR_DOT_PREFIX + string;
        String string4 = string3 + DOT_FILE_SUFFIX;
        String string5 = string3 + DEFAULT_SUFFIX;
        boolean bl2 = System.getProperty("os.name").startsWith("Mac");
        boolean bl3 = bl = string.startsWith("CreateNode") || string.startsWith("LinkNavigation") || string.startsWith("Paste");
        if ((!bl2 || bl) && cursorProperties.containsKey(string4)) {
            string2 = cursorProperties.getProperty(string4);
            cursor = TSECursorManager.createCustomCursor(string, string2);
        }
        if (cursor == null && cursorProperties.containsKey(string5)) {
            string2 = cursorProperties.getProperty(string5);
            cursor = TSECursorManager.createStandardCursor(string2);
        }
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadCursorProperties() throws Exception {
        InputStream inputStream;
        block7: {
            cursorProperties = new Properties();
            InputStream inputStream2 = null;
            inputStream = null;
            String string = TSECursorManager.getCursorDir() + "/cursors.properties";
            String string2 = null;
            if (TSECursorManager.getUserCursorDir() != null) {
                string2 = TSECursorManager.getUserCursorDir() + "/cursors.properties";
            }
            try {
                inputStream2 = (class$com$tomsawyer$editor$TSECursorManager == null ? (class$com$tomsawyer$editor$TSECursorManager = TSECursorManager.class$("com.tomsawyer.editor.TSECursorManager")) : class$com$tomsawyer$editor$TSECursorManager).getResourceAsStream("/" + string);
                cursorProperties.load(inputStream2);
                if (string2 != null) {
                    inputStream = (class$com$tomsawyer$editor$TSECursorManager == null ? (class$com$tomsawyer$editor$TSECursorManager = TSECursorManager.class$("com.tomsawyer.editor.TSECursorManager")) : class$com$tomsawyer$editor$TSECursorManager).getResourceAsStream("/" + string2);
                    cursorProperties.load(inputStream);
                }
                Object var5_4 = null;
                if (inputStream2 == null) break block7;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (inputStream2 != null) {
                    inputStream2.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
                throw throwable;
            }
            inputStream2.close();
        }
        if (inputStream != null) {
            inputStream.close();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        cursorInstance = Cursor.getPredefinedCursor(0);
        propertiesFileAvailable = true;
    }
}

