/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.editor;

import com.tomsawyer.util.TSSystem;
import java.awt.Color;
import java.util.StringTokenizer;

public class TSEColor {
    public static final TSEColor white = new TSEColor(255, 255, 255);
    public static final TSEColor black = new TSEColor(0, 0, 0);
    public static final TSEColor gray = new TSEColor(153, 153, 153);
    public static final TSEColor paleGray = new TSEColor(204, 204, 204);
    public static final TSEColor darkGray = new TSEColor(102, 102, 102);
    public static final TSEColor red = new TSEColor(255, 0, 0);
    public static final TSEColor paleRed = new TSEColor(255, 102, 102);
    public static final TSEColor darkRed = new TSEColor(153, 0, 0);
    public static final TSEColor green = new TSEColor(0, 255, 0);
    public static final TSEColor paleGreen = new TSEColor(102, 255, 102);
    public static final TSEColor darkGreen = new TSEColor(0, 153, 0);
    public static final TSEColor blue = new TSEColor(0, 0, 255);
    public static final TSEColor paleBlue = new TSEColor(102, 102, 255);
    public static final TSEColor darkBlue = new TSEColor(0, 0, 153);
    public static final TSEColor cyan = new TSEColor(0, 255, 255);
    public static final TSEColor paleCyan = new TSEColor(153, 255, 255);
    public static final TSEColor darkCyan = new TSEColor(0, 153, 153);
    public static final TSEColor magenta = new TSEColor(255, 0, 255);
    public static final TSEColor paleMagenta = new TSEColor(255, 153, 255);
    public static final TSEColor darkMagenta = new TSEColor(153, 0, 153);
    public static final TSEColor yellow = new TSEColor(255, 255, 0);
    public static final TSEColor paleYellow = new TSEColor(255, 255, 153);
    public static final TSEColor darkYellow = new TSEColor(153, 153, 0);
    Color color;

    public TSEColor() {
        this(Color.black);
    }

    public TSEColor(String string) {
        this(TSEColor.parseColor(string));
    }

    public TSEColor(TSEColor tSEColor) {
        this(tSEColor.getColor());
    }

    public TSEColor(int n, int n2, int n3) {
        this(new Color(n, n2, n3));
    }

    public TSEColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(TSEColor tSEColor) {
        this.color = tSEColor == null ? null : tSEColor.getColor();
    }

    public static Color parseColor(String string) {
        try {
            if ("transparent".equals(string)) {
                return null;
            }
            if (string.startsWith("#")) {
                return Color.decode(string);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            return new Color(n, n2, n3);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(string);
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof TSEColor) {
            Color color = ((TSEColor)object).getColor();
            bl = TSSystem.equals(this.color, color);
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        if (this.color != null) {
            n = this.color.hashCode();
        }
        return n;
    }

    public String toString() {
        if (this.color == null) {
            return "transparent";
        }
        return this.color.getRed() + " " + this.color.getGreen() + " " + this.color.getBlue();
    }
}

