/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.geometry;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;

public class TSRect
extends TSConstRect {
    public TSRect() {
        super(0.0, 0.0, 0.0, 0.0);
    }

    public TSRect(double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
    }

    public TSRect(TSConstPoint tSConstPoint, TSConstPoint tSConstPoint2) {
        super(tSConstPoint, tSConstPoint2);
    }

    public TSRect(TSConstRect tSConstRect) {
        super(tSConstRect);
    }

    public void setBottom(double d) {
        this.bottom = d;
    }

    public void setBounds(TSConstRect tSConstRect) {
        this.left = tSConstRect.left;
        this.right = tSConstRect.right;
        this.top = tSConstRect.top;
        this.bottom = tSConstRect.bottom;
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        if (d < d3) {
            this.left = d;
            this.right = d3;
        } else {
            this.left = d3;
            this.right = d;
        }
        if (d2 < d4) {
            this.bottom = d2;
            this.top = d4;
        } else {
            this.bottom = d4;
            this.top = d2;
        }
    }

    public void setBounds(TSConstPoint tSConstPoint, TSConstPoint tSConstPoint2) {
        this.setBounds(tSConstPoint.getX(), tSConstPoint.getY(), tSConstPoint2.getX(), tSConstPoint2.getY());
    }

    public void setBoundsFromCenter(TSConstPoint tSConstPoint, TSConstSize tSConstSize) {
        this.setBoundsFromCenter(tSConstPoint.getX(), tSConstPoint.getY(), tSConstSize.getWidth(), tSConstSize.getHeight());
    }

    public void setBoundsFromCenter(double d, double d2, double d3, double d4) {
        this.left = d - d3 / 2.0;
        this.bottom = d2 - d4 / 2.0;
        this.right = this.left + d3;
        this.top = this.bottom + d4;
    }

    public void setCenterX(double d) {
        double d2 = (this.left - this.right) / 2.0;
        this.left = d + d2;
        this.right = d - d2;
    }

    public void setCenterY(double d) {
        double d2 = (this.bottom - this.top) / 2.0;
        this.bottom = d + d2;
        this.top = d - d2;
    }

    public void setHeight(double d) {
        this.bottom = (this.top + this.bottom - d) / 2.0;
        this.top = this.bottom + d;
    }

    public void setLeft(double d) {
        this.left = d;
    }

    public void setCenter(TSConstPoint tSConstPoint) {
        this.setCenterX(tSConstPoint.getX());
        this.setCenterY(tSConstPoint.getY());
    }

    public void setCenter(double d, double d2) {
        this.setCenterX(d);
        this.setCenterY(d2);
    }

    public void setRight(double d) {
        this.right = d;
    }

    public void setSize(TSConstSize tSConstSize) {
        this.setSize(tSConstSize.getWidth(), tSConstSize.getHeight());
    }

    public void setSize(double d, double d2) {
        this.setWidth(d);
        this.setHeight(d2);
    }

    public void setTop(double d) {
        this.top = d;
    }

    public void setWidth(double d) {
        this.left = (this.right + this.left - d) / 2.0;
        this.right = this.left + d;
    }

    public boolean merge(TSConstRect tSConstRect) {
        boolean bl = false;
        if (tSConstRect.left < this.left) {
            this.left = tSConstRect.left;
            bl = true;
        }
        if (tSConstRect.bottom < this.bottom) {
            this.bottom = tSConstRect.bottom;
            bl = true;
        }
        if (tSConstRect.right > this.right) {
            this.right = tSConstRect.right;
            bl = true;
        }
        if (tSConstRect.top > this.top) {
            this.top = tSConstRect.top;
            bl = true;
        }
        return bl;
    }

    public boolean merge(double d, double d2, double d3, double d4) {
        return this.merge(d, d2) | this.merge(d3, d4);
    }

    public boolean merge(TSConstPoint tSConstPoint) {
        return this.merge(tSConstPoint.getX(), tSConstPoint.getY());
    }

    public boolean merge(double d, double d2) {
        boolean bl = false;
        if (d < this.left) {
            this.left = d;
            bl = true;
        } else if (d > this.right) {
            this.right = d;
            bl = true;
        }
        if (d2 < this.bottom) {
            this.bottom = d2;
            bl = true;
        } else if (d2 > this.top) {
            this.top = d2;
            bl = true;
        }
        return bl;
    }

    public void moveBy(TSConstSize tSConstSize) {
        this.moveBy(tSConstSize.getWidth(), tSConstSize.getHeight());
    }

    public void moveBy(double d, double d2) {
        this.left += d;
        this.right += d;
        this.bottom += d2;
        this.top += d2;
    }
}

