/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.geometry;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.drawing.geometry.TSSize;
import com.tomsawyer.util.TSSystem;
import java.io.Serializable;

public class TSExpTransform
implements Cloneable,
Serializable {
    double scaleX;
    double scaleY;
    double offsetX;
    double offsetY;

    public TSExpTransform() {
        this.setScaleX(1.0);
        this.setScaleY(1.0);
        this.setOffsetX(0.0);
        this.setOffsetY(0.0);
    }

    public double transformX(double d) {
        return d * this.getScaleX() + this.getOffsetX();
    }

    public double transformY(double d) {
        return d * this.getScaleY() + this.getOffsetY();
    }

    public void transformPoint(TSConstPoint tSConstPoint, TSPoint tSPoint) {
        tSPoint.setLocation(tSConstPoint.getX() * this.getScaleX() + this.getOffsetX(), tSConstPoint.getY() * this.getScaleY() + this.getOffsetY());
    }

    public void transformSize(TSConstSize tSConstSize, TSSize tSSize) {
        tSSize.setSize(tSConstSize.getWidth() * Math.abs(this.getScaleX()), tSConstSize.getHeight() * Math.abs(this.getScaleY()));
    }

    public void transformRect(TSConstRect tSConstRect, TSRect tSRect) {
        tSRect.setBounds(tSConstRect.getLeft() * this.scaleX + this.offsetX, tSConstRect.getBottom() * this.scaleY + this.offsetY, tSConstRect.getRight() * this.scaleX + this.offsetX, tSConstRect.getTop() * this.scaleY + this.offsetY);
    }

    public double inverseTransformX(double d) {
        if (this.getScaleX() == 0.0) {
            return Double.NaN;
        }
        return (d - this.getOffsetX()) / this.getScaleX();
    }

    public double inverseTransformY(double d) {
        if (this.getScaleY() == 0.0) {
            return Double.NaN;
        }
        return (d - this.getOffsetY()) / this.getScaleY();
    }

    public void inverseTransformPoint(TSConstPoint tSConstPoint, TSPoint tSPoint) {
        tSPoint.setLocation(this.inverseTransformX(tSConstPoint.getX()), this.inverseTransformY(tSConstPoint.getY()));
    }

    public double inverseTransformWidth(double d) {
        if (this.getScaleX() == 0.0) {
            return Double.NaN;
        }
        return d / Math.abs(this.getScaleX());
    }

    public double inverseTransformHeight(double d) {
        if (this.getScaleY() == 0.0) {
            return Double.NaN;
        }
        return d / Math.abs(this.getScaleY());
    }

    public void inverseTransformSize(TSConstSize tSConstSize, TSSize tSSize) {
        tSSize.setSize(this.inverseTransformWidth(tSConstSize.getWidth()), this.inverseTransformHeight(tSConstSize.getHeight()));
    }

    public void inverseTransformRect(TSConstRect tSConstRect, TSRect tSRect) {
        tSRect.setBounds(this.inverseTransformX(tSConstRect.getLeft()), this.inverseTransformY(tSConstRect.getBottom()), this.inverseTransformX(tSConstRect.getRight()), this.inverseTransformY(tSConstRect.getTop()));
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public void setScale(double d) {
        this.setScaleX(d);
        this.setScaleY(d);
    }

    public void setScaleX(double d) {
        this.scaleX = d;
    }

    public void setScaleY(double d) {
        this.scaleY = d;
    }

    public void magnifyX(double d) {
        this.scaleX *= d;
    }

    public void magnifyY(double d) {
        this.scaleY *= d;
    }

    public void magnify(double d) {
        this.magnifyX(d);
        this.magnifyY(d);
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetX(double d) {
        this.offsetX = d;
    }

    public void setOffsetY(double d) {
        this.offsetY = d;
    }

    public void shiftX(double d) {
        this.offsetX += d;
    }

    public void shiftY(double d) {
        this.offsetY += d;
    }

    public void shift(double d) {
        this.shiftX(d);
        this.shiftY(d);
    }

    public static TSExpTransform compose(TSExpTransform tSExpTransform, TSExpTransform tSExpTransform2) {
        TSExpTransform tSExpTransform3 = new TSExpTransform();
        double d = tSExpTransform.getScaleX() * tSExpTransform2.getScaleX();
        double d2 = tSExpTransform.getScaleY() * tSExpTransform2.getScaleY();
        double d3 = tSExpTransform.getOffsetX() + tSExpTransform2.getOffsetX();
        double d4 = tSExpTransform.getOffsetY() + tSExpTransform2.getOffsetY();
        tSExpTransform3.setScaleX(d);
        tSExpTransform3.setScaleY(d2);
        tSExpTransform3.setOffsetX(d3);
        tSExpTransform3.setOffsetY(d4);
        return tSExpTransform3;
    }

    public boolean equals(Object object) {
        if (object instanceof TSExpTransform) {
            TSExpTransform tSExpTransform = (TSExpTransform)object;
            return tSExpTransform.getScaleX() == this.getScaleX() && tSExpTransform.getScaleY() == this.getScaleY() && tSExpTransform.getOffsetX() == this.getOffsetX() && tSExpTransform.getOffsetY() == this.getOffsetY();
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.scaleX);
        long l2 = Double.doubleToLongBits(this.scaleY);
        long l3 = Double.doubleToLongBits(this.offsetX);
        long l4 = Double.doubleToLongBits(this.offsetY);
        int n = (int)(l ^ l >>> 32);
        int n2 = (int)(l2 ^ l2 >>> 32);
        int n3 = (int)(l3 ^ l3 >>> 32);
        int n4 = (int)(l4 ^ l4 >>> 32);
        return n ^ n2 >>> 8 ^ n3 >>> 16 ^ n4 >>> 24;
    }

    public String toString() {
        return this.getClass().getName() + TSSystem.eol + '{' + TSSystem.eol + "\tscaleX = " + this.getScaleX() + TSSystem.eol + "\tscaleY = " + this.getScaleY() + TSSystem.eol + "\toffsetX = " + this.getOffsetX() + TSSystem.eol + "\toffsetY = " + this.getOffsetY() + TSSystem.eol + '}';
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    public void copy(Object object) {
        TSExpTransform tSExpTransform = (TSExpTransform)object;
        this.scaleX = tSExpTransform.scaleX;
        this.scaleY = tSExpTransform.scaleY;
        this.offsetX = tSExpTransform.offsetX;
        this.offsetY = tSExpTransform.offsetY;
    }
}

