/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.geometry;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSPoint;

public class TSConstSegment
implements Cloneable {
    double x1;
    double y1;
    double x2;
    double y2;

    public TSConstSegment(TSConstPoint tSConstPoint, TSConstPoint tSConstPoint2) {
        this.x1 = tSConstPoint.getX();
        this.y1 = tSConstPoint.getY();
        this.x2 = tSConstPoint2.getX();
        this.y2 = tSConstPoint2.getY();
    }

    public TSConstSegment(double d, double d2, double d3, double d4) {
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
    }

    public final double getX1() {
        return this.x1;
    }

    public final double getY1() {
        return this.y1;
    }

    public final double getX2() {
        return this.x2;
    }

    public final double getY2() {
        return this.y2;
    }

    public boolean colinear(TSConstPoint tSConstPoint) {
        return this.colinear(tSConstPoint.getX(), tSConstPoint.getY());
    }

    public boolean colinear(double d, double d2) {
        return (d - this.getX1()) * (this.getY2() - this.getY1()) == (d2 - this.getY1()) * (this.getX2() - this.getX1());
    }

    public boolean contains(TSConstPoint tSConstPoint) {
        return this.contains(tSConstPoint.getX(), tSConstPoint.getY());
    }

    public boolean contains(double d, double d2) {
        boolean bl = false;
        if (this.isWithinXRange(d) && this.isWithinYRange(d2)) {
            bl = this.colinear(d, d2);
        }
        return bl;
    }

    public TSConstPoint getFirst() {
        return new TSConstPoint(this.getX1(), this.getY1());
    }

    public TSConstPoint getLast() {
        return new TSConstPoint(this.getX2(), this.getY2());
    }

    public TSConstPoint intersection(TSConstSegment tSConstSegment) {
        TSConstPoint tSConstPoint = null;
        if (tSConstSegment != null) {
            tSConstPoint = TSConstSegment.intersection(this.getX1(), this.getY1(), this.getX2(), this.getY2(), tSConstSegment.getX1(), tSConstSegment.getY1(), tSConstSegment.getX2(), tSConstSegment.getY2());
        }
        return tSConstPoint;
    }

    public TSConstPoint intersection(double d, double d2, double d3, double d4) {
        return TSConstSegment.intersection(this.getX1(), this.getY1(), this.getX2(), this.getY2(), d, d2, d3, d4);
    }

    public static double xIntersection(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        TSConstPoint tSConstPoint = TSConstSegment.intersection(d, d2, d3, d4, d5, d6, d7, d8);
        double d9 = Double.NaN;
        if (tSConstPoint != null) {
            d9 = tSConstPoint.getX();
        }
        return d9;
    }

    public static double yIntersection(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        TSConstPoint tSConstPoint = TSConstSegment.intersection(d, d2, d3, d4, d5, d6, d7, d8);
        double d9 = Double.NaN;
        if (tSConstPoint != null) {
            d9 = tSConstPoint.getY();
        }
        return d9;
    }

    public static TSConstPoint intersection(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        TSPoint tSPoint = null;
        double d9 = d3 - d;
        double d10 = d4 - d2;
        double d11 = d7 - d5;
        double d12 = d8 - d6;
        double d13 = d9 * d9 + d10 * d10;
        double d14 = d11 * d11 + d12 * d12;
        double d15 = d10 * d11 - d12 * d9;
        double d16 = -(d11 * (d2 - d6) + d12 * (d5 - d));
        double d17 = d9 * (d6 - d2) + d10 * (d - d5);
        if (d15 < 0.0) {
            d15 = -d15;
            d16 = -d16;
            d17 = -d17;
        }
        if (d15 == 0.0) {
            if (d16 == 0.0 && d17 == 0.0) {
                if (d13 > d14) {
                    if (d13 == 0.0) {
                        if (d == d5 && d2 == d6) {
                            tSPoint = new TSPoint(d, d2);
                        }
                    } else {
                        double d18;
                        double d19 = 2.0;
                        double d20 = -1.0;
                        if (Math.abs(d9) > Math.abs(d10)) {
                            d18 = (d5 - d) / d9;
                            d19 = Math.min(d19, d18);
                            d20 = Math.max(d20, d18);
                            d18 = (d7 - d) / d9;
                            d19 = Math.min(d19, d18);
                            d20 = Math.max(d20, d18);
                        } else {
                            d18 = (d6 - d2) / d10;
                            d19 = Math.min(d19, d18);
                            d20 = Math.max(d20, d18);
                            d18 = (d8 - d2) / d10;
                            d19 = Math.min(d19, d18);
                            d20 = Math.max(d20, d18);
                        }
                        if (d19 <= 1.0 && d20 >= 0.0) {
                            d18 = Math.max(0.0, d19);
                            tSPoint = new TSPoint(d + d9 * d18, d2 + d10 * d18);
                        }
                    }
                } else if (d14 == 0.0) {
                    if (d5 == d && d6 == d2) {
                        tSPoint = new TSPoint(d5, d6);
                    }
                } else {
                    double d21;
                    double d22 = 2.0;
                    double d23 = -1.0;
                    if (Math.abs(d11) > Math.abs(d12)) {
                        d21 = (d - d5) / d11;
                        d22 = Math.min(d22, d21);
                        d23 = Math.max(d23, d21);
                        d21 = (d3 - d5) / d11;
                        d22 = Math.min(d22, d21);
                        d23 = Math.max(d23, d21);
                    } else {
                        d21 = (d2 - d6) / d12;
                        d22 = Math.min(d22, d21);
                        d23 = Math.max(d23, d21);
                        d21 = (d4 - d6) / d12;
                        d22 = Math.min(d22, d21);
                        d23 = Math.max(d23, d21);
                    }
                    if (d22 <= 1.0 && d23 >= 0.0) {
                        d21 = Math.max(0.0, d22);
                        tSPoint = new TSPoint(d5 + d11 * d21, d6 + d12 * d21);
                    }
                }
            }
        } else if (d16 * d15 >= 0.0 && d16 <= d15 && d17 * d15 >= 0.0 && d17 <= d15) {
            if (d13 > d14) {
                double d24 = d17 / d15;
                tSPoint = new TSPoint(d5 + d11 * d24, d6 + d12 * d24);
            } else {
                double d25 = d16 / d15;
                tSPoint = new TSPoint(d + d9 * d25, d2 + d10 * d25);
            }
        }
        return tSPoint;
    }

    public static double verticalSegmentIntersection(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        return TSConstSegment.horizontalSegmentIntersection(d2, d, d4, d3, d5, d6, d7);
    }

    public static double horizontalSegmentIntersection(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        double d9;
        double d10;
        if (d6 > d7) {
            d10 = d6;
            d6 = d7;
            d7 = d10;
        }
        d2 -= d5;
        if ((d4 -= d5) > 0.0 && d2 > 0.0 || d4 < 0.0 && d2 < 0.0) {
            return Double.NaN;
        }
        d10 = d4 - d2;
        if (d4 == d2) {
            d9 = d3;
            if (d3 > d7) {
                d9 = d > d7 ? Double.NaN : d7;
            }
            if (d3 < d6) {
                d9 = d < d6 ? Double.NaN : d6;
            }
        } else {
            d8 = -d2 / (d4 - d2);
            double d11 = d3 - d;
            d9 = d + d11 * d8;
        }
        d8 = Double.NaN;
        if (d9 >= d6 && d9 <= d7) {
            d8 = d9;
        }
        return d8;
    }

    public static double xOnLine(double d, double d2, double d3, double d4, double d5) {
        if (d2 == d4) {
            return d3;
        }
        return (d5 - d2) * (d3 - d) / (d4 - d2) + d;
    }

    public static double yOnLine(double d, double d2, double d3, double d4, double d5) {
        return TSConstSegment.xOnLine(d2, d, d4, d3, d5);
    }

    public final double length() {
        double d = this.getX1() - this.getX2();
        double d2 = this.getY1() - this.getY2();
        return Math.sqrt(d * d + d2 * d2);
    }

    public boolean isWithinXRange(double d) {
        boolean bl = this.getX1() <= this.getX2() ? this.getX1() <= d && d <= this.getX2() : this.getX2() <= d && d <= this.getX1();
        return bl;
    }

    public boolean isWithinYRange(double d) {
        boolean bl = this.getY1() <= this.getY2() ? this.getY1() <= d && d <= this.getY2() : this.getY2() <= d && d <= this.getY1();
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof TSConstSegment) {
            TSConstSegment tSConstSegment = (TSConstSegment)object;
            bl = this.x1 == tSConstSegment.x1 && this.y1 == tSConstSegment.y1 && this.x2 == tSConstSegment.x2 && this.y2 == tSConstSegment.y2;
        }
        return bl;
    }

    public String toString() {
        return "[(" + this.x1 + ", " + this.y1 + ")(" + this.x2 + ", " + this.y2 + ")]";
    }
}

