/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.TSPEdge;
import com.tomsawyer.drawing.TSPNode;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.util.command.TSCommand;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSDeletePNodeCommand
extends TSCommand {
    TSDEdge edge;
    TSPNode bend;
    int pNodeIndex;
    TSConstPoint location;
    TSPEdge extraPath;
    List graphs;
    List margins;

    public TSDeletePNodeCommand(TSPNode tSPNode) {
        if (tSPNode == null || !tSPNode.isOwned()) {
            throw new IllegalArgumentException();
        }
        this.edge = (TSDEdge)tSPNode.getOwner();
        this.bend = tSPNode;
    }

    protected void doAction() throws Throwable {
        if (this.edge.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(32L, new TSDrawingChangeEventData(this.bend, this.edge, null)), true)) {
            this.storeOldMargins();
            this.pNodeIndex = this.edge.getPathNodeIndex(this.bend);
            this.location = this.bend.getLocalCenter();
            this.extraPath = this.edge.removePathSegment(this.bend);
        } else {
            this.setAddToUndoStack(false);
        }
    }

    protected void undoAction() throws Throwable {
        TSPEdge tSPEdge = this.edge.getPathEdgeAtIndex(this.pNodeIndex);
        if (tSPEdge.getTargetNode() == this.extraPath.getTargetNode()) {
            this.edge.insertPathSegment(this.bend, this.extraPath);
        } else {
            this.bend = this.edge.addLocalPathNode(tSPEdge, this.location);
            this.extraPath = this.bend.getOutEdge();
        }
        this.restoreMargins();
    }

    protected void redoAction() throws Throwable {
        TSPEdge tSPEdge = this.edge.getPathEdgeAtIndex(this.pNodeIndex);
        if (tSPEdge != null) {
            this.bend = (TSPNode)tSPEdge.getTargetNode();
            this.extraPath = this.edge.removePathSegment(this.bend);
        }
        this.restoreMargins();
    }

    protected void doCleanup() {
        this.bend.dispose();
    }

    protected TSPNode getPathNode() {
        return this.bend;
    }

    private void storeOldMargins() {
        TSDGraphManager tSDGraphManager;
        if (this.edge.getOwner() != null && (tSDGraphManager = (TSDGraphManager)this.edge.getOwner().getOwnerGraphManager()) != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSDGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSDGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    private void restoreMargins() {
        if (this.graphs != null) {
            Iterator iterator = this.graphs.iterator();
            Iterator iterator2 = this.margins.iterator();
            while (iterator.hasNext()) {
                TSDGraph tSDGraph = (TSDGraph)iterator.next();
                TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
                double[] dArray = (double[])iterator2.next();
                double d = tSGraphTailor.getOriginalLeftConstantMargin();
                double d2 = tSGraphTailor.getOriginalRightConstantMargin();
                double d3 = tSGraphTailor.getOriginalBottomConstantMargin();
                double d4 = tSGraphTailor.getOriginalTopConstantMargin();
                tSGraphTailor.setLeftConstantMargin(dArray[0]);
                tSGraphTailor.setRightConstantMargin(dArray[1]);
                tSGraphTailor.setBottomConstantMargin(dArray[2]);
                tSGraphTailor.setTopConstantMargin(dArray[3]);
                tSGraphTailor.setOriginalLeftConstantMargin(d);
                tSGraphTailor.setOriginalRightConstantMargin(d2);
                tSGraphTailor.setOriginalBottomConstantMargin(d3);
                tSGraphTailor.setOriginalTopConstantMargin(d4);
                tSDGraph.updateBounds();
            }
        }
    }
}

