/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSEdgeLabel;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.util.command.TSCommand;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSDeleteEdgeLabelCommand
extends TSCommand {
    TSDEdge edge;
    TSEdgeLabel label;
    List graphs;
    List margins;

    public TSDeleteEdgeLabelCommand(TSEdgeLabel tSEdgeLabel) {
        if (tSEdgeLabel == null || !tSEdgeLabel.isOwned()) {
            throw new IllegalArgumentException();
        }
        this.edge = (TSDEdge)tSEdgeLabel.getOwner();
        this.label = tSEdgeLabel;
    }

    protected void doAction() throws Throwable {
        if (this.edge.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(16L, new TSDrawingChangeEventData(this.label, this.edge, null)), true)) {
            this.storeOldMargins();
            this.edge.remove(this.label);
        } else {
            this.setAddToUndoStack(false);
        }
    }

    protected void undoAction() throws Throwable {
        this.edge.insert(this.label);
        this.restoreMargins();
    }

    protected void redoAction() throws Throwable {
        this.edge.remove(this.label);
    }

    protected void doCleanup() {
        if (!this.label.isOwned()) {
            this.label.dispose();
        }
    }

    protected TSEdgeLabel getEdgeLabel() {
        return this.label;
    }

    private void storeOldMargins() {
        TSDGraphManager tSDGraphManager;
        if (this.edge.getOwner() != null && (tSDGraphManager = (TSDGraphManager)this.edge.getOwner().getOwnerGraphManager()) != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSDGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSDGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    private void restoreMargins() {
        if (this.graphs != null) {
            Iterator iterator = this.graphs.iterator();
            Iterator iterator2 = this.margins.iterator();
            while (iterator.hasNext()) {
                TSDGraph tSDGraph = (TSDGraph)iterator.next();
                TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
                double[] dArray = (double[])iterator2.next();
                double d = tSGraphTailor.getOriginalLeftConstantMargin();
                double d2 = tSGraphTailor.getOriginalRightConstantMargin();
                double d3 = tSGraphTailor.getOriginalBottomConstantMargin();
                double d4 = tSGraphTailor.getOriginalTopConstantMargin();
                tSGraphTailor.setLeftConstantMargin(dArray[0]);
                tSGraphTailor.setRightConstantMargin(dArray[1]);
                tSGraphTailor.setBottomConstantMargin(dArray[2]);
                tSGraphTailor.setTopConstantMargin(dArray[3]);
                tSGraphTailor.setOriginalLeftConstantMargin(d);
                tSGraphTailor.setOriginalRightConstantMargin(d2);
                tSGraphTailor.setOriginalBottomConstantMargin(d3);
                tSGraphTailor.setOriginalTopConstantMargin(d4);
                tSDGraph.updateBounds();
            }
        }
    }
}

