/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.command;

import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.ct;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.util.command.TSCommand;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TSDeleteConnectorCommand
extends TSCommand {
    TSDNode node;
    Map sourceEdgeClippingMap;
    Map targetEdgeClippingMap;
    List connectorLabels;
    TSConnector connector;

    public TSDeleteConnectorCommand(TSConnector tSConnector) {
        this.connector = tSConnector;
        this.node = (TSDNode)tSConnector.getOwner();
        this.sourceEdgeClippingMap = new HashMap();
        this.targetEdgeClippingMap = new HashMap();
        this.connectorLabels = new Vector();
    }

    protected void doAction() throws Throwable {
        if (this.node.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(64L, new TSDrawingChangeEventData(this.connector, this.node, null)), true)) {
            TSDEdge tSDEdge;
            Iterator iterator = this.connector.incidentEdges().iterator();
            while (iterator.hasNext()) {
                tSDEdge = (TSDEdge)iterator.next();
                if (tSDEdge.getSourceConnector() == this.connector) {
                    this.sourceEdgeClippingMap.put(tSDEdge, new ct(tSDEdge.getSourceClipping()));
                }
                if (tSDEdge.getTargetConnector() != this.connector) continue;
                this.targetEdgeClippingMap.put(tSDEdge, new ct(tSDEdge.getTargetClipping()));
            }
            iterator = this.connector.disconnectedEdges().iterator();
            while (iterator.hasNext()) {
                tSDEdge = (TSDEdge)iterator.next();
                if (tSDEdge.getSourceConnector() == this.connector) {
                    this.sourceEdgeClippingMap.put(tSDEdge, new ct(tSDEdge.getSourceClipping()));
                }
                if (tSDEdge.getTargetConnector() != this.connector) continue;
                this.targetEdgeClippingMap.put(tSDEdge, new ct(tSDEdge.getTargetClipping()));
            }
            this.connectorLabels.addAll(this.connector.labels());
            this.node.remove(this.connector);
        } else {
            this.setAddToUndoStack(false);
        }
    }

    protected void undoAction() throws Throwable {
        Object object;
        this.node.insert(this.connector);
        Iterator iterator = this.sourceEdgeClippingMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (TSDEdge)iterator.next();
            ((TSDEdge)object).setSourceConnector(this.connector);
            ((TSDEdge)object).setSourceClipping((ct)this.sourceEdgeClippingMap.get(object));
        }
        object = this.targetEdgeClippingMap.keySet().iterator();
        while (object.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)object.next();
            tSDEdge.setTargetConnector(this.connector);
            tSDEdge.setTargetClipping((ct)this.targetEdgeClippingMap.get(tSDEdge));
        }
    }

    protected void redoAction() throws Throwable {
        this.node.remove(this.connector);
    }

    public List getAffectedObjects() {
        Vector<TSDNode> vector = new Vector<TSDNode>();
        if (this.node != null) {
            vector.add(this.node);
        }
        vector.addAll(this.sourceEdgeClippingMap.keySet());
        vector.addAll(this.targetEdgeClippingMap.keySet());
        vector.addAll(this.connectorLabels);
        return vector;
    }

    protected void doCleanup() {
        if (!this.connector.isOwned()) {
            this.connector.dispose();
        }
    }

    public TSDNode getNode() {
        return this.node;
    }

    public TSConnector getConnector() {
        return this.connector;
    }
}

