/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.graph.event.TSGraphChangeEvent;
import com.tomsawyer.graph.event.TSGraphChangeEventData;
import com.tomsawyer.util.command.TSCommand;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSAddEdgeCommand
extends TSCommand {
    private boolean typeSpecified;
    int edgeType = -1;
    TSDNode source;
    TSDNode target;
    TSDGraph graph;
    TSDEdge edge = null;
    TSConnector sourceConnector;
    TSConnector targetConnector;
    List graphs;
    List margins;

    public TSAddEdgeCommand(TSDGraph tSDGraph, TSDNode tSDNode, TSDNode tSDNode2) {
        this.typeSpecified = false;
        this.graph = tSDGraph;
        this.source = tSDNode;
        this.target = tSDNode2;
    }

    public TSAddEdgeCommand(int n, TSDGraph tSDGraph, TSDNode tSDNode, TSDNode tSDNode2) {
        this.typeSpecified = true;
        this.edgeType = n;
        this.graph = tSDGraph;
        this.source = tSDNode;
        this.target = tSDNode2;
    }

    protected void doAction() throws Throwable {
        this.storeOldMargins();
        boolean bl = this.graph.isFiringEvents();
        this.graph.setFireEvents(false);
        this.edge = this.typeSpecified ? (this.graph.isIntergraph() ? (TSDEdge)this.graph.getOwnerGraphManager().addEdge(this.edgeType, this.source, this.target) : (TSDEdge)this.graph.addEdge(this.edgeType, this.source, this.target)) : (this.graph.isIntergraph() ? (TSDEdge)this.graph.getOwnerGraphManager().addEdge(this.source, this.target) : (TSDEdge)this.graph.addEdge(this.source, this.target));
        this.edge.getOwnerGraph().remove(this.edge);
        this.graph.setFireEvents(bl);
        TSGraphChangeEvent tSGraphChangeEvent = new TSGraphChangeEvent(4L, new TSGraphChangeEventData(this.edge, null, this.graph));
        if (this.graph.fireEvent(tSGraphChangeEvent, true)) {
            this.edge.getOwnerGraph().insert(this.edge);
        } else {
            this.setAddToUndoStack(false);
        }
    }

    protected void undoAction() throws Throwable {
        this.sourceConnector = this.edge.getSourceConnector();
        this.targetConnector = this.edge.getTargetConnector();
        this.graph.remove(this.edge);
        this.restoreMargins();
    }

    public void redoAction() throws Throwable {
        this.graph.insert(this.edge);
        if (this.edge.isIntergraphEdge()) {
            this.edge.setSourceConnector(this.sourceConnector);
            this.edge.setTargetConnector(this.targetConnector);
        }
    }

    public List getAffectedObjects() {
        Vector<TSDEdge> vector = new Vector<TSDEdge>();
        if (this.edge != null) {
            vector.add(this.edge);
        }
        return vector;
    }

    protected void undoCleanup() {
        if (!this.edge.isOwned()) {
            this.edge.dispose();
        }
    }

    public int getType() {
        return this.edgeType;
    }

    public TSDNode getSourceNode() {
        return this.source;
    }

    public TSDNode getTargetNode() {
        return this.target;
    }

    public TSDGraph getGraph() {
        return this.graph;
    }

    public TSDEdge getEdge() {
        return this.edge;
    }

    private void storeOldMargins() {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.graph.getOwnerGraphManager();
        if (tSDGraphManager != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSDGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSDGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    private void restoreMargins() {
        if (this.graphs != null) {
            Iterator iterator = this.graphs.iterator();
            Iterator iterator2 = this.margins.iterator();
            while (iterator.hasNext()) {
                TSDGraph tSDGraph = (TSDGraph)iterator.next();
                TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
                double[] dArray = (double[])iterator2.next();
                double d = tSGraphTailor.getOriginalLeftConstantMargin();
                double d2 = tSGraphTailor.getOriginalRightConstantMargin();
                double d3 = tSGraphTailor.getOriginalBottomConstantMargin();
                double d4 = tSGraphTailor.getOriginalTopConstantMargin();
                tSGraphTailor.setLeftConstantMargin(dArray[0]);
                tSGraphTailor.setRightConstantMargin(dArray[1]);
                tSGraphTailor.setBottomConstantMargin(dArray[2]);
                tSGraphTailor.setTopConstantMargin(dArray[3]);
                tSGraphTailor.setOriginalLeftConstantMargin(d);
                tSGraphTailor.setOriginalRightConstantMargin(d2);
                tSGraphTailor.setOriginalBottomConstantMargin(d3);
                tSGraphTailor.setOriginalTopConstantMargin(d4);
                tSDGraph.updateBounds();
            }
        }
    }
}

