/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.util.command.TSCommand;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSAddConnectorCommand
extends TSCommand {
    double width;
    double height;
    double x;
    double y;
    double dx;
    double dy;
    TSDNode node;
    List detachedEdges;
    TSConnector connector;
    List graphs;
    List margins;

    public TSAddConnectorCommand(TSDNode tSDNode, double d, double d2, double d3, double d4, double d5, double d6) {
        this.node = tSDNode;
        this.connector = null;
        this.width = d;
        this.height = d2;
        this.x = d3;
        this.y = d4;
        this.dx = d5;
        this.dy = d6;
        this.detachedEdges = new Vector();
    }

    protected void doAction() throws Throwable {
        TSGraph tSGraph = this.node.getOwnerGraph();
        boolean bl = tSGraph.isFiringEvents();
        tSGraph.setFireEvents(false);
        this.storeOldMargins();
        this.connector = this.node.addConnector();
        this.connector.setLocalSize(this.width, this.height);
        this.connector.setLocalConstantXOffset(this.x);
        this.connector.setLocalConstantYOffset(this.y);
        this.connector.setProportionalXOffset(this.dx);
        this.connector.setProportionalYOffset(this.dy);
        this.node.remove(this.connector);
        tSGraph.setFireEvents(bl);
        TSDrawingChangeEvent tSDrawingChangeEvent = new TSDrawingChangeEvent(8L, new TSDrawingChangeEventData(this.connector, null, this.node));
        if (tSGraph.fireEvent(tSDrawingChangeEvent, true)) {
            this.node.insert(this.connector);
        } else {
            this.setAddToUndoStack(false);
        }
    }

    protected void undoAction() throws Throwable {
        this.detachedEdges = this.connector.disconnectedEdges();
        this.node.remove(this.connector);
        this.restoreMargins();
    }

    protected void redoAction() throws Throwable {
        this.node.insert(this.connector);
        Iterator iterator = this.detachedEdges.iterator();
        while (iterator.hasNext()) {
            TSDEdge tSDEdge = (TSDEdge)iterator.next();
            if (tSDEdge.getSourceNode() == this.node) {
                tSDEdge.setSourceConnector(this.connector);
                continue;
            }
            tSDEdge.setTargetConnector(this.connector);
        }
    }

    public List getAffectedObjects() {
        Vector<TSConnector> vector = new Vector<TSConnector>();
        if (this.connector != null) {
            vector.add(this.connector);
        }
        return vector;
    }

    protected void undoCleanup() {
        this.connector.dispose();
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public double getConstantXOffset() {
        return this.x;
    }

    public double getConstantYOffset() {
        return this.y;
    }

    public double getProportionalXOffset() {
        return this.dx;
    }

    public double getProportionalYOffset() {
        return this.dy;
    }

    public TSDNode getNode() {
        return this.node;
    }

    public TSConnector getConnector() {
        return this.connector;
    }

    private void storeOldMargins() {
        TSDGraphManager tSDGraphManager;
        if (this.node.getOwner() != null && (tSDGraphManager = (TSDGraphManager)this.node.getOwner().getOwnerGraphManager()) != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSDGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSDGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    private void restoreMargins() {
        if (this.graphs != null) {
            Iterator iterator = this.graphs.iterator();
            Iterator iterator2 = this.margins.iterator();
            while (iterator.hasNext()) {
                TSDGraph tSDGraph = (TSDGraph)iterator.next();
                TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
                double[] dArray = (double[])iterator2.next();
                double d = tSGraphTailor.getOriginalLeftConstantMargin();
                double d2 = tSGraphTailor.getOriginalRightConstantMargin();
                double d3 = tSGraphTailor.getOriginalBottomConstantMargin();
                double d4 = tSGraphTailor.getOriginalTopConstantMargin();
                tSGraphTailor.setLeftConstantMargin(dArray[0]);
                tSGraphTailor.setRightConstantMargin(dArray[1]);
                tSGraphTailor.setBottomConstantMargin(dArray[2]);
                tSGraphTailor.setTopConstantMargin(dArray[3]);
                tSGraphTailor.setOriginalLeftConstantMargin(d);
                tSGraphTailor.setOriginalRightConstantMargin(d2);
                tSGraphTailor.setOriginalBottomConstantMargin(d3);
                tSGraphTailor.setOriginalTopConstantMargin(d4);
                tSDGraph.updateBounds();
            }
        }
    }
}

