/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graph.event.TSGraphChangeEvent;
import com.tomsawyer.graph.event.TSGraphChangeEventData;
import com.tomsawyer.util.command.TSCommand;
import java.util.List;
import java.util.Vector;

public class TSAddChildGraphCommand
extends TSCommand {
    TSGraphMember graphMember;
    TSGraph childGraph;
    boolean isExpanded;

    public TSAddChildGraphCommand(TSGraphMember tSGraphMember) {
        if (tSGraphMember == null || !tSGraphMember.isOwned()) {
            throw new IllegalArgumentException();
        }
        this.graphMember = tSGraphMember;
        this.childGraph = null;
        this.isExpanded = false;
    }

    protected void doAction() throws Throwable {
        TSGraph tSGraph = (TSGraph)this.graphMember.getOwner();
        boolean bl = tSGraph.isFiringEvents();
        tSGraph.setFireEvents(false);
        this.childGraph = tSGraph.getOwnerGraphManager().addGraph(tSGraph.getType());
        this.childGraph.getOwnerGraphManager().remove(this.childGraph);
        TSGraph tSGraph2 = this.graphMember.getChildGraph();
        tSGraph.setFireEvents(bl);
        long l = this.graphMember instanceof TSNode ? 8192L : 16384L;
        TSGraphChangeEvent tSGraphChangeEvent = new TSGraphChangeEvent(l, new TSGraphChangeEventData(this.graphMember, tSGraph2, this.childGraph));
        if (tSGraph.fireEvent(tSGraphChangeEvent, true)) {
            this.childGraph.getOwnerGraphManager().insert(this.childGraph);
            this.graphMember.setChildGraph(this.childGraph);
        } else {
            this.setAddToUndoStack(false);
        }
    }

    protected void undoAction() throws Throwable {
        this.isExpanded = this.graphMember.isExpanded();
        if (this.isExpanded) {
            TSNestingManager.collapse((TSDNode)this.graphMember);
        }
        this.graphMember.setChildGraph(null);
    }

    protected void redoAction() throws Throwable {
        this.graphMember.setChildGraph(this.childGraph);
        if (this.isExpanded) {
            TSNestingManager.expand((TSDNode)this.graphMember);
        }
    }

    public List getAffectedObjects() {
        Vector<TSGraphMember> vector = new Vector<TSGraphMember>();
        vector.add(this.graphMember);
        return vector;
    }

    protected void undoCleanup() {
        if (this.childGraph.getParent() == null) {
            this.childGraph.dispose();
        }
    }

    public TSGraphMember getGraphMember() {
        return this.graphMember;
    }

    public TSGraph getChildGraph() {
        return this.childGraph;
    }
}

