/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing;

import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSLabel;
import com.tomsawyer.drawing.TSSolidGeometricObject;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.graph.TSGraphObject;

public abstract class TSRectangularObjectLabel
extends TSLabel {
    double dx;
    double dy;
    double fx;
    double fy;

    protected TSRectangularObjectLabel() {
    }

    protected TSRectangularObjectLabel(TSGraphObject tSGraphObject) {
        this.setOwner(tSGraphObject);
    }

    protected void initGraphObject() {
        super.initGraphObject();
        this.dx = 0.0;
        this.dy = 0.0;
        this.fx = 0.0;
        this.fy = 0.0;
        double d = this.getLocalDefaultWidth() / 2.0;
        double d2 = this.getLocalDefaultHeight() / 2.0;
        this.assignBounds(-d, -d2, d, d2);
    }

    public void setLocalSize(double d, double d2) {
        TSConstRect tSConstRect = this.getLocalBounds();
        this.assignSize(d, d2);
        if (this.getOwnerGraph() != null && ((TSDGraph)this.getOwnerGraph()).isGeometryChangeNotified()) {
            this.notifyOwnerOnResize(tSConstRect);
        }
        this.fireLabelResizedEvent(tSConstRect);
    }

    public void setLocalCenter(double d, double d2) {
        TSConstRect tSConstRect = this.getLocalBounds();
        this.assignCenter(d, d2);
        if (this.getOwnerGraph() != null && ((TSDGraph)this.getOwnerGraph()).isGeometryChangeNotified()) {
            this.notifyOwnerOnMove(tSConstRect);
        }
        this.fireLabelMovedEvent(tSConstRect);
    }

    public void setOffset(double d, double d2, double d3, double d4) {
        this.setLocalOffset(d, d2, d3, d4);
    }

    public void setLocalOffset(double d, double d2, double d3, double d4) {
        TSConstRect tSConstRect = this.getLocalBounds();
        this.dx = d3;
        this.dy = d4;
        this.fx = d;
        this.fy = d2;
        TSSolidGeometricObject tSSolidGeometricObject = (TSSolidGeometricObject)((Object)this.getOwner());
        this.labelBounds.setCenter(tSSolidGeometricObject.getLocalCenterX() + tSSolidGeometricObject.getLocalWidth() / 2.0 * this.fx + this.dx, tSSolidGeometricObject.getLocalCenterY() + tSSolidGeometricObject.getLocalHeight() / 2.0 * this.fy + this.dy);
        if (this.getOwnerGraph() != null && ((TSDGraph)this.getOwnerGraph()).isGeometryChangeNotified()) {
            this.notifyOwnerOnMove(tSConstRect);
        }
        this.fireLabelMovedEvent(tSConstRect);
    }

    public void setOffset(String string, double d) {
        this.setLocalOffset(string, d);
    }

    public abstract void setLocalOffset(String var1, double var2);

    public void setDefaultOffset() {
        this.setLocalOffset(0.0, 0.0, 0.0, 0.0);
    }

    public void setConstantOffset(double d, double d2) {
        this.setLocalConstantOffset(d, d2);
    }

    public void setLocalConstantOffset(double d, double d2) {
        this.setLocalOffset(this.fx, this.fy, d, d2);
    }

    public void setProportionalOffset(double d, double d2) {
        this.setOffset(d, d2, this.dx, this.dy);
    }

    public TSConstPoint getAttachmentPoint() {
        TSPoint tSPoint = new TSPoint(this.getLocalAttachmentPoint());
        if (this.getOwnerGraph() != null) {
            ((TSDGraph)this.getOwnerGraph()).expandedTransformPoint(tSPoint);
        }
        return tSPoint;
    }

    public abstract TSConstPoint getLocalAttachmentPoint();

    public double getAttachmentX() {
        return this.getAttachmentPoint().getX();
    }

    public double getLocalAttachmentX() {
        return this.getLocalAttachmentPoint().getX();
    }

    public double getAttachmentY() {
        return this.getAttachmentPoint().getY();
    }

    public double getLocalAttachmentY() {
        return this.getLocalAttachmentPoint().getY();
    }

    public TSConstPoint getDrawableAttachmentPoint() {
        return this.getLocalAttachmentPoint();
    }

    public TSConstSize getConstantOffset() {
        return this.getLocalConstantOffset();
    }

    public TSConstSize getLocalConstantOffset() {
        return new TSConstSize(this.dx, this.dy);
    }

    public double getConstantOffsetX() {
        return this.getLocalConstantOffsetX();
    }

    public double getLocalConstantOffsetX() {
        return this.dx;
    }

    public double getConstantOffsetY() {
        return this.getLocalConstantOffsetY();
    }

    public double getLocalConstantOffsetY() {
        return this.dy;
    }

    public TSConstPoint getProportionalOffset() {
        return new TSConstPoint(this.fx, this.fy);
    }

    public double getProportionalOffsetX() {
        return this.fx;
    }

    public double getProportionalOffsetY() {
        return this.fy;
    }

    public void copy(Object object, boolean bl) {
        super.copy(object, bl);
        TSRectangularObjectLabel tSRectangularObjectLabel = (TSRectangularObjectLabel)object;
        this.dx = tSRectangularObjectLabel.dx;
        this.dy = tSRectangularObjectLabel.dy;
        this.fx = tSRectangularObjectLabel.fx;
        this.fy = tSRectangularObjectLabel.fy;
    }

    abstract void notifyOwnerOnMove(TSConstRect var1);

    abstract void notifyOwnerOnResize(TSConstRect var1);

    boolean updateBounds() {
        TSSolidGeometricObject tSSolidGeometricObject = (TSSolidGeometricObject)((Object)this.getOwner());
        double d = tSSolidGeometricObject.getLocalCenterX();
        double d2 = tSSolidGeometricObject.getLocalCenterY();
        d = d + tSSolidGeometricObject.getLocalWidth() * this.getProportionalOffsetX() / 2.0 + this.getLocalConstantOffsetX();
        d2 = d2 + tSSolidGeometricObject.getLocalHeight() * this.getProportionalOffsetY() / 2.0 + this.getLocalConstantOffsetY();
        if (this.getLocalCenterX() == d && this.getLocalCenterY() == d2) {
            return false;
        }
        TSConstRect tSConstRect = this.getLocalBounds();
        this.assignCenter(d, d2);
        this.notifyOwnerOnMove(tSConstRect);
        return true;
    }

    public void assignCenter(double d, double d2) {
        super.assignCenter(d, d2);
        TSSolidGeometricObject tSSolidGeometricObject = (TSSolidGeometricObject)((Object)this.getOwner());
        if (tSSolidGeometricObject != null) {
            if (d > tSSolidGeometricObject.getLocalRight()) {
                this.dx = d - tSSolidGeometricObject.getLocalRight();
                this.fx = 1.0;
            } else if (d < tSSolidGeometricObject.getLocalLeft()) {
                this.dx = d - tSSolidGeometricObject.getLocalLeft();
                this.fx = -1.0;
            } else {
                this.dx = 0.0;
                this.fx = tSSolidGeometricObject.getLocalWidth() == 0.0 ? 0.0 : (d - tSSolidGeometricObject.getLocalCenterX()) * 2.0 / tSSolidGeometricObject.getLocalWidth();
            }
            if (d2 > tSSolidGeometricObject.getLocalTop()) {
                this.dy = d2 - tSSolidGeometricObject.getLocalTop();
                this.fy = 1.0;
            } else if (d2 < tSSolidGeometricObject.getLocalBottom()) {
                this.dy = d2 - tSSolidGeometricObject.getLocalBottom();
                this.fy = -1.0;
            } else {
                this.dy = 0.0;
                this.fy = tSSolidGeometricObject.getLocalHeight() == 0.0 ? 0.0 : (d2 - tSSolidGeometricObject.getLocalCenterY()) * 2.0 / tSSolidGeometricObject.getLocalHeight();
            }
        } else {
            this.dx = 0.0;
            this.dy = 0.0;
            this.fx = 0.0;
            this.fy = 0.0;
        }
    }

    public void ltShiftBounds() {
        TSSolidGeometricObject tSSolidGeometricObject = (TSSolidGeometricObject)((Object)this.getOwner());
        this.assignCenter(tSSolidGeometricObject.getLocalCenterX() + this.getProportionalOffsetX() * tSSolidGeometricObject.getLocalWidth() / 2.0 + this.getLocalConstantOffsetX(), tSSolidGeometricObject.getLocalCenterY() + this.getProportionalOffsetY() * tSSolidGeometricObject.getLocalHeight() / 2.0 + this.getLocalConstantOffsetY());
    }

    protected void fireLabelMovedEvent(TSConstRect tSConstRect) {
        if (this.getOwner() != null && this.getOwner().getOwnerGraph() != null && !this.getLocalCenter().equals(tSConstRect.getCenter())) {
            this.getOwner().getOwnerGraph().fireEvent(new TSDrawingChangeEvent(8192L, new TSDrawingChangeEventData(this, tSConstRect, this.getLocalBounds())));
        }
    }

    protected void fireLabelResizedEvent(TSConstRect tSConstRect) {
        if (this.getOwner() != null && this.getOwner().getOwnerGraph() != null && !this.getLocalSize().equals(tSConstRect.getSize())) {
            this.getOwner().getOwnerGraph().fireEvent(new TSDrawingChangeEvent(131072L, new TSDrawingChangeEventData(this, tSConstRect, this.getLocalBounds())));
        }
    }
}

