/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing;

import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSGNode;
import com.tomsawyer.drawing.TSPEdge;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.TSSystem;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TSPNode
extends TSGNode {
    public static final double WIDTH = 5.0;
    public static final double HEIGHT = 5.0;
    public static final double CENTER_X = 0.0;
    public static final double CENTER_Y = 0.0;
    TSPoint center;

    protected TSPNode() {
    }

    protected TSPNode(TSGraphObject tSGraphObject) {
        this.setOwner(tSGraphObject);
    }

    protected void initGraphObject() {
        super.initGraphObject();
        this.center = new TSPoint(0.0, 0.0);
    }

    public boolean isViewable() {
        return this.isOwned() && this.getOwner().isViewable();
    }

    public TSPEdge getInEdge() {
        TSSystem.tsAssert(this.inEdges().size() + this.outEdges().size() <= 2, "Too many edges at a path node");
        TSPEdge tSPEdge = this.findInEdge();
        if (tSPEdge != null) {
            return tSPEdge;
        }
        throw new NoSuchElementException();
    }

    public boolean hasInEdge() {
        TSSystem.tsAssert(this.inEdges().size() + this.outEdges().size() <= 2, "Too many edges at a path node");
        return this.findInEdge() != null;
    }

    TSPEdge findInEdge() {
        if (!this.inEdges().isEmpty()) {
            return (TSPEdge)this.inEdges().get(0);
        }
        Iterator iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            TSPEdge tSPEdge = (TSPEdge)iterator.next();
            if (tSPEdge.getTargetNode() != this) continue;
            return tSPEdge;
        }
        return null;
    }

    public TSPEdge getOutEdge() {
        TSSystem.tsAssert(this.inEdges().size() + this.outEdges().size() <= 2, "Too many edges at a path node");
        TSPEdge tSPEdge = this.findOutEdge();
        if (tSPEdge != null) {
            return tSPEdge;
        }
        throw new NoSuchElementException();
    }

    public boolean hasOutEdge() {
        TSSystem.tsAssert(this.inEdges().size() + this.outEdges().size() <= 2, "Too many edges at a path node");
        return this.findOutEdge() != null;
    }

    TSPEdge findOutEdge() {
        if (!this.outEdges().isEmpty()) {
            return (TSPEdge)this.outEdges().get(0);
        }
        Iterator iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            TSPEdge tSPEdge = (TSPEdge)iterator.next();
            if (tSPEdge.getSourceNode() != this) continue;
            return tSPEdge;
        }
        return null;
    }

    public boolean inside(TSConstRect tSConstRect) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.locallyInside(tSConstRect);
    }

    public boolean locallyInside(TSConstRect tSConstRect) {
        return tSConstRect.contains(this.getLocalBounds());
    }

    public boolean contains(double d, double d2) {
        TSPoint tSPoint = new TSPoint(d, d2);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformPoint(tSPoint);
        }
        return this.locallyContains(tSPoint.getX(), tSPoint.getY());
    }

    public boolean locallyContains(double d, double d2) {
        return this.getLocalLeft() <= d && d <= this.getLocalRight() && this.getLocalBottom() <= d2 && d2 <= this.getLocalTop();
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        TSRect tSRect = new TSRect(d, d2, d3, d4);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.locallyContains(tSRect.getLeft(), tSRect.getBottom(), tSRect.getRight(), tSRect.getTop());
    }

    public boolean locallyContains(double d, double d2, double d3, double d4) {
        return d >= this.getLocalLeft() && d2 >= this.getLocalBottom() && d3 <= this.getLocalRight() && d4 <= this.getLocalTop();
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        TSRect tSRect = new TSRect(d, d2, d3, d4);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.locallyIntersects(tSRect.getLeft(), tSRect.getBottom(), tSRect.getRight(), tSRect.getTop());
    }

    public boolean locallyIntersects(double d, double d2, double d3, double d4) {
        return d3 >= this.getLocalLeft() && this.getLocalRight() >= d && d4 >= this.getLocalBottom() && this.getLocalTop() >= d2;
    }

    public TSConstRect getBounds() {
        TSRect tSRect = new TSRect(this.getLocalBounds());
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.expandedTransformRect(tSRect);
        }
        return tSRect;
    }

    public TSConstRect getLocalBounds() {
        return new TSConstRect(this.getLocalLeft(), this.getLocalBottom(), this.getLocalRight(), this.getLocalTop());
    }

    public double getCenterX() {
        double d = this.getLocalCenterX();
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalCenterX() {
        return this.center.getX();
    }

    public double getCenterY() {
        double d = this.getLocalCenterY();
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalCenterY() {
        return this.center.getY();
    }

    public double getHeight() {
        return this.getLocalHeight();
    }

    public double getLocalHeight() {
        return 5.0;
    }

    public double getWidth() {
        return this.getLocalWidth();
    }

    public double getLocalWidth() {
        return 5.0;
    }

    public void setCenter(double d, double d2) {
        TSPoint tSPoint = new TSPoint(d, d2);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformPoint(tSPoint);
        }
        this.setLocalCenter(tSPoint.getX(), tSPoint.getY());
    }

    public void setLocalCenter(double d, double d2) {
        TSConstRect tSConstRect = this.getLocalBounds();
        this.assignCenter(d, d2);
        TSGraphObject tSGraphObject = this.getOwner();
        if (this.isOwned() && tSGraphObject.isOwned() && ((TSDGraph)tSGraphObject.getOwner()).isGeometryChangeNotified()) {
            this.notifyOwnerOnMove(tSConstRect);
        }
        if (this.getOwner() != null && this.getOwner().getOwnerGraph() != null && !this.getLocalCenter().equals(tSConstRect.getCenter())) {
            this.getOwner().getOwnerGraph().fireEvent(new TSDrawingChangeEvent(16384L, new TSDrawingChangeEventData(this, tSConstRect, this.getLocalBounds())));
        }
    }

    public TSConstPoint getLocalCenter() {
        return this.center;
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        TSRect tSRect = new TSRect(d, d2, d3, d4);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        this.setLocalBounds(tSRect.getLeft(), tSRect.getBottom(), tSRect.getRight(), tSRect.getTop());
    }

    public void setLocalBounds(double d, double d2, double d3, double d4) {
        this.setLocalCenter((d + d3) / 2.0, (d2 + d4) / 2.0);
    }

    public void setSize(TSConstSize tSConstSize) {
    }

    public void setLocalSize(TSConstSize tSConstSize) {
    }

    public void setSize(double d, double d2) {
    }

    public void setLocalSize(double d, double d2) {
    }

    public void setWidth(double d) {
    }

    public void setLocalWidth(double d) {
    }

    public void setHeight(double d) {
    }

    public void setLocalHeight(double d) {
    }

    void notifyOwnerOnMove(TSConstRect tSConstRect) {
        if (this.isOwned()) {
            TSSystem.tsAssert(this.getOwner() != null);
            TSDEdge tSDEdge = (TSDEdge)this.getOwner();
            tSDEdge.updateEdgeBoundsOnBendMove(tSConstRect, this.getLocalBounds());
            this.recomputeIncidentClippingPoints();
        }
    }

    public boolean isPathNode() {
        return true;
    }

    public void copy(Object object, boolean bl) {
        super.copy(object, bl);
        TSPNode tSPNode = (TSPNode)object;
        this.center = (TSPoint)tSPNode.getLocalCenter().clone();
    }

    public void assignCenter(double d, double d2) {
        this.center.setX(d);
        this.center.setY(d2);
        this.recomputeIncidentClippingPoints();
    }

    public void dispose() {
        if (this.isOwned()) {
            ((TSDEdge)this.getOwner()).discard(this);
        } else if (!this.isDiscarded()) {
            this.onDiscard(this.getOwner());
        }
    }

    public boolean isVisible() {
        return this.getOwner().isVisible();
    }

    public void onInsert(TSGraphObject tSGraphObject) {
        super.onInsert(tSGraphObject);
    }

    public void onRemove(TSGraphObject tSGraphObject) {
        tSGraphObject.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(32L, new TSDrawingChangeEventData(this, tSGraphObject, null)));
        super.onRemove(tSGraphObject);
    }

    public void onDiscard(TSGraphObject tSGraphObject) {
        if (this.getOwnerGraph() != null) {
            this.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(256L, new TSDrawingChangeEventData(this, tSGraphObject, null)));
        }
        super.onDiscard(tSGraphObject);
    }
}

