/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing;

import com.tomsawyer.drawing.TSSolidGeometricObject;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSegment;
import com.tomsawyer.drawing.geometry.TSShape;
import com.tomsawyer.util.TSProperty;
import java.util.List;
import java.util.Vector;

public abstract class TSAbstractShape
implements TSShape,
Cloneable {
    public static final double WIDTH = 100.0;
    public static final double HEIGHT = 100.0;
    TSSolidGeometricObject ownerObject;

    public Object clone() {
        try {
            TSAbstractShape tSAbstractShape = (TSAbstractShape)super.clone();
            tSAbstractShape.copy(this);
            return tSAbstractShape;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.getMessage());
        }
    }

    protected void copy(TSAbstractShape tSAbstractShape) {
        this.setOwner(null);
    }

    public TSSolidGeometricObject getOwner() {
        return this.ownerObject;
    }

    public void setOwner(TSSolidGeometricObject tSSolidGeometricObject) {
        this.ownerObject = tSSolidGeometricObject;
    }

    public boolean contains(TSConstPoint tSConstPoint) {
        return this.contains(tSConstPoint.getX(), tSConstPoint.getY());
    }

    public boolean contains(TSConstRect tSConstRect) {
        double d = tSConstRect.getLeft();
        double d2 = tSConstRect.getRight();
        double d3 = tSConstRect.getTop();
        double d4 = tSConstRect.getBottom();
        return this.contains(d, d3) && this.contains(d2, d3) && this.contains(d2, d4) && this.contains(d, d4);
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.contains(d, d4) && this.contains(d3, d4) && this.contains(d3, d2) && this.contains(d, d2);
    }

    public boolean intersects(TSConstRect tSConstRect) {
        return this.intersects(tSConstRect.getLeft(), tSConstRect.getBottom(), tSConstRect.getRight(), tSConstRect.getTop());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        boolean bl = false;
        if (d3 >= this.getLeft() && this.getRight() >= d && d4 >= this.getBottom() && this.getTop() >= d2) {
            TSConstRect tSConstRect = new TSConstRect(d, d2, d3, d4);
            if (tSConstRect.contains(this.getLeft(), this.getBottom(), this.getRight(), this.getTop())) {
                bl = true;
            } else if (this.intersection(d, d4, d, d2) != null) {
                bl = true;
            } else if (this.intersection(d, d4, d3, d4) != null) {
                bl = true;
            } else if (this.intersection(d3, d4, d3, d2) != null) {
                bl = true;
            } else if (this.intersection(d3, d2, d, d2) != null) {
                bl = true;
            } else if (this.contains(d, d2, d3, d4)) {
                bl = true;
            }
        }
        return bl;
    }

    public TSConstPoint intersection(TSConstSegment tSConstSegment) {
        if (tSConstSegment == null) {
            return null;
        }
        return this.intersection(tSConstSegment.getX1(), tSConstSegment.getY1(), tSConstSegment.getX2(), tSConstSegment.getY2());
    }

    public TSConstRect getBounds() {
        if (this.getOwner() == null) {
            return new TSConstRect(0.0, 0.0, 100.0, 100.0);
        }
        return this.getOwner().getLocalBounds();
    }

    public double getLeft() {
        if (this.getOwner() != null) {
            return this.getOwner().getLocalLeft();
        }
        return 0.0;
    }

    public double getRight() {
        if (this.getOwner() != null) {
            return this.getOwner().getLocalRight();
        }
        return 100.0;
    }

    public double getTop() {
        if (this.getOwner() != null) {
            return this.getOwner().getLocalTop();
        }
        return 100.0;
    }

    public double getBottom() {
        if (this.getOwner() != null) {
            return this.getOwner().getLocalBottom();
        }
        return 0.0;
    }

    public double getWidth() {
        if (this.getOwner() != null) {
            return this.getOwner().getLocalWidth();
        }
        return 100.0;
    }

    public double getHeight() {
        if (this.getOwner() != null) {
            return this.getOwner().getLocalHeight();
        }
        return 100.0;
    }

    public List getChangedProperties() {
        return new Vector();
    }

    public void setProperty(TSProperty tSProperty) {
    }

    public Object getParentEventSource() {
        return this.getOwner();
    }

    public abstract boolean contains(double var1, double var3);

    public abstract TSConstPoint intersection(double var1, double var3, double var5, double var7);
}

