/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.diagramming.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.TSLabel;
import com.tomsawyer.drawing.TSSolidGeometricObject;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.drawing.geometry.TSSize;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.util.command.TSCommand;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSResizeGraphObjectCommand
extends TSCommand {
    TSConstRect oldBounds;
    TSConstRect newBounds;
    TSSolidGeometricObject graphObject;
    TSConstSize oldOriginalSize;
    List graphs;
    List margins;

    public TSResizeGraphObjectCommand(TSSolidGeometricObject tSSolidGeometricObject, TSConstRect tSConstRect, TSConstRect tSConstRect2) {
        if (tSSolidGeometricObject == null || tSConstRect == null || tSConstRect2 == null) {
            throw new IllegalArgumentException("null graphObject, oldBounds, or newBounds");
        }
        this.graphObject = tSSolidGeometricObject;
        this.oldBounds = tSConstRect;
        this.newBounds = tSConstRect2;
        if (this.graphObject instanceof TSDNode) {
            TSDNode tSDNode = (TSDNode)this.graphObject;
            if (this.oldOriginalSize == null) {
                this.oldOriginalSize = tSDNode.getLocalOriginalSize();
            }
        }
    }

    protected void doAction() throws Throwable {
        long l = this.graphObject instanceof TSNode ? 65536L : (this.graphObject instanceof TSConnector ? 262144L : 131072L);
        if (this.graphObject.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(l, new TSDrawingChangeEventData(this.graphObject, this.oldBounds, this.newBounds)), true)) {
            this.resizeObject();
        } else {
            this.setAddToUndoStack(false);
        }
    }

    protected void undoAction() throws Throwable {
        Cloneable cloneable;
        if (this.graphObject instanceof TSDNode) {
            cloneable = (TSDNode)this.graphObject;
            cloneable.setLocalOriginalSize(this.oldOriginalSize);
        }
        cloneable = new TSRect(this.oldBounds);
        if (this.graphObject instanceof TSDNode || this.graphObject instanceof TSLabel) {
            if (this.graphObject instanceof TSDNode) {
                ((TSDNode)this.graphObject).adjustBounds(this.oldBounds.getLeft(), this.oldBounds.getBottom(), this.oldBounds.getRight(), this.oldBounds.getTop(), (TSRect)cloneable);
            } else {
                ((TSLabel)this.graphObject).adjustBounds(this.oldBounds.getLeft(), this.oldBounds.getBottom(), this.oldBounds.getRight(), this.oldBounds.getTop(), (TSRect)cloneable);
            }
        }
        this.graphObject.setLocalBounds((TSConstRect)cloneable);
        this.restoreMargins();
    }

    private void resizeObject() {
        Cloneable cloneable;
        if (this.graphObject instanceof TSDNode) {
            cloneable = (TSDNode)this.graphObject;
            TSSize tSSize = ((TSDNode)cloneable).adjustSize(this.newBounds.getWidth(), this.newBounds.getHeight(), null);
            ((TSDNode)cloneable).setLocalOriginalSize(tSSize);
        }
        cloneable = new TSRect(this.newBounds);
        if (this.graphObject instanceof TSDNode || this.graphObject instanceof TSLabel) {
            if (this.graphObject instanceof TSDNode) {
                ((TSDNode)this.graphObject).adjustBounds(this.newBounds.getLeft(), this.newBounds.getBottom(), this.newBounds.getRight(), this.newBounds.getTop(), (TSRect)cloneable);
            } else {
                ((TSLabel)this.graphObject).adjustBounds(this.newBounds.getLeft(), this.newBounds.getBottom(), this.newBounds.getRight(), this.newBounds.getTop(), (TSRect)cloneable);
            }
        }
        this.graphObject.setLocalBounds((TSConstRect)cloneable);
    }

    protected void redoAction() throws Throwable {
        this.resizeObject();
    }

    public TSSolidGeometricObject getGraphObject() {
        return this.graphObject;
    }

    public TSConstRect getNewBounds() {
        return this.newBounds;
    }

    public TSConstRect getLocalOldBounds() {
        return this.oldBounds;
    }

    public TSConstSize getLocalOldOriginalSize() {
        return this.oldOriginalSize;
    }

    private void storeOldMargins() {
        TSDGraphManager tSDGraphManager;
        if (this.graphObject.getOwnerGraph() != null && (tSDGraphManager = (TSDGraphManager)this.graphObject.getOwnerGraph().getOwnerGraphManager()) != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSDGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSDGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    private void restoreMargins() {
        if (this.graphs != null) {
            Iterator iterator = this.graphs.iterator();
            Iterator iterator2 = this.margins.iterator();
            while (iterator.hasNext()) {
                TSDGraph tSDGraph = (TSDGraph)iterator.next();
                TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
                double[] dArray = (double[])iterator2.next();
                double d = tSGraphTailor.getOriginalLeftConstantMargin();
                double d2 = tSGraphTailor.getOriginalRightConstantMargin();
                double d3 = tSGraphTailor.getOriginalBottomConstantMargin();
                double d4 = tSGraphTailor.getOriginalTopConstantMargin();
                tSGraphTailor.setLeftConstantMargin(dArray[0]);
                tSGraphTailor.setRightConstantMargin(dArray[1]);
                tSGraphTailor.setBottomConstantMargin(dArray[2]);
                tSGraphTailor.setTopConstantMargin(dArray[3]);
                tSGraphTailor.setOriginalLeftConstantMargin(d);
                tSGraphTailor.setOriginalRightConstantMargin(d2);
                tSGraphTailor.setOriginalBottomConstantMargin(d3);
                tSGraphTailor.setOriginalTopConstantMargin(d4);
                tSDGraph.updateBounds();
            }
        }
    }

    public void setMarginLists(List list, List list2) {
        this.graphs = new Vector(list);
        this.margins = new Vector(list2);
    }
}

