/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.diagramming;

import com.tomsawyer.complexity.TSFoldingManager;
import com.tomsawyer.complexity.TSHidingManager;
import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.diagramming.ce;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSConnectorLabel;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSEdgeLabel;
import com.tomsawyer.drawing.TSGNode;
import com.tomsawyer.drawing.TSLabel;
import com.tomsawyer.drawing.TSNodeLabel;
import com.tomsawyer.drawing.TSPNode;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.drawing.geometry.TSSize;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphManager;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graph.de;
import com.tomsawyer.util.TSOptionData;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.df;
import com.tomsawyer.util.f0;
import com.tomsawyer.xml.TSCompositeXMLReader;
import com.tomsawyer.xml.TSCompositeXMLWriter;
import com.tomsawyer.xml.TSTopLevelXMLReader;
import com.tomsawyer.xml.TSTopLevelXMLWriter;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TSCutCopyPasteControl
implements ClipboardOwner {
    private TSDGraphManager clipboardGraphManager;
    private TSDGraphManager originalGraphManager;
    private List inputNodeList;
    private List inputEdgeList;
    private List inputEdgeLabelList;
    private List inputNodeLabelList;
    private List inputConnectorLabelList;
    private List affectedGraphList = new Vector();
    private List affectedNodeList = new Vector();
    private List affectedEdgeList = new Vector();
    Vector partiallyAffectedEdgeList = new Vector();
    private List affectedEdgeLabelList = new Vector();
    private List affectedNodeLabelList = new Vector();
    private List affectedConnectorLabelList = new Vector();
    public static final DataFlavor graphFlavor = new DataFlavor(class$com$tomsawyer$drawing$TSDGraph == null ? (class$com$tomsawyer$drawing$TSDGraph = TSCutCopyPasteControl.class$("com.tomsawyer.drawing.TSDGraph")) : class$com$tomsawyer$drawing$TSDGraph, "application/x-java-serialized-object");
    Clipboard myClipboard;
    private static final String MAGIC_LINE = "k12rOD_a_334Si_S45EtaG:";
    long timeStamp;
    public static final TSSize shiftAmount = new TSSize(10.0, -10.0);
    private boolean usingXML;
    Class graphManagerXMLWriterClass = null;
    Class graphManagerXMLReaderClass = null;
    Class serviceInputDataXMLWriterClass = null;
    Class serviceInputDataXMLReaderClass = null;
    TSOptionData originalServiceInputData;
    TSOptionData clipboardServiceInputData;
    final String GRAPH_MANAGER = "graphManager";
    final String SERVICE_INPUT_DATA = "serviceInputData";
    static /* synthetic */ Class class$com$tomsawyer$drawing$TSDGraphManager;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$tomsawyer$drawing$TSDGraph;

    public TSCutCopyPasteControl(Clipboard clipboard) {
        this.init();
        this.myClipboard = clipboard;
    }

    void init() {
        if (this.clipboardGraphManager != null) {
            TSNestingManager.discardManager(this.clipboardGraphManager);
            TSFoldingManager.discardManager(this.clipboardGraphManager);
            TSHidingManager.discardManager(this.clipboardGraphManager);
            this.clipboardGraphManager = null;
        }
        this.timeStamp = -1L;
        this.originalGraphManager = null;
        this.originalServiceInputData = null;
        this.clipboardServiceInputData = null;
        this.clipboardServiceInputData = null;
        this.inputNodeList = new Vector();
        this.inputEdgeList = new Vector();
        this.inputEdgeLabelList = new Vector();
        this.inputNodeLabelList = new Vector();
        this.inputConnectorLabelList = new Vector();
        this.clearAffectedObjectLists();
        this.setUsingXML(this.isUsingXMLByDefault());
    }

    public void copy(TSDGraphManager tSDGraphManager, List list, List list2, List list3, List list4, List list5) {
        this.copy(tSDGraphManager, list, list2, list3, list4, list5, false);
    }

    private void copy(TSDGraphManager tSDGraphManager, List list, List list2, List list3, List list4, List list5, boolean bl) {
        this.copy(tSDGraphManager, null, list, list2, list3, list4, list5, bl);
    }

    public void copy(TSDGraphManager tSDGraphManager, TSOptionData tSOptionData, List list, List list2, List list3, List list4, List list5) {
        this.copy(tSDGraphManager, tSOptionData, list, list2, list3, list4, list5, false);
    }

    private void copy(TSDGraphManager tSDGraphManager, TSOptionData tSOptionData, List list, List list2, List list3, List list4, List list5, boolean bl) {
        if (tSDGraphManager != null) {
            this.setAffectedObjectLists(tSDGraphManager, tSOptionData, list, list2, list3, list4, list5);
            this.privateCopy();
            if (!bl) {
                this.resetOriginalReferences();
            }
        }
    }

    public void cut(TSDGraphManager tSDGraphManager, List list, List list2, List list3, List list4, List list5, List list6, List list7, List list8, List list9, List list10) {
        this.cut(tSDGraphManager, null, list, list2, list3, list4, list5, list6, list7, list8, list9, list10);
    }

    public void cut(TSDGraphManager tSDGraphManager, TSOptionData tSOptionData, List list, List list2, List list3, List list4, List list5, List list6, List list7, List list8, List list9, List list10) {
        if (tSDGraphManager != null && (list != null || list2 != null || list3 != null || list4 != null || list5 != null)) {
            TSDGraph tSDGraph;
            TSGraphMember tSGraphMember;
            Object object;
            Iterator iterator;
            Object object2;
            Object object3;
            if (list6 != null) {
                list6.clear();
            }
            if (list7 != null) {
                list7.clear();
            }
            if (list10 != null) {
                list10.clear();
            }
            if (list8 != null) {
                list8.clear();
            }
            if (list9 != null) {
                list9.clear();
            }
            this.setAffectedObjectLists(tSDGraphManager, tSOptionData, list, list2, list3, list4, list5);
            Iterator iterator2 = this.affectedEdgeLabelList().iterator();
            while (iterator2.hasNext()) {
                object3 = (TSEdgeLabel)iterator2.next();
                object2 = (TSDEdge)((TSGraphObject)object3).getOwner();
                ((TSDEdge)object2).remove((TSLabel)object3);
                list10.add(object3);
            }
            object3 = this.affectedNodeLabelList().iterator();
            while (object3.hasNext()) {
                object2 = (TSNodeLabel)object3.next();
                iterator = (TSDNode)((TSGraphObject)object2).getOwner();
                ((TSDNode)((Object)iterator)).remove((TSLabel)object2);
                list8.add(object2);
            }
            object2 = this.affectedConnectorLabelList().iterator();
            while (object2.hasNext()) {
                iterator = (TSConnectorLabel)object2.next();
                object = (TSConnector)((TSGraphObject)((Object)iterator)).getOwner();
                ((TSConnector)object).remove((TSLabel)((Object)iterator));
                list9.add(iterator);
            }
            iterator = this.affectedNodeList().iterator();
            while (iterator.hasNext()) {
                object = (TSDNode)iterator.next();
                ((TSNode)object).setVisited(true);
            }
            object = this.affectedEdgeList().iterator();
            while (object.hasNext()) {
                tSGraphMember = (TSDEdge)object.next();
                tSDGraph = (TSDGraph)tSGraphMember.getOwner();
                if (!((TSEdge)tSGraphMember).getSourceNode().isVisited() && !((TSEdge)tSGraphMember).getTargetNode().isVisited()) continue;
                tSDGraph.getOwnerGraphManager().remove((TSEdge)tSGraphMember);
                list7.add(tSGraphMember);
            }
            iterator = this.affectedNodeList().iterator();
            while (iterator.hasNext()) {
                tSGraphMember = (TSDNode)iterator.next();
                tSDGraph = (TSDGraph)tSGraphMember.getOwner();
                tSDGraph.remove((TSNode)tSGraphMember);
                list6.add(tSGraphMember);
                ((TSNode)tSGraphMember).setVisited(true);
            }
            iterator = this.affectedNodeList().iterator();
            while (iterator.hasNext()) {
                tSGraphMember = (TSDNode)iterator.next();
                ((TSNode)tSGraphMember).setVisited(false);
            }
            this.privateCopy();
        }
    }

    public void paste(TSGraphObject tSGraphObject, long l, long l2, List list, List list2, List list3, List list4, List list5) throws IOException {
        this.paste(tSGraphObject, null, l, l2, list, list2, list3, list4, list5);
    }

    public void paste(TSGraphObject tSGraphObject, TSOptionData tSOptionData, long l, long l2, List list, List list2, List list3, List list4, List list5) throws IOException {
        if (tSGraphObject != null) {
            if (list != null) {
                list.clear();
            }
            if (list2 != null) {
                list2.clear();
            }
            if (list5 != null) {
                list5.clear();
            }
            if (list3 != null) {
                list3.clear();
            }
            if (list4 != null) {
                list4.clear();
            }
            this.fetchClipboardGraphManager(tSOptionData);
            TSPoint tSPoint = new TSPoint(l, l2);
            if (tSGraphObject instanceof TSDGraph) {
                TSDGraph tSDGraph = (TSDGraph)tSGraphObject;
                TSPoint tSPoint2 = this.getCenterOfClipboardGraph(true, false, false, false);
                TSSize tSSize = new TSSize(tSPoint.getX() - tSPoint2.getX(), tSPoint.getY() - tSPoint2.getY());
                this.pasteToGraph(tSDGraph, tSSize, list, list2, tSOptionData);
            } else if (tSGraphObject instanceof TSDNode) {
                TSDNode tSDNode = (TSDNode)tSGraphObject;
                TSPoint tSPoint3 = this.getCenterOfClipboardGraph(false, false, true, false);
                TSSize tSSize = new TSSize(tSPoint.getX() - tSPoint3.getX(), tSPoint.getY() - tSPoint3.getY());
                this.pasteToNode(tSDNode, tSSize, list3, tSOptionData);
            } else if (tSGraphObject instanceof TSConnector) {
                TSConnector tSConnector = (TSConnector)tSGraphObject;
                TSPoint tSPoint4 = this.getCenterOfClipboardGraph(false, false, false, true);
                TSSize tSSize = new TSSize(tSPoint.getX() - tSPoint4.getX(), tSPoint.getY() - tSPoint4.getY());
                this.pasteToConnector(tSConnector, tSSize, list4, tSOptionData);
            } else if (tSGraphObject instanceof TSDEdge) {
                TSDEdge tSDEdge = (TSDEdge)tSGraphObject;
                TSPoint tSPoint5 = this.getCenterOfClipboardGraph(false, true, false, false);
                TSSize tSSize = new TSSize(tSPoint.getX() - tSPoint5.getX(), tSPoint.getY() - tSPoint5.getY());
                this.pasteToEdge(tSDEdge, tSSize, list5, tSOptionData);
            }
            this.getClipboardGraphManager().nullifyUtilityObject();
        }
    }

    public void duplicate(TSDGraphManager tSDGraphManager, List list, List list2, List list3, List list4, List list5, List list6, List list7, List list8, List list9, List list10, TSSize tSSize) {
        this.duplicate(tSDGraphManager, null, list, list2, list3, list4, list5, list6, list7, list8, list9, list10, tSSize);
    }

    public void duplicate(TSDGraphManager tSDGraphManager, TSOptionData tSOptionData, List list, List list2, List list3, List list4, List list5, List list6, List list7, List list8, List list9, List list10, TSSize tSSize) {
        if (tSDGraphManager != null && (list != null || list2 != null || list3 != null || list4 != null || list5 != null)) {
            TSGraphObject tSGraphObject;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (list6 != null) {
                list6.clear();
            }
            if (list7 != null) {
                list7.clear();
            }
            if (list10 != null) {
                list10.clear();
            }
            if (list8 != null) {
                list8.clear();
            }
            if (list9 != null) {
                list9.clear();
            }
            this.copy(tSDGraphManager, tSOptionData, list, list2, list3, list4, list5, true);
            Iterator iterator = this.affectedNodeList().iterator();
            while (iterator.hasNext()) {
                object4 = (TSDNode)iterator.next();
                object3 = (TSDGraph)((TSGraphObject)object4).getOwner();
                this.cloneAndInsertNodeToGraph((TSDGraph)object3, (TSDNode)object4, tSSize, list6, true, tSOptionData, tSOptionData);
            }
            object4 = this.affectedEdgeList().iterator();
            while (object4.hasNext()) {
                object3 = (TSDEdge)object4.next();
                object2 = (TSDGraph)((TSGraphObject)object3).getOwner();
                object = (TSDNode)((TSEdge)object3).getSourceNode();
                tSGraphObject = (TSDNode)((TSEdge)object3).getTargetNode();
                if (((TSGraphObject)object).getUtilityObject() != null) {
                    object = (TSDNode)((TSGraphObject)object).getUtilityObject();
                }
                if (tSGraphObject.getUtilityObject() != null) {
                    tSGraphObject = (TSDNode)tSGraphObject.getUtilityObject();
                }
                this.cloneAndInsertEdgeToGraph((TSDGraph)object2, (TSDEdge)object3, (TSDNode)object, (TSDNode)tSGraphObject, tSSize, list7, true, tSOptionData, tSOptionData);
            }
            object3 = this.affectedNodeLabelList().iterator();
            while (object3.hasNext()) {
                object2 = (TSNodeLabel)object3.next();
                object = (TSDNode)((TSGraphObject)object2).getOwner();
                if (((TSGraphObject)object).getUtilityObject() != null) continue;
                this.cloneAndInsertNodeLabelToNode((TSDNode)object, (TSNodeLabel)object2, tSSize, list8, true, tSOptionData, tSOptionData);
            }
            object2 = this.affectedConnectorLabelList().iterator();
            while (object2.hasNext()) {
                object = (TSConnectorLabel)object2.next();
                tSGraphObject = (TSConnector)((TSGraphObject)object).getOwner();
                if (tSGraphObject.getUtilityObject() != null) continue;
                this.cloneAndInsertConnectorLabelToConnector((TSConnector)tSGraphObject, (TSConnectorLabel)object, tSSize, list9, true, tSOptionData, tSOptionData);
            }
            object = this.affectedEdgeLabelList().iterator();
            while (object.hasNext()) {
                tSGraphObject = (TSEdgeLabel)object.next();
                TSDEdge tSDEdge = (TSDEdge)tSGraphObject.getOwner();
                if (tSDEdge.getUtilityObject() != null) continue;
                this.cloneAndInsertEdgeLabelToEdge(tSDEdge, (TSEdgeLabel)tSGraphObject, tSSize, list10, true, tSOptionData, tSOptionData);
            }
            tSDGraphManager.nullifyUtilityObject();
        }
    }

    public void createClipboardGraph() {
        TSDGraph tSDGraph = null;
        TSSystem.tsAssert(this.getOriginalGraphManager() != null);
        this.getClipboardGraphManager().emptyTopology();
        tSDGraph = (TSDGraph)this.getClipboardGraphManager().addGraph();
        TSDNode tSDNode = (TSDNode)tSDGraph.addNode();
        TSConnector tSConnector = tSDNode.addConnector();
        TSDEdge tSDEdge = (TSDEdge)tSDGraph.addEdge(tSDNode, tSDNode);
        tSDNode.setVisible(false);
        tSConnector.setVisible(false);
        tSDEdge.setVisible(false);
        this.getClipboardGraphManager().setMainDisplayGraph(tSDGraph);
    }

    public boolean canPaste() {
        Transferable transferable = null;
        Clipboard clipboard = this.getClipboard();
        if (clipboard != null) {
            transferable = clipboard.getContents(this);
        }
        if (transferable == null) {
            return false;
        }
        if (this.isUsingSystemClipboard() && this.isUsingXML()) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                return string.startsWith(MAGIC_LINE);
            }
            catch (Exception exception) {
                return false;
            }
        }
        return transferable.isDataFlavorSupported(graphFlavor);
    }

    public void clearAffectedObjectLists() {
        this.affectedGraphList.clear();
        this.affectedNodeList.clear();
        this.affectedEdgeList.clear();
        this.affectedEdgeLabelList.clear();
        this.affectedNodeLabelList.clear();
        this.affectedConnectorLabelList.clear();
    }

    TSDGraphManager getOriginalGraphManager() {
        return this.originalGraphManager;
    }

    public void setAffectedObjectLists(TSDGraphManager tSDGraphManager, TSOptionData tSOptionData, List list, List list2, List list3, List list4, List list5) {
        if (tSDGraphManager != null) {
            this.originalGraphManager = tSDGraphManager;
            this.originalServiceInputData = tSOptionData;
            this.inputNodeList = list;
            this.inputEdgeList = list2;
            this.inputEdgeLabelList = list5;
            this.inputNodeLabelList = list3;
            this.inputConnectorLabelList = list4;
            this.computeAffectedObjectLists();
        }
    }

    void computeAffectedObjectLists() {
        TSSystem.tsAssert(!this.getOriginalGraphManager().hasMarkedObject());
        TSSystem.tsAssert(!this.getOriginalGraphManager().hasVisitedNodes());
        TSSystem.tsAssert(!this.getOriginalGraphManager().hasTraversedEdges());
        this.getOriginalGraphManager().nullifyUtilityObject();
        this.clearAffectedObjectLists();
        this.partiallyAffectedEdgeList.clear();
        this.computeAffectedGraphLists();
        this.markGraphObjectsOfLists(true);
        Iterator iterator = this.affectedGraphList().iterator();
        while (iterator.hasNext()) {
            this.addGraphAffectedObjectsToLists((TSDGraph)iterator.next());
        }
        this.addIntergraphAffectedObjectsToLists();
        this.markGraphObjectsOfLists(false);
    }

    public TSDGraphManager getClipboardGraphManager() {
        if (this.clipboardGraphManager == null) {
            TSSystem.tsAssert(this.getOriginalGraphManager() != null);
            if (this.getOriginalGraphManager() != null) {
                try {
                    this.clipboardGraphManager = (TSDGraphManager)this.getOriginalGraphManager().getClass().newInstance();
                }
                catch (Exception exception) {
                    this.clipboardGraphManager = new TSDGraphManager();
                }
            }
        }
        if (this.timeStamp < 0L) {
            this.timeStamp = System.currentTimeMillis();
        }
        return this.clipboardGraphManager;
    }

    public void computeAffectedGraphLists() {
        Cloneable cloneable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        TSSystem.tsAssert(this.getOriginalGraphManager() != null);
        Object object6 = null;
        TSDGraphManager tSDGraphManager = this.getOriginalGraphManager();
        TSDGraph tSDGraph = tSDGraphManager.getMainDisplayGraph();
        Iterator iterator = this.inputNodeList().iterator();
        while (iterator.hasNext()) {
            object5 = (TSDNode)iterator.next();
            object4 = (TSDGraph)((TSNode)object5).getOwnerGraph();
            object6 = ((TSNode)object5).getOwnerGraph().getUtilityObject();
            if (!((TSDGraph)object4).isViewable() || object6 != null) continue;
            this.markSuccessors(TSNestingManager.getNestedGraph((TSDNode)object5), "2L");
        }
        object5 = this.inputEdgeList().iterator();
        while (object5.hasNext()) {
            object4 = (TSDEdge)object5.next();
            object6 = ((TSEdge)object4).getOwnerGraph().getUtilityObject();
            if (!((TSEdge)object4).getOwnerGraph().isViewable() || object6 != null) continue;
            ((TSEdge)object4).getOwnerGraph().setUtilityObject("1L");
        }
        object4 = this.inputNodeLabelList().iterator();
        while (object4.hasNext()) {
            object3 = (TSNodeLabel)object4.next();
            object6 = ((TSLabel)object3).getOwnerGraph().getUtilityObject();
            if (!((TSLabel)object3).getOwnerGraph().isViewable() || object6 != null) continue;
            ((TSLabel)object3).getOwnerGraph().setUtilityObject("1L");
        }
        object3 = this.inputConnectorLabelList().iterator();
        while (object3.hasNext()) {
            object2 = (TSConnectorLabel)object3.next();
            object6 = ((TSConnectorLabel)object2).getOwnerGraph().getUtilityObject();
            if (!((TSConnectorLabel)object2).getOwnerGraph().isViewable() || object6 != null) continue;
            ((TSConnectorLabel)object2).getOwnerGraph().setUtilityObject("1L");
        }
        object2 = this.inputEdgeLabelList().iterator();
        while (object2.hasNext()) {
            object = (TSEdgeLabel)object2.next();
            object6 = ((TSLabel)object).getOwnerGraph().getUtilityObject();
            if (!((TSLabel)object).getOwnerGraph().isViewable() || object6 != null) continue;
            ((TSLabel)object).getOwnerGraph().setUtilityObject("1L");
        }
        iterator = this.inputNodeList().iterator();
        while (iterator.hasNext()) {
            object = (TSDNode)iterator.next();
            cloneable = (TSDGraph)((TSNode)object).getOwnerGraph();
            object6 = ((TSGraphObject)cloneable).getUtilityObject();
            if (!((TSDGraph)cloneable).isViewable() || object6 != null) continue;
            while (cloneable != tSDGraph) {
                ((TSGraphObject)cloneable).setUtilityObject("1L");
                cloneable = (TSDGraph)((TSDGraph)cloneable).getParent().getOwnerGraph();
                TSSystem.tsAssert(cloneable != null);
            }
            if (cloneable != tSDGraph || ((TSGraphObject)cloneable).getUtilityObject() != null) continue;
            ((TSGraphObject)cloneable).setUtilityObject("1L");
        }
        object = new de();
        TSNestingManager.buildAllNestedGraphList(tSDGraphManager.getMainDisplayGraph(), (List)object, false);
        ((df)object).add(0, tSDGraphManager.getMainDisplayGraph());
        for (cloneable = ((de)object).b(); cloneable != null; cloneable = ((f0)cloneable).d()) {
            TSDGraph tSDGraph2 = (TSDGraph)((f0)cloneable).b();
            if (tSDGraph2.getUtilityObject() == null) continue;
            if (tSDGraph2.getUtilityObject().equals("1L")) {
                this.affectedGraphList().add(tSDGraph2);
            }
            tSDGraph2.nullifyUtilityObject();
        }
    }

    public void markGraphObjectsOfLists(boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Iterator iterator;
        Object object4;
        String string = "1L";
        if (!bl) {
            string = "0L";
        }
        Object object5 = null;
        Iterator iterator2 = this.affectedGraphList().iterator();
        while (iterator2.hasNext()) {
            object4 = (TSDGraph)iterator2.next();
            object5 = ((TSGraphObject)object4).getUtilityObject();
            if ((object5 != null || string == "0L") && (object5 == null || object5.equals(string))) continue;
            ((TSGraphObject)object4).setUtilityObject(string);
        }
        object4 = this.inputNodeList().iterator();
        while (object4.hasNext()) {
            iterator = (TSDNode)object4.next();
            object3 = (TSDGraph)((TSNode)((Object)iterator)).getOwnerGraph();
            object5 = ((TSGraphObject)object3).getUtilityObject();
            if (object3 == null || !((TSDGraph)object3).isViewable() || (object5 != null || string != "0L") && (object5 == null || !object5.equals(string)) || ((TSNode)((Object)iterator)).isVisited() == bl) continue;
            ((TSNode)((Object)iterator)).setVisited(bl);
        }
        iterator = this.inputEdgeList().iterator();
        while (iterator.hasNext()) {
            object3 = (TSDEdge)iterator.next();
            object2 = (TSDGraph)((TSEdge)object3).getOwnerGraph();
            object5 = ((TSGraphObject)object2).getUtilityObject();
            if ((!((TSEdge)object3).isIntergraphEdge() || !((TSDEdge)object3).isViewable()) && (object2 == null || !((TSDGraph)object2).isViewable() || (object5 != null || string != "0L") && (object5 == null || !object5.equals(string)) || ((TSEdge)object3).isTraversed() == bl)) continue;
            ((TSEdge)object3).setTraversed(bl);
        }
        object4 = this.affectedNodeList().iterator();
        while (object4.hasNext()) {
            object3 = (TSDNode)object4.next();
            if (((TSNode)object3).isVisited() == bl) continue;
            ((TSNode)object3).setVisited(bl);
        }
        iterator = this.affectedEdgeList().iterator();
        while (iterator.hasNext()) {
            object3 = (TSDEdge)iterator.next();
            if (((TSEdge)object3).isTraversed() == bl) continue;
            ((TSEdge)object3).setTraversed(bl);
        }
        object3 = this.affectedNodeLabelList().iterator();
        while (object3.hasNext()) {
            object2 = (TSNodeLabel)object3.next();
            if (((TSGraphObject)object2).isMarked() == bl) continue;
            ((TSGraphObject)object2).setMarked(bl);
        }
        object2 = this.affectedConnectorLabelList().iterator();
        while (object2.hasNext()) {
            object = (TSConnectorLabel)object2.next();
            if (((TSGraphObject)object).isMarked() == bl) continue;
            ((TSGraphObject)object).setMarked(bl);
        }
        object = this.affectedEdgeLabelList().iterator();
        while (object.hasNext()) {
            TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)object.next();
            if (tSEdgeLabel.isMarked() == bl) continue;
            tSEdgeLabel.setMarked(bl);
        }
    }

    public List affectedGraphList() {
        return this.affectedGraphList;
    }

    void addGraphAffectedObjectsToLists(TSDGraph tSDGraph) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator = tSDGraph.nodes().iterator();
        while (iterator.hasNext()) {
            object4 = (TSDNode)iterator.next();
            if (!((TSNode)object4).isVisited()) continue;
            this.affectedNodeList.add(object4);
        }
        object4 = tSDGraph.edges().iterator();
        while (object4.hasNext()) {
            object3 = (TSDEdge)object4.next();
            if (!((TSEdge)object3).isTraversed()) continue;
            this.affectedEdgeList.add(object3);
        }
        object3 = this.inputEdgeLabelList().iterator();
        while (object3.hasNext()) {
            object2 = (TSEdgeLabel)object3.next();
            ((TSGraphObject)object2).setMarked(false);
        }
        object3 = this.inputEdgeLabelList().iterator();
        while (object3.hasNext()) {
            object2 = (TSEdgeLabel)object3.next();
            if (((TSLabel)object2).getOwnerGraph() != tSDGraph || ((TSGraphObject)object2).isMarked()) continue;
            ((TSGraphObject)object2).setMarked(true);
            this.affectedEdgeLabelList.add(object2);
        }
        object2 = this.inputNodeLabelList().iterator();
        while (object2.hasNext()) {
            object = (TSNodeLabel)object2.next();
            if (((TSLabel)object).getOwnerGraph() != tSDGraph || ((TSGraphObject)object).isMarked()) continue;
            ((TSGraphObject)object).setMarked(true);
            this.affectedNodeLabelList.add(object);
        }
        object = this.inputConnectorLabelList().iterator();
        while (object.hasNext()) {
            TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)object.next();
            if (tSConnectorLabel.getOwnerGraph() != tSDGraph || tSConnectorLabel.isMarked() || tSConnectorLabel.getOwner().isMarked()) continue;
            tSConnectorLabel.setMarked(true);
            this.affectedConnectorLabelList.add(tSConnectorLabel);
        }
    }

    public void addIntergraphAffectedObjectsToLists() {
        TSDGraphManager tSDGraphManager = this.getOriginalGraphManager();
        TSDGraph tSDGraph = null;
        if (tSDGraphManager != null) {
            tSDGraph = (TSDGraph)tSDGraphManager.queryIntergraph();
        }
        if (tSDGraph != null) {
            Object object;
            Iterator iterator = tSDGraphManager.intergraphEdges().iterator();
            while (iterator.hasNext()) {
                object = (TSDEdge)iterator.next();
                if (!((TSEdge)object).isTraversed()) continue;
                this.affectedEdgeList.add(object);
            }
            object = this.inputEdgeLabelList().iterator();
            while (object.hasNext()) {
                TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)object.next();
                if (tSEdgeLabel.getOwnerGraph() != tSDGraph) continue;
                this.affectedEdgeLabelList.add(tSEdgeLabel);
                tSEdgeLabel.setMarked(true);
            }
            if (!this.affectedGraphList().contains(tSDGraph)) {
                this.affectedGraphList().add(tSDGraph);
            }
        }
    }

    public List affectedNodeLabelList() {
        return this.affectedNodeLabelList;
    }

    public List affectedEdgeLabelList() {
        return this.affectedEdgeLabelList;
    }

    public List affectedConnectorLabelList() {
        return this.affectedConnectorLabelList;
    }

    public TSDGraph getClipboardGraph() {
        TSDGraphManager tSDGraphManager = this.queryClipboardGraphManager();
        TSDGraph tSDGraph = null;
        if (tSDGraphManager != null) {
            tSDGraph = tSDGraphManager.getMainDisplayGraph();
        }
        return tSDGraph;
    }

    private void storeClipboardGraphManager() {
        try {
            Transferable transferable;
            if (this.isUsingSystemClipboard() && this.isUsingXML()) {
                StringWriter stringWriter = new StringWriter();
                stringWriter.write(MAGIC_LINE);
                stringWriter.write(Long.toString(this.timeStamp));
                stringWriter.write(10);
                stringWriter.write(this.clipboardGraphManager.getClass().getName());
                stringWriter.write(10);
                if (this.clipboardServiceInputData != null) {
                    stringWriter.write(this.clipboardServiceInputData.getClass().getName());
                    stringWriter.write(10);
                } else {
                    stringWriter.write("null");
                    stringWriter.write(10);
                }
                this.xmlWrite(stringWriter, this.clipboardGraphManager, this.clipboardServiceInputData);
                stringWriter.close();
                String string = stringWriter.toString();
                transferable = new StringSelection(string);
            } else {
                transferable = new ce(this.clipboardGraphManager);
            }
            this.getClipboard().setContents(transferable, this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public List affectedNodeList() {
        return this.affectedNodeList;
    }

    public List affectedEdgeList() {
        return this.affectedEdgeList;
    }

    public List partiallyAffectedEdgeList() {
        return this.partiallyAffectedEdgeList;
    }

    public TSDEdge getDemoEdge() {
        TSDGraph tSDGraph;
        if (this.getClipboardGraphManager() != null && (tSDGraph = this.getClipboardGraphManager().getMainDisplayGraph()) != null) {
            return (TSDEdge)tSDGraph.edges().get(0);
        }
        return null;
    }

    public TSDNode getDemoNode() {
        TSDGraph tSDGraph;
        TSDNode tSDNode = null;
        if (this.getClipboardGraphManager() != null && (tSDGraph = this.getClipboardGraphManager().getMainDisplayGraph()) != null) {
            tSDNode = (TSDNode)tSDGraph.nodes().get(0);
        }
        return tSDNode;
    }

    public TSConnector getDemoConnector() {
        TSConnector tSConnector = null;
        TSDNode tSDNode = this.getDemoNode();
        if (tSDNode != null) {
            tSConnector = (TSConnector)tSDNode.connectors().get(0);
        }
        return tSConnector;
    }

    public TSPoint getCenterOfClipboardGraph(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        Iterator iterator;
        TSDGraph tSDGraph = this.getClipboardGraph();
        TSRect tSRect = new TSRect();
        TSRect tSRect2 = new TSRect();
        boolean bl5 = false;
        if (bl) {
            iterator = tSDGraph.edges().iterator();
            while (iterator.hasNext()) {
                object = (TSDEdge)iterator.next();
                if (object == this.getDemoEdge()) continue;
                tSRect = new TSRect(((TSDEdge)object).getLocalBounds());
                if (!bl5) {
                    tSRect2 = new TSRect(tSRect);
                    bl5 = true;
                    continue;
                }
                tSRect2.merge(tSRect);
            }
            object = tSDGraph.nodes().iterator();
            while (object.hasNext()) {
                TSDNode tSDNode = (TSDNode)object.next();
                if (tSDNode == this.getDemoNode()) continue;
                tSRect = new TSRect(tSDNode.getLocalBounds());
                if (!bl5) {
                    tSRect2 = new TSRect(tSRect);
                    bl5 = true;
                    continue;
                }
                tSRect2.merge(tSRect);
            }
        }
        if (bl2) {
            iterator = this.getDemoEdge().labels().iterator();
            while (iterator.hasNext()) {
                object = (TSEdgeLabel)iterator.next();
                tSRect = new TSRect(((TSLabel)object).getLocalBounds());
                if (!bl5) {
                    tSRect2 = new TSRect(tSRect);
                    bl5 = true;
                    continue;
                }
                tSRect2.merge(tSRect);
            }
        }
        if (bl3) {
            iterator = this.getDemoNode().labels().iterator();
            while (iterator.hasNext()) {
                object = (TSNodeLabel)iterator.next();
                tSRect = new TSRect(((TSLabel)object).getLocalBounds());
                if (!bl5) {
                    tSRect2 = new TSRect(tSRect);
                    bl5 = true;
                    continue;
                }
                tSRect2.merge(tSRect);
            }
        }
        if (bl4) {
            iterator = this.getDemoConnector().labels().iterator();
            while (iterator.hasNext()) {
                object = (TSConnectorLabel)iterator.next();
                tSRect = new TSRect(((TSLabel)object).getLocalBounds());
                if (!bl5) {
                    tSRect2 = new TSRect(tSRect);
                    bl5 = true;
                    continue;
                }
                tSRect2.merge(tSRect);
            }
        }
        return new TSPoint(tSRect2.getCenter());
    }

    public TSDGraphManager queryClipboardGraphManager() {
        return this.clipboardGraphManager;
    }

    public List inputNodeList() {
        return this.inputNodeList;
    }

    public List inputEdgeList() {
        return this.inputEdgeList;
    }

    public List inputNodeLabelList() {
        return this.inputNodeLabelList;
    }

    public List inputEdgeLabelList() {
        return this.inputEdgeLabelList;
    }

    public List inputConnectorLabelList() {
        return this.inputConnectorLabelList;
    }

    void markSuccessors(TSDGraph tSDGraph, String string) {
        Object object;
        if (tSDGraph != null && ((object = tSDGraph.getUtilityObject()) == null && string != "0L" || object != null && !object.equals(string))) {
            tSDGraph.setUtilityObject(string);
            Vector<TSDGraph> vector = new Vector<TSDGraph>();
            TSNestingManager.buildNestedGraphList(tSDGraph, vector, false);
            if (tSDGraph.hideGraph() != null && (tSDGraph.hideGraph().numberOfNodes() != 0 || tSDGraph.hideGraph().numberOfEdges() != 0 || tSDGraph.hideGraph().numberOfDisconnectedEdges() != 0)) {
                vector.add(tSDGraph.hideGraph());
            }
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                this.markSuccessors((TSDGraph)iterator.next(), string);
            }
        }
    }

    void privateCopy() {
        this.getClipboardGraphManager().emptyTopology();
        this.timeStamp = -1L;
        this.createClipboardGraph();
        this.copyToClipboard();
        this.storeClipboardGraphManager();
    }

    void copyToClipboard() {
        TSSize tSSize = new TSSize(0.0, 0.0);
        TSSystem.tsAssert(this.getOriginalGraphManager() != null);
        if (!this.getOriginalGraphManager().deep()) {
            this.flatCopy(this.getClipboardGraph(), tSSize);
        } else {
            this.getClipboardGraphManager().getChildGraphForest().emptyTopology();
            this.flatCopy(this.getClipboardGraph(), tSSize);
            this.copyNestingInfo();
        }
        this.getOriginalGraphManager().nullifyUtilityObject();
    }

    private void flatCopy(TSDGraph tSDGraph, TSSize tSSize) {
        Object object;
        TSGraphObject tSGraphObject;
        Object object2;
        Object object3;
        TSGraphObject tSGraphObject2;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        if (this.originalServiceInputData != null && this.clipboardGraphManager != null) {
            try {
                object7 = this.originalServiceInputData.getClass();
                object6 = ((Class)object7).getConstructor(class$com$tomsawyer$drawing$TSDGraphManager == null ? (class$com$tomsawyer$drawing$TSDGraphManager = TSCutCopyPasteControl.class$("com.tomsawyer.drawing.TSDGraphManager")) : class$com$tomsawyer$drawing$TSDGraphManager);
                this.clipboardServiceInputData = object5 = (TSOptionData)((Constructor)object6).newInstance(this.clipboardGraphManager);
                this.clipboardServiceInputData.setInternalServiceName(this.originalServiceInputData.getInternalServiceName());
            }
            catch (Exception exception) {
                this.clipboardServiceInputData = null;
            }
        } else {
            this.clipboardServiceInputData = null;
        }
        TSGraphObject.setStoreCloneInUtilityObject(true);
        object7 = this.affectedNodeList().iterator();
        object6 = null;
        while (object7.hasNext()) {
            object5 = (TSDNode)object7.next();
            object6 = tSDGraph != null ? tSDGraph : (TSDGraph)((TSNode)object5).getOwnerGraph();
            object4 = (TSDNode)((TSGraphObject)object5).clone();
            ((TSDGraph)object6).insert((TSNode)object4);
            tSGraphObject2 = (TSDGraph)((TSGraphMember)object5).getChildGraph();
            if (tSGraphObject2 != null) {
                this.cloneChildGraphs((TSGraphMember)object5, ((TSDGraph)object6).getOwnerGraphManager());
            }
            this.copyNodeRelatedServiceInputData((TSDNode)object5, (TSDNode)object4, this.originalServiceInputData, this.clipboardServiceInputData);
            if (object4 == null) continue;
            ((TSGNode)object4).setLocalBounds(((TSDNode)object5).getBounds());
        }
        object5 = this.getOriginalGraphManager().intergraphEdges().iterator();
        while (object5.hasNext()) {
            boolean bl;
            object4 = (TSDEdge)object5.next();
            tSGraphObject2 = (TSDNode)((TSEdge)object4).getSourceNode();
            object3 = (TSDNode)((TSEdge)object4).getTargetNode();
            object2 = (TSDGraph)tSGraphObject2.getOwner();
            tSGraphObject = (TSDGraph)((TSGraphObject)object3).getOwner();
            object = (TSDGraph)((TSDGraph)tSGraphObject).getOwnerGraphManager().getCommonOwnerGraph((TSGraph)object2, (TSGraph)tSGraphObject);
            for (bl = false; !bl && object != null; bl |= ((TSDGraph)object).getParent() != null && this.affectedEdgeList.contains(((TSDGraph)object).getParent())) {
                bl |= ((TSGraphObject)object).getUtilityObject() instanceof TSDGraph;
                if (((TSDGraph)object).getParent() != null) {
                    object = (TSDGraph)((TSDGraph)object).getParent().getTransformGraph();
                    continue;
                }
                object = null;
            }
            if (!bl || this.affectedEdgeList().contains(object4)) continue;
            this.affectedEdgeList().add(object4);
        }
        object4 = this.affectedEdgeList().iterator();
        while (object4.hasNext()) {
            tSGraphObject2 = (TSDEdge)object4.next();
            object3 = (TSDNode)((TSEdge)tSGraphObject2).getSourceNode();
            object2 = (TSDNode)((TSEdge)tSGraphObject2).getTargetNode();
            if (((TSGraphObject)object3).getUtilityObject() == null && ((TSGraphObject)object2).getUtilityObject() == null) continue;
            object6 = tSDGraph != null ? tSDGraph : (TSDGraph)((TSEdge)tSGraphObject2).getOwnerGraph();
            this.cloneEdge((TSDEdge)tSGraphObject2, (TSDNode)object3, (TSDNode)object2, (TSDGraph)object6, tSSize);
        }
        tSGraphObject2 = this.getDemoEdge();
        object3 = this.affectedEdgeLabelList().iterator();
        while (object3.hasNext()) {
            object2 = (TSEdgeLabel)object3.next();
            if (tSDGraph == null) {
                tSGraphObject2 = (TSDEdge)((TSGraphObject)object2).getOwner();
            }
            tSGraphObject = (TSEdgeLabel)((TSGraphObject)object2).clone();
            ((TSDEdge)tSGraphObject2).insert((TSEdgeLabel)tSGraphObject);
            this.copyServiceInputData(object2, tSGraphObject, this.originalServiceInputData, this.clipboardServiceInputData);
            if (tSGraphObject == null) continue;
            ((TSLabel)tSGraphObject).setLocalBounds(((TSLabel)object2).getBounds());
        }
        object2 = this.affectedNodeLabelList().iterator();
        tSGraphObject = this.getDemoNode();
        while (object2.hasNext()) {
            object = (TSNodeLabel)object2.next();
            if (tSDGraph == null) {
                tSGraphObject = (TSDNode)((TSGraphObject)object).getOwner();
            }
            TSNodeLabel tSNodeLabel = (TSNodeLabel)((TSGraphObject)object).clone();
            ((TSDNode)tSGraphObject).insert(tSNodeLabel);
            this.copyServiceInputData(object, tSNodeLabel, this.originalServiceInputData, this.clipboardServiceInputData);
            if (tSNodeLabel == null) continue;
            tSNodeLabel.setLocalBounds(((TSLabel)object).getBounds());
        }
        object = this.affectedConnectorLabelList().iterator();
        TSConnector tSConnector = this.getDemoConnector();
        while (object.hasNext()) {
            TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)object.next();
            if (tSDGraph == null) {
                tSConnector = (TSConnector)tSConnectorLabel.getOwner();
            }
            TSConnectorLabel tSConnectorLabel2 = (TSConnectorLabel)tSConnectorLabel.clone();
            tSConnector.insert(tSConnectorLabel2);
            this.copyServiceInputData(tSConnectorLabel, tSConnectorLabel2, this.originalServiceInputData, this.clipboardServiceInputData);
            if (tSConnectorLabel2 == null) continue;
            tSConnectorLabel2.setLocalBounds(tSConnectorLabel.getBounds());
        }
        TSGraphObject.setStoreCloneInUtilityObject(false);
    }

    private void copyNestingInfo() {
        TSSystem.tsAssert(this.getOriginalGraphManager() != null);
        if (this.getOriginalGraphManager() != null) {
            TSDGraph tSDGraph;
            Object object;
            Vector vector = new Vector(this.affectedNodeList());
            vector.addAll(this.affectedEdgeList());
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                object = (TSGraphMember)iterator.next();
                tSDGraph = (TSDGraph)((TSGraphMember)object).getChildGraph();
                TSGraphMember tSGraphMember = (TSGraphMember)((TSGraphObject)object).getUtilityObject();
                this.expandNecessaryCloneNodes(tSDGraph);
                if (!(object instanceof TSDNode)) continue;
                TSDNode tSDNode = (TSDNode)object;
                TSDNode tSDNode2 = (TSDNode)tSGraphMember;
                if (!tSDNode.isExpanded() || tSDNode2 == null) continue;
                ((TSDGraphManager)tSDNode2.getOwnerGraphManager()).expandNodeOnCopy(tSDNode2);
                tSDNode2.expandedNodeExtension().copy(tSDNode.expandedNodeExtension());
            }
            object = this.getClipboardGraphManager().graphs(false).iterator();
            while (object.hasNext()) {
                tSDGraph = (TSDGraph)object.next();
                tSDGraph.updateBounds();
            }
        }
    }

    private void expandNecessaryCloneNodes(TSDGraph tSDGraph) {
        if (tSDGraph != null) {
            Vector vector = new Vector(tSDGraph.nodes());
            vector.addAll(tSDGraph.edges());
            TSDGraph tSDGraph2 = tSDGraph.hideGraph();
            if (tSDGraph2 != null) {
                vector.addAll(tSDGraph2.nodes());
                vector.addAll(tSDGraph2.edges());
                vector.addAll(tSDGraph2.disconnectedEdges());
            }
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                TSGraphMember tSGraphMember = (TSGraphMember)iterator.next();
                TSGraphMember tSGraphMember2 = (TSGraphMember)tSGraphMember.getUtilityObject();
                TSDGraph tSDGraph3 = (TSDGraph)tSGraphMember.getChildGraph();
                if (tSDGraph3 != null) {
                    this.expandNecessaryCloneNodes(tSDGraph3);
                }
                if (!(tSGraphMember instanceof TSDNode)) continue;
                TSDNode tSDNode = (TSDNode)tSGraphMember;
                TSDNode tSDNode2 = (TSDNode)tSGraphMember2;
                if (!tSDNode.isExpanded() || tSDNode2 == null) continue;
                ((TSDGraphManager)tSDNode2.getOwnerGraphManager()).expandNodeOnCopy(tSDNode2);
                tSDNode2.expandedNodeExtension().copy(tSDNode.expandedNodeExtension());
            }
        }
    }

    private void cloneEdge(TSDEdge tSDEdge, TSDNode tSDNode, TSDNode tSDNode2, TSDGraph tSDGraph, TSSize tSSize) {
        TSDGraph tSDGraph2;
        TSDNode tSDNode3;
        TSDNode tSDNode4;
        TSGraphObject.setStoreCloneInUtilityObject(true);
        TSPoint tSPoint = new TSPoint();
        TSDEdge tSDEdge2 = (TSDEdge)tSDEdge.clone();
        boolean bl = false;
        if (tSDNode.getUtilityObject() == null) {
            tSDNode4 = tSDNode;
            tSDEdge2.setSourceNode(tSDNode4);
            bl = true;
        } else {
            tSDNode4 = (TSDNode)tSDNode.getUtilityObject();
            tSDEdge2.setSourceNode(tSDNode4);
        }
        if (tSDNode2.getUtilityObject() == null) {
            tSDNode3 = tSDNode2;
            tSDEdge2.setTargetNode(tSDNode3);
            bl = true;
        } else {
            tSDNode3 = (TSDNode)tSDNode2.getUtilityObject();
            tSDEdge2.setTargetNode(tSDNode3);
        }
        if (tSDEdge2 != null) {
            tSDNode = (TSDNode)tSDEdge.getSourceNode();
            tSDNode2 = (TSDNode)tSDEdge.getTargetNode();
            tSDGraph2 = (TSDGraph)tSDNode.getOwner();
            TSDGraph tSDGraph3 = (TSDGraph)tSDNode2.getOwner();
            TSDGraph tSDGraph4 = (TSDGraph)tSDGraph2.getOwnerGraphManager().getCommonOwnerGraph(tSDGraph2, tSDGraph3);
            if (tSDGraph4 != null && !(tSDGraph4.getUtilityObject() instanceof TSDGraph)) {
                Object object;
                Object object2;
                Iterator iterator = tSDEdge.pathNodes().iterator();
                Iterator iterator2 = tSDEdge2.pathNodes().iterator();
                while (iterator.hasNext() && iterator2.hasNext()) {
                    object2 = (TSPNode)iterator.next();
                    tSPoint = new TSPoint();
                    ((TSGNode)object2).getLocalCenter(tSPoint);
                    tSDGraph4.expandedTransformPoint(tSPoint);
                    tSPoint.moveBy(tSSize);
                    object = (TSPNode)iterator2.next();
                    ((TSPNode)object).assignCenter(tSPoint.getX(), tSPoint.getY());
                }
                TSSystem.tsAssert(!iterator2.hasNext() || !iterator.hasNext());
                object2 = tSDEdge.labels().iterator();
                object = tSDEdge2.labels().iterator();
                while (object2.hasNext() && object.hasNext()) {
                    TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)object2.next();
                    tSPoint = new TSPoint(tSEdgeLabel.getLocalCenter());
                    tSDGraph4.expandedTransformPoint(tSPoint);
                    tSPoint.moveBy(tSSize);
                    TSEdgeLabel tSEdgeLabel2 = (TSEdgeLabel)object.next();
                    tSEdgeLabel2.assignCenter(tSPoint.getX(), tSPoint.getY());
                }
            }
        }
        if (bl) {
            tSDGraph.insert(tSDEdge2);
            this.partiallyAffectedEdgeList.add(tSDEdge2);
        } else {
            ((TSDGraphManager)tSDGraph.getOwner()).insert(tSDEdge2, tSDEdge2.getSourceNode(), tSDEdge2.getTargetNode());
        }
        tSDGraph2 = (TSDGraph)tSDEdge.getChildGraph();
        if (tSDGraph2 != null) {
            this.cloneChildGraphs(tSDEdge, tSDEdge2.getOwnerGraphManager());
        }
        if (tSDEdge.getSourceConnector() != null) {
            if (tSDEdge.getSourceConnector().getUtilityObject() != null) {
                tSDEdge2.setSourceConnector((TSConnector)tSDEdge.getSourceConnector().getUtilityObject());
            } else {
                tSDEdge2.setSourceConnector(tSDEdge.getSourceConnector());
            }
        }
        if (tSDEdge.getTargetConnector() != null) {
            if (tSDEdge.getTargetConnector().getUtilityObject() != null) {
                tSDEdge2.setTargetConnector((TSConnector)tSDEdge.getTargetConnector().getUtilityObject());
            } else {
                tSDEdge2.setTargetConnector(tSDEdge.getTargetConnector());
            }
        }
        this.copyEdgeRelatedServiceInputData(tSDEdge, tSDEdge2, this.originalServiceInputData, this.clipboardServiceInputData);
        TSGraphObject.setStoreCloneInUtilityObject(false);
    }

    void pasteToGraph(TSDGraph tSDGraph, TSSize tSSize, List list, List list2, TSOptionData tSOptionData) throws IOException {
        TSDEdge tSDEdge;
        Object object;
        TSGraphObject.setStoreCloneInUtilityObject(true);
        this.fetchClipboardGraphManager(tSOptionData);
        Iterator iterator = this.getClipboardGraph().nodes().iterator();
        while (iterator.hasNext()) {
            object = (TSDNode)iterator.next();
            this.cloneAndInsertNodeToGraph(tSDGraph, (TSDNode)object, tSSize, list, false, this.clipboardServiceInputData, tSOptionData);
        }
        object = this.getClipboardGraph().edges();
        Vector<TSDEdge> vector = new Vector<TSDEdge>();
        vector.addAll(this.partiallyAffectedEdgeList());
        vector.addAll(this.getClipboardGraphManager().intergraphEdges());
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            tSDEdge = (TSDEdge)iterator2.next();
            vector.add(tSDEdge);
        }
        iterator2 = vector.iterator();
        while (iterator2.hasNext()) {
            tSDEdge = (TSDEdge)iterator2.next();
            TSDNode tSDNode = (TSDNode)tSDEdge.getSourceNode();
            TSDNode tSDNode2 = (TSDNode)tSDEdge.getTargetNode();
            if (tSDNode.getUtilityObject() != null) {
                tSDNode = (TSDNode)tSDNode.getUtilityObject();
            }
            if (tSDNode2.getUtilityObject() != null) {
                tSDNode2 = (TSDNode)tSDNode2.getUtilityObject();
            }
            this.cloneAndInsertEdgeToGraph(tSDGraph, tSDEdge, tSDNode, tSDNode2, tSSize, list2, false, this.clipboardServiceInputData, tSOptionData);
        }
        tSDGraph.updateBounds();
        TSGraphObject.setStoreCloneInUtilityObject(false);
    }

    private void cloneAndInsertNodeToGraph(TSDGraph tSDGraph, TSDNode tSDNode, TSSize tSSize, List list, boolean bl, TSOptionData tSOptionData, TSOptionData tSOptionData2) {
        TSGraphObject.setStoreCloneInUtilityObject(true);
        TSPoint tSPoint = new TSPoint();
        if (this.getDemoNode() != tSDNode) {
            TSDNode tSDNode2 = (TSDNode)tSDNode.clone();
            list.add(tSDNode2);
            tSDGraph.insert(tSDNode2);
            TSRect tSRect = new TSRect(tSDNode.getLocalBounds());
            TSSize tSSize2 = new TSSize(tSDNode.getLocalOriginalSize());
            tSPoint.setLocation(tSRect.getCenter());
            tSPoint.moveBy(tSSize);
            if (!bl) {
                tSDGraph.inverseExpandedTransformPoint(tSPoint);
                tSDGraph.inverseExpandedTransformSize(tSSize2);
                tSDGraph.inverseExpandedTransformRect(tSRect);
            }
            tSDNode2.setLocalCenter(tSPoint.getX(), tSPoint.getY());
            tSDNode2.setLocalOriginalWidth(tSSize2.getWidth());
            tSDNode2.setLocalOriginalHeight(tSSize2.getHeight());
            TSDGraph tSDGraph2 = (TSDGraph)tSDNode.getChildGraph();
            if (tSDGraph2 != null) {
                this.cloneChildGraphs(tSDNode, tSDNode2.getOwnerGraphManager());
            }
            this.expandNecessaryCloneNodes((TSDGraph)tSDNode.getChildGraph());
            if (tSDNode.isExpanded()) {
                ((TSDGraphManager)tSDNode2.getOwnerGraphManager()).expandNodeOnCopy(tSDNode2);
                tSDNode2.expandedNodeExtension().copy(tSDNode.expandedNodeExtension());
            }
            this.copyNodeRelatedServiceInputData(tSDNode, tSDNode2, tSOptionData, tSOptionData2);
        }
        TSGraphObject.setStoreCloneInUtilityObject(false);
    }

    private void cloneAndInsertEdgeToGraph(TSDGraph tSDGraph, TSDEdge tSDEdge, TSDNode tSDNode, TSDNode tSDNode2, TSSize tSSize, List list, boolean bl, TSOptionData tSOptionData, TSOptionData tSOptionData2) {
        TSGraphObject.setStoreCloneInUtilityObject(true);
        if (this.getDemoEdge() != tSDEdge) {
            Object object;
            TSPoint tSPoint = new TSPoint();
            TSDGraphManager tSDGraphManager = (TSDGraphManager)tSDGraph.getOwnerGraphManager();
            TSDEdge tSDEdge2 = (TSDEdge)tSDEdge.clone();
            list.add(tSDEdge2);
            tSDEdge2.setSourceNode(tSDNode);
            tSDEdge2.setTargetNode(tSDNode2);
            TSDGraph tSDGraph2 = (TSDGraph)tSDEdge.getSourceNode().getOwner();
            TSDGraph tSDGraph3 = (TSDGraph)tSDEdge.getTargetNode().getOwner();
            TSDGraph tSDGraph4 = (TSDGraph)tSDGraph3.getOwnerGraphManager().getCommonOwnerGraph(tSDGraph2, tSDGraph3);
            TSDGraph tSDGraph5 = (TSDGraph)tSDNode.getOwner();
            TSDGraph tSDGraph6 = (TSDGraph)tSDNode2.getOwner();
            TSDGraph tSDGraph7 = (TSDGraph)tSDGraph6.getOwnerGraphManager().getCommonOwnerGraph(tSDGraph5, tSDGraph6);
            tSDGraphManager.insert(tSDEdge2, tSDEdge2.getSourceNode(), tSDEdge2.getTargetNode());
            if (tSDGraph4 == null || !(tSDGraph4.getUtilityObject() instanceof TSDGraph)) {
                Object object2;
                Object object3;
                object = tSDEdge.pathNodes().iterator();
                Iterator iterator = tSDEdge2.pathNodes().iterator();
                while (object.hasNext() && iterator.hasNext()) {
                    object3 = (TSPNode)object.next();
                    tSPoint = new TSPoint();
                    ((TSGNode)object3).getLocalCenter(tSPoint);
                    tSPoint.moveBy(tSSize);
                    if (!bl) {
                        tSDGraph7.inverseExpandedTransformPoint(tSPoint);
                    }
                    object2 = (TSPNode)iterator.next();
                    ((TSPNode)object2).assignCenter(tSPoint.getX(), tSPoint.getY());
                }
                object3 = tSDEdge.labels().iterator();
                object2 = tSDEdge2.labels().iterator();
                while (object3.hasNext() && object2.hasNext()) {
                    TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)object3.next();
                    tSPoint = new TSPoint(tSEdgeLabel.getLocalCenter());
                    tSPoint.moveBy(tSSize);
                    if (!bl) {
                        tSDGraph7.inverseExpandedTransformPoint(tSPoint);
                    }
                    TSEdgeLabel tSEdgeLabel2 = (TSEdgeLabel)object2.next();
                    tSEdgeLabel2.assignCenter(tSPoint.getX(), tSPoint.getY());
                }
            }
            if (tSDEdge.getSourceConnector() != null) {
                if (tSDEdge.getSourceConnector().getUtilityObject() != null) {
                    tSDEdge2.setSourceConnector((TSConnector)tSDEdge.getSourceConnector().getUtilityObject());
                } else {
                    tSDEdge2.setSourceConnector(tSDEdge.getSourceConnector());
                }
            }
            if (tSDEdge.getTargetConnector() != null) {
                if (tSDEdge.getTargetConnector().getUtilityObject() != null) {
                    tSDEdge2.setTargetConnector((TSConnector)tSDEdge.getTargetConnector().getUtilityObject());
                } else {
                    tSDEdge2.setTargetConnector(tSDEdge.getTargetConnector());
                }
            }
            if ((object = (TSDGraph)tSDEdge.getChildGraph()) != null) {
                this.cloneChildGraphs(tSDEdge, tSDEdge2.getOwnerGraphManager());
            }
            this.expandNecessaryCloneNodes((TSDGraph)tSDEdge.getChildGraph());
            this.copyEdgeRelatedServiceInputData(tSDEdge, tSDEdge2, tSOptionData, tSOptionData2);
        }
        TSGraphObject.setStoreCloneInUtilityObject(false);
    }

    private void cloneAndInsertNodeLabelToNode(TSDNode tSDNode, TSNodeLabel tSNodeLabel, TSSize tSSize, List list, boolean bl, TSOptionData tSOptionData, TSOptionData tSOptionData2) {
        TSGraphObject.setStoreCloneInUtilityObject(true);
        TSPoint tSPoint = new TSPoint(tSNodeLabel.getLocalCenter());
        tSPoint.moveBy(tSSize);
        TSNodeLabel tSNodeLabel2 = (TSNodeLabel)tSNodeLabel.clone();
        list.add(tSNodeLabel2);
        tSDNode.insert(tSNodeLabel2);
        if (tSNodeLabel2 != null) {
            TSDGraph tSDGraph = (TSDGraph)tSDNode.getTransformGraph();
            if (!bl) {
                tSDGraph.inverseExpandedTransformPoint(tSPoint);
            }
            tSNodeLabel2.setLocalCenter(tSPoint);
        }
        this.copyServiceInputData(tSNodeLabel, tSNodeLabel2, tSOptionData, tSOptionData2);
        TSGraphObject.setStoreCloneInUtilityObject(false);
    }

    private void cloneAndInsertEdgeLabelToEdge(TSDEdge tSDEdge, TSEdgeLabel tSEdgeLabel, TSSize tSSize, List list, boolean bl, TSOptionData tSOptionData, TSOptionData tSOptionData2) {
        TSGraphObject.setStoreCloneInUtilityObject(true);
        TSPoint tSPoint = new TSPoint(tSEdgeLabel.getLocalCenter());
        tSPoint.moveBy(tSSize);
        TSEdgeLabel tSEdgeLabel2 = (TSEdgeLabel)tSEdgeLabel.clone();
        list.add(tSEdgeLabel2);
        tSDEdge.insert(tSEdgeLabel2);
        if (tSEdgeLabel2 != null) {
            TSDGraph tSDGraph = (TSDGraph)tSDEdge.getTransformGraph();
            if (!bl) {
                tSDGraph.inverseExpandedTransformPoint(tSPoint);
            }
            tSEdgeLabel2.setLocalCenter(tSPoint);
        }
        this.copyServiceInputData(tSEdgeLabel, tSEdgeLabel2, tSOptionData, tSOptionData2);
        TSGraphObject.setStoreCloneInUtilityObject(false);
    }

    private void cloneAndInsertConnectorLabelToConnector(TSConnector tSConnector, TSConnectorLabel tSConnectorLabel, TSSize tSSize, List list, boolean bl, TSOptionData tSOptionData, TSOptionData tSOptionData2) {
        TSGraphObject.setStoreCloneInUtilityObject(true);
        TSPoint tSPoint = new TSPoint(tSConnectorLabel.getLocalCenter());
        tSPoint.moveBy(tSSize);
        TSConnectorLabel tSConnectorLabel2 = (TSConnectorLabel)tSConnectorLabel.clone();
        list.add(tSConnectorLabel2);
        tSConnector.insert(tSConnectorLabel2);
        if (tSConnectorLabel2 != null) {
            TSDGraph tSDGraph = (TSDGraph)((TSDNode)tSConnector.getOwner()).getTransformGraph();
            if (!bl) {
                tSDGraph.inverseExpandedTransformPoint(tSPoint);
            }
            tSConnectorLabel2.setLocalCenter(tSPoint);
        }
        this.copyServiceInputData(tSConnectorLabel, tSConnectorLabel2, tSOptionData, tSOptionData2);
        TSGraphObject.setStoreCloneInUtilityObject(false);
    }

    private void cloneChildGraphs(TSGraphMember tSGraphMember, TSGraphManager tSGraphManager) {
        TSGraphMember tSGraphMember2;
        TSDGraph tSDGraph = (TSDGraph)tSGraphMember.getChildGraph();
        if (tSDGraph != null && (tSGraphMember2 = (TSGraphMember)tSGraphMember.getUtilityObject()) != null) {
            Object object;
            TSGraph tSGraph = (TSGraph)tSDGraph.clone(true);
            tSGraphManager.insert(tSGraph);
            tSGraphMember2.setChildGraph(tSGraph);
            Vector vector = new Vector();
            tSDGraph.buildChildGraphList(vector);
            TSDGraph tSDGraph2 = tSDGraph.hideGraph();
            if (tSDGraph2 != null) {
                object = new Vector();
                tSDGraph2.buildChildGraphList((List)object);
                vector.addAll(object);
            }
            object = vector.iterator();
            while (object.hasNext()) {
                tSDGraph = (TSDGraph)object.next();
                this.cloneChildGraphs(tSDGraph.getParent(), tSGraphManager);
            }
        }
    }

    void pasteToNode(TSDNode tSDNode, TSSize tSSize, List list, TSOptionData tSOptionData) throws IOException {
        if (tSDNode != null) {
            this.fetchClipboardGraphManager(tSOptionData);
            Iterator iterator = this.getDemoNode().labels().iterator();
            while (iterator.hasNext()) {
                TSNodeLabel tSNodeLabel = (TSNodeLabel)iterator.next();
                this.cloneAndInsertNodeLabelToNode(tSDNode, tSNodeLabel, tSSize, list, false, this.clipboardServiceInputData, tSOptionData);
            }
        }
    }

    void pasteToConnector(TSConnector tSConnector, TSSize tSSize, List list, TSOptionData tSOptionData) throws IOException {
        if (tSConnector != null) {
            this.fetchClipboardGraphManager(tSOptionData);
            Iterator iterator = this.getDemoConnector().labels().iterator();
            while (iterator.hasNext()) {
                TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)iterator.next();
                this.cloneAndInsertConnectorLabelToConnector(tSConnector, tSConnectorLabel, tSSize, list, false, this.clipboardServiceInputData, tSOptionData);
            }
        }
    }

    void pasteToEdge(TSDEdge tSDEdge, TSSize tSSize, List list, TSOptionData tSOptionData) throws IOException {
        if (tSDEdge != null) {
            this.fetchClipboardGraphManager(tSOptionData);
            Iterator iterator = this.getDemoEdge().labels().iterator();
            while (iterator.hasNext()) {
                TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)iterator.next();
                this.cloneAndInsertEdgeLabelToEdge(tSDEdge, tSEdgeLabel, tSSize, list, false, this.clipboardServiceInputData, tSOptionData);
            }
        }
    }

    public void setClipboard(Clipboard clipboard) {
        this.myClipboard = clipboard;
    }

    public Clipboard getClipboard() {
        return this.myClipboard;
    }

    public boolean isUsingSystemClipboard() {
        return this.getClipboard().getName().equals("System");
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    String getLine(Reader reader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(80);
        while ((n = reader.read()) != -1 && n != 10) {
            stringBuffer.append((char)n);
        }
        if (n == -1 && stringBuffer.length() <= 0) {
            throw new EOFException();
        }
        return stringBuffer.toString();
    }

    private void createGraphFromStringManager(String string, TSOptionData tSOptionData) throws IOException {
        try {
            StringReader stringReader = new StringReader(string);
            String string2 = this.getLine(stringReader);
            if (!string2.startsWith(MAGIC_LINE)) {
                throw new IOException("Not a graph Manager");
            }
            long l = Long.parseLong(string2.substring(1 + string2.indexOf(MAGIC_LINE.charAt(MAGIC_LINE.length() - 1))));
            if (this.timeStamp < l) {
                String string3 = this.getLine(stringReader);
                String string4 = this.getLine(stringReader);
                if (this.clipboardGraphManager != null) {
                    TSNestingManager.discardManager(this.clipboardGraphManager);
                    TSFoldingManager.discardManager(this.clipboardGraphManager);
                    TSHidingManager.discardManager(this.clipboardGraphManager);
                }
                this.clipboardGraphManager = (TSDGraphManager)Class.forName(string3).newInstance();
                if (this.clipboardGraphManager != null && !string4.equals("null")) {
                    TSOptionData tSOptionData2;
                    Class<?> clazz = Class.forName(string4);
                    Constructor<?> constructor = clazz.getConstructor(class$com$tomsawyer$drawing$TSDGraphManager == null ? (class$com$tomsawyer$drawing$TSDGraphManager = TSCutCopyPasteControl.class$("com.tomsawyer.drawing.TSDGraphManager")) : class$com$tomsawyer$drawing$TSDGraphManager);
                    this.clipboardServiceInputData = tSOptionData2 = (TSOptionData)constructor.newInstance(this.clipboardGraphManager);
                    this.clipboardServiceInputData.setInternalServiceName(tSOptionData.getInternalServiceName());
                } else {
                    this.clipboardServiceInputData = null;
                }
                this.xmlRead(stringReader, this.clipboardGraphManager, this.clipboardServiceInputData);
                this.partiallyAffectedEdgeList().clear();
            }
            stringReader.close();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Time stamp error");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IOException("Graph Manager reading error");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Class specification exception");
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Class cast error");
        }
        catch (Exception exception) {
            throw new IOException(exception.getClass().getName());
        }
    }

    public void fetchClipboardGraphManager(TSOptionData tSOptionData) throws IOException {
        this.clearAffectedObjectLists();
        Transferable transferable = null;
        Clipboard clipboard = this.getClipboard();
        if (clipboard != null) {
            transferable = clipboard.getContents(this);
        }
        if (transferable != null) {
            try {
                if (this.isUsingSystemClipboard() && this.isUsingXML()) {
                    if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        Object object = transferable.getTransferData(DataFlavor.stringFlavor);
                        this.createGraphFromStringManager((String)object, tSOptionData);
                    }
                } else if (transferable.isDataFlavorSupported(graphFlavor)) {
                    this.clipboardGraphManager = (TSDGraphManager)transferable.getTransferData(graphFlavor);
                }
                this.affectedGraphList.addAll(this.clipboardGraphManager.graphs(true));
                this.affectedNodeList.addAll(this.clipboardGraphManager.getMainDisplayGraph().nodes());
                this.affectedEdgeList.addAll(this.clipboardGraphManager.getMainDisplayGraph().edges());
                this.affectedEdgeList.addAll(this.clipboardGraphManager.intergraphEdges());
                this.affectedEdgeLabelList.addAll(this.getDemoEdge().labels());
                this.affectedNodeLabelList.addAll(this.getDemoNode().labels());
                this.affectedConnectorLabelList.addAll(this.getDemoConnector().labels());
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                throw new InternalError();
            }
        }
    }

    public void reset() {
        if (this.clipboardGraphManager != null) {
            TSNestingManager.discardManager(this.clipboardGraphManager);
            TSFoldingManager.discardManager(this.clipboardGraphManager);
            TSHidingManager.discardManager(this.clipboardGraphManager);
            this.clipboardGraphManager = null;
        }
        this.timeStamp = -1L;
        this.resetOriginalReferences();
    }

    public void resetOriginalReferences() {
        this.originalGraphManager = null;
        this.originalServiceInputData = null;
        this.inputNodeList = new Vector();
        this.inputEdgeList = new Vector();
        this.inputEdgeLabelList = new Vector();
        this.inputNodeLabelList = new Vector();
        this.inputConnectorLabelList = new Vector();
        this.clearAffectedObjectLists();
    }

    public boolean isUsingXML() {
        return this.usingXML && this.isXMLPackagesAvailable();
    }

    public void setUsingXML(boolean bl) {
        this.usingXML = bl;
    }

    public boolean isUsingXMLByDefault() {
        return true;
    }

    protected boolean isXMLPackagesAvailable() {
        return this.getGraphManagerXMLReaderClass() != null && this.getGraphManagerXMLWriterClass() != null && this.getServiceInputDataXMLReaderClass() != null && this.getServiceInputDataXMLWriterClass() != null;
    }

    protected Class getGraphManagerXMLReaderClass() {
        if (this.graphManagerXMLReaderClass == null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.tomsawyer.xml.editor.TSEGraphManagerXMLReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    clazz = Class.forName("com.tomsawyer.xml.drawing.TSDGraphManagerXMLReader");
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    clazz = null;
                }
            }
            this.graphManagerXMLReaderClass = clazz;
        }
        return this.graphManagerXMLReaderClass;
    }

    protected Class getGraphManagerXMLWriterClass() {
        if (this.graphManagerXMLWriterClass == null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.tomsawyer.xml.editor.TSEGraphManagerXMLWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    clazz = Class.forName("com.tomsawyer.xml.drawing.TSDGraphManagerXMLWriter");
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    clazz = null;
                }
            }
            this.graphManagerXMLWriterClass = clazz;
        }
        return this.graphManagerXMLWriterClass;
    }

    protected Class getServiceInputDataXMLReaderClass() {
        if (this.serviceInputDataXMLReaderClass == null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.tomsawyer.xml.service.TSServiceInputDataXMLReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
            this.serviceInputDataXMLReaderClass = clazz;
        }
        return this.serviceInputDataXMLReaderClass;
    }

    protected Class getServiceInputDataXMLWriterClass() {
        if (this.serviceInputDataXMLWriterClass == null) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.tomsawyer.xml.service.TSServiceInputDataXMLWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = null;
            }
            this.serviceInputDataXMLWriterClass = clazz;
        }
        return this.serviceInputDataXMLWriterClass;
    }

    protected void xmlWrite(Writer writer, TSDGraphManager tSDGraphManager, TSOptionData tSOptionData) throws Exception {
        TSTopLevelXMLWriter tSTopLevelXMLWriter;
        Constructor constructor;
        Class clazz;
        TSCompositeXMLWriter tSCompositeXMLWriter = new TSCompositeXMLWriter(writer);
        if (tSDGraphManager != null) {
            tSCompositeXMLWriter.setObjectToWrite(this.GRAPH_MANAGER, tSDGraphManager);
            clazz = this.getGraphManagerXMLWriterClass();
            constructor = clazz.getConstructor(new Class[0]);
            tSTopLevelXMLWriter = (TSTopLevelXMLWriter)constructor.newInstance(new Object[0]);
            tSCompositeXMLWriter.setWriter(this.GRAPH_MANAGER, tSTopLevelXMLWriter);
        }
        if (tSOptionData != null) {
            tSCompositeXMLWriter.setObjectToWrite(this.SERVICE_INPUT_DATA, tSOptionData);
            clazz = this.getServiceInputDataXMLWriterClass();
            Class[] classArray = new Class[1];
            classArray[0] = class$java$lang$String == null ? (class$java$lang$String = TSCutCopyPasteControl.class$("java.lang.String")) : class$java$lang$String;
            constructor = clazz.getConstructor(classArray);
            tSTopLevelXMLWriter = (TSTopLevelXMLWriter)constructor.newInstance(this.SERVICE_INPUT_DATA);
            tSCompositeXMLWriter.setWriter(this.SERVICE_INPUT_DATA, tSTopLevelXMLWriter);
        }
        tSCompositeXMLWriter.write();
    }

    protected void xmlRead(Reader reader, TSDGraphManager tSDGraphManager, TSOptionData tSOptionData) throws Exception {
        TSTopLevelXMLReader tSTopLevelXMLReader;
        Constructor constructor;
        Class clazz;
        TSCompositeXMLReader tSCompositeXMLReader = new TSCompositeXMLReader(reader);
        if (tSDGraphManager != null) {
            tSCompositeXMLReader.setObjectToRead(this.GRAPH_MANAGER, tSDGraphManager);
            clazz = this.getGraphManagerXMLReaderClass();
            constructor = clazz.getConstructor(new Class[0]);
            tSTopLevelXMLReader = (TSTopLevelXMLReader)constructor.newInstance(new Object[0]);
            tSCompositeXMLReader.setReader(this.GRAPH_MANAGER, tSTopLevelXMLReader);
        }
        if (tSOptionData != null) {
            tSCompositeXMLReader.setObjectToRead(this.SERVICE_INPUT_DATA, tSOptionData);
            clazz = this.getServiceInputDataXMLReaderClass();
            Class[] classArray = new Class[1];
            classArray[0] = class$java$lang$String == null ? (class$java$lang$String = TSCutCopyPasteControl.class$("java.lang.String")) : class$java$lang$String;
            constructor = clazz.getConstructor(classArray);
            tSTopLevelXMLReader = (TSTopLevelXMLReader)constructor.newInstance(this.SERVICE_INPUT_DATA);
            tSCompositeXMLReader.setReader(this.SERVICE_INPUT_DATA, tSTopLevelXMLReader);
        }
        tSCompositeXMLReader.read();
    }

    private void copyGraphRelatedServiceInputData(TSDGraph tSDGraph, TSDGraph tSDGraph2, TSOptionData tSOptionData, TSOptionData tSOptionData2) {
        if (tSDGraph != null && tSDGraph2 != null && tSOptionData != null && tSOptionData2 != null) {
            TSDEdge tSDEdge;
            Object object;
            Object object2;
            this.copyServiceInputData(tSDGraph, tSDGraph2, tSOptionData, tSOptionData2);
            Iterator iterator = tSDGraph.nodes().iterator();
            while (iterator.hasNext()) {
                object2 = (TSDNode)iterator.next();
                object = null;
                if (((TSGraphObject)object2).getUtilityObject() instanceof TSDNode) {
                    object = (TSDNode)((TSGraphObject)object2).getUtilityObject();
                }
                this.copyNodeRelatedServiceInputData((TSDNode)object2, (TSDNode)object, tSOptionData, tSOptionData2);
            }
            object2 = tSDGraph.edges().iterator();
            while (object2.hasNext()) {
                object = (TSDEdge)object2.next();
                tSDEdge = null;
                if (((TSGraphObject)object).getUtilityObject() instanceof TSDEdge) {
                    tSDEdge = (TSDEdge)((TSGraphObject)object).getUtilityObject();
                }
                this.copyEdgeRelatedServiceInputData((TSDEdge)object, tSDEdge, tSOptionData, tSOptionData2);
            }
            object = tSDGraph.disconnectedEdges().iterator();
            while (object.hasNext()) {
                tSDEdge = (TSDEdge)object.next();
                TSDEdge tSDEdge2 = null;
                if (tSDEdge.getUtilityObject() instanceof TSDEdge) {
                    tSDEdge2 = (TSDEdge)tSDEdge.getUtilityObject();
                }
                this.copyEdgeRelatedServiceInputData(tSDEdge, tSDEdge2, tSOptionData, tSOptionData2);
            }
            this.copyGraphRelatedServiceInputData(tSDGraph.hideGraph(), tSDGraph2.hideGraph(), tSOptionData, tSOptionData2);
        }
    }

    private void copyEdgeRelatedServiceInputData(TSDEdge tSDEdge, TSDEdge tSDEdge2, TSOptionData tSOptionData, TSOptionData tSOptionData2) {
        TSGraphObject tSGraphObject;
        Object object;
        if (tSDEdge != null && tSDEdge2 != null && tSOptionData != null && tSOptionData2 != null) {
            this.copyServiceInputData(tSDEdge, tSDEdge2, tSOptionData, tSOptionData2);
            object = tSDEdge.labels().iterator();
            while (object.hasNext()) {
                tSGraphObject = (TSEdgeLabel)object.next();
                TSEdgeLabel tSEdgeLabel = null;
                if (tSGraphObject.getUtilityObject() instanceof TSEdgeLabel) {
                    tSEdgeLabel = (TSEdgeLabel)tSGraphObject.getUtilityObject();
                }
                this.copyServiceInputData(tSGraphObject, tSEdgeLabel, tSOptionData, tSOptionData2);
            }
        }
        if (tSDEdge.getChildGraph() != null) {
            object = (TSDGraph)tSDEdge.getChildGraph();
            tSGraphObject = null;
            if (((TSGraphObject)object).getUtilityObject() instanceof TSDGraph) {
                tSGraphObject = (TSDGraph)((TSGraphObject)object).getUtilityObject();
            }
            this.copyGraphRelatedServiceInputData((TSDGraph)object, (TSDGraph)tSGraphObject, tSOptionData, tSOptionData2);
        }
    }

    private void copyNodeRelatedServiceInputData(TSDNode tSDNode, TSDNode tSDNode2, TSOptionData tSOptionData, TSOptionData tSOptionData2) {
        if (tSDNode != null && tSDNode2 != null && tSOptionData != null && tSOptionData2 != null) {
            TSGraphObject tSGraphObject;
            TSGraphObject tSGraphObject2;
            Object object;
            this.copyServiceInputData(tSDNode, tSDNode2, tSOptionData, tSOptionData2);
            Iterator iterator = tSDNode.labels().iterator();
            while (iterator.hasNext()) {
                object = (TSNodeLabel)iterator.next();
                tSGraphObject2 = null;
                if (((TSGraphObject)object).getUtilityObject() instanceof TSNodeLabel) {
                    tSGraphObject2 = (TSNodeLabel)((TSGraphObject)object).getUtilityObject();
                }
                this.copyServiceInputData(object, tSGraphObject2, tSOptionData, tSOptionData2);
            }
            object = tSDNode.connectors().iterator();
            while (object.hasNext()) {
                tSGraphObject2 = (TSConnector)object.next();
                tSGraphObject = null;
                if (tSGraphObject2.getUtilityObject() instanceof TSConnector) {
                    tSGraphObject = (TSConnector)tSGraphObject2.getUtilityObject();
                }
                if (tSGraphObject == null) continue;
                this.copyServiceInputData(tSGraphObject2, tSGraphObject, tSOptionData, tSOptionData2);
                iterator = ((TSConnector)tSGraphObject2).labels().iterator();
                while (iterator.hasNext()) {
                    TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)iterator.next();
                    TSConnectorLabel tSConnectorLabel2 = null;
                    if (tSConnectorLabel.getUtilityObject() instanceof TSConnectorLabel) {
                        tSConnectorLabel2 = (TSConnectorLabel)tSConnectorLabel.getUtilityObject();
                    }
                    this.copyServiceInputData(tSConnectorLabel, tSConnectorLabel2, tSOptionData, tSOptionData2);
                }
            }
            if (tSDNode.getChildGraph() != null) {
                tSGraphObject2 = (TSDGraph)tSDNode.getChildGraph();
                tSGraphObject = null;
                if (tSGraphObject2.getUtilityObject() instanceof TSDGraph) {
                    tSGraphObject = (TSDGraph)tSGraphObject2.getUtilityObject();
                }
                this.copyGraphRelatedServiceInputData((TSDGraph)tSGraphObject2, (TSDGraph)tSGraphObject, tSOptionData, tSOptionData2);
            }
        }
    }

    private void copyServiceInputData(Object object, Object object2, TSOptionData tSOptionData, TSOptionData tSOptionData2) {
        Map map;
        if (tSOptionData != null && tSOptionData2 != null && object != null && object2 != null && (map = tSOptionData.getValues(object)) != null) {
            HashMap hashMap = new HashMap(map);
            tSOptionData2.setOption(object2, hashMap);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

