/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.complexity.command;

import com.tomsawyer.complexity.TSFoldingManager;
import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.complexity.event.TSComplexityChangeEvent;
import com.tomsawyer.complexity.event.TSComplexityChangeEventData;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.util.command.TSGroupCommand;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSUnfoldCommand
extends TSCommand {
    TSDNode folder;
    List nodeList;
    TSGroupCommand groupUnfoldCommand;
    boolean compressMetaEdges;
    boolean isChildCommand;
    TSPoint oldCenter;
    TSDGraph startGraph;
    boolean deep;

    public TSUnfoldCommand() {
    }

    public TSUnfoldCommand(TSDGraph tSDGraph, boolean bl) {
        this.folder = null;
        this.nodeList = null;
        this.oldCenter = null;
        this.groupUnfoldCommand = new TSGroupCommand();
        this.setChildCommand(false);
        this.startGraph = tSDGraph;
        this.deep = bl;
    }

    public TSUnfoldCommand(TSDNode tSDNode) {
        this.folder = null;
        this.nodeList = null;
        this.oldCenter = null;
        this.setChildCommand(false);
        this.startGraph = null;
        this.deep = false;
        if (tSDNode != null && tSDNode.isFolderNode()) {
            this.folder = tSDNode;
        }
    }

    public TSUnfoldCommand(List list) {
        TSSystem.tsAssert(list != null && list.size() > 0);
        this.folder = null;
        this.oldCenter = null;
        this.setChildCommand(false);
        this.startGraph = null;
        this.deep = false;
        this.groupUnfoldCommand = new TSGroupCommand();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            if (!tSDNode.isFolderNode()) continue;
            TSUnfoldCommand tSUnfoldCommand = new TSUnfoldCommand(tSDNode);
            tSUnfoldCommand.setChildCommand(true);
            this.groupUnfoldCommand.add(tSUnfoldCommand);
        }
    }

    protected void init() {
        if (this.folder != null && this.folder.isFolderNode()) {
            this.compressMetaEdges = ((TSDGraphManager)this.folder.getOwner().getOwner()).getCompressMetaEdges();
            if (this.folder.hasChildGraph()) {
                this.nodeList = new Vector(this.folder.getChildGraph().nodes());
            }
        } else if (this.startGraph != null) {
            TSDGraph tSDGraph = this.startGraph;
            Vector<Object> vector = new Vector<Object>();
            vector.add(tSDGraph);
            if (this.deep) {
                TSNestingManager.buildAllNestedGraphList(tSDGraph, vector, false);
            }
            while (!vector.isEmpty()) {
                TSDGraph tSDGraph2 = (TSDGraph)vector.remove(0);
                Iterator iterator = tSDGraph2.nodes().iterator();
                while (iterator.hasNext()) {
                    Object object;
                    TSDNode tSDNode = (TSDNode)iterator.next();
                    if (!tSDNode.isFolderNode()) continue;
                    if (tSDNode.getChildGraph() != null && !TSNestingManager.isNested((TSDGraph)tSDNode.getChildGraph())) {
                        object = (TSDGraph)tSDNode.getChildGraph();
                        vector.add(object);
                        TSNestingManager.buildAllNestedGraphList((TSDGraph)object, vector, false);
                    }
                    object = new TSUnfoldCommand(tSDNode);
                    ((TSUnfoldCommand)object).setChildCommand(true);
                    this.groupUnfoldCommand.add((TSCommand)object);
                }
            }
        }
    }

    protected void doAction() throws Throwable {
        if (this.folder != null) {
            TSDGraph tSDGraph = (TSDGraph)this.folder.getOwnerGraph();
            TSFoldingManager tSFoldingManager = TSFoldingManager.getManager((TSDGraphManager)tSDGraph.getOwner());
            this.oldCenter = new TSPoint(this.folder.getLocalCenter());
            if (tSDGraph.fireEvent(new TSComplexityChangeEvent(16L, new TSComplexityChangeEventData(this.folder, null, null)), true)) {
                tSFoldingManager.unfold(this.folder, true);
                tSDGraph.remove(this.folder);
                tSDGraph.getOwnerGraphManager().remove(this.folder.getChildGraph());
            }
            tSFoldingManager.clearResultLists();
        } else if (this.groupUnfoldCommand != null) {
            this.groupUnfoldCommand.execute();
        }
    }

    protected void redoAction() throws Throwable {
        if (this.folder != null) {
            TSDGraph tSDGraph = (TSDGraph)this.folder.getOwnerGraph();
            TSDGraphManager tSDGraphManager = (TSDGraphManager)tSDGraph.getOwner();
            TSFoldingManager tSFoldingManager = TSFoldingManager.getManager(tSDGraphManager);
            tSFoldingManager.unfold(this.folder, true);
            tSDGraph.remove(this.folder);
            tSDGraphManager.remove(this.folder.getChildGraph());
            this.nodeList = tSFoldingManager.getResultNodeList();
            tSFoldingManager.clearResultLists();
        } else if (this.groupUnfoldCommand != null) {
            this.groupUnfoldCommand.redo();
        }
    }

    protected void undoAction() throws Throwable {
        if (this.folder != null) {
            TSDGraph tSDGraph = (TSDGraph)this.folder.getOwner();
            TSDGraphManager tSDGraphManager = (TSDGraphManager)tSDGraph.getOwner();
            tSDGraph.insert(this.folder);
            TSFoldingManager tSFoldingManager = TSFoldingManager.getManager(tSDGraphManager);
            tSFoldingManager.fold(this.folder, (TSDGraph)this.folder.getChildGraph(), this.nodeList, true);
            tSFoldingManager.clearResultLists();
            this.folder.setLocalCenter(this.oldCenter);
        } else if (this.groupUnfoldCommand != null) {
            this.groupUnfoldCommand.undo();
        }
    }

    public boolean isCoalesced() {
        return true;
    }

    public boolean isOrderPreservedInCoalescing() {
        return true;
    }

    protected boolean isChildCommand() {
        return this.isChildCommand;
    }

    protected void setChildCommand(boolean bl) {
        this.isChildCommand = bl;
    }

    public boolean isAddToUndoStack() {
        boolean bl = super.isAddToUndoStack();
        if (this.groupUnfoldCommand != null) {
            Iterator iterator = this.groupUnfoldCommand.getCommandList().iterator();
            while (iterator.hasNext()) {
                TSCommand tSCommand = (TSCommand)iterator.next();
                bl = bl || tSCommand.isAddToUndoStack();
            }
        }
        return bl;
    }

    protected void doCleanup() {
        if (this.folder != null && !this.folder.isOwned()) {
            this.folder.dispose();
        }
        if (this.groupUnfoldCommand != null) {
            this.groupUnfoldCommand.doCleanup();
        }
    }
}

