/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.complexity;

import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.geometry.TSShape;
import com.tomsawyer.drawing.geometry.TSSize;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.util.TSObject;
import com.tomsawyer.util.TSSystem;

public class TSExpandedNodeExtension
extends TSObject {
    private TSGraphObject owner;
    private TSSize preExpandSize;
    private TSSize preExpandOriginalSize;
    TSShape preExpandShape;

    public TSExpandedNodeExtension(TSDNode tSDNode, TSDGraphManager tSDGraphManager) {
        this.owner = tSDNode != null ? tSDNode : tSDGraphManager;
        if (tSDNode != null) {
            this.preExpandSize = new TSSize();
            this.preExpandSize.copy(tSDNode.getLocalSize());
            this.preExpandOriginalSize = new TSSize();
            this.preExpandOriginalSize.copy(tSDNode.getLocalOriginalSize());
            this.preExpandShape = tSDNode.getShape();
        }
    }

    public void init() {
        this.owner = null;
    }

    public TSSize getPreExpandSize() {
        return this.preExpandSize;
    }

    public TSSize getPreExpandOriginalSize() {
        return this.preExpandOriginalSize;
    }

    public void setPreExpandOriginalSize(TSSize tSSize) {
        if (tSSize != null) {
            this.preExpandOriginalSize.copy(tSSize);
        }
    }

    public void setPreExpandSize(TSSize tSSize) {
        if (tSSize != null) {
            this.preExpandSize.copy(tSSize);
        }
    }

    public TSDNode getExpandedNode() {
        TSDNode tSDNode = this.owner != null && this.owner instanceof TSDNode ? (TSDNode)this.owner : null;
        return tSDNode;
    }

    public TSDGraphManager getOwnerGraphManager() {
        TSDGraphManager tSDGraphManager = this.owner != null && this.owner instanceof TSDGraphManager ? (TSDGraphManager)this.owner : (this.getExpandedNode() != null && this.getExpandedNode().getOwner() != null ? (TSDGraphManager)this.getExpandedNode().getOwner().getOwner() : null);
        return tSDGraphManager;
    }

    public void exchangeContents(boolean bl) {
        TSDNode tSDNode = this.getExpandedNode();
        if (tSDNode != null) {
            if (!bl) {
                this.preExpandSize.copy(tSDNode.getLocalSize());
                this.preExpandOriginalSize.copy(tSDNode.getLocalOriginalSize());
                this.preExpandShape = tSDNode.getShape();
                boolean bl2 = tSDNode.getOwnerGraph().isFiringEvents();
                tSDNode.getOwnerGraph().setFireEvents(false);
                tSDNode.setShape(null);
                tSDNode.getOwnerGraph().setFireEvents(bl2);
            }
            if (bl) {
                TSSize tSSize = new TSSize(this.preExpandSize);
                TSSize tSSize2 = new TSSize(this.preExpandOriginalSize);
                tSDNode.setLocalSize(tSSize.getWidth(), tSSize.getHeight());
                tSDNode.setLocalOriginalSize(tSSize2.getWidth(), tSSize2.getHeight());
                boolean bl3 = tSDNode.getOwnerGraph().isFiringEvents();
                tSDNode.getOwnerGraph().setFireEvents(false);
                tSDNode.setShape(this.getPreExpandShape());
                tSDNode.getOwnerGraph().setFireEvents(bl3);
            }
        }
    }

    public TSShape getPreExpandShape() {
        return this.preExpandShape;
    }

    public void setPreExpandShape(TSShape tSShape) {
        this.preExpandShape = tSShape;
    }

    public void copy(Object object) {
        TSExpandedNodeExtension tSExpandedNodeExtension = (TSExpandedNodeExtension)object;
        this.setPreExpandOriginalSize(tSExpandedNodeExtension.getPreExpandOriginalSize());
        this.setPreExpandSize(tSExpandedNodeExtension.getPreExpandSize());
    }

    protected String getAttributeString() {
        return "\tpreExpandSize = " + this.getPreExpandSize() + TSSystem.eol + "\tpreExpandOriginalSize = " + this.getPreExpandOriginalSize();
    }
}

