/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.file;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.util.Comparator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class FileDescription {
    static long time;
    public static final String SEARCH_IN_PROGRES;
    private File file;
    private Project project;
    private SourceGroup sourceGroup;
    private FileObject fileObject;
    private Icon icon;
    private String projectName;
    private Icon projectIcon;
    private boolean prefered;
    private static final String EMPTY_STRING = "";

    public FileDescription(File file, Project project, SourceGroup sourceGroup, boolean bl) {
        this.file = file;
        this.project = project;
        this.sourceGroup = sourceGroup;
        this.prefered = bl;
    }

    public String getName() {
        return this.file.getName();
    }

    public synchronized Icon getIcon() {
        if (this.icon == null) {
            DataObject dataObject = this.getDataObject();
            Image image = dataObject.getNodeDelegate().getIcon(1);
            this.icon = new ImageIcon(image);
        }
        return this.icon;
    }

    public String getRelativePath() {
        return " (" + FileUtil.getRelativePath((FileObject)this.sourceGroup.getRootFolder(), (FileObject)this.getFileObject().getParent()) + ")";
    }

    public synchronized String getProjectName() {
        if (this.projectName == null) {
            this.initProjectInfo();
        }
        return this.projectName;
    }

    public synchronized Icon getProjectIcon() {
        if (this.projectIcon == null) {
            this.initProjectInfo();
        }
        return this.projectIcon;
    }

    public synchronized boolean isVisible() {
        boolean bl;
        long l = System.currentTimeMillis();
        if (this.fileObject == null) {
            this.fileObject = FileUtil.toFileObject((File)this.file);
        }
        boolean bl2 = bl = this.fileObject == null ? false : VisibilityQuery.getDefault().isVisible(this.fileObject);
        if (!bl) {
            this.addTime(l);
            return false;
        }
        while (this.fileObject.getParent() != null) {
            this.fileObject = this.fileObject.getParent();
            if (this.fileObject.equals(this.sourceGroup.getRootFolder())) {
                this.addTime(l);
                return true;
            }
            if (VisibilityQuery.getDefault().isVisible(this.fileObject)) continue;
            this.addTime(l);
            return false;
        }
        this.addTime(l);
        return true;
    }

    private void addTime(long l) {
    }

    public void open() {
        DataObject dataObject = this.getDataObject();
        if (dataObject != null) {
            EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
            if (editCookie != null) {
                editCookie.edit();
            } else {
                OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
                if (openCookie != null) {
                    openCookie.open();
                }
            }
        }
    }

    public FileObject getFileObject() {
        return FileUtil.toFileObject((File)this.file);
    }

    private DataObject getDataObject() {
        try {
            FileObject fileObject = this.getFileObject();
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    private void initProjectInfo() {
        ProjectInformation projectInformation = ProjectUtils.getInformation((Project)this.project);
        this.projectName = projectInformation.getDisplayName();
        this.projectIcon = projectInformation.getIcon();
    }

    static {
        SEARCH_IN_PROGRES = NbBundle.getMessage(FileDescription.class, (String)"TXT_SearchingOtherProjects");
    }

    public static class Renderer
    extends DefaultListCellRenderer
    implements ChangeListener {
        public static Icon WAIT_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/jumpto/file/resources/wait.gif"));
        private JPanel rendererComponent;
        private JLabel jlName = new JLabel();
        private JLabel jlPath = new JLabel();
        private JLabel jlPrj = new JLabel();
        private int DARKER_COLOR_COMPONENT = 5;
        private int LIGHTER_COLOR_COMPONENT = 80;
        private Color fgColor;
        private Color fgColorLighter;
        private Color bgColor;
        private Color bgColorDarker;
        private Color bgSelectionColor;
        private Color fgSelectionColor;
        private Color bgColorGreener;
        private Color bgColorDarkerGreener;
        private JList jList;
        private boolean colorPrefered;

        public Renderer(JList jList) {
            this.jList = jList;
            Container container = jList.getParent();
            if (container instanceof JViewport) {
                ((JViewport)container).addChangeListener(this);
                this.stateChanged(new ChangeEvent(container));
            }
            this.rendererComponent = new JPanel();
            this.rendererComponent.setLayout(new BorderLayout());
            this.rendererComponent.add((Component)this.jlName, "West");
            this.rendererComponent.add((Component)this.jlPath, "Center");
            this.rendererComponent.add((Component)this.jlPrj, "East");
            this.jlName.setOpaque(false);
            this.jlPath.setOpaque(false);
            this.jlPrj.setOpaque(false);
            this.jlName.setFont(jList.getFont());
            this.jlPath.setFont(jList.getFont());
            this.jlPrj.setFont(jList.getFont());
            this.jlPrj.setHorizontalAlignment(4);
            this.jlPrj.setHorizontalTextPosition(2);
            this.fgColor = jList.getForeground();
            this.fgColorLighter = new Color(Math.min(255, this.fgColor.getRed() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getGreen() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getBlue() + this.LIGHTER_COLOR_COMPONENT));
            this.bgColor = jList.getBackground();
            this.bgColorDarker = new Color(Math.abs(this.bgColor.getRed() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getGreen() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getBlue() - this.DARKER_COLOR_COMPONENT));
            this.bgSelectionColor = jList.getSelectionBackground();
            this.fgSelectionColor = jList.getSelectionForeground();
            this.bgColorGreener = new Color(Math.abs(this.bgColor.getRed() - 20), Math.min(255, this.bgColor.getGreen() + 10), Math.abs(this.bgColor.getBlue() - 20));
            this.bgColorDarkerGreener = new Color(Math.abs(this.bgColorDarker.getRed() - 35), Math.min(255, this.bgColorDarker.getGreen() + 5), Math.abs(this.bgColorDarker.getBlue() - 35));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            int n2 = jList.getFixedCellHeight();
            int n3 = jList.getFixedCellWidth() - 1;
            n3 = n3 < 200 ? 200 : n3;
            Dimension dimension = new Dimension(n3, n2);
            this.rendererComponent.setMaximumSize(dimension);
            this.rendererComponent.setPreferredSize(dimension);
            if (bl) {
                this.jlName.setForeground(this.fgSelectionColor);
                this.jlPath.setForeground(this.fgSelectionColor);
                this.jlPrj.setForeground(this.fgSelectionColor);
                this.rendererComponent.setBackground(this.bgSelectionColor);
            } else {
                this.jlName.setForeground(this.fgColor);
                this.jlPath.setForeground(this.fgColorLighter);
                this.jlPrj.setForeground(this.fgColor);
                this.rendererComponent.setBackground(n % 2 == 0 ? this.bgColor : this.bgColorDarker);
            }
            if (object instanceof FileDescription) {
                FileDescription fileDescription = (FileDescription)object;
                this.jlName.setIcon(fileDescription.getIcon());
                this.jlName.setText(fileDescription.getName());
                this.jlPath.setIcon(null);
                this.jlPath.setHorizontalAlignment(2);
                this.jlPath.setText(fileDescription.getRelativePath());
                this.jlPrj.setText(fileDescription.getProjectName());
                this.jlPrj.setIcon(fileDescription.getProjectIcon());
                if (!bl) {
                    this.rendererComponent.setBackground(n % 2 == 0 ? (fileDescription.prefered && this.colorPrefered ? this.bgColorGreener : this.bgColor) : (fileDescription.prefered && this.colorPrefered ? this.bgColorDarkerGreener : this.bgColorDarker));
                }
            } else {
                this.jlName.setText(FileDescription.EMPTY_STRING);
                this.jlName.setIcon(null);
                this.jlPath.setIcon(WAIT_ICON);
                this.jlPath.setHorizontalAlignment(0);
                this.jlPath.setText(object.toString());
                this.jlPrj.setIcon(null);
                this.jlPrj.setText(FileDescription.EMPTY_STRING);
            }
            return this.rendererComponent;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            this.jlName.setText("Sample");
            this.jlName.setIcon(new ImageIcon());
            this.jList.setFixedCellHeight(this.jlName.getPreferredSize().height);
            this.jList.setFixedCellWidth(jViewport.getExtentSize().width);
        }

        public void setColorPrefered(boolean bl) {
            this.colorPrefered = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FDComarator
    implements Comparator<FileDescription> {
        private boolean usePrefered;
        private boolean caseSensitive;

        public FDComarator(boolean bl, boolean bl2) {
            this.usePrefered = bl;
            this.caseSensitive = bl2;
        }

        @Override
        public int compare(FileDescription fileDescription, FileDescription fileDescription2) {
            int n;
            if (this.usePrefered) {
                if (fileDescription.prefered && !fileDescription2.prefered) {
                    return -1;
                }
                if (!fileDescription.prefered && fileDescription2.prefered) {
                    return 1;
                }
            }
            if ((n = this.compareStrings(fileDescription.file.getName(), fileDescription2.file.getName(), this.caseSensitive)) != 0) {
                return n;
            }
            n = this.compareStrings(fileDescription.getProjectName(), fileDescription2.getProjectName(), this.caseSensitive);
            if (n != 0) {
                return n;
            }
            n = this.compareStrings(fileDescription.file.getPath(), fileDescription2.file.getPath(), this.caseSensitive);
            return n;
        }

        private int compareStrings(String string, String string2, boolean bl) {
            if (string == null) {
                string = FileDescription.EMPTY_STRING;
            }
            if (string2 == null) {
                string2 = FileDescription.EMPTY_STRING;
            }
            return bl ? string.compareTo(string2) : string.compareToIgnoreCase(string2);
        }
    }
}

