/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage.preferences;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.lib.editor.util.CharacterConversions;
import org.netbeans.modules.editor.settings.storage.preferences.PreferencesImpl;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;
import org.netbeans.modules.editor.settings.storage.spi.StorageReader;
import org.netbeans.modules.editor.settings.storage.spi.StorageWriter;
import org.netbeans.modules.editor.settings.storage.spi.support.StorageSupport;
import org.openide.filesystems.FileObject;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PreferencesStorage
implements StorageDescription<String, PreferencesImpl.TypedValue> {
    private static final Logger LOG = Logger.getLogger(PreferencesStorage.class.getName());
    public static final String ID = "Preferences";
    private static final String E_ROOT = "editor-preferences";
    private static final String E_ENTRY = "entry";
    private static final String E_VALUE = "value";
    private static final String A_NAME = "name";
    private static final String A_VALUE = "value";
    private static final String A_VALUE_ID = "valueId";
    private static final String A_JAVA_TYPE = "javaType";
    private static final String A_REMOVE = "remove";
    private static final String A_XML_SPACE = "xml:space";
    private static final String V_PRESERVE = "preserve";
    private static final String PUBLIC_ID = "-//NetBeans//DTD Editor Preferences 1.0//EN";
    private static final String SYSTEM_ID = "http://www.netbeans.org/dtds/EditorPreferences-1_0.dtd";
    private static final String MIME_TYPE = "text/x-nbeditor-preferences";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean isUsingProfiles() {
        return false;
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public String getLegacyFileName() {
        return "properties.xml";
    }

    @Override
    public StorageReader<String, PreferencesImpl.TypedValue> createReader(FileObject fileObject, String string) {
        if (MIME_TYPE.equals(fileObject.getMIMEType())) {
            return new Reader(fileObject, string);
        }
        return new LegacyReader(fileObject, string);
    }

    @Override
    public StorageWriter<String, PreferencesImpl.TypedValue> createWriter(FileObject fileObject, String string) {
        return new Writer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Writer
    extends StorageWriter<String, PreferencesImpl.TypedValue> {
        @Override
        public Document getDocument() {
            Element element;
            Document document = XMLUtil.createDocument((String)PreferencesStorage.E_ROOT, null, (String)PreferencesStorage.PUBLIC_ID, (String)PreferencesStorage.SYSTEM_ID);
            Node node = document.getElementsByTagName(PreferencesStorage.E_ROOT).item(0);
            for (String string : this.getAdded().keySet()) {
                Object object;
                element = document.createElement(PreferencesStorage.E_ENTRY);
                node.appendChild(element);
                element.setAttribute(PreferencesStorage.A_NAME, string);
                String string2 = ((PreferencesImpl.TypedValue)this.getAdded().get(string)).getValue();
                if (string2.length() > 0) {
                    object = document.createElement("value");
                    object.appendChild(document.createCDATASection(CharacterConversions.lineFeedToLineSeparator((CharSequence)string2)));
                    element.appendChild((Node)object);
                } else {
                    element.setAttribute(string, string2);
                }
                object = ((PreferencesImpl.TypedValue)this.getAdded().get(string)).getJavaType();
                if (object != null && ((String)object).length() > 0) {
                    element.setAttribute(PreferencesStorage.A_JAVA_TYPE, (String)object);
                }
                element.setAttribute(PreferencesStorage.A_XML_SPACE, PreferencesStorage.V_PRESERVE);
            }
            for (String string : this.getRemoved()) {
                element = document.createElement(PreferencesStorage.E_ENTRY);
                node.appendChild(element);
                element.setAttribute(PreferencesStorage.A_NAME, string);
                element.setAttribute(PreferencesStorage.A_REMOVE, Boolean.TRUE.toString());
            }
            return document;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LegacyReader
    extends PreferencesReader {
        private static final String EL_ROOT = "properties";
        private static final String EL_PROPERTY = "property";
        private static final String AL_NAME = "name";
        private static final String AL_CLASS = "class";
        private static final String AL_VALUE = "value";
        private Map<String, PreferencesImpl.TypedValue> entriesMap = new HashMap<String, PreferencesImpl.TypedValue>();
        private String name = null;
        private String value = null;
        private String javaType = null;

        public LegacyReader(FileObject fileObject, String string) {
            super(fileObject, string);
        }

        @Override
        public Map<String, PreferencesImpl.TypedValue> getAdded() {
            return this.entriesMap;
        }

        @Override
        public Set<String> getRemoved() {
            return Collections.emptySet();
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!string3.equals(EL_ROOT) && string3.equals(EL_PROPERTY)) {
                this.name = attributes.getValue("name");
                this.value = attributes.getValue("value");
                this.javaType = attributes.getValue(AL_CLASS);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!string3.equals(EL_ROOT) && string3.equals(EL_PROPERTY)) {
                if (this.name != null && this.value != null) {
                    this.entriesMap.put(this.name, new PreferencesImpl.TypedValue(this.value, this.javaType));
                } else {
                    LOG.warning("Ignoring editor preferences legacy entry {'" + this.name + "', '" + this.value + "'}!");
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Reader
    extends PreferencesReader {
        private Map<String, PreferencesImpl.TypedValue> entriesMap = new HashMap<String, PreferencesImpl.TypedValue>();
        private Set<String> removedEntries = new HashSet<String>();
        private String name = null;
        private String value = null;
        private String javaType = null;
        private StringBuilder text = null;
        private StringBuilder cdataText = null;
        private boolean insideCdata = false;

        public Reader(FileObject fileObject, String string) {
            super(fileObject, string);
        }

        @Override
        public Map<String, PreferencesImpl.TypedValue> getAdded() {
            return this.entriesMap;
        }

        @Override
        public Set<String> getRemoved() {
            return this.removedEntries;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.text != null) {
                this.text.append(cArray, n, n2);
                if (this.insideCdata) {
                    this.cdataText.append(cArray, n, n2);
                }
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (!string3.equals(PreferencesStorage.E_ROOT)) {
                if (string3.equals(PreferencesStorage.E_ENTRY)) {
                    boolean bl = Boolean.valueOf(attributes.getValue(PreferencesStorage.A_REMOVE));
                    this.name = null;
                    this.value = null;
                    this.javaType = null;
                    this.text = null;
                    this.cdataText = null;
                    if (bl) {
                        String string4 = attributes.getValue(PreferencesStorage.A_NAME);
                        this.removedEntries.add(string4);
                    } else {
                        String string5;
                        this.name = attributes.getValue(PreferencesStorage.A_NAME);
                        String string6 = attributes.getValue(PreferencesStorage.A_VALUE_ID);
                        if (string6 != null && (string5 = StorageSupport.getLocalizingBundleMessage(this.getProcessedFile(), string6, null)) != null) {
                            this.value = string5;
                        }
                        if ((string5 = attributes.getValue("value")) != null) {
                            if (this.value == null) {
                                this.value = string5;
                            } else {
                                LOG.warning("The 'valueId' attribute specified valid resource bundle key, ignoring the 'value' attribute!");
                            }
                        }
                        this.javaType = attributes.getValue(PreferencesStorage.A_JAVA_TYPE);
                    }
                } else if (this.name != null && string3.equals("value")) {
                    if (this.value == null) {
                        this.text = new StringBuilder();
                        this.cdataText = new StringBuilder();
                        this.insideCdata = false;
                    } else {
                        LOG.warning("The 'value' or 'valueId' attribute was specified, ignoring the <value/> element!");
                    }
                }
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!string3.equals(PreferencesStorage.E_ROOT)) {
                if (string3.equals(PreferencesStorage.E_ENTRY)) {
                    if (this.name != null) {
                        if (this.value != null) {
                            if (!this.entriesMap.containsKey(this.name)) {
                                this.entriesMap.put(this.name, new PreferencesImpl.TypedValue(CharacterConversions.lineSeparatorToLineFeed((CharSequence)this.value), this.javaType));
                            } else {
                                LOG.warning("Ignoring duplicate editor preferences entry '" + this.name + "'!");
                            }
                        } else {
                            LOG.warning("Ignoring editor preferences entry '" + this.name + "' that does not specify any value!");
                        }
                    }
                } else if (string3.equals("value") && this.text != null) {
                    this.value = this.cdataText.length() > 0 ? this.cdataText.toString() : this.text.toString();
                }
            }
        }

        @Override
        public void startCDATA() throws SAXException {
            if (this.cdataText != null) {
                this.insideCdata = true;
            }
        }

        @Override
        public void endCDATA() throws SAXException {
            if (this.cdataText != null) {
                this.insideCdata = false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class PreferencesReader
    extends StorageReader<String, PreferencesImpl.TypedValue> {
        protected PreferencesReader(FileObject fileObject, String string) {
            super(fileObject, string);
        }

        @Override
        public abstract Map<String, PreferencesImpl.TypedValue> getAdded();

        @Override
        public abstract Set<String> getRemoved();
    }
}

