/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.fontscolors.CompositeFCS;
import org.netbeans.modules.editor.settings.storage.fontscolors.FontColorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.keybindings.KeyBindingSettingsImpl;
import org.netbeans.modules.editor.settings.storage.preferences.PreferencesImpl;
import org.netbeans.spi.editor.mimelookup.MimeDataProvider;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class SettingsProvider
implements MimeDataProvider {
    private static final Logger LOG = Logger.getLogger(SettingsProvider.class.getName());
    private final Map<MimePath, WeakReference<Lookup>> cache = new WeakHashMap<MimePath, WeakReference<Lookup>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookup(MimePath mimePath) {
        if (mimePath.size() > 0 && mimePath.getMimeType(0).contains("text/base")) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "Won't provide any settings for text/base It's been deprecated, use MimePath.EMPTY instead.");
            }
            return null;
        }
        Map<MimePath, WeakReference<Lookup>> map = this.cache;
        synchronized (map) {
            Object object;
            WeakReference<Lookup> weakReference = this.cache.get(mimePath);
            Lookup lookup = object = weakReference == null ? null : (Lookup)weakReference.get();
            if (object == null) {
                String string = mimePath.getPath();
                if (string.startsWith("test")) {
                    int n = string.indexOf(95);
                    if (n == -1) {
                        throw new IllegalStateException("Invalid mimePath: " + string);
                    }
                    String string2 = string.substring(0, n);
                    MimePath mimePath2 = MimePath.parse((String)string.substring(n + 1));
                    object = new ProxyLookup(new Lookup[]{new MyLookup(mimePath2, string2), Lookups.exclude((Lookup)MimeLookup.getLookup((MimePath)mimePath2), (Class[])new Class[]{FontColorSettings.class, KeyBindingSettings.class})});
                } else {
                    object = new MyLookup(mimePath, null);
                }
                this.cache.put(mimePath, new WeakReference<Lookup>((Lookup)object));
            }
            return object;
        }
    }

    private static final class MyLookup
    extends AbstractLookup
    implements PropertyChangeListener {
        private final MimePath mimePath;
        private final boolean specialFcsProfile;
        private String fcsProfile;
        private final InstanceContent ic;
        private CompositeFCS fontColorSettings = null;
        private Object keyBindingSettings = null;
        private Object preferences = null;
        private KeyBindingSettingsImpl kbsi;

        public MyLookup(MimePath mimePath, String string) {
            this(mimePath, string, new InstanceContent());
        }

        private MyLookup(MimePath mimePath, String string, InstanceContent instanceContent) {
            super((AbstractLookup.Content)instanceContent);
            Object object;
            this.mimePath = mimePath;
            if (string == null) {
                object = EditorSettings.getDefault().getCurrentFontColorProfile();
                this.fcsProfile = FontColorSettingsImpl.get(mimePath).getInternalFontColorProfile((String)object);
                this.specialFcsProfile = false;
            } else {
                this.fcsProfile = string;
                this.specialFcsProfile = true;
            }
            this.ic = instanceContent;
            object = EditorSettings.getDefault();
            ((EditorSettings)object).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)object));
            this.kbsi = KeyBindingSettingsImpl.get(mimePath);
            this.kbsi.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.kbsi));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void initialize() {
            MyLookup myLookup = this;
            synchronized (myLookup) {
                this.fontColorSettings = new CompositeFCS(this.mimePath, this.fcsProfile);
                this.keyBindingSettings = this.kbsi.createInstanceForLookup();
                this.preferences = PreferencesImpl.get(this.mimePath);
                this.ic.set(Arrays.asList(new Object[]{this.fontColorSettings, this.keyBindingSettings, this.preferences}), null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            MyLookup myLookup = this;
            synchronized (myLookup) {
                MimePath mimePath;
                String string;
                boolean bl = false;
                boolean bl2 = false;
                if (this.kbsi == propertyChangeEvent.getSource()) {
                    bl2 = true;
                } else if (propertyChangeEvent.getPropertyName() == null) {
                    if (!this.specialFcsProfile) {
                        string = EditorSettings.getDefault().getCurrentFontColorProfile();
                        this.fcsProfile = FontColorSettingsImpl.get(this.mimePath).getInternalFontColorProfile(string);
                    }
                    bl = true;
                } else if (propertyChangeEvent.getPropertyName().equals("editorFontColors")) {
                    string = (String)propertyChangeEvent.getNewValue();
                    if (string.equals(this.fcsProfile)) {
                        bl = true;
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("fontColors")) {
                    string = (String)propertyChangeEvent.getNewValue();
                    if (string.equals(this.fcsProfile)) {
                        mimePath = (MimePath)propertyChangeEvent.getOldValue();
                        if (this.fontColorSettings != null && this.fontColorSettings.isDerivedFromMimePath(mimePath)) {
                            bl = true;
                        }
                    }
                } else if (propertyChangeEvent.getPropertyName().equals("currentFontColorProfile") && !this.specialFcsProfile) {
                    string = (String)propertyChangeEvent.getNewValue();
                    this.fcsProfile = FontColorSettingsImpl.get(this.mimePath).getInternalFontColorProfile(string);
                    bl = true;
                }
                boolean bl3 = false;
                if (bl && this.fontColorSettings != null) {
                    this.fontColorSettings = new CompositeFCS(this.mimePath, this.fcsProfile);
                    bl3 = true;
                }
                if (bl2 && this.keyBindingSettings != null) {
                    this.keyBindingSettings = this.kbsi.createInstanceForLookup();
                    bl3 = true;
                }
                if (bl3) {
                    mimePath = new ArrayList();
                    if (this.fontColorSettings != null) {
                        mimePath.add(this.fontColorSettings);
                    }
                    if (this.keyBindingSettings != null) {
                        mimePath.add(this.keyBindingSettings);
                    }
                    if (this.preferences != null) {
                        mimePath.add(this.preferences);
                    }
                    this.ic.set((Collection)mimePath, null);
                }
            }
        }
    }
}

