/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.ConcurrentLinkedQueuePool;
import com.sun.grizzly.util.SelectionKeyActionAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;

public class SSLSelectionKeyAttachment
extends SelectionKeyActionAttachment {
    private static ConcurrentLinkedQueuePool<SSLSelectionKeyAttachment> pool = new ConcurrentLinkedQueuePool<SSLSelectionKeyAttachment>(){

        @Override
        public SSLSelectionKeyAttachment newInstance() {
            return new SSLSelectionKeyAttachment();
        }
    };
    private SSLEngine sslEngine;
    private ByteBuffer inputBB;
    private ByteBuffer outputBB;
    private AtomicReference<SelectionKey> associatedKey = new AtomicReference();

    public static SSLSelectionKeyAttachment create(SelectionKey key, SSLEngine sslEngine) {
        SSLSelectionKeyAttachment attachment = pool.poll();
        attachment.associatedKey.set(key);
        attachment.setInputBB(null);
        attachment.setOutputBB(null);
        attachment.setSslEngine(sslEngine);
        return attachment;
    }

    private SSLSelectionKeyAttachment() {
    }

    public ByteBuffer getInputBB() {
        return this.inputBB;
    }

    public void setInputBB(ByteBuffer inputBB) {
        this.inputBB = inputBB;
    }

    public ByteBuffer getOutputBB() {
        return this.outputBB;
    }

    public void setOutputBB(ByteBuffer outputBB) {
        this.outputBB = outputBB;
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public void setSslEngine(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    public void process(SelectionKey selectionKey) {
        if (this.associatedKey.get() == selectionKey) {
            WorkerThread workerThread;
            try {
                workerThread = (WorkerThread)((Object)Thread.currentThread());
            }
            catch (ClassCastException ex) {
                throw new IllegalStateException(ex.getMessage());
            }
            if (this.inputBB != null) {
                workerThread.setInputBB(this.inputBB);
                this.inputBB = null;
            }
            if (this.outputBB != null) {
                workerThread.setOutputBB(this.outputBB);
                this.outputBB = null;
            }
            workerThread.setSSLEngine(this.sslEngine);
        }
    }

    public void release(SelectionKey selectionKey) {
        if (this.associatedKey.getAndSet(null) == selectionKey) {
            this.sslEngine = null;
            this.inputBB = null;
            this.outputBB = null;
            super.release(selectionKey);
            pool.offer(this);
        }
    }
}

