/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.ComplexSelectorHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.ConnectorHandlerPool;
import com.sun.grizzly.Context;
import com.sun.grizzly.ControllerStateListener;
import com.sun.grizzly.DefaultConnectorHandlerPool;
import com.sun.grizzly.DefaultPipeline;
import com.sun.grizzly.DefaultProtocolChainInstanceHandler;
import com.sun.grizzly.DefaultSelectionKeyHandler;
import com.sun.grizzly.Lifecycle;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.ProtocolChainContextTask;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ReadController;
import com.sun.grizzly.RoundRobinSelectorHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.SelectorHandlerRunner;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.util.AttributeHolder;
import com.sun.grizzly.util.Cloner;
import com.sun.grizzly.util.ConcurrentLinkedQueuePool;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.State;
import com.sun.grizzly.util.StateHolder;
import com.sun.grizzly.util.SupportStateHolder;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller
implements Runnable,
Lifecycle,
Copyable,
ConnectorHandlerPool,
AttributeHolder,
SupportStateHolder<State> {
    private ConcurrentLinkedQueuePool<Context> contexts;
    protected ProtocolChainInstanceHandler instanceHandler;
    protected SelectionKeyHandler selectionKeyHandler;
    protected ComplexSelectorHandler multiReadThreadSelectorHandler = null;
    protected ConnectorHandlerPool connectorHandlerPool = null;
    protected ConcurrentLinkedQueue<SelectorHandler> selectorHandlers;
    protected StateHolder<State> stateHolder;
    protected int readThreadsCount = 0;
    protected ReadController[] readThreadControllers;
    private static Logger logger = Logger.getLogger("grizzly");
    private Pipeline<Callable> pipeline;
    protected Collection<ControllerStateListener> stateListeners = new LinkedList<ControllerStateListener>();
    protected AtomicInteger readySelectorHandlerCounter;
    protected AtomicInteger stoppedSelectorHandlerCounter;
    private boolean handleReadWriteConcurrently = true;
    protected Map<String, Object> attributes;

    public Controller() {
        this.contexts = new ConcurrentLinkedQueuePool<Context>(){

            @Override
            public Context newInstance() {
                return new Context();
            }
        };
        this.stateHolder = new StateHolder(true);
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        if (this.pipeline == null) {
            this.pipeline = new DefaultPipeline();
        }
        if (this.instanceHandler == null) {
            this.instanceHandler = new DefaultProtocolChainInstanceHandler();
        }
        if (this.selectorHandlers == null) {
            this.selectorHandlers = new ConcurrentLinkedQueue();
        }
        if (this.connectorHandlerPool == null) {
            this.connectorHandlerPool = new DefaultConnectorHandlerPool(this);
        }
    }

    protected void doSelect(SelectorHandler selectorHandler) {
        SelectionKey key = null;
        boolean delegateToWorkerThread = false;
        Object pciHandler = null;
        Object protocolChain = null;
        Context serverCtx = this.contexts.poll();
        serverCtx.setController(this);
        serverCtx.setSelectorHandler(selectorHandler);
        try {
            int selectorState = 0;
            if (selectorHandler.getSelectionKeyHandler() == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Set DefaultSelectionKeyHandler to SelectorHandler: " + selectorHandler);
                }
                SelectionKeyHandler tmpSelectionKeyHandler = this.selectionKeyHandler != null ? this.selectionKeyHandler : new DefaultSelectionKeyHandler(selectorHandler);
                selectorHandler.setSelectionKeyHandler(tmpSelectionKeyHandler);
            }
            selectorHandler.preSelect(serverCtx);
            Set<SelectionKey> readyKeys = selectorHandler.select(serverCtx);
            selectorState = readyKeys.size();
            if (this.stateHolder.getState(false) == State.STARTED && selectorHandler.getStateHolder().getState(false) == State.STARTED && selectorState != 0) {
                Iterator<SelectionKey> iterator = readyKeys.iterator();
                while (iterator.hasNext()) {
                    key = iterator.next();
                    iterator.remove();
                    boolean skipOpWrite = false;
                    delegateToWorkerThread = false;
                    if (key.isValid()) {
                        if ((key.readyOps() & 0x10) == 16) {
                            if (this.readThreadsCount > 0 && this.multiReadThreadSelectorHandler.supportsProtocol(selectorHandler.protocol())) {
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.log(Level.FINE, "OP_ACCEPT on " + key + " passed to multi readthread handler");
                                }
                                delegateToWorkerThread = this.multiReadThreadSelectorHandler.onAcceptInterest(key, serverCtx);
                                continue;
                            }
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "OP_ACCEPT on " + key);
                            }
                            delegateToWorkerThread = selectorHandler.onAcceptInterest(key, serverCtx);
                            continue;
                        }
                        if ((key.readyOps() & 8) == 8) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "OP_CONNECT on " + key);
                            }
                            delegateToWorkerThread = selectorHandler.onConnectInterest(key, serverCtx);
                            continue;
                        }
                        if ((key.readyOps() & 1) == 1) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "OP_READ on " + key);
                            }
                            delegateToWorkerThread = selectorHandler.onReadInterest(key, serverCtx);
                            if (!this.handleReadWriteConcurrently) {
                                skipOpWrite = true;
                            }
                        }
                        if (!skipOpWrite && key.isValid() && (key.readyOps() & 4) == 4) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "OP_WRITE on " + key);
                            }
                            delegateToWorkerThread |= selectorHandler.onWriteInterest(key, serverCtx);
                        }
                        if (!delegateToWorkerThread) continue;
                        Context context = this.pollContext(key);
                        context.setSelectorHandler(selectorHandler);
                        context.setPipeline(selectorHandler.pipeline());
                        context.setAsyncQueueReader(selectorHandler.getAsyncQueueReader());
                        context.setAsyncQueueWriter(selectorHandler.getAsyncQueueWriter());
                        context.execute(ProtocolChainContextTask.poll());
                        continue;
                    }
                    selectorHandler.getSelectionKeyHandler().cancel(key);
                }
            }
            delegateToWorkerThread = false;
            selectorHandler.postSelect(serverCtx);
            this.contexts.offer(serverCtx);
        }
        catch (ClosedSelectorException e) {
            if (this.stateHolder.getState() == State.STARTED && selectorHandler.getStateHolder().getState() == State.STARTED) {
                logger.log(Level.SEVERE, "Selector was unexpectedly closed.");
                this.notifyException(e);
            } else {
                logger.log(Level.FINE, "doSelect Selector closed");
            }
        }
        catch (ClosedChannelException e) {
            if (this.stateHolder.getState() == State.STARTED && selectorHandler.getStateHolder().getState() == State.STARTED) {
                logger.log(Level.WARNING, "Channel was unexpectedly closed");
                if (key != null) {
                    selectorHandler.getSelectionKeyHandler().cancel(key);
                }
                this.notifyException(e);
            }
        }
        catch (Throwable t) {
            if (key != null) {
                selectorHandler.getSelectionKeyHandler().cancel(key);
            }
            this.notifyException(t);
            logger.log(Level.SEVERE, "doSelect exception", t);
        }
    }

    public void registerKey(SelectionKey key) {
        this.registerKey(key, 1);
    }

    public void registerKey(SelectionKey key, int ops) {
        this.registerKey(key, ops, this.selectorHandlers.peek().protocol());
    }

    public void registerKey(SelectionKey key, int ops, Protocol protocol) {
        if (this.stateHolder.getState() == State.STOPPED) {
            return;
        }
        this.getSelectorHandler(protocol).register(key, ops);
    }

    public void cancelKey(SelectionKey key) {
        if (this.stateHolder.getState() == State.STOPPED) {
            return;
        }
        SelectorHandler selectorHandler = this.getSelectorHandler(key.selector());
        if (selectorHandler == null) {
            throw new IllegalStateException("SelectionKey is not associated with known SelectorHandler");
        }
        selectorHandler.getSelectionKeyHandler().cancel(key);
    }

    public Context pollContext(SelectionKey key) {
        Context ctx = this.contexts.poll();
        ctx.setController(this);
        ctx.setSelectionKey(key);
        return ctx;
    }

    public void returnContext(Context ctx) {
        ctx.recycle();
        this.contexts.offer(ctx);
    }

    public static Logger logger() {
        return logger;
    }

    public static void setLogger(Logger l) {
        logger = l;
    }

    public void setProtocolChainInstanceHandler(ProtocolChainInstanceHandler instanceHandler) {
        this.instanceHandler = instanceHandler;
    }

    public ProtocolChainInstanceHandler getProtocolChainInstanceHandler() {
        return this.instanceHandler;
    }

    public void setSelectionKeyHandler(SelectionKeyHandler selectionKeyHandler) {
        this.selectionKeyHandler = selectionKeyHandler;
    }

    public SelectionKeyHandler getSelectionKeyHandler() {
        return this.selectionKeyHandler;
    }

    public void addSelectorHandler(SelectorHandler selectorHandler) {
        this.selectorHandlers.add(selectorHandler);
        if (this.stateHolder.getState(false) != null && !State.STOPPED.equals((Object)this.stateHolder.getState())) {
            this.addSelectorHandlerOnReadControllers(selectorHandler);
            if (this.readySelectorHandlerCounter != null) {
                this.readySelectorHandlerCounter.incrementAndGet();
            }
            if (this.stoppedSelectorHandlerCounter != null) {
                this.stoppedSelectorHandlerCounter.incrementAndGet();
            }
            this.startSelectorHandlerRunner(selectorHandler, true);
        }
    }

    public void setSelectorHandler(SelectorHandler selectorHandler) {
        this.addSelectorHandler(selectorHandler);
    }

    public SelectorHandler getSelectorHandler(Protocol protocol) {
        for (SelectorHandler selectorHandler : this.selectorHandlers) {
            if (selectorHandler.protocol() != protocol) continue;
            return selectorHandler;
        }
        return null;
    }

    public SelectorHandler getSelectorHandler(Selector selector) {
        for (SelectorHandler selectorHandler : this.selectorHandlers) {
            if (selectorHandler.getSelector() != selector) continue;
            return selectorHandler;
        }
        return null;
    }

    public ConcurrentLinkedQueue getSelectorHandlers() {
        return this.selectorHandlers;
    }

    public void removeSelectorHandler(SelectorHandler selectorHandler) {
        if (this.selectorHandlers.remove(selectorHandler)) {
            this.removeSelectorHandlerOnReadControllers(selectorHandler);
            selectorHandler.shutdown();
        }
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(Pipeline<Callable> pipeline) {
        this.pipeline = pipeline;
    }

    public int getReadThreadsCount() {
        return this.readThreadsCount;
    }

    public void setReadThreadsCount(int readThreadsCount) {
        this.readThreadsCount = readThreadsCount;
    }

    public ConnectorHandlerPool getConnectorHandlerPool() {
        return this.connectorHandlerPool;
    }

    public void setConnectorHandlerPool(ConnectorHandlerPool connectorHandlerPool) {
        this.connectorHandlerPool = connectorHandlerPool;
    }

    @Override
    public void run() {
        try {
            this.start();
        }
        catch (IOException e) {
            this.notifyException(e);
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public void copyTo(Copyable copy) {
        Controller copyController = (Controller)copy;
        copyController.contexts = this.contexts;
        copyController.attributes = this.attributes;
        copyController.instanceHandler = this.instanceHandler;
        copyController.pipeline = this.pipeline;
        copyController.readThreadControllers = this.readThreadControllers;
        copyController.readThreadsCount = this.readThreadsCount;
        copyController.selectionKeyHandler = this.selectionKeyHandler;
        copyController.stateHolder = this.stateHolder;
    }

    public void addStateListener(ControllerStateListener stateListener) {
        this.stateListeners.add(stateListener);
    }

    public void removeStateListener(ControllerStateListener stateListener) {
        this.stateListeners.remove(stateListener);
    }

    void notifyStarted() {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onStarted();
        }
    }

    void notifyReady() {
        if (this.readySelectorHandlerCounter.decrementAndGet() == 0) {
            for (ControllerStateListener stateListener : this.stateListeners) {
                stateListener.onReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyStopped() {
        if (this.stoppedSelectorHandlerCounter.decrementAndGet() == 0) {
            AtomicInteger atomicInteger = this.stoppedSelectorHandlerCounter;
            synchronized (atomicInteger) {
                this.stoppedSelectorHandlerCounter.notifyAll();
            }
            for (ControllerStateListener stateListener : this.stateListeners) {
                stateListener.onStopped();
            }
        }
    }

    void notifyException(Throwable e) {
        for (ControllerStateListener stateListener : this.stateListeners) {
            stateListener.onException(e);
        }
    }

    @Override
    public void start() throws IOException {
        if (this.selectorHandlers.isEmpty()) {
            TCPSelectorHandler selectorHandler = new TCPSelectorHandler();
            this.selectorHandlers.add(selectorHandler);
        }
        this.pipeline.initPipeline();
        this.pipeline.startPipeline();
        if (this.readThreadsCount > 0) {
            this.initReadThreads();
            this.multiReadThreadSelectorHandler = new RoundRobinSelectorHandler(this.readThreadControllers);
        }
        this.stateHolder.setState(State.STARTED);
        this.notifyStarted();
        int selectorHandlerCount = this.selectorHandlers.size();
        this.readySelectorHandlerCounter = new AtomicInteger(selectorHandlerCount);
        this.stoppedSelectorHandlerCounter = new AtomicInteger(selectorHandlerCount);
        for (SelectorHandler selectorHandler : this.selectorHandlers) {
            this.startSelectorHandlerRunner(selectorHandler, selectorHandlerCount > 1);
        }
        this.waitUntilSeletorHandlersStop();
        this.selectorHandlers.clear();
        this.pipeline.stopPipeline();
        this.attributes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        this.stateHolder.getStateLocker().writeLock().lock();
        try {
            if (this.stateHolder.getState(false) == State.STOPPED) {
                logger.log(Level.FINE, "Controller is already in stopped state");
                Object var2_1 = null;
                this.stateHolder.getStateLocker().writeLock().unlock();
                return;
            }
            this.stateHolder.setState(State.STOPPED, false);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.stateHolder.getStateLocker().writeLock().unlock();
            throw throwable;
        }
        Object var2_2 = null;
        this.stateHolder.getStateLocker().writeLock().unlock();
        if (this.stoppedSelectorHandlerCounter != null) {
            this.waitUntilSeletorHandlersStop();
        }
        if (this.readThreadsCount > 0) {
            this.multiReadThreadSelectorHandler.shutdown();
            this.multiReadThreadSelectorHandler = null;
            for (ReadController readController : this.readThreadControllers) {
                try {
                    ((Controller)readController).stop();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Exception occured when stopping read Controller!", e);
                }
            }
            this.readThreadControllers = null;
        }
    }

    @Override
    public void pause() throws IOException {
        this.stateHolder.setState(State.PAUSED);
    }

    @Override
    public void resume() throws IOException {
        if (!State.PAUSED.equals((Object)this.stateHolder.getState(false))) {
            throw new IllegalStateException("Controller is not in PAUSED state, but: " + (Object)((Object)this.stateHolder.getState(false)));
        }
        this.stateHolder.setState(State.STARTED);
    }

    @Override
    public StateHolder<State> getStateHolder() {
        return this.stateHolder;
    }

    private void initReadThreads() throws IOException {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(2);
        }
        this.readThreadControllers = new ReadController[this.readThreadsCount];
        for (int i = 0; i < this.readThreadsCount; ++i) {
            ReadController controller = new ReadController();
            this.copyTo(controller);
            controller.setReadThreadsCount(0);
            this.readThreadControllers[i] = controller;
        }
        for (SelectorHandler selectorHandler : this.selectorHandlers) {
            this.addSelectorHandlerOnReadControllers(selectorHandler);
        }
        for (ReadController readController : this.readThreadControllers) {
            new Thread(readController).start();
        }
    }

    private void addSelectorHandlerOnReadControllers(SelectorHandler selectorHandler) {
        if (this.readThreadControllers == null || this.readThreadsCount == 0) {
            return;
        }
        if (selectorHandler.getAttributes() == null) {
            selectorHandler.setAttributes(new HashMap<String, Object>(2));
        }
        for (ReadController readController : this.readThreadControllers) {
            SelectorHandler copySelectorHandler = Cloner.clone(selectorHandler);
            copySelectorHandler.setSelector(null);
            readController.addSelectorHandler(copySelectorHandler);
        }
    }

    private void startSelectorHandlerRunner(SelectorHandler selectorHandler, boolean isRunAsync) {
        SelectorHandlerRunner selectorRunner = new SelectorHandlerRunner(this, selectorHandler);
        if (isRunAsync) {
            new Thread(selectorRunner).start();
        } else {
            selectorRunner.run();
        }
    }

    private void removeSelectorHandlerOnReadControllers(SelectorHandler selectorHandler) {
        if (this.readThreadControllers == null) {
            return;
        }
        for (ReadController readController : this.readThreadControllers) {
            readController.removeSelectorHandlerClone(selectorHandler);
        }
    }

    public boolean isStarted() {
        return this.stateHolder.getState() == State.STARTED;
    }

    public ConnectorHandler acquireConnectorHandler(Protocol protocol) {
        return this.connectorHandlerPool.acquireConnectorHandler(protocol);
    }

    public void releaseConnectorHandler(ConnectorHandler connectorHandler) {
        this.connectorHandlerPool.releaseConnectorHandler(connectorHandler);
    }

    public boolean isHandleReadWriteConcurrently() {
        return this.handleReadWriteConcurrently;
    }

    public void setHandleReadWriteConcurrently(boolean handleReadWriteConcurrently) {
        this.handleReadWriteConcurrently = handleReadWriteConcurrently;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilSeletorHandlersStop() {
        AtomicInteger atomicInteger = this.stoppedSelectorHandlerCounter;
        synchronized (atomicInteger) {
            while (this.stoppedSelectorHandlerCounter.get() > 0 || !State.STOPPED.equals((Object)this.stateHolder.getState())) {
                try {
                    this.stoppedSelectorHandlerCounter.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public Object removeAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocol {
        UDP,
        TCP,
        TLS,
        CUSTOM;

    }
}

