/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.includes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmSyntaxSupport;
import org.netbeans.modules.cnd.completion.includes.CsmIncludeCompletionItem;
import org.netbeans.modules.cnd.completion.includes.CsmIncludeCompletionQuery;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmIncludeCompletionProvider
implements CompletionProvider {
    private static final boolean TRACE = Boolean.getBoolean("cnd.completion.includes.trace");

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        CsmSyntaxSupport csmSyntaxSupport = (CsmSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)jTextComponent).get(CsmSyntaxSupport.class);
        if (csmSyntaxSupport == null) {
            return 0;
        }
        if (string.equals("\"") || string.equals("<") || string.equals(" ") || string.equals("/")) {
            int n = jTextComponent.getCaret().getDot();
            if (TRACE) {
                System.out.println("offset " + n);
            }
            if (!csmSyntaxSupport.isIncludeCompletionDisabled(n)) {
                if (TRACE) {
                    System.out.println("include completion will be shown on " + n);
                }
                return 1;
            }
            if (TRACE) {
                System.out.println("include completion will NOT be shown on " + n);
            }
        }
        return 0;
    }

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        if (TRACE) {
            System.out.println("queryType = " + n);
        }
        if ((n & 1) != 0) {
            boolean bl = n == 9;
            int n2 = jTextComponent.getCaret().getDot();
            CsmSyntaxSupport csmSyntaxSupport = (CsmSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)jTextComponent).get(CsmSyntaxSupport.class);
            if (!csmSyntaxSupport.isIncludeCompletionDisabled(n2)) {
                if (TRACE) {
                    System.out.println("include completion task is created with offset " + n2);
                }
                return new AsyncCompletionTask((AsyncCompletionQuery)new Query(n2, bl), jTextComponent);
            }
            if (TRACE) {
                System.out.println("include completion task is NOT created on " + n2);
            }
        }
        return null;
    }

    static Collection<CsmIncludeCompletionItem> getFilteredData(BaseDocument baseDocument, int n, int n2) {
        Query query = new Query(n, true);
        Collection collection = query.getItems(baseDocument, n);
        collection = query.getFilteredData(collection, query.filterPrefix);
        if (TRACE) {
            System.err.println("Completion Items " + collection.size());
            for (CsmIncludeCompletionItem csmIncludeCompletionItem : collection) {
                System.err.println(csmIncludeCompletionItem.toString());
            }
        }
        return collection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Query
    extends AsyncCompletionQuery {
        private JTextComponent component;
        private Collection<CsmIncludeCompletionItem> results;
        private int creationCaretOffset;
        private int resultSetAnchorOffset;
        private int queryAnchorOffset;
        private String dirPrefix;
        private String filterPrefix;
        private Boolean usrInclude;
        private boolean showAll;

        Query(int n, boolean bl) {
            this.creationCaretOffset = n;
            this.queryAnchorOffset = -1;
            this.resultSetAnchorOffset = this.creationCaretOffset;
            this.showAll = bl;
        }

        protected void preQueryUpdate(JTextComponent jTextComponent) {
            int n = jTextComponent.getCaretPosition();
            if (TRACE) {
                System.out.println("preQueryUpdate on " + n + " created on " + this.creationCaretOffset);
            }
            Document document = jTextComponent.getDocument();
            if (this.creationCaretOffset > 0 && n >= this.creationCaretOffset) {
                try {
                    if (this.isValidIncludeNamePart(document.getText(this.creationCaretOffset, n - this.creationCaretOffset))) {
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            Completion.get().hideCompletion();
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            if (TRACE) {
                System.out.println("query on " + n + " anchor " + this.queryAnchorOffset);
            }
            Collection<CsmIncludeCompletionItem> collection = this.getItems((BaseDocument)document, n);
            if (this.queryAnchorOffset > 0) {
                if (collection != null && collection.size() > 0) {
                    this.results = collection;
                    collection = this.getFilteredData(collection, this.filterPrefix);
                    completionResultSet.estimateItems(collection.size(), -1);
                    completionResultSet.addAllItems(collection);
                    completionResultSet.setAnchorOffset(this.resultSetAnchorOffset);
                }
                completionResultSet.setHasAdditionalItems(true);
            }
            completionResultSet.finish();
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected boolean canFilter(JTextComponent jTextComponent) {
            int n = jTextComponent.getCaretPosition();
            Document document = jTextComponent.getDocument();
            this.filterPrefix = null;
            String string = this.dirPrefix;
            this.dirPrefix = "";
            if (this.queryAnchorOffset > -1 && n > this.queryAnchorOffset) {
                try {
                    String string2 = document.getText(this.queryAnchorOffset, n - this.queryAnchorOffset);
                    if (this.isValidIncludeNamePart(string2)) {
                        this.filterPrefix = string2;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            this.fixFilter();
            if (TRACE) {
                System.out.println("canFilter INCINFO: usrInclude=" + this.usrInclude + " anchorOffset=" + this.queryAnchorOffset + " oldDir=" + string + " dirPrefix=" + this.dirPrefix + " filterPrefix=" + this.filterPrefix);
            }
            return this.filterPrefix != null && string.equals(this.dirPrefix);
        }

        protected void filter(CompletionResultSet completionResultSet) {
            if (this.filterPrefix != null && this.results != null) {
                completionResultSet.setAnchorOffset(this.resultSetAnchorOffset);
                Collection<CsmIncludeCompletionItem> collection = this.getFilteredData(this.results, this.filterPrefix);
                completionResultSet.estimateItems(collection.size(), -1);
                completionResultSet.addAllItems(collection);
            }
            completionResultSet.setHasAdditionalItems(true);
            completionResultSet.finish();
        }

        private void fixFilter() {
            String string = this.filterPrefix;
            if (string != null) {
                int n;
                int n2 = string.lastIndexOf("/");
                this.resultSetAnchorOffset = this.queryAnchorOffset;
                if (n2 != -1) {
                    this.resultSetAnchorOffset += n2 + 1;
                }
                if ((n = (string = this.trimIncludeSigns(string)).lastIndexOf("/")) != -1) {
                    this.dirPrefix = string.substring(0, n + 1);
                    string = string.substring(n + 1);
                }
                this.filterPrefix = string;
            }
        }

        private Collection<CsmIncludeCompletionItem> getItems(BaseDocument baseDocument, int n) {
            Collection<CsmIncludeCompletionItem> collection = Collections.emptyList();
            try {
                if (this.init(baseDocument, n)) {
                    CsmIncludeCompletionQuery csmIncludeCompletionQuery = new CsmIncludeCompletionQuery(null);
                    collection = csmIncludeCompletionQuery.query(baseDocument, this.dirPrefix, this.queryAnchorOffset, this.usrInclude, this.showAll);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return collection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private boolean init(BaseDocument var1_1, int var2_2) throws BadLocationException {
            this.resultSetAnchorOffset = var2_2;
            this.filterPrefix = null;
            this.queryAnchorOffset = -1;
            this.usrInclude = null;
            this.dirPrefix = "";
            if (var1_1 != null && (var3_3 = (CsmSyntaxSupport)var1_1.getSyntaxSupport().get(CsmSyntaxSupport.class)) != null) {
                var4_4 = var3_3.getTokenItem(var2_2);
                if (var4_4 != null) {
                    var1_1.atomicLock();
                    try {
                        switch (var4_4.getTokenID().getNumericID()) {
                            case 154: 
                            case 164: {
                                this.usrInclude = Boolean.FALSE;
                                this.queryAnchorOffset = var4_4.getOffset();
                                this.filterPrefix = var1_1.getText(this.queryAnchorOffset, var2_2 - this.queryAnchorOffset);
                                ** break;
lbl17:
                                // 1 sources

                                break;
                            }
                            case 155: 
                            case 165: {
                                this.usrInclude = Boolean.TRUE;
                                this.queryAnchorOffset = var4_4.getOffset();
                                this.filterPrefix = var1_1.getText(this.queryAnchorOffset, var2_2 - this.queryAnchorOffset);
                                break;
                            }
                            ** default:
lbl24:
                            // 1 sources

                            break;
                        }
                    }
                    catch (BadLocationException var5_5) {
                    }
                    finally {
                        var1_1.atomicUnlock();
                    }
                }
                if (this.queryAnchorOffset < 0 && (var4_4 = var3_3.shiftToNonWhiteBwd(var4_4)) != null) {
                    switch (var4_4.getTokenID().getNumericID()) {
                        case 147: 
                        case 148: {
                            this.usrInclude = null;
                            this.queryAnchorOffset = var2_2;
                            this.filterPrefix = null;
                            break;
                        }
                        case 164: {
                            this.usrInclude = Boolean.FALSE;
                            this.queryAnchorOffset = var4_4.getOffset();
                            this.filterPrefix = var1_1.getText(this.queryAnchorOffset, var2_2 - this.queryAnchorOffset);
                            break;
                        }
                        case 165: {
                            this.usrInclude = Boolean.TRUE;
                            this.queryAnchorOffset = var4_4.getOffset();
                            this.filterPrefix = var1_1.getText(this.queryAnchorOffset, var2_2 - this.queryAnchorOffset);
                        }
                    }
                }
            }
            this.fixFilter();
            if (CsmIncludeCompletionProvider.access$300()) {
                System.out.println("INCINFO: usrInclude=" + this.usrInclude + " anchorOffset=" + this.queryAnchorOffset + " dirPrefix=" + this.dirPrefix + " filterPrefix=" + this.filterPrefix);
            }
            return this.queryAnchorOffset > 0;
        }

        private String trimIncludeSigns(String string) {
            if (string.startsWith("\"") || string.startsWith("<")) {
                string = string.substring(1);
            }
            if (string.endsWith("\"") || string.endsWith(">")) {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }

        private boolean isValidIncludeNamePart(String string) {
            if (string == null || string.length() == 0) {
                return true;
            }
            if (string.length() == 1) {
                if (string.startsWith("\"")) {
                    return true;
                }
                if (string.startsWith("<")) {
                    return this.usrInclude == Boolean.FALSE;
                }
            }
            return !string.endsWith("\"") && !string.endsWith(">");
        }

        private Collection<CsmIncludeCompletionItem> getFilteredData(Collection<CsmIncludeCompletionItem> collection, String string) {
            Collection<CsmIncludeCompletionItem> collection2;
            if (string == null) {
                collection2 = collection;
            } else {
                ArrayList<CsmIncludeCompletionItem> arrayList = new ArrayList<CsmIncludeCompletionItem>(collection.size());
                for (CsmIncludeCompletionItem csmIncludeCompletionItem : collection) {
                    if (!this.matchPrefix(csmIncludeCompletionItem, string)) continue;
                    arrayList.add(csmIncludeCompletionItem);
                }
                collection2 = arrayList;
            }
            return collection2;
        }

        private boolean matchPrefix(CsmIncludeCompletionItem csmIncludeCompletionItem, String string) {
            return csmIncludeCompletionItem.getItemText().startsWith(string);
        }
    }
}

