/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInitializerListContainer;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmSortUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmProjectContentResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmContextUtilities {
    private static final boolean DEBUG = Boolean.getBoolean("csm.utilities.trace");
    private static final int FILE_LOCAL_MACROS = 0;
    private static final int FILE_PROJECT_LOCAL_MACROS = 1;
    private static final int FILE_LIB_LOCAL_MACROS = 2;
    private static final int PROJECT_MACROS = 3;
    private static final int LIB_MACROS = 4;

    private CsmContextUtilities() {
    }

    public static List findGlobalVariables(CsmProject csmProject) {
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(csmProject);
        return csmProjectContentResolver.getGlobalVariables("", false);
    }

    public static List<CsmDeclaration> findLocalDeclarations(CsmContext csmContext, String string, boolean bl, boolean bl2) {
        return CsmContextUtilities.findLocalDeclarations(csmContext, string, bl, bl2, true, false);
    }

    public static List<CsmDeclaration> findFileLocalVariables(CsmContext csmContext) {
        return CsmContextUtilities.findFileLocalVariables(csmContext, "", false, false);
    }

    public static List<CsmDeclaration> findFileLocalVariables(CsmContext csmContext, String string, boolean bl, boolean bl2) {
        return CsmContextUtilities.findLocalDeclarations(csmContext, string, bl, bl2, true, false);
    }

    public static List<CsmDeclaration> findFunctionLocalVariables(CsmContext csmContext) {
        List<CsmDeclaration> list = CsmContextUtilities.findFunctionLocalDeclarations(csmContext, "", false, false);
        ArrayList<CsmDeclaration> arrayList = new ArrayList<CsmDeclaration>(list.size());
        for (CsmDeclaration csmDeclaration : list) {
            if (!CsmKindUtilities.isVariable((CsmObject)csmDeclaration)) continue;
            arrayList.add(csmDeclaration);
        }
        return arrayList;
    }

    public static List<CsmDeclaration> findFunctionLocalDeclarations(CsmContext csmContext, String string, boolean bl, boolean bl2) {
        List<CsmDeclaration> list = CsmContextUtilities.findLocalDeclarations(csmContext, string, bl, bl2, false, true);
        return list;
    }

    public static List<CsmMacro> findFileLocalMacros(CsmContext csmContext, String string, boolean bl, boolean bl2) {
        return CsmContextUtilities.findMacros(csmContext, string, bl, bl2, 0);
    }

    public static List<CsmMacro> findFileIncludedProjectMacros(CsmContext csmContext, String string, boolean bl, boolean bl2) {
        return CsmContextUtilities.findMacros(csmContext, string, bl, bl2, 1);
    }

    public static List<CsmMacro> findFileIncludedLibMacros(CsmContext csmContext, String string, boolean bl, boolean bl2) {
        return CsmContextUtilities.findMacros(csmContext, string, bl, bl2, 2);
    }

    public static List<CsmMacro> findProjectMacros(CsmContext csmContext, String string, boolean bl, boolean bl2) {
        return CsmContextUtilities.findMacros(csmContext, string, bl, bl2, 3);
    }

    public static List<CsmMacro> findLibMacros(CsmContext csmContext, String string, boolean bl, boolean bl2) {
        return CsmContextUtilities.findMacros(csmContext, string, bl, bl2, 4);
    }

    private static List<CsmMacro> findMacros(CsmContext csmContext, String string, boolean bl, boolean bl2, int n) {
        ArrayList<CsmMacro> arrayList = new ArrayList<CsmMacro>();
        Iterator iterator = csmContext.iterator();
        while (iterator.hasNext()) {
            CsmContext.CsmContextEntry csmContextEntry = (CsmContext.CsmContextEntry)iterator.next();
            CsmScope csmScope = csmContextEntry.getScope();
            int n2 = csmContextEntry.getOffset();
            if (!CsmKindUtilities.isFile((CsmObject)csmScope)) continue;
            CsmFile csmFile = (CsmFile)csmScope;
            switch (n) {
                case 0: {
                    CsmContextUtilities.getFileLocalMacros(csmFile, arrayList, new HashSet(), string, bl, bl2);
                    break;
                }
                case 1: {
                    CsmContextUtilities.gatherProjectIncludedMacros(csmFile, arrayList, false, string, bl, bl2);
                    break;
                }
                case 2: {
                    CsmContextUtilities.gatherLibIncludedMacros(csmFile, arrayList, false, string, bl, bl2);
                    break;
                }
                case 3: {
                    CsmContextUtilities.gatherProjectIncludedMacros(csmFile, arrayList, true, string, bl, bl2);
                    break;
                }
                case 4: {
                    CsmContextUtilities.gatherLibIncludedMacros(csmFile, arrayList, true, string, bl, bl2);
                }
            }
        }
        return arrayList;
    }

    private static void getFileLocalMacros(CsmFile csmFile, List list, Set set, String string, boolean bl, boolean bl2) {
        CsmSelect.CsmFilter csmFilter = CsmSelect.getDefault().getFilterBuilder().getNameAcceptor(string, bl, bl2, false);
        Iterator iterator = CsmSelect.getDefault().getMacros(csmFile, csmFilter);
        while (iterator.hasNext()) {
            CsmMacro csmMacro = (CsmMacro)iterator.next();
            String string2 = ((Object)csmMacro.getName()).toString();
            if (set.contains(string2) || !CsmSortUtilities.matchName((CharSequence)string2, (CharSequence)string, (boolean)bl, (boolean)bl2)) continue;
            list.add(csmMacro);
            set.add(string2);
        }
    }

    private static void gatherProjectIncludedMacros(CsmFile csmFile, List list, boolean bl, String string, boolean bl2, boolean bl3) {
        CsmProject csmProject = csmFile.getProject();
        if (!bl) {
            CsmContextUtilities.gatherIncludeMacros(csmFile, csmProject, true, new HashSet(), new HashSet(), list, string, bl2, bl3);
        } else {
            HashSet hashSet = new HashSet();
            Iterator iterator = csmProject.getHeaderFiles().iterator();
            while (iterator.hasNext()) {
                CsmContextUtilities.getFileLocalMacros((CsmFile)iterator.next(), list, hashSet, string, bl2, bl3);
            }
        }
    }

    private static void gatherLibIncludedMacros(CsmFile csmFile, List list, boolean bl, String string, boolean bl2, boolean bl3) {
        CsmProject csmProject = csmFile.getProject();
        if (!bl) {
            CsmContextUtilities.gatherIncludeMacros(csmFile, csmProject, false, new HashSet(), new HashSet(), list, string, bl2, bl3);
        } else {
            HashSet hashSet = new HashSet();
            for (CsmProject csmProject2 : csmProject.getLibraries()) {
                Iterator iterator = csmProject2.getHeaderFiles().iterator();
                while (iterator.hasNext()) {
                    CsmContextUtilities.getFileLocalMacros((CsmFile)iterator.next(), list, hashSet, string, bl2, bl3);
                }
            }
        }
    }

    private static void gatherIncludeMacros(CsmFile csmFile, CsmProject csmProject, boolean bl, Set set, Set set2, List list, String string, boolean bl2, boolean bl3) {
        if (set.contains(csmFile)) {
            return;
        }
        set.add(csmFile);
        for (CsmInclude csmInclude : csmFile.getIncludes()) {
            CsmFile csmFile2 = csmInclude.getIncludeFile();
            if (csmFile2 == null) continue;
            if (bl) {
                if (csmFile2.getProject() != csmProject) continue;
                CsmContextUtilities.getFileLocalMacros(csmFile2, list, set2, string, bl2, bl3);
                CsmContextUtilities.gatherIncludeMacros(csmFile2, csmProject, bl, set, set2, list, string, bl2, bl3);
                continue;
            }
            if (csmFile2.getProject() != csmProject) {
                CsmContextUtilities.getFileLocalMacros(csmFile2, list, set2, string, bl2, bl3);
            }
            CsmContextUtilities.gatherIncludeMacros(csmFile2, csmProject, bl, set, set2, list, string, bl2, bl3);
        }
    }

    protected static List<CsmDeclaration> findLocalDeclarations(CsmContext csmContext, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5;
        List<CsmDeclaration> list = new ArrayList<CsmDeclaration>();
        boolean bl6 = bl5 = bl3 || bl4;
        assert (bl5) : "at least one must be true";
        boolean bl7 = bl3 && bl4;
        Iterator iterator = csmContext.iterator();
        while (iterator.hasNext() && bl5) {
            CsmContext.CsmContextEntry csmContextEntry = (CsmContext.CsmContextEntry)iterator.next();
            boolean bl8 = bl7;
            if (!bl8) {
                if (!bl3) {
                    assert (bl4);
                    if (CsmKindUtilities.isFunction((CsmObject)csmContextEntry.getScope())) {
                        bl8 = true;
                        bl7 = true;
                    }
                } else if (!bl4) {
                    assert (bl3);
                    if (CsmKindUtilities.isFunction((CsmObject)csmContextEntry.getScope()) || CsmKindUtilities.isClassifier((CsmObject)csmContextEntry.getScope())) {
                        bl8 = false;
                        bl5 = false;
                        bl7 = false;
                    } else {
                        bl8 = true;
                    }
                }
            }
            if (!bl8) continue;
            list = CsmContextUtilities.addEntryDeclarations(csmContextEntry, list, csmContext, string, bl, bl2);
        }
        return list;
    }

    private static List<CsmDeclaration> addEntryDeclarations(CsmContext.CsmContextEntry csmContextEntry, List<CsmDeclaration> list, CsmContext csmContext, String string, boolean bl, boolean bl2) {
        List<CsmDeclaration> list2 = CsmContextUtilities.findEntryDeclarations(csmContextEntry, csmContext, string, bl, bl2);
        return CsmContextUtilities.mergeDeclarations(list, list2);
    }

    private static List<CsmDeclaration> findEntryDeclarations(CsmContext.CsmContextEntry csmContextEntry, CsmContext csmContext, String string, boolean bl, boolean bl2) {
        CsmScopeElement csmScopeElement;
        assert (csmContextEntry != null) : "can't work on null entries";
        CsmScope csmScope = csmContextEntry.getScope();
        int n = csmContextEntry.getOffset();
        ArrayList<CsmDeclaration> arrayList = new ArrayList<CsmDeclaration>();
        Iterator iterator = csmScope.getScopeElements().iterator();
        while (iterator.hasNext() && !CsmContextUtilities.canBreak(n, csmScopeElement = (CsmScopeElement)iterator.next(), csmContext)) {
            List list = CsmContextUtilities.extractDeclarations(csmScopeElement, string, bl, bl2);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static List<CsmDeclaration> findFileLocalEnumerators(CsmContext csmContext, String string, boolean bl, boolean bl2) {
        ArrayList<CsmDeclaration> arrayList = new ArrayList<CsmDeclaration>();
        Iterator iterator = csmContext.iterator();
        while (iterator.hasNext()) {
            CsmDeclaration csmDeclaration;
            CsmContext.CsmContextEntry csmContextEntry = (CsmContext.CsmContextEntry)iterator.next();
            CsmScope csmScope = csmContextEntry.getScope();
            int n = csmContextEntry.getOffset();
            if (!CsmKindUtilities.isFile((CsmObject)csmScope)) continue;
            CsmFile csmFile = (CsmFile)csmScope;
            Iterator iterator2 = csmFile.getDeclarations().iterator();
            while (iterator2.hasNext() && !CsmContextUtilities.canBreak(n, (CsmScopeElement)(csmDeclaration = (CsmDeclaration)iterator2.next()), csmContext)) {
                CsmDeclaration csmDeclaration2;
                CsmEnum csmEnum;
                if (CsmKindUtilities.isEnum((CsmObject)csmDeclaration)) {
                    csmEnum = (CsmEnum)csmDeclaration;
                    if (csmEnum.getName().length() != 0) continue;
                    CsmContextUtilities.addEnumerators(arrayList, csmEnum, string, bl, bl2);
                    continue;
                }
                if (!CsmKindUtilities.isNamespaceDefinition((CsmObject)csmDeclaration) || csmDeclaration.getName().length() != 0) continue;
                csmEnum = (CsmNamespaceDefinition)csmDeclaration;
                Iterator iterator3 = csmEnum.getDeclarations().iterator();
                while (iterator3.hasNext() && !CsmContextUtilities.canBreak(n, (CsmScopeElement)(csmDeclaration2 = (CsmDeclaration)iterator3.next()), csmContext)) {
                    CsmEnum csmEnum2;
                    if (!CsmKindUtilities.isEnum((CsmObject)csmDeclaration2) || (csmEnum2 = (CsmEnum)csmDeclaration2).getName().length() != 0) continue;
                    CsmContextUtilities.addEnumerators(arrayList, csmEnum2, string, bl, bl2);
                }
            }
        }
        return arrayList;
    }

    private static void addEnumerators(List list, CsmEnum csmEnum, String string, boolean bl, boolean bl2) {
        for (CsmNamedElement csmNamedElement : csmEnum.getEnumerators()) {
            if (!CsmSortUtilities.matchName((CharSequence)csmNamedElement.getName(), (CharSequence)string, (boolean)bl, (boolean)bl2)) continue;
            list.add(csmNamedElement);
        }
    }

    private static boolean canBreak(int n, CsmScopeElement csmScopeElement, CsmContext csmContext) {
        if (n == -1) {
            return CsmContextUtilities.isInContext(csmContext, (CsmObject)csmScopeElement);
        }
        if (CsmKindUtilities.isOffsetable((Object)csmScopeElement)) {
            return ((CsmOffsetable)csmScopeElement).getStartOffset() >= n || CsmContextUtilities.isInContext(csmContext, (CsmObject)csmScopeElement);
        }
        return CsmContextUtilities.isInContext(csmContext, (CsmObject)csmScopeElement);
    }

    private static List mergeDeclarations(List list, List list2) {
        ArrayList arrayList = new ArrayList();
        if (list2 != null && list2.size() > 0) {
            arrayList.addAll(list2);
        }
        if (list != null && list.size() > 0) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public static void updateContextObject(CsmObject csmObject, int n, CsmContext csmContext) {
        if (csmContext != null && csmObject != null) {
            csmContext.setLastObject(csmObject);
        }
    }

    public static void updateContext(CsmObject csmObject, int n, CsmContext csmContext) {
        if (csmContext != null) {
            if (CsmKindUtilities.isScope((CsmObject)csmObject)) {
                csmContext.add((CsmScope)csmObject, n);
            } else if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
                CsmContextUtilities.updateContextObject(csmObject, n, csmContext);
            }
        }
    }

    private static boolean isInContext(CsmContext csmContext, CsmObject csmObject) {
        Iterator iterator = csmContext.iterator();
        while (iterator.hasNext()) {
            CsmContext.CsmContextEntry csmContextEntry = (CsmContext.CsmContextEntry)iterator.next();
            if (!csmObject.equals(csmContextEntry.getScope())) continue;
            return true;
        }
        return false;
    }

    private static List extractDeclarations(CsmScopeElement csmScopeElement, String string, boolean bl, boolean bl2) {
        ArrayList<CsmScopeElement> arrayList;
        block4: {
            CsmStatement.Kind kind;
            block3: {
                arrayList = new ArrayList<CsmScopeElement>();
                if (!CsmKindUtilities.isDeclaration((CsmObject)csmScopeElement)) break block3;
                if (!CsmSortUtilities.matchName((CharSequence)((CsmNamedElement)csmScopeElement).getName(), (CharSequence)string, (boolean)bl, (boolean)bl2)) break block4;
                boolean bl3 = true;
                if (CsmKindUtilities.isParamVariable((CsmObject)csmScopeElement)) {
                    boolean bl4 = bl3 = !((CsmParameter)csmScopeElement).isVarArgs();
                }
                if (!bl3) break block4;
                arrayList.add(csmScopeElement);
                break block4;
            }
            if (CsmKindUtilities.isStatement((CsmObject)csmScopeElement) && (kind = ((CsmStatement)csmScopeElement).getKind()) == CsmStatement.Kind.DECLARATION) {
                List list = ((CsmDeclarationStatement)csmScopeElement).getDeclarators();
                List list2 = CsmSortUtilities.filterList((Collection)list, (CharSequence)string, (boolean)bl, (boolean)bl2);
                arrayList.addAll(list2);
                for (CsmDeclaration csmDeclaration : list) {
                    if (!CsmKindUtilities.isEnum((CsmObject)csmDeclaration)) continue;
                    list2 = CsmSortUtilities.filterList((Collection)((CsmEnum)csmDeclaration).getEnumerators(), (CharSequence)string, (boolean)bl, (boolean)bl2);
                    arrayList.addAll(list2);
                }
            }
        }
        return arrayList;
    }

    public static CsmClass getClass(CsmContext csmContext, boolean bl) {
        CsmClass csmClass = null;
        Iterator iterator = csmContext.iterator();
        while (iterator.hasNext()) {
            CsmContext.CsmContextEntry csmContextEntry = (CsmContext.CsmContextEntry)iterator.next();
            if (!CsmKindUtilities.isClass((CsmObject)csmContextEntry.getScope())) continue;
            csmClass = (CsmClass)csmContextEntry.getScope();
            break;
        }
        if (csmClass == null && bl) {
            iterator = CsmContextUtilities.getFunction(csmContext);
            csmClass = iterator == null ? null : CsmBaseUtilities.getFunctionClass((CsmFunction)iterator);
        }
        return csmClass;
    }

    public static CsmFunction getFunction(CsmContext csmContext) {
        CsmFunction csmFunction = null;
        Iterator iterator = csmContext.iterator();
        while (iterator.hasNext()) {
            CsmContext.CsmContextEntry csmContextEntry = (CsmContext.CsmContextEntry)iterator.next();
            if (!CsmKindUtilities.isFunction((CsmObject)csmContextEntry.getScope())) continue;
            csmFunction = (CsmFunction)csmContextEntry.getScope();
            break;
        }
        return csmFunction;
    }

    public static CsmFunctionDefinition getFunctionDefinition(CsmContext csmContext) {
        CsmFunctionDefinition csmFunctionDefinition = null;
        Iterator iterator = csmContext.iterator();
        while (iterator.hasNext()) {
            CsmContext.CsmContextEntry csmContextEntry = (CsmContext.CsmContextEntry)iterator.next();
            if (!CsmKindUtilities.isFunctionDefinition((CsmObject)csmContextEntry.getScope())) continue;
            csmFunctionDefinition = (CsmFunctionDefinition)csmContextEntry.getScope();
            break;
        }
        return csmFunctionDefinition;
    }

    public static CsmNamespace getNamespace(CsmContext csmContext) {
        CsmClass csmClass;
        CsmFunction csmFunction = CsmContextUtilities.getFunction(csmContext);
        CsmNamespace csmNamespace = null;
        csmNamespace = csmFunction != null ? CsmContextUtilities.getFunctionNamespace(csmFunction) : ((csmClass = CsmContextUtilities.getClass(csmContext, false)) == null ? null : CsmContextUtilities.getClassNamespace(csmClass));
        return csmNamespace;
    }

    private static CsmNamespace getFunctionNamespace(CsmFunction csmFunction) {
        return CsmBaseUtilities.getFunctionNamespace((CsmFunction)csmFunction);
    }

    private static CsmNamespace getClassNamespace(CsmClass csmClass) {
        return CsmBaseUtilities.getClassNamespace((CsmClassifier)csmClass);
    }

    public static boolean isInFunctionBodyOrInitializerList(CsmContext csmContext, int n) {
        return CsmContextUtilities.isInFunctionBody(csmContext, n) || CsmContextUtilities.isInInitializerList(csmContext, n);
    }

    public static boolean isInFunctionBody(CsmContext csmContext, int n) {
        CsmFunctionDefinition csmFunctionDefinition = CsmContextUtilities.getFunctionDefinition(csmContext);
        return csmFunctionDefinition == null ? false : CsmOffsetUtilities.isInObject((CsmObject)csmFunctionDefinition.getBody(), n);
    }

    public static boolean isInInitializerList(CsmContext csmContext, int n) {
        CsmFunction csmFunction = CsmContextUtilities.getFunction(csmContext);
        if (CsmKindUtilities.isConstructor((CsmObject)csmFunction)) {
            for (CsmExpression csmExpression : ((CsmInitializerListContainer)csmFunction).getInitializerList()) {
                if (!CsmOffsetUtilities.isInObject((CsmObject)csmExpression, n)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInFunction(CsmContext csmContext, int n) {
        CsmFunction csmFunction = CsmContextUtilities.getFunction(csmContext);
        return csmFunction != null;
    }

    public static boolean isInType(CsmContext csmContext, int n) {
        CsmObject csmObject = csmContext.getLastObject();
        return CsmKindUtilities.isType((CsmObject)csmObject) && CsmOffsetUtilities.isInObject(csmObject, n);
    }
}

