/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.modules.cnd.completion.cplusplus.NbCsmSyntaxSupport;
import org.netbeans.modules.cnd.completion.cplusplus.utils.Token;
import org.netbeans.modules.cnd.editor.cplusplus.CCTokenContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenUtilities {
    private static int TOKEN_LIMIT = 100;

    private TokenUtilities() {
    }

    public static List<Token> getTokens(Document document, int n, int n2) {
        if (!(document instanceof BaseDocument)) {
            return Collections.emptyList();
        }
        try {
            SyntaxSupport syntaxSupport = ((BaseDocument)document).getSyntaxSupport();
            NbCsmSyntaxSupport nbCsmSyntaxSupport = (NbCsmSyntaxSupport)syntaxSupport.get(NbCsmSyntaxSupport.class);
            if (nbCsmSyntaxSupport == null) {
                String string = (String)document.getProperty("title");
                System.err.println("document " + string + " doesn't have NbCsmSyntaxSupport syntax support " + document);
                System.err.println("document " + (CndLexerUtilities.getCppTokenSequence((Document)document, (int)n) == null ? "DOESN'T" : "") + " have " + "lexer info");
                return Collections.emptyList();
            }
            AllTokensTP allTokensTP = new AllTokensTP();
            nbCsmSyntaxSupport.tokenizeText(allTokensTP, n, n2, true);
            return allTokensTP.getTokens();
        }
        catch (BadLocationException badLocationException) {
            return Collections.emptyList();
        }
    }

    public static Token getToken(Document document, int n) {
        if (!(document instanceof BaseDocument)) {
            return null;
        }
        try {
            BaseDocument baseDocument = (BaseDocument)document;
            SyntaxSupport syntaxSupport = baseDocument.getSyntaxSupport();
            NbCsmSyntaxSupport nbCsmSyntaxSupport = (NbCsmSyntaxSupport)syntaxSupport.get(NbCsmSyntaxSupport.class);
            if (nbCsmSyntaxSupport == null) {
                return null;
            }
            FirstTokenTP firstTokenTP = new FirstTokenTP();
            nbCsmSyntaxSupport.tokenizeText(firstTokenTP, n, document.getLength(), true);
            Token token = firstTokenTP.getToken();
            return token;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static int correctOffsetToID(BaseDocument baseDocument, int n) {
        if (baseDocument == null) {
            return n;
        }
        SyntaxSupport syntaxSupport = baseDocument.getSyntaxSupport();
        if (syntaxSupport == null) {
            return n;
        }
        NbCsmSyntaxSupport nbCsmSyntaxSupport = (NbCsmSyntaxSupport)syntaxSupport.get(NbCsmSyntaxSupport.class);
        if (nbCsmSyntaxSupport == null) {
            return n;
        }
        int n2 = n;
        boolean bl = false;
        try {
            for (int i = 0; i < TOKEN_LIMIT && n >= 0; ++i) {
                TokenID tokenID = nbCsmSyntaxSupport.getTokenID(n);
                if (tokenID == null) {
                    return n2;
                }
                if (tokenID == CCTokenContext.IDENTIFIER || tokenID == CCTokenContext.SYS_INCLUDE || tokenID == CCTokenContext.USR_INCLUDE) {
                    return n;
                }
                if (tokenID == CCTokenContext.WHITESPACE) {
                    --n;
                    if (!bl) continue;
                    return n2;
                }
                if (tokenID.getCategory() == CCTokenContext.OPERATORS) {
                    --n;
                    if (bl) {
                        return n2;
                    }
                    bl = true;
                    continue;
                }
                return n2;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return n2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AllTokensTP
    implements TokenProcessor {
        private List<Token> tokens = new ArrayList<Token>();
        private int bufferStartPos;
        private char[] buffer;

        private AllTokensTP() {
        }

        public List<Token> getTokens() {
            return this.tokens;
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
            String string = new String(this.buffer, n, n2);
            this.tokens.add(new Token(this.bufferStartPos + n, n2, tokenID, string));
            return true;
        }

        public int eot(int n) {
            return 0;
        }

        public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
            this.buffer = cArray;
            this.bufferStartPos = n3 - n;
        }
    }

    private static class FirstTokenTP
    implements TokenProcessor {
        private Token token;
        private int bufferStartPos;
        private char[] buffer;

        private FirstTokenTP() {
        }

        public Token getToken() {
            return this.token;
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
            String string = new String(this.buffer, n, n2);
            this.token = new Token(this.bufferStartPos + n, n2, tokenID, string);
            return false;
        }

        public int eot(int n) {
            return 0;
        }

        public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
            this.buffer = cArray;
            this.bufferStartPos = n3 - n;
        }
    }
}

