/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.hyperlink;

import java.util.Collection;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.services.CsmFunctionDefinitionResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmAbstractHyperlinkProvider;
import org.netbeans.modules.cnd.completion.cplusplus.utils.Token;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.editor.cplusplus.CCTokenContext;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;

public final class CsmHyperlinkProvider
extends CsmAbstractHyperlinkProvider {
    protected void performAction(BaseDocument baseDocument, JTextComponent jTextComponent, int n) {
        this.goToDeclaration(baseDocument, jTextComponent, n);
    }

    protected boolean isValidToken(Token token) {
        return CsmHyperlinkProvider.isSupportedToken(token);
    }

    public static boolean isSupportedToken(Token token) {
        return token != null && (token.getTokenID() == CCTokenContext.IDENTIFIER || token.getTokenID() == CCTokenContext.OPERATOR);
    }

    public boolean goToDeclaration(BaseDocument baseDocument, JTextComponent jTextComponent, int n) {
        if (!this.preJump(baseDocument, jTextComponent, n, "opening-csm-element")) {
            return false;
        }
        Token token = this.getJumpToken();
        CsmOffsetable csmOffsetable = this.findTargetObject(jTextComponent, baseDocument, token, n);
        return this.postJump(csmOffsetable, "goto_source_source_not_found", "cannot-open-csm-element");
    }

    CsmOffsetable findTargetObject(JTextComponent jTextComponent, BaseDocument baseDocument, Token token, int n) {
        CsmObject csmObject;
        CsmOffsetable csmOffsetable = null;
        assert (token != null);
        CsmFile csmFile = CsmUtilities.getCsmFile((Document)baseDocument, (boolean)true);
        CsmObject csmObject2 = csmObject = csmFile == null ? null : ReferencesSupport.findDeclaration(csmFile, baseDocument, token, n);
        if (csmObject != null) {
            csmOffsetable = this.toJumpObject(csmObject, csmFile, n);
        }
        return csmOffsetable;
    }

    private CsmOffsetable toJumpObject(CsmObject csmObject, CsmFile csmFile, int n) {
        CsmOffsetable csmOffsetable = null;
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            CsmVariableDefinition csmVariableDefinition;
            csmOffsetable = (CsmOffsetable)csmObject;
            if (CsmKindUtilities.isFunctionDeclaration((CsmObject)csmObject)) {
                CsmFunctionDefinition csmFunctionDefinition = ((CsmFunction)csmObject).getDefinition();
                if (csmFunctionDefinition != null) {
                    if (csmFile.equals(csmFunctionDefinition.getContainingFile()) && csmFunctionDefinition.getStartOffset() <= n && n <= csmFunctionDefinition.getBody().getStartOffset()) {
                        if (csmFunctionDefinition.getDeclaration() != null) {
                            csmOffsetable = csmFunctionDefinition.getDeclaration();
                        } else if (csmObject.equals(csmFunctionDefinition)) {
                            csmOffsetable = (CsmOffsetable)csmObject;
                        }
                    } else {
                        csmOffsetable = csmFunctionDefinition;
                    }
                } else {
                    CsmReference csmReference = CsmFunctionDefinitionResolver.getDefault().getFunctionDefinition((CsmFunction)csmObject);
                    if (csmReference != null) {
                        csmOffsetable = csmReference;
                    }
                }
            } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
                CsmFunctionDefinition csmFunctionDefinition = (CsmFunctionDefinition)csmObject;
                if (csmFile.equals(csmFunctionDefinition.getContainingFile()) && csmFunctionDefinition.getStartOffset() <= n && n <= csmFunctionDefinition.getBody().getStartOffset()) {
                    if (csmFunctionDefinition.getDeclaration() != null) {
                        csmOffsetable = csmFunctionDefinition.getDeclaration();
                    } else if (csmObject.equals(csmFunctionDefinition)) {
                        csmOffsetable = (CsmOffsetable)csmObject;
                    }
                }
            } else if (CsmKindUtilities.isVariableDeclaration((CsmObject)csmObject) && (csmVariableDefinition = ((CsmVariable)csmObject).getDefinition()) != null) {
                csmOffsetable = csmVariableDefinition;
            }
        } else if (CsmKindUtilities.isNamespace((CsmObject)csmObject)) {
            CsmNamespace csmNamespace = (CsmNamespace)csmObject;
            Collection collection = csmNamespace.getDefinitions();
            CsmNamespaceDefinition csmNamespaceDefinition = null;
            for (CsmNamespaceDefinition csmNamespaceDefinition2 : collection) {
                CsmFile csmFile2;
                if (csmNamespaceDefinition == null) {
                    csmNamespaceDefinition = csmNamespaceDefinition2;
                }
                if (!csmFile.equals(csmFile2 = csmNamespaceDefinition2.getContainingFile())) continue;
                csmNamespaceDefinition = csmNamespaceDefinition2;
                break;
            }
            csmOffsetable = csmNamespaceDefinition;
        }
        return csmOffsetable;
    }
}

