/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionExpression;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.modelutil.CsmPaintComponent;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.modelutil.ParamStr;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CsmResultItem
implements CompletionQuery.ResultItem,
CompletionQuery.ResultItemAssociatedObject,
CompletionItem {
    private static boolean enableInstantSubstitution = true;
    protected int selectionStartOffset = -1;
    protected int selectionEndOffset = -1;
    protected int substituteOffset = -1;
    CsmObject associatedObject;
    private static final Color KEYWORD_COLOR = Color.gray;
    private static final Color TYPE_COLOR = Color.black;
    private int priority;
    public static final String COMPLETION_SUBSTITUTE_TEXT = "completion-substitute-text";
    static String toAdd;

    protected CsmResultItem(CsmObject csmObject, int n) {
        this.associatedObject = csmObject;
        this.priority = n;
    }

    public abstract String getItemText();

    public Object getAssociatedObject() {
        return this.associatedObject;
    }

    protected static Color getTypeColor(CsmType csmType) {
        return csmType.isBuiltInBased(false) ? KEYWORD_COLOR : TYPE_COLOR;
    }

    public void setSubstituteOffset(int n) {
        this.substituteOffset = n;
    }

    public boolean substituteCommonText(JTextComponent jTextComponent, int n, int n2, int n3) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        String string = this.getReplaceText();
        if (string != null) {
            baseDocument.atomicLock();
            try {
                CharSequence charSequence = DocumentUtilities.getText((Document)baseDocument, (int)n, (int)n2);
                if (CharSequenceUtilities.textEquals((CharSequence)string, (CharSequence)charSequence)) {
                    boolean bl2 = false;
                    return bl2;
                }
                baseDocument.remove(n, n2);
                baseDocument.insertString(n, string, null);
                if (this.selectionStartOffset >= 0) {
                    jTextComponent.select(n + this.selectionStartOffset, n + this.selectionEndOffset);
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                baseDocument.atomicUnlock();
            }
        }
        return true;
    }

    public Component getPaintComponent(JList jList, boolean bl, boolean bl2) {
        Component component = this.getPaintComponent(bl);
        if (component == null) {
            return null;
        }
        if (bl) {
            component.setBackground(jList.getSelectionBackground());
            component.setForeground(jList.getSelectionForeground());
        } else {
            component.setBackground(jList.getBackground());
            component.setForeground(jList.getForeground());
        }
        component.getAccessibleContext().setAccessibleName(this.getItemText());
        component.getAccessibleContext().setAccessibleDescription(this.getItemText());
        return component;
    }

    protected abstract Component getPaintComponent(boolean var1);

    public int getPreferredWidth(Graphics graphics, Font font) {
        Component component = this.getPaintComponent(false);
        component.setFont(font);
        int n = component.getPreferredSize().width;
        return n;
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        Component component = this.getPaintComponent(bl);
        component.setFont(font);
        component.setForeground(color);
        component.setBackground(color2);
        component.setBounds(0, 0, n, n2);
        ((CsmPaintComponent)component).paintComponent(graphics);
    }

    protected static String getTypeName(CsmType csmType) {
        return ((Object)csmType.getText()).toString();
    }

    public String toString() {
        Component component = this.getPaintComponent(false);
        return component != null ? component.toString() : "";
    }

    protected int convertCsmModifiers(CsmObject csmObject) {
        return CsmUtilities.getModifiers((CsmObject)csmObject);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 400) {
            Completion completion = Completion.get();
            switch (keyEvent.getKeyChar()) {
                case ' ': {
                    if (keyEvent.getModifiers() != 0) break;
                    completion.hideCompletion();
                    completion.hideDocumentation();
                    break;
                }
                case '%': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case ':': 
                case ';': 
                case '=': {
                    completion.hideCompletion();
                    completion.hideDocumentation();
                    break;
                }
                case '.': {
                    if (!this.defaultAction((JTextComponent)keyEvent.getSource(), Character.toString(keyEvent.getKeyChar()))) break;
                    keyEvent.consume();
                }
            }
        }
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public static void setEnableInstantSubstitution(boolean bl) {
        enableInstantSubstitution = bl;
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        if (enableInstantSubstitution) {
            Completion completion = Completion.get();
            completion.hideCompletion();
            completion.hideDocumentation();
            this.defaultAction(jTextComponent);
            return true;
        }
        return false;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        this.defaultAction(jTextComponent, "");
    }

    boolean defaultAction(JTextComponent jTextComponent, String string) {
        int n = this.substituteOffset;
        if (n == -1) {
            n = jTextComponent.getCaret().getDot();
        }
        toAdd = string;
        if (this.substituteText(jTextComponent, n, jTextComponent.getCaret().getDot() - n, false)) {
            CsmIncludeResolver csmIncludeResolver = CsmIncludeResolver.getDefault();
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            Object object = this.getAssociatedObject();
            if (CsmKindUtilities.isCsmObject((Object)object)) {
                String string2;
                CsmFile csmFile = CsmUtilities.getCsmFile((Document)baseDocument, (boolean)false);
                if (!csmIncludeResolver.isObjectVisible(csmFile, (CsmObject)object) && (string2 = csmIncludeResolver.getIncludeDirective(csmFile, (CsmObject)object)).length() != 0 && !this.isForwardDeclaration(jTextComponent)) {
                    this.insertInclude(jTextComponent, csmFile, string2, string2.charAt(string2.length() - 1) == '>');
                }
            } else {
                System.err.println("not yet handled object " + object);
            }
            return true;
        }
        return false;
    }

    private boolean isForwardDeclaration(JTextComponent jTextComponent) {
        TokenSequence tokenSequence = CndLexerUtilities.getCppTokenSequence((JTextComponent)jTextComponent, (int)0);
        tokenSequence.moveStart();
        if (!tokenSequence.moveNext()) {
            return false;
        }
        Token token = tokenSequence.token();
        while (tokenSequence.offset() < this.substituteOffset) {
            if (!(((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.BLOCK_COMMENT) || ((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.DOXYGEN_COMMENT) || ((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.NEW_LINE) || ((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.LINE_COMMENT) || ((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.WHITESPACE))) {
                token = tokenSequence.token();
            }
            if (tokenSequence.moveNext()) continue;
            return false;
        }
        return token.id().equals(CppTokenId.CLASS) || token.id().equals(CppTokenId.STRUCT) || token.id().equals(CppTokenId.UNION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertInclude(JTextComponent jTextComponent, CsmFile csmFile, String string, boolean bl) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        CsmInclude csmInclude = null;
        boolean bl2 = false;
        for (CsmInclude csmInclude2 : csmFile.getIncludes()) {
            if (csmInclude2.isSystem() == bl) {
                csmInclude = csmInclude2;
                bl2 = true;
                continue;
            }
            if (csmInclude != null && (bl2 || bl)) continue;
            csmInclude = csmInclude2;
        }
        baseDocument.atomicLock();
        try {
            if (csmInclude != null) {
                if (bl2) {
                    baseDocument.insertString(csmInclude.getEndOffset(), "\n" + string, null);
                } else if (!bl) {
                    baseDocument.insertString(csmInclude.getEndOffset(), "\n\n" + string, null);
                } else {
                    baseDocument.insertString(csmInclude.getStartOffset(), string + "\n\n", null);
                }
            } else {
                TokenSequence tokenSequence = CndLexerUtilities.getCppTokenSequence((JTextComponent)jTextComponent, (int)0);
                if (tokenSequence != null) {
                    int n = this.getIncludeOffsetFromTokenSequence((TokenSequence<CppTokenId>)tokenSequence);
                    if (n == 0) {
                        baseDocument.insertString(n, "\n" + string + "\n\n", null);
                    } else {
                        baseDocument.insertString(n, "\n\n" + string + "\n", null);
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            baseDocument.atomicUnlock();
        }
    }

    private int getIncludeOffsetFromTokenSequence(TokenSequence<CppTokenId> tokenSequence) {
        tokenSequence.moveStart();
        if (!tokenSequence.moveNext()) {
            return 0;
        }
        while (((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.WHITESPACE) || ((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.NEW_LINE)) {
            if (tokenSequence.moveNext()) continue;
            return 0;
        }
        if (((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.BLOCK_COMMENT) || ((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.DOXYGEN_COMMENT)) {
            if (!tokenSequence.moveNext()) {
                return 0;
            }
            int n = tokenSequence.offset();
            int n2 = 0;
            while (((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.WHITESPACE) || ((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.NEW_LINE)) {
                if (((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.NEW_LINE)) {
                    ++n2;
                }
                if (tokenSequence.moveNext()) continue;
                return 0;
            }
            if (((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.BLOCK_COMMENT) || ((CppTokenId)tokenSequence.token().id()).equals((Object)CppTokenId.DOXYGEN_COMMENT)) {
                return n;
            }
            if (n2 > 1) {
                return n;
            }
            return 0;
        }
        return 0;
    }

    protected String getReplaceText() {
        return this.getItemText();
    }

    public int getSortPriority() {
        return this.priority;
    }

    public static class StringResultItem
    extends CsmResultItem {
        private String str;
        private static CsmPaintComponent.StringPaintComponent stringComponent = null;

        public StringResultItem(String string, int n) {
            super(null, n);
            this.str = string;
        }

        public String getItemText() {
            return this.str;
        }

        public Component getPaintComponent(boolean bl) {
            if (stringComponent == null) {
                stringComponent = this.createStringPaintComponent();
            }
            stringComponent.setSelected(bl);
            stringComponent.setString(this.str);
            return stringComponent;
        }

        public Object getAssociatedObject() {
            return this.str;
        }

        protected CsmPaintComponent.StringPaintComponent createStringPaintComponent() {
            return new CsmPaintComponent.StringPaintComponent();
        }
    }

    public static class TypedefResultItem
    extends CsmResultItem {
        private CsmTypedef def;
        private int defDisplayOffset;
        private boolean isDeprecated;
        private boolean displayFQN;
        private static CsmPaintComponent.TypedefPaintComponent defComponent = null;

        public TypedefResultItem(CsmTypedef csmTypedef, boolean bl, int n) {
            this(csmTypedef, 0, bl, n);
        }

        public TypedefResultItem(CsmTypedef csmTypedef, int n, boolean bl, int n2) {
            super((CsmObject)csmTypedef, n2);
            this.def = csmTypedef;
            this.defDisplayOffset = n;
            this.displayFQN = bl;
        }

        protected String getName() {
            return ((Object)this.def.getName()).toString();
        }

        protected String getReplaceText() {
            String string = this.getItemText();
            if (this.defDisplayOffset > 0 && this.defDisplayOffset < string.length()) {
                string = string.substring(this.defDisplayOffset);
            }
            return string;
        }

        public String getItemText() {
            return this.displayFQN ? ((Object)this.def.getQualifiedName()).toString() : ((Object)this.def.getName()).toString();
        }

        protected CsmPaintComponent.TypedefPaintComponent createTypedefPaintComponent() {
            return new CsmPaintComponent.TypedefPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (defComponent == null) {
                defComponent = this.createTypedefPaintComponent();
            }
            defComponent.setSelected(bl);
            defComponent.setFormatTypedefName(this.getName());
            return defComponent;
        }
    }

    public static class ClassResultItem
    extends CsmResultItem {
        private CsmClass cls;
        private CsmDeclaration.Kind kind;
        private boolean isInterface;
        private int classDisplayOffset;
        private boolean isDeprecated;
        private boolean displayFQN;
        private static CsmPaintComponent.ClassPaintComponent clsComponent = null;
        private static CsmPaintComponent.StructPaintComponent structComponent = null;
        private static CsmPaintComponent.UnionPaintComponent unionComponent = null;

        public ClassResultItem(CsmClass csmClass, boolean bl, int n) {
            this(csmClass, 0, bl, n);
        }

        public ClassResultItem(CsmClass csmClass, int n, boolean bl, int n2) {
            super((CsmObject)csmClass, n2);
            this.cls = csmClass;
            this.kind = csmClass.getKind();
            this.classDisplayOffset = n;
            this.displayFQN = bl;
        }

        protected String getName() {
            return this.cls.isTemplate() ? ((Object)((CsmTemplate)this.cls).getDisplayName()).toString() : ((Object)this.cls.getName()).toString();
        }

        protected String getReplaceText() {
            String string = this.getItemText();
            if (this.classDisplayOffset > 0 && this.classDisplayOffset < string.length()) {
                string = string.substring(this.classDisplayOffset);
            }
            return string;
        }

        public String getItemText() {
            return this.displayFQN ? ((Object)this.cls.getQualifiedName()).toString() : this.getName();
        }

        protected CsmPaintComponent.StructPaintComponent createStructPaintComponent() {
            return new CsmPaintComponent.StructPaintComponent();
        }

        protected CsmPaintComponent.UnionPaintComponent createUnionPaintComponent() {
            return new CsmPaintComponent.UnionPaintComponent();
        }

        protected CsmPaintComponent.ClassPaintComponent createClassPaintComponent() {
            return new CsmPaintComponent.ClassPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (this.kind == CsmDeclaration.Kind.STRUCT) {
                if (structComponent == null) {
                    structComponent = this.createStructPaintComponent();
                }
                structComponent.setSelected(bl);
                structComponent.setFormatClassName(this.getName());
                return structComponent;
            }
            if (this.kind == CsmDeclaration.Kind.UNION) {
                if (unionComponent == null) {
                    unionComponent = this.createUnionPaintComponent();
                }
                unionComponent.setSelected(bl);
                unionComponent.setFormatClassName(this.getName());
                return unionComponent;
            }
            assert (this.kind == CsmDeclaration.Kind.CLASS) : "must be class kind";
            if (clsComponent == null) {
                clsComponent = this.createClassPaintComponent();
            }
            clsComponent.setSelected(bl);
            clsComponent.setFormatClassName(this.getName());
            return clsComponent;
        }
    }

    public static class EnumeratorResultItem
    extends CsmResultItem {
        private CsmEnumerator enmtr;
        private int enumDisplayOffset;
        private boolean isDeprecated;
        private boolean displayFQN;
        private static CsmPaintComponent.EnumeratorPaintComponent enumtrComponent = null;

        public EnumeratorResultItem(CsmEnumerator csmEnumerator, boolean bl, int n) {
            this(csmEnumerator, 0, bl, n);
        }

        public EnumeratorResultItem(CsmEnumerator csmEnumerator, int n, boolean bl, int n2) {
            super((CsmObject)csmEnumerator, n2);
            this.enmtr = csmEnumerator;
            this.enumDisplayOffset = n;
            this.displayFQN = bl;
        }

        protected String getName() {
            return ((Object)this.enmtr.getName()).toString();
        }

        protected String getReplaceText() {
            String string = this.getItemText();
            if (this.enumDisplayOffset > 0 && this.enumDisplayOffset < string.length()) {
                string = string.substring(this.enumDisplayOffset);
            }
            return string;
        }

        public String getItemText() {
            return (this.displayFQN ? this.enmtr.getEnumeration().getQualifiedName() + "::" : "") + this.enmtr.getName();
        }

        protected CsmPaintComponent.EnumeratorPaintComponent createPaintComponent() {
            return new CsmPaintComponent.EnumeratorPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (enumtrComponent == null) {
                enumtrComponent = this.createPaintComponent();
            }
            enumtrComponent.setSelected(bl);
            enumtrComponent.setFormatEnumeratorName(this.getName());
            return enumtrComponent;
        }
    }

    public static class EnumResultItem
    extends CsmResultItem {
        private CsmEnum enm;
        private boolean isInterface;
        private int classDisplayOffset;
        private boolean isDeprecated;
        private boolean displayFQN;
        private static CsmPaintComponent.EnumPaintComponent enumComponent = null;

        public EnumResultItem(CsmEnum csmEnum, boolean bl, int n) {
            this(csmEnum, 0, bl, n);
        }

        public EnumResultItem(CsmEnum csmEnum, int n, boolean bl, int n2) {
            super((CsmObject)csmEnum, n2);
            this.enm = csmEnum;
            this.classDisplayOffset = n;
            this.displayFQN = bl;
        }

        protected String getName() {
            return ((Object)this.enm.getName()).toString();
        }

        protected String getReplaceText() {
            String string = this.getItemText();
            if (this.classDisplayOffset > 0 && this.classDisplayOffset < string.length()) {
                string = string.substring(this.classDisplayOffset);
            }
            return string;
        }

        public String getItemText() {
            return this.displayFQN ? ((Object)this.enm.getQualifiedName()).toString() : ((Object)this.enm.getName()).toString();
        }

        protected CsmPaintComponent.EnumPaintComponent createPaintComponent() {
            return new CsmPaintComponent.EnumPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (enumComponent == null) {
                enumComponent = this.createPaintComponent();
            }
            enumComponent.setSelected(bl);
            enumComponent.setFormatEnumName(this.getName());
            return enumComponent;
        }
    }

    public static class NamespaceResultItem
    extends CsmResultItem {
        private boolean displayFullNamespacePath;
        private CsmNamespace pkg;
        private String pkgName;
        private static CsmPaintComponent.NamespacePaintComponent pkgComponent;

        public NamespaceResultItem(CsmNamespace csmNamespace, boolean bl, int n) {
            super((CsmObject)csmNamespace, n);
            this.pkg = csmNamespace;
            this.displayFullNamespacePath = bl;
            this.pkgName = ((Object)csmNamespace.getName()).toString();
        }

        public String getItemText() {
            return this.displayFullNamespacePath ? ((Object)this.pkg.getQualifiedName()).toString() : ((Object)this.pkg.getName()).toString();
        }

        protected CsmPaintComponent.NamespacePaintComponent createPaintComponent() {
            return new CsmPaintComponent.NamespacePaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (pkgComponent == null) {
                pkgComponent = this.createPaintComponent();
            }
            pkgComponent.setSelected(bl);
            pkgComponent.setNamespaceName(this.pkgName);
            pkgComponent.setDisplayFullNamespacePath(this.displayFullNamespacePath);
            return pkgComponent;
        }
    }

    public static class NamespaceAliasResultItem
    extends CsmResultItem {
        private CsmNamespaceAlias alias;
        private String aliasName;
        private static CsmPaintComponent.NamespaceAliasPaintComponent aliasComponent;

        public NamespaceAliasResultItem(CsmNamespaceAlias csmNamespaceAlias, boolean bl, int n) {
            super((CsmObject)csmNamespaceAlias, n);
            this.alias = csmNamespaceAlias;
            this.aliasName = ((Object)csmNamespaceAlias.getAlias()).toString();
        }

        public String getItemText() {
            return ((Object)this.alias.getAlias()).toString();
        }

        protected CsmPaintComponent.NamespaceAliasPaintComponent createPaintComponent() {
            return new CsmPaintComponent.NamespaceAliasPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (aliasComponent == null) {
                aliasComponent = this.createPaintComponent();
            }
            aliasComponent.setSelected(bl);
            aliasComponent.setAliasName(this.aliasName);
            return aliasComponent;
        }
    }

    public static class ConstructorResultItem
    extends CsmResultItem {
        private CsmFunction ctr;
        private CsmCompletionExpression substituteExp;
        private List params = new ArrayList();
        private List excs = new ArrayList();
        private int modifiers;
        private static CsmPaintComponent.ConstructorPaintComponent ctrComponent = null;
        private int activeParameterIndex = -1;
        private int varArgIndex = -1;

        public ConstructorResultItem(CsmFunction csmFunction, CsmCompletionExpression csmCompletionExpression, int n) {
            super((CsmObject)csmFunction, n);
            this.ctr = csmFunction;
            this.substituteExp = csmCompletionExpression;
            this.modifiers = this.convertCsmModifiers((CsmObject)csmFunction);
            CsmParameter[] csmParameterArray = csmFunction.getParameters().toArray(new CsmParameter[0]);
            for (int i = 0; i < csmParameterArray.length; ++i) {
                CsmParameter csmParameter = csmParameterArray[i];
                CsmType csmType = csmParameter.getType();
                if (csmType == null) {
                    assert (csmParameter.isVarArgs());
                    this.params.add(new ParamStr("", "", ((Object)csmParameter.getName()).toString(), true, KEYWORD_COLOR));
                    this.varArgIndex = i;
                    continue;
                }
                String string = ((Object)csmType.getText()).toString();
                this.params.add(new ParamStr(string, ((Object)csmType.getText()).toString(), ((Object)csmParameter.getName()).toString(), false, TYPE_COLOR));
            }
        }

        public CsmCompletionExpression getExpression() {
            return this.substituteExp;
        }

        int getActiveParameterIndex() {
            return this.activeParameterIndex;
        }

        void setActiveParameterIndex(int n) {
            this.activeParameterIndex = n;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public String getName() {
            return ((Object)this.ctr.getName()).toString();
        }

        public List getParams() {
            return this.params;
        }

        public List getExceptions() {
            return this.excs;
        }

        public int getCurrentParamIndex() {
            int n = 0;
            if (this.substituteExp != null && this.substituteExp.getExpID() == 10) {
                n = this.substituteExp.getParameterCount() - 1;
            }
            if (this.varArgIndex > -1 && this.varArgIndex < n) {
                n = this.varArgIndex;
            }
            return n;
        }

        public List createParamsList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = this.getParams().iterator();
            while (iterator.hasNext()) {
                StringBuffer stringBuffer = new StringBuffer();
                ParamStr paramStr = (ParamStr)iterator.next();
                stringBuffer.append(paramStr.getSimpleTypeName());
                if (paramStr.isVarArg()) {
                    stringBuffer.append("...");
                } else {
                    String string = paramStr.getName();
                    if (string != null && string.length() > 0) {
                        stringBuffer.append(" ");
                        stringBuffer.append(string);
                    }
                }
                if (iterator.hasNext()) {
                    stringBuffer.append(", ");
                }
                arrayList.add(stringBuffer.toString());
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            int n3;
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            String string = null;
            boolean bl2 = true;
            switch (this.substituteExp != null ? this.substituteExp.getExpID() : -1) {
                case 11: {
                    break;
                }
                case 10: {
                    boolean bl3;
                    int n4 = this.params.size();
                    if (n4 == 0) {
                        if (this.getActiveParameterIndex() != -1) break;
                        try {
                            n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(n + n2));
                            if (n3 > -1 && baseDocument.getChars(n3, 1)[0] == ')') {
                                string = baseDocument.getText(n + n2, n3 + 1 - n - n2);
                                n2 = n3 + 1 - n;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        if (string != null) break;
                        string = ")";
                        break;
                    }
                    n3 = this.getActiveParameterIndex();
                    if (n3 != -1) {
                        String string2;
                        boolean bl4 = false;
                        if (n3 < n4 && (string2 = ((ParamStr)this.params.get(n3)).getName()) != null) {
                            try {
                                baseDocument.insertString(jTextComponent.getCaretPosition(), string2, null);
                                bl4 = true;
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                        return bl4;
                    }
                    int n5 = this.substituteExp.getParameterCount() - 1;
                    boolean bl5 = CodeStyle.getDefault((Document)baseDocument).spaceAfterComma();
                    try {
                        if (bl5 && (n5 == 0 || n > 0 && Character.isWhitespace(DocumentUtilities.getText((Document)baseDocument, (int)(n - 1), (int)1).charAt(0)))) {
                            bl5 = false;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    boolean bl6 = bl3 = n4 > 0 ? ((ParamStr)this.params.get(n4 - 1)).isVarArg() : false;
                    if (n5 >= n4 && !bl3) break;
                    string = bl5 ? " " : "";
                    break;
                }
                default: {
                    int n6;
                    Object object;
                    string = this.getItemText();
                    n3 = CodeStyle.getDefault((Document)baseDocument).spaceBeforeMethodCallParen();
                    boolean bl7 = false;
                    Formatter formatter = baseDocument.getFormatter();
                    if (formatter instanceof ExtFormatter) {
                        object = ((ExtFormatter)formatter).getSettingValue("pair-characters-completion");
                        object = Settings.getValue((Class)baseDocument.getKitClass(), (String)"pair-characters-completion");
                        if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                            bl7 = true;
                        }
                    }
                    if (!bl2) break;
                    object = null;
                    try {
                        n6 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(n + n2));
                        if (n6 > -1 && n6 <= Utilities.getRowEnd((BaseDocument)baseDocument, (int)(n + n2)) && baseDocument.getChars(n6, 1)[0] == '(') {
                            object = baseDocument.getText(n + n2, n6 + 1 - n - n2);
                            if (n3 != 0 && ((String)object).length() < 2) {
                                string = string + ' ';
                            }
                            n2 = n6 + 1 - n;
                            string = string + (String)object;
                            toAdd = null;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    if (object == null) {
                        if (n3 != 0) {
                            string = string + ' ';
                        }
                        string = string + '(';
                        if (this.params.size() > 0) {
                            this.selectionStartOffset = this.selectionEndOffset = string.length();
                            Completion completion = Completion.get();
                            completion.hideCompletion();
                            completion.hideDocumentation();
                            completion.showToolTip();
                        }
                        if (!bl7) break;
                        string = string + ")";
                        break;
                    }
                    try {
                        n6 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)(n + n2));
                        if (n6 <= -1 || baseDocument.getChars(n6, 1)[0] != ')') break;
                        object = baseDocument.getText(n + n2, n6 + 1 - n - n2);
                        n2 = n6 + 1 - n;
                        if (this.params.size() > 0) {
                            this.selectionStartOffset = this.selectionEndOffset = string.length();
                        }
                        string = string + (String)object;
                        break;
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
            if (string != null) {
                if (toAdd != null && !toAdd.equals("\n") && !"(".equals(toAdd)) {
                    string = string + toAdd;
                }
                baseDocument.atomicLock();
                try {
                    CharSequence charSequence = DocumentUtilities.getText((Document)baseDocument, (int)n, (int)n2);
                    if (CharSequenceUtilities.textEquals((CharSequence)string, (CharSequence)charSequence)) {
                        jTextComponent.setCaretPosition(n + n2);
                        n3 = 0;
                        return n3 != 0;
                    }
                    baseDocument.remove(n, n2);
                    baseDocument.insertString(n, string, null);
                    if (this.selectionStartOffset >= 0) {
                        jTextComponent.select(n + this.selectionStartOffset, n + this.selectionEndOffset);
                    } else if ("(".equals(toAdd) && (n3 = string.lastIndexOf(41)) > -1) {
                        jTextComponent.setCaretPosition(n + n3);
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    baseDocument.atomicUnlock();
                }
                return true;
            }
            return false;
        }

        public String getItemText() {
            return ((Object)this.ctr.getName()).toString();
        }

        protected CsmPaintComponent.ConstructorPaintComponent createPaintComponent() {
            return new CsmPaintComponent.ConstructorPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (ctrComponent == null) {
                ctrComponent = this.createPaintComponent();
            }
            ctrComponent.setName(this.getItemText());
            ctrComponent.setModifiers(this.getModifiers());
            ctrComponent.setParams(this.getParams());
            ctrComponent.setExceptions(this.getExceptions());
            ctrComponent.setSelected(bl);
            return ctrComponent;
        }
    }

    public static class MethodResultItem
    extends ConstructorResultItem {
        private static CsmPaintComponent.MethodPaintComponent mtdComponent = null;
        private static CsmPaintComponent.MethodPaintComponent globFunComponent = null;
        private String typeName;
        private Color typeColor;
        private String mtdName;

        public MethodResultItem(CsmFunction csmFunction, CsmCompletionExpression csmCompletionExpression, int n) {
            super(csmFunction, csmCompletionExpression, n);
            this.typeName = CsmResultItem.getTypeName(csmFunction.getReturnType());
            this.mtdName = ((Object)csmFunction.getName()).toString();
            this.typeColor = CsmResultItem.getTypeColor(csmFunction.getReturnType());
        }

        public String getName() {
            return this.mtdName;
        }

        public String getItemText() {
            return this.getName();
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String string) {
            this.typeName = string;
        }

        public Color getTypeColor() {
            return this.typeColor;
        }

        public void setTypeColor(Color color) {
            this.typeColor = color;
        }

        protected CsmPaintComponent.ConstructorPaintComponent createPaintComponent() {
            return new CsmPaintComponent.MethodPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            CsmPaintComponent.MethodPaintComponent methodPaintComponent = null;
            assert (CsmKindUtilities.isCsmObject((Object)this.getAssociatedObject())) : "must be csm object";
            CsmObject csmObject = (CsmObject)this.getAssociatedObject();
            if (CsmKindUtilities.isMethod((CsmObject)csmObject)) {
                if (mtdComponent == null) {
                    mtdComponent = (CsmPaintComponent.MethodPaintComponent)this.createPaintComponent();
                }
                methodPaintComponent = mtdComponent;
            } else {
                assert (CsmKindUtilities.isGlobalFunction((CsmObject)csmObject)) : "support only global fun and class methods";
                if (globFunComponent == null) {
                    globFunComponent = (CsmPaintComponent.MethodPaintComponent)this.createPaintComponent();
                }
                methodPaintComponent = globFunComponent;
            }
            methodPaintComponent.setName(this.getName());
            methodPaintComponent.setModifiers(this.getModifiers());
            methodPaintComponent.setTypeName(this.getTypeName());
            methodPaintComponent.setTypeColor(this.getTypeColor());
            methodPaintComponent.setParams(this.getParams());
            methodPaintComponent.setExceptions(this.getExceptions());
            methodPaintComponent.setSelected(bl);
            return methodPaintComponent;
        }
    }

    public static class GlobalFunctionResultItem
    extends MethodResultItem {
        public GlobalFunctionResultItem(CsmFunction csmFunction, CsmCompletionExpression csmCompletionExpression, int n) {
            super(csmFunction, csmCompletionExpression, n);
        }

        protected CsmPaintComponent.ConstructorPaintComponent createPaintComponent() {
            return new CsmPaintComponent.GlobalFunctionPaintComponent();
        }
    }

    public static class FileLocalFunctionResultItem
    extends MethodResultItem {
        public FileLocalFunctionResultItem(CsmFunction csmFunction, CsmCompletionExpression csmCompletionExpression, int n) {
            super(csmFunction, csmCompletionExpression, n);
        }

        protected CsmPaintComponent.ConstructorPaintComponent createPaintComponent() {
            return new CsmPaintComponent.FileLocalFunctionPaintComponent();
        }
    }

    public static abstract class VariableResultItem
    extends CsmResultItem {
        private String typeName;
        private Color typeColor;
        private String fldName;
        private int modifiers;
        private boolean isDeprecated;
        private static CsmPaintComponent.FieldPaintComponent fieldComponent = null;
        private static CsmPaintComponent.FieldPaintComponent globVarComponent = null;
        private static CsmPaintComponent.FieldPaintComponent localVarComponent = null;
        private static CsmPaintComponent.FieldPaintComponent fileLocalVarComponent = null;

        public VariableResultItem(CsmVariable csmVariable, int n) {
            super((CsmObject)csmVariable, n);
            this.fldName = ((Object)csmVariable.getName()).toString();
            this.modifiers = this.convertCsmModifiers((CsmObject)csmVariable);
            this.typeName = VariableResultItem.getTypeName(csmVariable.getType());
            this.typeColor = VariableResultItem.getTypeColor(csmVariable.getType());
        }

        public String getItemText() {
            return this.fldName;
        }

        protected abstract CsmPaintComponent.FieldPaintComponent createPaintComponent();

        public Component getPaintComponent(boolean bl) {
            CsmPaintComponent.FieldPaintComponent fieldPaintComponent = null;
            assert (CsmKindUtilities.isCsmObject((Object)this.getAssociatedObject())) : "must be csm object";
            CsmObject csmObject = (CsmObject)this.getAssociatedObject();
            if (CsmKindUtilities.isField((CsmObject)csmObject)) {
                if (fieldComponent == null) {
                    fieldComponent = this.createPaintComponent();
                }
                fieldPaintComponent = fieldComponent;
            } else if (CsmKindUtilities.isGlobalVariable((CsmObject)csmObject)) {
                if (globVarComponent == null) {
                    globVarComponent = this.createPaintComponent();
                }
                fieldPaintComponent = globVarComponent;
            } else if (CsmKindUtilities.isFileLocalVariable((CsmObject)csmObject)) {
                if (fileLocalVarComponent == null) {
                    fileLocalVarComponent = this.createPaintComponent();
                }
                fieldPaintComponent = fileLocalVarComponent;
            } else {
                assert (CsmKindUtilities.isLocalVariable((CsmObject)csmObject)) : "support only global var, local var, file local var and class fields";
                if (localVarComponent == null) {
                    localVarComponent = this.createPaintComponent();
                }
                fieldPaintComponent = localVarComponent;
            }
            fieldPaintComponent.setTypeName(this.typeName);
            fieldPaintComponent.setName(this.fldName);
            fieldPaintComponent.setTypeColor(this.typeColor);
            fieldPaintComponent.setModifiers(this.modifiers);
            fieldPaintComponent.setSelected(bl);
            return fieldPaintComponent;
        }
    }

    public static class MacroResultItem
    extends CsmResultItem {
        private String macName;
        private List params;
        private static CsmPaintComponent.MacroPaintComponent macroPaintComp = null;

        public MacroResultItem(CsmMacro csmMacro, int n) {
            super((CsmObject)csmMacro, n);
            this.macName = ((Object)csmMacro.getName()).toString();
            this.params = csmMacro.getParameters();
        }

        private String getName() {
            return this.macName;
        }

        private List getParams() {
            return this.params;
        }

        public String getItemText() {
            return this.getName();
        }

        protected CsmPaintComponent.MacroPaintComponent createPaintComponent() {
            return new CsmPaintComponent.MacroPaintComponent();
        }

        public Component getPaintComponent(boolean bl) {
            if (macroPaintComp == null) {
                macroPaintComp = this.createPaintComponent();
            }
            CsmMacro csmMacro = (CsmMacro)this.getAssociatedObject();
            macroPaintComp.setName(this.getName());
            macroPaintComp.setParams(this.getParams());
            macroPaintComp.setSelected(bl);
            return macroPaintComp;
        }
    }

    public static class FieldResultItem
    extends VariableResultItem {
        public FieldResultItem(CsmField csmField, int n) {
            super((CsmVariable)csmField, n);
        }

        protected CsmPaintComponent.FieldPaintComponent createPaintComponent() {
            return new CsmPaintComponent.FieldPaintComponent();
        }
    }

    public static class LocalVariableResultItem
    extends VariableResultItem {
        public LocalVariableResultItem(CsmVariable csmVariable, int n) {
            super(csmVariable, n);
        }

        protected CsmPaintComponent.FieldPaintComponent createPaintComponent() {
            return new CsmPaintComponent.LocalVariablePaintComponent();
        }
    }

    public static class GlobalVariableResultItem
    extends VariableResultItem {
        public GlobalVariableResultItem(CsmVariable csmVariable, int n) {
            super(csmVariable, n);
        }

        protected CsmPaintComponent.FieldPaintComponent createPaintComponent() {
            return new CsmPaintComponent.GlobalVariablePaintComponent();
        }
    }

    public static class FileLocalVariableResultItem
    extends VariableResultItem {
        public FileLocalVariableResultItem(CsmVariable csmVariable, int n) {
            super(csmVariable, n);
        }

        protected CsmPaintComponent.FieldPaintComponent createPaintComponent() {
            return new CsmPaintComponent.FileLocalVariablePaintComponent();
        }
    }
}

