/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmFinder;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmSyntaxSupport;
import org.netbeans.modules.cnd.editor.cplusplus.CCSyntax;

public class CsmIncludeProcessor
implements TokenProcessor {
    private static final int INIT_SCAN_LEN = 4096;
    private static final int INIT = 0;
    private static final int AFTER_IMPORT = 1;
    private static final int INSIDE_EXP = 2;
    private static final int INSIDE_MIXED_EXP = 3;
    private HashMap<String, CsmClassifier> name2Class = new HashMap(501);
    private char[] buffer;
    private ArrayList infoList = new ArrayList();
    private int state;
    private boolean parsingPackage;
    private int startPos;
    private int expPos;
    private boolean eotReached;
    private StringBuilder exp = new StringBuilder();
    private boolean star;
    private int posEndOfImportSection;
    private boolean disableReparsing;
    CCSyntax debugSyntax = new CCSyntax();
    private int startOffset;
    private int endOffset;
    private int lastStartOffset = -1;
    private int lastEndOffset = -1;
    private boolean firstFiring = true;
    private EventListenerList listenerList = new EventListenerList();
    private int bufferStartOffset;
    private CsmSyntaxSupport sup;
    private boolean useCustomImports = false;

    public CsmIncludeProcessor(CsmSyntaxSupport csmSyntaxSupport) {
        this.sup = csmSyntaxSupport;
        this.posEndOfImportSection = -1;
        this.disableReparsing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(BaseDocument baseDocument) {
        if (this.disableReparsing) {
            return;
        }
        if (this.useCustomImports) {
            return;
        }
        this.initJavaLangPkg();
        baseDocument.readLock();
        try {
            int n = 4096;
            int n2 = baseDocument.getLength();
            boolean bl = false;
            do {
                if (n >= n2) {
                    n = n2;
                    bl = true;
                }
                this.eotReached = false;
                this.init();
                try {
                    baseDocument.getSyntaxSupport().tokenizeText((TokenProcessor)this, 0, n, false);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                n *= 4;
            } while (!bl && this.eotReached);
            if (this.lastEndOffset != this.endOffset || this.lastStartOffset != this.startOffset) {
                this.lastStartOffset = this.startOffset;
                this.lastEndOffset = this.endOffset;
                if (!this.firstFiring) {
                    this.fireChange(new ChangeEvent(this));
                }
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        this.buffer = null;
    }

    public void appendCustomImportsMap(Map map) {
        if (!this.useCustomImports) {
            this.initJavaLangPkg();
        }
        this.useCustomImports = true;
        if (map == null) {
            this.initJavaLangPkg();
        } else {
            this.name2Class.putAll(map);
        }
    }

    public Map getImportsMap() {
        return Collections.unmodifiableMap(this.name2Class);
    }

    private void initJavaLangPkg() {
        this.name2Class.clear();
    }

    protected void init() {
        this.exp.setLength(0);
        this.state = 0;
        this.star = false;
        this.parsingPackage = false;
        this.startOffset = Integer.MAX_VALUE;
        this.endOffset = Integer.MIN_VALUE;
        this.infoList.clear();
    }

    private CsmClass checkForInnerClass(String string) {
        for (CsmClass csmClass : this.name2Class.values()) {
            if (csmClass == null || !((Object)csmClass.getQualifiedName()).toString().endsWith("." + string)) continue;
            return csmClass;
        }
        return null;
    }

    public List getInnerClasses() {
        Iterator<CsmClassifier> iterator = this.name2Class.values().iterator();
        ArrayList<CsmClass> arrayList = new ArrayList<CsmClass>();
        while (iterator.hasNext()) {
            CsmClass csmClass = (CsmClass)iterator.next();
            if (csmClass == null || ((Object)csmClass.getName()).toString().indexOf(".") <= 0) continue;
            arrayList.add(csmClass);
        }
        return arrayList;
    }

    public int getStartOffset() {
        return this.startOffset == Integer.MAX_VALUE ? -1 : this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset == Integer.MIN_VALUE ? -1 : this.endOffset;
    }

    public boolean isEmpty() {
        return this.getStartOffset() == -1;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    private void fireChange(ChangeEvent changeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public CsmClassifier getClazz(String string) {
        CsmFinder csmFinder = this.sup.getFinder();
        CsmClass csmClass = (CsmClass)this.name2Class.get(string);
        if (csmClass == null) {
            csmClass = this.checkForInnerClass(string);
        }
        if (csmClass == null) {
            csmClass = csmFinder.getExactClassifier(string);
        } else if (csmFinder.getExactClassifier(((Object)csmClass.getQualifiedName()).toString()) != null) {
            csmClass = csmFinder.getExactClassifier(((Object)csmClass.getQualifiedName()).toString());
        }
        return csmClass;
    }

    protected void packageStatementFound(int n, int n2, String string) {
        CsmNamespace csmNamespace = this.sup.getFinder().getExactNamespace(string);
        if (csmNamespace != null) {
            // empty if block
        }
    }

    protected void importStatementFound(int n, int n2, String string, boolean bl) {
        if (n < this.startOffset) {
            this.startOffset = n;
        }
        if (n2 > this.endOffset) {
            this.endOffset = n2;
        }
        CsmFinder csmFinder = this.sup.getFinder();
        Info info = new Info(n, n2, bl);
        CsmClassifier csmClassifier = csmFinder.getExactClassifier(string);
        if (csmClassifier != null) {
            info.cls = csmClassifier;
            if (!this.star) {
                this.name2Class.put(((Object)csmClassifier.getName()).toString(), csmClassifier);
            }
        } else {
            CsmNamespace csmNamespace = csmFinder.getExactNamespace(string);
            if (csmNamespace != null) {
                info.pkg = csmNamespace;
                if (bl) {
                    // empty if block
                }
            } else {
                int n3;
                String string2 = string;
                String string3 = null;
                while ((n3 = string2.lastIndexOf(46)) >= 0) {
                    string2 = string2.substring(0, n3);
                    if (string3 != null) continue;
                    string3 = string2;
                }
                if (csmClassifier == null && string3 != null && !this.star) {
                    this.name2Class.put(((Object)csmClassifier.getName()).toString(), csmClassifier);
                }
            }
        }
        if (info.cls == null && info.pkg == null) {
            info.unknownImport = string;
        }
        this.infoList.add(info);
    }

    public boolean isUnknownImport(String string) {
        for (int i = 0; i < this.infoList.size(); ++i) {
            String string2 = ((Info)this.infoList.get((int)i)).unknownImport;
            if (string2 == null || string2.indexOf(string) <= -1) continue;
            return true;
        }
        return false;
    }

    protected List getUnknownImports() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.infoList.size(); ++i) {
            String string = ((Info)this.infoList.get((int)i)).unknownImport;
            if (string == null) continue;
            if (((Info)this.infoList.get((int)i)).star) {
                string = string + ".*";
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
        boolean bl = true;
        int n3 = this.bufferStartOffset + n;
        block0 : switch (tokenID.getNumericID()) {
            case 7: {
                switch (this.state) {
                    case 1: {
                        this.expPos = n3;
                        this.state = 2;
                        break;
                    }
                    case 3: {
                        this.exp.append(this.buffer, n3, n2);
                    }
                    case 2: {
                        if (!this.star) break;
                        bl = false;
                    }
                }
                break;
            }
            case 53: {
                switch (this.state) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        bl = false;
                        break;
                    }
                    case 3: {
                        this.exp.append('.');
                    }
                    case 2: {
                        if (!this.star) break;
                        bl = false;
                    }
                }
                break;
            }
            case 58: {
                String string = null;
                switch (this.state) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        bl = false;
                        break;
                    }
                    case 2: {
                        string = new String(this.buffer, this.expPos, (this.star ? n3 - 2 : n3) - this.expPos);
                        break;
                    }
                    case 3: {
                        string = this.exp.toString();
                        this.exp.setLength(0);
                    }
                }
                if (string == null) break;
                if (this.parsingPackage) {
                    this.packageStatementFound(this.startPos, n3 + 1, string);
                } else {
                    this.importStatementFound(this.startPos, n3 + 1, string, this.star);
                }
                this.star = false;
                this.parsingPackage = false;
                this.state = 0;
                break;
            }
            case 29: {
                if (this.star || this.parsingPackage) {
                    bl = false;
                    break;
                }
                switch (this.state) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        bl = false;
                        break;
                    }
                    case 2: {
                        this.star = true;
                        if (n3 != 0 && this.buffer[n3 - 1] == '.') break;
                        bl = false;
                        break;
                    }
                    case 3: {
                        int n4 = this.exp.length();
                        if (n4 > 0 && this.exp.charAt(n4 - 1) == '.') {
                            this.exp.setLength(n4 - 1);
                            this.star = true;
                            break;
                        }
                        bl = false;
                    }
                }
                break;
            }
            case 76: {
                switch (this.state) {
                    case 0: {
                        this.parsingPackage = false;
                        this.state = 1;
                        this.startPos = n3;
                        break block0;
                    }
                }
                bl = false;
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                switch (this.state) {
                    case 2: {
                        if (n3 - this.expPos < 0) {
                            bl = false;
                            break;
                        }
                        this.exp.append(this.buffer, this.expPos, n3 - this.expPos);
                        this.state = 3;
                    }
                }
                break;
            }
            default: {
                if (this.posEndOfImportSection == -1 || n3 + n2 > this.posEndOfImportSection) {
                    this.posEndOfImportSection = n3 + n2;
                }
                if (this.firstFiring) {
                    this.firstFiring = false;
                }
                bl = false;
            }
        }
        return bl;
    }

    private String debugState(int n) {
        switch (n) {
            case 0: {
                return "INIT";
            }
            case 1: {
                return "AFTER_IMPORT";
            }
            case 2: {
                return "INSIDE_EXP";
            }
            case 3: {
                return "INSIDE_MIXED_EXP";
            }
        }
        return "UNKNOWN STATE";
    }

    public int eot(int n) {
        this.eotReached = true;
        return 0;
    }

    public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
        this.buffer = cArray;
        this.bufferStartOffset = n3 - n;
    }

    public void documentModifiedAtPosition(int n) {
        this.documentModifiedAtPosition(n, null);
    }

    public void documentModifiedAtPosition(int n, final BaseDocument baseDocument) {
        if (this.posEndOfImportSection != -1) {
            if (n > this.posEndOfImportSection) {
                this.disableReparsing = true;
            } else {
                this.disableReparsing = false;
                this.posEndOfImportSection = -1;
                CsmModelAccessor.getModel().enqueue(new Runnable(){

                    public void run() {
                        CsmIncludeProcessor.this.update(baseDocument);
                    }
                });
            }
        }
    }

    class Info {
        int startPos;
        int endPos;
        boolean star;
        CsmNamespace pkg;
        CsmClassifier cls;
        String unknownImport;

        Info(int n, int n2, boolean bl) {
            this.startPos = n;
            this.endPos = n2;
            this.star = bl;
        }
    }
}

