/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletion;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionExpression;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionTokenProcessor;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmFinder;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmResultItem;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmSyntaxSupport;
import org.netbeans.modules.cnd.completion.csm.CompletionResolver;
import org.netbeans.modules.cnd.editor.cplusplus.CCTokenContext;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.util.NbBundle;

public abstract class CsmCompletionQuery
implements CompletionQuery {
    private BaseDocument baseDocument;
    private static final String NO_SUGGESTIONS = NbBundle.getMessage(CsmCompletionQuery.class, (String)"completion-no-suggestions");
    private static final String PROJECT_BEEING_PARSED = NbBundle.getMessage(CsmCompletionQuery.class, (String)"completion-project-beeing-parsed");
    private static final boolean TRACE_COMPLETION = Boolean.getBoolean("cnd.completion.trace");
    private static CsmItemFactory itemFactory;
    private static final int FAKE_PRIORITY = 1000;

    protected BaseDocument getBaseDocument() {
        return this.baseDocument;
    }

    protected abstract CompletionResolver getCompletionResolver(boolean var1, boolean var2);

    protected abstract CsmFinder getFinder();

    protected abstract QueryScope getCompletionQueryScope();

    public CsmCompletionQuery() {
        this.initFactory();
    }

    protected void initFactory() {
        this.setCsmItemFactory(new DefaultCsmItemFactory());
    }

    public CompletionQuery.Result query(JTextComponent jTextComponent, int n, SyntaxSupport syntaxSupport) {
        boolean bl = false;
        return this.query(jTextComponent, n, syntaxSupport, false, bl);
    }

    public CompletionQuery.Result query(JTextComponent jTextComponent, int n, SyntaxSupport syntaxSupport, boolean bl, boolean bl2) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        return this.query(jTextComponent, baseDocument, n, syntaxSupport, bl, bl2);
    }

    public static boolean checkCondition(CsmSyntaxSupport csmSyntaxSupport, int n) {
        return csmSyntaxSupport != null && !csmSyntaxSupport.isCompletionDisabled(n) && csmSyntaxSupport.isIncludeCompletionDisabled(n);
    }

    public CompletionQuery.Result query(JTextComponent jTextComponent, BaseDocument baseDocument, int n, SyntaxSupport syntaxSupport, boolean bl, boolean bl2) {
        this.baseDocument = baseDocument;
        CompletionQuery.Result result = null;
        CsmSyntaxSupport csmSyntaxSupport = (CsmSyntaxSupport)syntaxSupport.get(CsmSyntaxSupport.class);
        if (!CsmCompletionQuery.checkCondition(csmSyntaxSupport, n)) {
            return null;
        }
        try {
            int n2 = csmSyntaxSupport.getLastCommandSeparator(n);
            CsmCompletionTokenProcessor csmCompletionTokenProcessor = new CsmCompletionTokenProcessor(n);
            csmCompletionTokenProcessor.setJava15(true);
            boolean bl3 = true;
            while (bl3) {
                csmSyntaxSupport.tokenizeText(csmCompletionTokenProcessor, n2 < n ? n2 + 1 : n, n, true);
                bl3 = csmCompletionTokenProcessor.isStopped() && (n2 = csmSyntaxSupport.findMatchingBlock(csmCompletionTokenProcessor.getCurrentOffest(), true)[0]) < n - 1;
            }
            boolean bl4 = false;
            TokenID tokenID = csmCompletionTokenProcessor.getLastValidTokenID();
            if (tokenID != null) {
                switch (tokenID.getNumericID()) {
                    case 9: {
                        if (csmCompletionTokenProcessor.getLastValidTokenText() != null && csmCompletionTokenProcessor.getLastValidTokenText().endsWith("*/")) break;
                        bl4 = true;
                        break;
                    }
                    case 8: {
                        bl4 = true;
                        break;
                    }
                    default: {
                        bl4 = tokenID.getCategory() == CCTokenContext.CPP ? true : csmCompletionTokenProcessor.isErrorState();
                    }
                }
            }
            if (!bl4) {
                csmSyntaxSupport.refreshClassInfo();
                CsmCompletionExpression csmCompletionExpression = csmCompletionTokenProcessor.getResultExp();
                if (TRACE_COMPLETION) {
                    System.err.println("expression " + csmCompletionExpression);
                }
                result = this.getResult(jTextComponent, csmSyntaxSupport, bl, n, csmCompletionExpression, bl2);
            } else if (TRACE_COMPLETION) {
                System.err.println("Error expression " + csmCompletionTokenProcessor.getResultExp());
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return result;
    }

    protected abstract boolean isProjectBeeingParsed(boolean var1);

    protected CompletionQuery.Result getResult(JTextComponent jTextComponent, CsmSyntaxSupport csmSyntaxSupport, boolean bl, int n, CsmCompletionExpression csmCompletionExpression, boolean bl2) {
        CompletionResolver completionResolver = this.getCompletionResolver(bl, bl2);
        if (completionResolver != null) {
            CsmOffsetableDeclaration csmOffsetableDeclaration = csmSyntaxSupport.getDefinition(n);
            Context context = new Context(jTextComponent, csmSyntaxSupport, bl, n, this.getFinder(), completionResolver, csmOffsetableDeclaration, bl2);
            context.resolveExp(csmCompletionExpression);
            if (context.result != null) {
                context.result.setSimpleVariableExpression(CsmCompletionQuery.isSimpleVariableExpression(csmCompletionExpression));
            }
            if (TRACE_COMPLETION) {
                CompletionItem[] completionItemArray = context.result == null ? new CompletionItem[]{} : context.result.getData().toArray(new CompletionItem[context.result.getData().size()]);
                System.err.println("Completion Items " + completionItemArray.length);
                for (int i = 0; i < completionItemArray.length; ++i) {
                    CompletionItem completionItem = completionItemArray[i];
                    System.err.println(completionItem.toString());
                }
            }
            return context.result;
        }
        boolean bl3 = this.isProjectBeeingParsed(bl);
        return new CsmCompletionResult(jTextComponent, this.getBaseDocument(), Collections.EMPTY_LIST, "", csmCompletionExpression, 0, bl3);
    }

    protected static boolean isCaseSensitive(Class clazz) {
        boolean bl = SettingsUtil.getBoolean((Class)clazz, (String)"completion-case-sensitive", (Boolean)ExtSettingsDefaults.defaultCompletionCaseSensitive);
        return bl;
    }

    protected static boolean isNaturalSort(Class clazz) {
        boolean bl = SettingsUtil.getBoolean((Class)clazz, (String)"completion-natural-sort", (Boolean)ExtSettingsDefaults.defaultCompletionNaturalSort);
        return bl;
    }

    private String formatName(String string, boolean bl) {
        return string != null ? (bl ? string + '*' : string) : (bl ? "*" : "");
    }

    private String formatType(CsmType csmType, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (csmType != null) {
            stringBuilder.append(csmType.getText());
        }
        if (bl2) {
            stringBuilder.append("::");
        }
        return stringBuilder.toString();
    }

    private static String formatType(CsmType csmType, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (csmType != null && csmType.getClassifier() != null) {
            stringBuilder.append(bl ? csmType.getClassifier().getQualifiedName() : csmType.getClassifier().getName());
        }
        if (bl2) {
            stringBuilder.append("::");
        }
        if (bl3) {
            stringBuilder.append('*');
        }
        return stringBuilder.toString();
    }

    static List findNestedClassifiers(CsmFinder csmFinder, CsmOffsetableDeclaration csmOffsetableDeclaration, CsmClassifier csmClassifier, String string, boolean bl, boolean bl2, boolean bl3) {
        ArrayList arrayList = new ArrayList();
        if (!CsmKindUtilities.isClass((CsmObject)(csmClassifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)csmClassifier)))) {
            return arrayList;
        }
        CsmClass csmClass = (CsmClass)csmClassifier;
        List list = csmFinder.findNestedClassifiers(csmOffsetableDeclaration, csmClass, string, bl, bl2, bl3);
        if (list != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    static List findFieldsAndMethods(CsmFinder csmFinder, CsmOffsetableDeclaration csmOffsetableDeclaration, CsmClassifier csmClassifier, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        List list;
        ArrayList arrayList = new ArrayList();
        if (!CsmKindUtilities.isClass((CsmObject)(csmClassifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)csmClassifier)))) {
            return arrayList;
        }
        CsmClass csmClass = (CsmClass)csmClassifier;
        CsmFunction csmFunction = CsmBaseUtilities.getContextFunction((CsmOffsetableDeclaration)csmOffsetableDeclaration);
        CsmClass csmClass2 = CsmBaseUtilities.getContextClass((CsmOffsetableDeclaration)csmOffsetableDeclaration);
        if (CsmInheritanceUtilities.isAssignableFrom((CsmClass)csmClass2, (CsmClass)csmClass)) {
            bl2 = false;
        }
        if ((list = csmFinder.findFields(csmOffsetableDeclaration, csmClass, string, bl, bl2, bl3, bl4, bl5, bl6)) != null) {
            arrayList.addAll(list);
        }
        if ((list = csmFinder.findEnumerators(csmOffsetableDeclaration, csmClass, string, bl, bl3, bl4, bl5, bl6)) != null) {
            arrayList.addAll(list);
        }
        if (csmFunction == null) {
            bl2 = false;
            csmOffsetableDeclaration = csmClass;
        }
        if ((list = csmFinder.findMethods(csmOffsetableDeclaration, csmClass, string, bl, bl2, bl3, bl4, bl5, bl6)) != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private static CsmClassifier getClassifier(CsmType csmType, boolean bl) {
        CsmType csmType2;
        CsmClassifier csmClassifier;
        CsmFunction csmFunction;
        CsmClassifier csmClassifier2 = csmType.getClassifier();
        CsmClassifier csmClassifier3 = csmClassifier2 = csmClassifier2 != null ? CsmBaseUtilities.getOriginalClassifier((CsmClassifier)csmClassifier2) : csmClassifier2;
        if (bl && CsmKindUtilities.isClass((CsmObject)csmClassifier2) && (csmFunction = CsmBaseUtilities.getOperator((CsmClassifier)((CsmClass)csmClassifier2), (CsmFunction.OperatorKind)CsmFunction.OperatorKind.ARROW)) != null && (csmClassifier = CsmCompletionQuery.getClassifier(csmType2 = csmFunction.getReturnType(), true)) != null) {
            csmClassifier2 = csmClassifier;
        }
        return csmClassifier2;
    }

    private static String formatTypeList(List list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list.size() > 0) {
            int n = list.size() - 1;
            for (int i = 0; i <= n; ++i) {
                CsmType csmType = (CsmType)list.get(i);
                if (csmType != null) {
                    stringBuilder.append(csmType.getText());
                } else {
                    stringBuilder.append('?');
                }
                if (i >= n) continue;
                stringBuilder.append(", ");
            }
            if (bl) {
                stringBuilder.append(", *");
            }
        } else if (bl) {
            stringBuilder.append("*");
        }
        return stringBuilder.toString();
    }

    private static boolean isSimpleVariableExpression(CsmCompletionExpression csmCompletionExpression) {
        switch (csmCompletionExpression.getExpID()) {
            case 4: 
            case 5: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return false;
            }
        }
        return true;
    }

    protected void setCsmItemFactory(CsmItemFactory csmItemFactory) {
        itemFactory = csmItemFactory;
    }

    public static CsmItemFactory getCsmItemFactory() {
        return itemFactory;
    }

    private static List convertData(List list, int n, CsmCompletionExpression csmCompletionExpression, int n2) {
        Iterator iterator = list.iterator();
        ArrayList<CsmResultItem> arrayList = new ArrayList<CsmResultItem>();
        while (iterator.hasNext()) {
            CsmResultItem csmResultItem;
            Object e = iterator.next();
            if (e instanceof CompletionQuery.ResultItem) {
                assert (false) : " why item element here?";
                csmResultItem = (CsmResultItem)e;
            } else {
                csmResultItem = CsmCompletionQuery.createResultItem(e, n, csmCompletionExpression);
            }
            assert (csmResultItem != null) : "why null item? object " + e;
            if (csmResultItem == null) continue;
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        return arrayList;
    }

    private static CsmResultItem createResultItem(Object object, int n, CsmCompletionExpression csmCompletionExpression) {
        if (CsmKindUtilities.isCsmObject((Object)object)) {
            CsmObject csmObject = (CsmObject)object;
            assert (!CsmKindUtilities.isMethod((CsmObject)csmObject) || CsmKindUtilities.isMethodDeclaration((CsmObject)csmObject)) : "completion result can not have method definitions " + object;
            if (CsmKindUtilities.isNamespace((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createNamespaceResultItem((CsmNamespace)csmObject, false);
            }
            if (CsmKindUtilities.isEnum((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createEnumResultItem((CsmEnum)csmObject, n, false);
            }
            if (CsmKindUtilities.isEnumerator((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createGlobalEnumeratorResultItem((CsmEnumerator)csmObject, n, false);
            }
            if (CsmKindUtilities.isClass((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createClassResultItem((CsmClass)csmObject, n, false);
            }
            if (CsmKindUtilities.isField((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createFieldResultItem((CsmField)csmObject);
            }
            if (CsmKindUtilities.isConstructor((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createConstructorResultItem((CsmConstructor)csmObject, csmCompletionExpression);
            }
            if (CsmKindUtilities.isMethodDeclaration((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createMethodResultItem((CsmMethod)csmObject, csmCompletionExpression);
            }
            if (CsmKindUtilities.isGlobalFunction((CsmObject)csmObject)) {
                if (CsmBaseUtilities.isFileLocalFunction((CsmFunction)((CsmFunction)csmObject))) {
                    return CsmCompletionQuery.getCsmItemFactory().createFileLocalFunctionResultItem((CsmFunction)csmObject, csmCompletionExpression);
                }
                return CsmCompletionQuery.getCsmItemFactory().createGlobalFunctionResultItem((CsmFunction)csmObject, csmCompletionExpression);
            }
            if (CsmKindUtilities.isGlobalVariable((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createGlobalVariableResultItem((CsmVariable)csmObject);
            }
            if (CsmKindUtilities.isFileLocalVariable((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createFileLocalVariableResultItem((CsmVariable)csmObject);
            }
            if (CsmKindUtilities.isLocalVariable((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createLocalVariableResultItem((CsmVariable)csmObject);
            }
            if (CsmKindUtilities.isMacro((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createGlobalMacroResultItem((CsmMacro)csmObject);
            }
            if (CsmKindUtilities.isTypedef((CsmObject)csmObject)) {
                return CsmCompletionQuery.getCsmItemFactory().createTypedefResultItem((CsmTypedef)csmObject, n, false);
            }
        }
        return null;
    }

    private static List convertData(CompletionResolver.Result result, int n, CsmCompletionExpression csmCompletionExpression, int n2) {
        CsmResultItem csmResultItem;
        if (result == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CsmResultItem> arrayList = new ArrayList<CsmResultItem>(result.size());
        CsmItemFactory csmItemFactory = CsmCompletionQuery.getCsmItemFactory();
        for (CsmVariable csmVariable : result.getLocalVariables()) {
            csmResultItem = csmItemFactory.createLocalVariableResultItem(csmVariable);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmField csmField : result.getClassFields()) {
            csmResultItem = csmItemFactory.createFieldResultItem(csmField);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmEnumerator csmEnumerator : result.getClassEnumerators()) {
            csmResultItem = csmItemFactory.createMemberEnumeratorResultItem(csmEnumerator, n, false);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmMethod csmMethod : result.getClassMethods()) {
            csmResultItem = CsmKindUtilities.isConstructor((CsmObject)csmMethod) ? csmItemFactory.createConstructorResultItem((CsmConstructor)csmMethod, csmCompletionExpression) : csmItemFactory.createMethodResultItem(csmMethod, csmCompletionExpression);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmClassifier csmClassifier : result.getProjectClassesifiersEnums()) {
            if (CsmKindUtilities.isClass((CsmObject)csmClassifier)) {
                csmResultItem = csmItemFactory.createClassResultItem((CsmClass)csmClassifier, n, false);
            } else if (CsmKindUtilities.isTypedef((CsmObject)csmClassifier)) {
                csmResultItem = csmItemFactory.createTypedefResultItem((CsmTypedef)csmClassifier, n, false);
            } else {
                assert (CsmKindUtilities.isEnum((CsmObject)csmClassifier));
                csmResultItem = csmItemFactory.createEnumResultItem((CsmEnum)csmClassifier, n, false);
            }
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmVariable csmVariable : result.getFileLocalVars()) {
            csmResultItem = csmItemFactory.createFileLocalVariableResultItem(csmVariable);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmEnumerator csmEnumerator : result.getFileLocalEnumerators()) {
            csmResultItem = csmItemFactory.createFileLocalEnumeratorResultItem(csmEnumerator, n, false);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmMacro csmMacro : result.getFileLocalMacros()) {
            csmResultItem = csmItemFactory.createFileLocalMacroResultItem(csmMacro);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmFunction csmFunction : result.getFileLocalFunctions()) {
            csmResultItem = csmItemFactory.createFileLocalFunctionResultItem(csmFunction, csmCompletionExpression);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmMacro csmMacro : result.getInFileIncludedProjectMacros()) {
            csmResultItem = csmItemFactory.createFileIncludedProjectMacroResultItem(csmMacro);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmVariable csmVariable : result.getGlobalVariables()) {
            csmResultItem = csmItemFactory.createGlobalVariableResultItem(csmVariable);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmEnumerator csmEnumerator : result.getGlobalEnumerators()) {
            csmResultItem = csmItemFactory.createGlobalEnumeratorResultItem(csmEnumerator, n, false);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmMacro csmMacro : result.getGlobalProjectMacros()) {
            csmResultItem = csmItemFactory.createGlobalMacroResultItem(csmMacro);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmFunction csmFunction : result.getGlobalProjectFunctions()) {
            csmResultItem = csmItemFactory.createGlobalFunctionResultItem(csmFunction, csmCompletionExpression);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmNamespace csmNamespace : result.getGlobalProjectNamespaces()) {
            csmResultItem = csmItemFactory.createNamespaceResultItem(csmNamespace, false);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmNamespaceAlias csmNamespaceAlias : result.getProjectNamespaceAliases()) {
            csmResultItem = csmItemFactory.createNamespaceAliasResultItem(csmNamespaceAlias, false);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmClassifier csmClassifier : result.getLibClassifiersEnums()) {
            if (CsmKindUtilities.isClass((CsmObject)csmClassifier)) {
                csmResultItem = csmItemFactory.createLibClassResultItem((CsmClass)csmClassifier, n, false);
            } else if (CsmKindUtilities.isTypedef((CsmObject)csmClassifier)) {
                csmResultItem = csmItemFactory.createLibTypedefResultItem((CsmTypedef)csmClassifier, n, false);
            } else {
                assert (CsmKindUtilities.isEnum((CsmObject)csmClassifier));
                csmResultItem = csmItemFactory.createLibEnumResultItem((CsmEnum)csmClassifier, n, false);
            }
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmMacro csmMacro : result.getInFileIncludedLibMacros()) {
            csmResultItem = csmItemFactory.createFileIncludedLibMacroResultItem(csmMacro);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmMacro csmMacro : result.getLibMacros()) {
            csmResultItem = csmItemFactory.createLibMacroResultItem(csmMacro);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmVariable csmVariable : result.getLibVariables()) {
            csmResultItem = csmItemFactory.createLibGlobalVariableResultItem(csmVariable);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmEnumerator csmEnumerator : result.getLibEnumerators()) {
            csmResultItem = csmItemFactory.createLibGlobalEnumeratorResultItem(csmEnumerator, n, false);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmFunction csmFunction : result.getLibFunctions()) {
            csmResultItem = csmItemFactory.createLibGlobalFunctionResultItem(csmFunction, csmCompletionExpression);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmNamespace csmNamespace : result.getLibNamespaces()) {
            csmResultItem = csmItemFactory.createLibNamespaceResultItem(csmNamespace, false);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        for (CsmNamespaceAlias csmNamespaceAlias : result.getLibNamespaceAliases()) {
            csmResultItem = csmItemFactory.createLibNamespaceAliasResultItem(csmNamespaceAlias, false);
            assert (csmResultItem != null);
            csmResultItem.setSubstituteOffset(n2);
            arrayList.add(csmResultItem);
        }
        return arrayList;
    }

    public static class DefaultCsmItemFactory
    implements CsmItemFactory {
        public CsmResultItem.NamespaceResultItem createNamespaceResultItem(CsmNamespace csmNamespace, boolean bl) {
            return new CsmResultItem.NamespaceResultItem(csmNamespace, bl, 1000);
        }

        public CsmResultItem.NamespaceAliasResultItem createNamespaceAliasResultItem(CsmNamespaceAlias csmNamespaceAlias, boolean bl) {
            return new CsmResultItem.NamespaceAliasResultItem(csmNamespaceAlias, bl, 1000);
        }

        public CsmResultItem.EnumeratorResultItem createMemberEnumeratorResultItem(CsmEnumerator csmEnumerator, int n, boolean bl) {
            return this.createGlobalEnumeratorResultItem(csmEnumerator, n, bl);
        }

        public CsmResultItem.EnumeratorResultItem createFileLocalEnumeratorResultItem(CsmEnumerator csmEnumerator, int n, boolean bl) {
            return this.createGlobalEnumeratorResultItem(csmEnumerator, n, bl);
        }

        public CsmResultItem.EnumeratorResultItem createGlobalEnumeratorResultItem(CsmEnumerator csmEnumerator, int n, boolean bl) {
            return new CsmResultItem.EnumeratorResultItem(csmEnumerator, n, bl, 1000);
        }

        public CsmResultItem.MacroResultItem createFileLocalMacroResultItem(CsmMacro csmMacro) {
            return this.createGlobalMacroResultItem(csmMacro);
        }

        public CsmResultItem.MacroResultItem createFileIncludedProjectMacroResultItem(CsmMacro csmMacro) {
            return this.createGlobalMacroResultItem(csmMacro);
        }

        public CsmResultItem.ClassResultItem createClassResultItem(CsmClass csmClass, int n, boolean bl) {
            return new CsmResultItem.ClassResultItem(csmClass, n, bl, 1000);
        }

        public CsmResultItem.EnumResultItem createEnumResultItem(CsmEnum csmEnum, int n, boolean bl) {
            return new CsmResultItem.EnumResultItem(csmEnum, n, bl, 1000);
        }

        public CsmResultItem.TypedefResultItem createTypedefResultItem(CsmTypedef csmTypedef, int n, boolean bl) {
            return new CsmResultItem.TypedefResultItem(csmTypedef, n, bl, 1000);
        }

        public CsmResultItem.ClassResultItem createLibClassResultItem(CsmClass csmClass, int n, boolean bl) {
            return this.createClassResultItem(csmClass, n, bl);
        }

        public CsmResultItem.EnumResultItem createLibEnumResultItem(CsmEnum csmEnum, int n, boolean bl) {
            return this.createEnumResultItem(csmEnum, n, bl);
        }

        public CsmResultItem.TypedefResultItem createLibTypedefResultItem(CsmTypedef csmTypedef, int n, boolean bl) {
            return this.createLibTypedefResultItem(csmTypedef, n, bl);
        }

        public CsmResultItem.FieldResultItem createFieldResultItem(CsmField csmField) {
            return new CsmResultItem.FieldResultItem(csmField, 1000);
        }

        public CsmResultItem.MethodResultItem createMethodResultItem(CsmMethod csmMethod, CsmCompletionExpression csmCompletionExpression) {
            return new CsmResultItem.MethodResultItem((CsmFunction)csmMethod, csmCompletionExpression, 1000);
        }

        public CsmResultItem.ConstructorResultItem createConstructorResultItem(CsmConstructor csmConstructor, CsmCompletionExpression csmCompletionExpression) {
            return new CsmResultItem.ConstructorResultItem((CsmFunction)csmConstructor, csmCompletionExpression, 1000);
        }

        public CsmResultItem.GlobalFunctionResultItem createGlobalFunctionResultItem(CsmFunction csmFunction, CsmCompletionExpression csmCompletionExpression) {
            return new CsmResultItem.GlobalFunctionResultItem(csmFunction, csmCompletionExpression, 1000);
        }

        public CsmResultItem.GlobalVariableResultItem createGlobalVariableResultItem(CsmVariable csmVariable) {
            return new CsmResultItem.GlobalVariableResultItem(csmVariable, 1000);
        }

        public CsmResultItem.LocalVariableResultItem createLocalVariableResultItem(CsmVariable csmVariable) {
            return new CsmResultItem.LocalVariableResultItem(csmVariable, 1000);
        }

        public CsmResultItem.FileLocalVariableResultItem createFileLocalVariableResultItem(CsmVariable csmVariable) {
            return new CsmResultItem.FileLocalVariableResultItem(csmVariable, 1000);
        }

        public CsmResultItem.FileLocalFunctionResultItem createFileLocalFunctionResultItem(CsmFunction csmFunction, CsmCompletionExpression csmCompletionExpression) {
            return new CsmResultItem.FileLocalFunctionResultItem(csmFunction, csmCompletionExpression, 1000);
        }

        public CsmResultItem.MacroResultItem createGlobalMacroResultItem(CsmMacro csmMacro) {
            return new CsmResultItem.MacroResultItem(csmMacro, 1000);
        }

        public CsmResultItem.MacroResultItem createFileIncludedLibMacroResultItem(CsmMacro csmMacro) {
            return this.createGlobalMacroResultItem(csmMacro);
        }

        public CsmResultItem.MacroResultItem createLibMacroResultItem(CsmMacro csmMacro) {
            return this.createGlobalMacroResultItem(csmMacro);
        }

        public CsmResultItem.GlobalVariableResultItem createLibGlobalVariableResultItem(CsmVariable csmVariable) {
            return this.createGlobalVariableResultItem(csmVariable);
        }

        public CsmResultItem.EnumeratorResultItem createLibGlobalEnumeratorResultItem(CsmEnumerator csmEnumerator, int n, boolean bl) {
            return this.createGlobalEnumeratorResultItem(csmEnumerator, n, bl);
        }

        public CsmResultItem.GlobalFunctionResultItem createLibGlobalFunctionResultItem(CsmFunction csmFunction, CsmCompletionExpression csmCompletionExpression) {
            return this.createGlobalFunctionResultItem(csmFunction, csmCompletionExpression);
        }

        public CsmResultItem.NamespaceResultItem createLibNamespaceResultItem(CsmNamespace csmNamespace, boolean bl) {
            return this.createNamespaceResultItem(csmNamespace, bl);
        }

        public CsmResultItem.NamespaceAliasResultItem createLibNamespaceAliasResultItem(CsmNamespaceAlias csmNamespaceAlias, boolean bl) {
            return this.createNamespaceAliasResultItem(csmNamespaceAlias, bl);
        }
    }

    public static interface CsmItemFactory {
        public CsmResultItem.LocalVariableResultItem createLocalVariableResultItem(CsmVariable var1);

        public CsmResultItem.FieldResultItem createFieldResultItem(CsmField var1);

        public CsmResultItem.EnumeratorResultItem createMemberEnumeratorResultItem(CsmEnumerator var1, int var2, boolean var3);

        public CsmResultItem.MethodResultItem createMethodResultItem(CsmMethod var1, CsmCompletionExpression var2);

        public CsmResultItem.ConstructorResultItem createConstructorResultItem(CsmConstructor var1, CsmCompletionExpression var2);

        public CsmResultItem.ClassResultItem createClassResultItem(CsmClass var1, int var2, boolean var3);

        public CsmResultItem.EnumResultItem createEnumResultItem(CsmEnum var1, int var2, boolean var3);

        public CsmResultItem.TypedefResultItem createTypedefResultItem(CsmTypedef var1, int var2, boolean var3);

        public CsmResultItem.FileLocalVariableResultItem createFileLocalVariableResultItem(CsmVariable var1);

        public CsmResultItem.EnumeratorResultItem createFileLocalEnumeratorResultItem(CsmEnumerator var1, int var2, boolean var3);

        public CsmResultItem.FileLocalFunctionResultItem createFileLocalFunctionResultItem(CsmFunction var1, CsmCompletionExpression var2);

        public CsmResultItem.MacroResultItem createFileLocalMacroResultItem(CsmMacro var1);

        public CsmResultItem.MacroResultItem createFileIncludedProjectMacroResultItem(CsmMacro var1);

        public CsmResultItem.GlobalVariableResultItem createGlobalVariableResultItem(CsmVariable var1);

        public CsmResultItem.EnumeratorResultItem createGlobalEnumeratorResultItem(CsmEnumerator var1, int var2, boolean var3);

        public CsmResultItem.GlobalFunctionResultItem createGlobalFunctionResultItem(CsmFunction var1, CsmCompletionExpression var2);

        public CsmResultItem.MacroResultItem createGlobalMacroResultItem(CsmMacro var1);

        public CsmResultItem.NamespaceResultItem createNamespaceResultItem(CsmNamespace var1, boolean var2);

        public CsmResultItem.NamespaceAliasResultItem createNamespaceAliasResultItem(CsmNamespaceAlias var1, boolean var2);

        public CsmResultItem.ClassResultItem createLibClassResultItem(CsmClass var1, int var2, boolean var3);

        public CsmResultItem.EnumResultItem createLibEnumResultItem(CsmEnum var1, int var2, boolean var3);

        public CsmResultItem.TypedefResultItem createLibTypedefResultItem(CsmTypedef var1, int var2, boolean var3);

        public CsmResultItem.MacroResultItem createFileIncludedLibMacroResultItem(CsmMacro var1);

        public CsmResultItem.MacroResultItem createLibMacroResultItem(CsmMacro var1);

        public CsmResultItem.GlobalVariableResultItem createLibGlobalVariableResultItem(CsmVariable var1);

        public CsmResultItem.EnumeratorResultItem createLibGlobalEnumeratorResultItem(CsmEnumerator var1, int var2, boolean var3);

        public CsmResultItem.GlobalFunctionResultItem createLibGlobalFunctionResultItem(CsmFunction var1, CsmCompletionExpression var2);

        public CsmResultItem.NamespaceResultItem createLibNamespaceResultItem(CsmNamespace var1, boolean var2);

        public CsmResultItem.NamespaceAliasResultItem createLibNamespaceAliasResultItem(CsmNamespaceAlias var1, boolean var2);
    }

    public static class CsmCompletionResult
    extends CompletionQuery.DefaultResult {
        private int classDisplayOffset;
        private CsmCompletionExpression substituteExp;
        private int substituteOffset;
        private int substituteLength;
        private JTextComponent component;
        private BaseDocument baseDocument;
        private boolean simpleVariableExpression;

        public CsmCompletionResult(JTextComponent jTextComponent, BaseDocument baseDocument, List list, String string, CsmCompletionExpression csmCompletionExpression, int n, boolean bl) {
            this(jTextComponent, baseDocument, list, string, csmCompletionExpression, csmCompletionExpression.getTokenOffset(0), csmCompletionExpression.getTokenLength(0), n, bl);
        }

        public CsmCompletionResult(JTextComponent jTextComponent, BaseDocument baseDocument, CompletionResolver.Result result, String string, CsmCompletionExpression csmCompletionExpression, int n, boolean bl) {
            this(jTextComponent, baseDocument, result, string, csmCompletionExpression, csmCompletionExpression.getTokenOffset(0), csmCompletionExpression.getTokenLength(0), n, bl);
        }

        public CsmCompletionResult(JTextComponent jTextComponent, BaseDocument baseDocument, CompletionResolver.Result result, String string, CsmCompletionExpression csmCompletionExpression, int n, int n2, int n3, boolean bl) {
            this(jTextComponent, baseDocument, CsmCompletionQuery.convertData(result, n3, csmCompletionExpression, n), true, string, csmCompletionExpression, n, n2, n3, bl);
        }

        public CsmCompletionResult(JTextComponent jTextComponent, BaseDocument baseDocument, List list, String string, CsmCompletionExpression csmCompletionExpression, int n, int n2, int n3, boolean bl) {
            this(jTextComponent, baseDocument, CsmCompletionQuery.convertData(list, n3, csmCompletionExpression, n), true, string, csmCompletionExpression, n, n2, n3, bl);
        }

        public CsmCompletionResult(JTextComponent jTextComponent, BaseDocument baseDocument, List list, boolean bl, String string, CsmCompletionExpression csmCompletionExpression, int n, int n2, int n3, boolean bl2) {
            super(jTextComponent, bl ? CsmCompletionResult.getTitle(list, string, bl2) : string, list, n, n2);
            this.component = jTextComponent;
            this.baseDocument = baseDocument;
            this.substituteExp = csmCompletionExpression;
            this.substituteOffset = n;
            this.substituteLength = n2;
            this.classDisplayOffset = n3;
        }

        private static String getTitle(List list, String string, boolean bl) {
            if (CsmUtilities.DEBUG) {
                System.out.println("original title (resolved type) was " + string);
            }
            String string2 = NO_SUGGESTIONS;
            if (list != null && list.size() > 0) {
                string2 = string;
            }
            if (bl) {
                string2 = MessageFormat.format(PROJECT_BEEING_PARSED, string2);
            }
            return string2;
        }

        protected JTextComponent getComponent() {
            return this.component;
        }

        protected int getSubstituteLength() {
            return this.substituteLength;
        }

        public int getSubstituteOffset() {
            return this.substituteOffset;
        }

        protected CsmCompletionExpression getSubstituteExp() {
            return this.substituteExp;
        }

        protected int getClassDisplayOffset() {
            return this.classDisplayOffset;
        }

        private void setSimpleVariableExpression(boolean bl) {
            this.simpleVariableExpression = bl;
        }

        public boolean isSimpleVariableExpression() {
            return this.simpleVariableExpression;
        }
    }

    class Context {
        private boolean sort;
        private JTextComponent component;
        private CsmSyntaxSupport sup;
        private boolean openingSource;
        private int endOffset;
        private boolean findType;
        private boolean staticOnly = false;
        private boolean scopeAccessedClassifier = false;
        private CsmNamespace lastNamespace;
        private CsmType lastType;
        private CsmCompletionResult result;
        private boolean isConstructor;
        private CsmFinder finder;
        private CompletionResolver compResolver;
        private CsmOffsetableDeclaration contextElement;

        public Context(JTextComponent jTextComponent, CsmSyntaxSupport csmSyntaxSupport, boolean bl, int n, CsmFinder csmFinder, CompletionResolver completionResolver, CsmOffsetableDeclaration csmOffsetableDeclaration, boolean bl2) {
            this.component = jTextComponent;
            this.sup = csmSyntaxSupport;
            this.openingSource = bl;
            this.endOffset = n;
            this.finder = csmFinder;
            this.compResolver = completionResolver;
            this.contextElement = csmOffsetableDeclaration;
            this.sort = bl2;
        }

        public void setFindType(boolean bl) {
            this.findType = bl;
        }

        protected Object clone() {
            return new Context(this.component, this.sup, this.openingSource, this.endOffset, this.finder, this.compResolver, this.contextElement, this.sort);
        }

        private CsmType resolveType(CsmCompletionExpression csmCompletionExpression) {
            Context context = (Context)this.clone();
            context.setFindType(true);
            CsmType csmType = null;
            if (context.resolveExp(csmCompletionExpression)) {
                csmType = context.lastType;
            }
            return csmType;
        }

        private boolean isProjectBeeingParsed() {
            return CsmCompletionQuery.this.isProjectBeeingParsed(this.openingSource);
        }

        boolean resolveExp(CsmCompletionExpression csmCompletionExpression) {
            boolean bl = false;
            boolean bl2 = true;
            switch (csmCompletionExpression.getExpID()) {
                case 5: 
                case 26: {
                    bl = true;
                }
                case 4: 
                case 25: {
                    int n;
                    int n2 = csmCompletionExpression.getParameterCount();
                    ExprKind exprKind = csmCompletionExpression.getExpID() == 25 || csmCompletionExpression.getExpID() == 26 ? ExprKind.ARROW : ExprKind.DOT;
                    for (n = 0; n < n2 && bl2; ++n) {
                        CsmClassifier csmClassifier;
                        bl2 = this.resolveItem(csmCompletionExpression.getParameter(n), n == 0, !bl && n == n2 - 1, exprKind);
                        if (n != 0 || this.lastType == null || this.lastType.getArrayDepth() != 0 || exprKind != ExprKind.ARROW || (csmClassifier = CsmCompletionQuery.getClassifier(this.lastType, true)) == null) continue;
                        this.lastType = CsmCompletion.getType(csmClassifier, 0);
                    }
                    if (!bl2 || !bl) break;
                    n = csmCompletionExpression.getTokenCount() - 1;
                    int n3 = csmCompletionExpression.getTokenOffset(n) + csmCompletionExpression.getTokenLength(n);
                    if (this.lastType != null) {
                        List<Object> list;
                        CsmCompletion.SimpleClass simpleClass = this.lastType.getArrayDepth() == 0 ? this.lastType.getClassifier() : CsmCompletion.OBJECT_CLASS_ARRAY;
                        if (this.openingSource) {
                            list = new ArrayList<CsmClassifier>();
                            list.add(this.lastType.getClassifier());
                        } else {
                            list = CsmCompletionQuery.findFieldsAndMethods(this.finder, this.contextElement, simpleClass, "", false, this.staticOnly, false, true, this.scopeAccessedClassifier, this.sort);
                        }
                        this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), list, CsmCompletionQuery.formatType(this.lastType, true, true, true), csmCompletionExpression, n3, 0, simpleClass.getName().length() + 1, this.isProjectBeeingParsed());
                        break;
                    }
                    this.result = null;
                    break;
                }
                case 28: {
                    bl = true;
                }
                case 27: {
                    List list;
                    int n;
                    this.staticOnly = true;
                    int n4 = csmCompletionExpression.getParameterCount();
                    for (n = 0; n < n4 && bl2; ++n) {
                        bl2 = this.resolveItem(csmCompletionExpression.getParameter(n), n == 0, !bl && n == n4 - 1, ExprKind.SCOPE);
                    }
                    if (!bl2 || !bl) break;
                    n = csmCompletionExpression.getTokenCount() - 1;
                    int n5 = csmCompletionExpression.getTokenOffset(n) + csmCompletionExpression.getTokenLength(n);
                    if (this.lastType != null) {
                        List list2;
                        CsmCompletion.SimpleClass simpleClass = this.lastType.getArrayDepth() == 0 ? this.lastType.getClassifier() : CsmCompletion.OBJECT_CLASS_ARRAY;
                        if (this.openingSource) {
                            list2 = new ArrayList<CsmClassifier>();
                            list2.add(this.lastType.getClassifier());
                        } else {
                            list2 = CsmCompletionQuery.findFieldsAndMethods(this.finder, this.contextElement, simpleClass, "", false, this.staticOnly, false, true, this.scopeAccessedClassifier, this.sort);
                            List list3 = CsmCompletionQuery.findNestedClassifiers(this.finder, this.contextElement, simpleClass, "", false, true, this.sort);
                            list2.addAll(list3);
                        }
                        this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), list2, CsmCompletionQuery.formatType(this.lastType, true, true, true), csmCompletionExpression, n5, 0, 0, this.isProjectBeeingParsed());
                        break;
                    }
                    String string = (this.lastNamespace.isGlobal() ? "" : this.lastNamespace.getQualifiedName()) + "::";
                    if (this.openingSource) {
                        list = new ArrayList<CsmNamespace>();
                        list.add(this.lastNamespace);
                    } else {
                        list = this.finder.findNestedNamespaces(this.lastNamespace, "", false, false);
                        String string2 = null;
                        try {
                            int n6 = csmCompletionExpression.getTokenOffset(0);
                            int n7 = this.sup.getLastCommandSeparator(n6);
                            if (n7 < 0) {
                                string2 = this.sup.getDocument().getText(0, n6);
                                n7 = string2.lastIndexOf(10);
                                if (n7 != -1) {
                                    string2 = string2.substring(n7 + 1);
                                }
                            } else {
                                string2 = this.sup.getDocument().getText(n7, n6 - n7);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        if (string2 != null && -1 == string2.indexOf("namespace")) {
                            list.addAll(this.finder.findNamespaceElements(this.lastNamespace, "", false, false));
                        }
                    }
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), list, string + '*', csmCompletionExpression, n5, 0, 0, this.isProjectBeeingParsed());
                    break;
                }
                case 15: {
                    List list = this.finder.findClasses(null, "", false, false);
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), list, "*", csmCompletionExpression, this.endOffset, 0, 0, this.isProjectBeeingParsed());
                    break;
                }
                case 24: {
                    csmCompletionExpression = csmCompletionExpression.getParameter(0);
                }
                default: {
                    bl2 = this.resolveItem(csmCompletionExpression, true, true, ExprKind.NONE);
                }
            }
            return bl2;
        }

        boolean resolveItem(CsmCompletionExpression csmCompletionExpression, boolean bl, boolean bl2, ExprKind exprKind) {
            boolean bl3 = true;
            boolean bl4 = false;
            block0 : switch (csmCompletionExpression.getExpID()) {
                case 0: {
                    if (bl) {
                        this.lastType = CsmCompletion.getPredefinedType(csmCompletionExpression.getType());
                        this.staticOnly = false;
                        break;
                    }
                    bl3 = false;
                    break;
                }
                case 1: {
                    switch (csmCompletionExpression.getTokenID(0).getNumericID()) {
                        case 123: {
                            if (bl) {
                                CsmClass csmClass = this.sup.getClass(csmCompletionExpression.getTokenOffset(0));
                                if (csmClass == null) break block0;
                                this.lastType = CsmCompletion.getType((CsmClassifier)csmClass, 0);
                                this.staticOnly = false;
                                break;
                            }
                            this.staticOnly = false;
                            break;
                        }
                        default: {
                            String string = csmCompletionExpression.getTokenText(0);
                            int n = csmCompletionExpression.getTokenOffset(0);
                            if (bl) {
                                CompletionResolver.Result result;
                                if (bl2 && !this.findType) {
                                    CompletionResolver.Result result2 = null;
                                    this.compResolver.setResolveTypes(1);
                                    if (this.compResolver.refresh() && this.compResolver.resolve(n, string, this.openingSource)) {
                                        result2 = this.compResolver.getResult();
                                    }
                                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), result2, string + '*', csmCompletionExpression, 0, this.isProjectBeeingParsed());
                                    break;
                                }
                                if (exprKind != ExprKind.SCOPE) {
                                    this.lastType = (CsmType)this.sup.findType(string, n);
                                    if (this.lastType == null) {
                                        result = null;
                                        this.compResolver.setResolveTypes(660);
                                        if (this.compResolver.refresh() && this.compResolver.resolve(n, string, true)) {
                                            result = this.compResolver.getResult();
                                        }
                                        ArrayList arrayList = new ArrayList();
                                        result.addResulItemsToCol(arrayList);
                                        if (arrayList.size() > 0) {
                                            CsmVariable csmVariable = (CsmVariable)arrayList.get(0);
                                            this.lastType = csmVariable.getType();
                                        }
                                    }
                                }
                                if (this.lastType != null) {
                                    this.staticOnly = false;
                                    break;
                                }
                                if (exprKind != ExprKind.SCOPE && exprKind != ExprKind.NONE) break block0;
                                this.scopeAccessedClassifier = exprKind == ExprKind.SCOPE;
                                CsmNamespace csmNamespace = this.lastNamespace = exprKind != ExprKind.SCOPE ? null : this.finder.getExactNamespace(string);
                                if (this.lastNamespace != null) break block0;
                                result = this.sup.getClassFromName(string, true);
                                if (result == null) {
                                    if (exprKind == ExprKind.SCOPE) {
                                        this.lastNamespace = this.findExactNamespace(string, n);
                                    }
                                    if (this.lastNamespace == null && (result = this.findExactClass(string, n)) == null) {
                                        bl3 = false;
                                    }
                                }
                                if (result == null) break block0;
                                this.lastType = CsmCompletion.getType((CsmClassifier)result, 0);
                                break;
                            }
                            if (this.lastType != null) {
                                if (this.findType || !bl2) {
                                    CsmClassifier csmClassifier;
                                    boolean bl5 = false;
                                    int n2 = this.lastType.getArrayDepth();
                                    if (this.staticOnly && n2 == 0 && (csmClassifier = this.finder.getExactClassifier(this.lastType.getClassifier().getQualifiedName() + "::" + string)) != null) {
                                        this.lastType = CsmCompletion.getType(csmClassifier, 0);
                                        bl5 = true;
                                    }
                                    if (bl5) break block0;
                                    if (n2 == 0) {
                                        csmClassifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)this.lastType.getClassifier());
                                        if (CsmKindUtilities.isClass((CsmObject)csmClassifier)) {
                                            CsmClass csmClass = (CsmClass)csmClassifier;
                                            List list = this.finder.findFields((CsmOffsetableDeclaration)csmClass, csmClass, string, true, this.staticOnly, true, true, this.scopeAccessedClassifier, this.sort);
                                            if (list != null && list.size() > 0) {
                                                CsmField csmField = (CsmField)list.get(0);
                                                this.lastType = csmField.getType();
                                                this.staticOnly = false;
                                                break;
                                            }
                                            this.lastType = null;
                                            bl3 = false;
                                            break;
                                        }
                                        this.lastType = null;
                                        bl3 = false;
                                        break;
                                    }
                                    bl3 = false;
                                    break;
                                }
                                CsmCompletion.SimpleClass simpleClass = this.lastType.getArrayDepth() == 0 ? this.lastType.getClassifier() : CsmCompletion.OBJECT_CLASS_ARRAY;
                                List list = CsmCompletionQuery.findFieldsAndMethods(this.finder, this.contextElement, simpleClass, string, false, this.staticOnly, false, true, this.scopeAccessedClassifier, this.sort);
                                List list2 = CsmCompletionQuery.findNestedClassifiers(this.finder, this.contextElement, simpleClass, string, false, true, this.sort);
                                list.addAll(list2);
                                this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), list, CsmCompletionQuery.formatType(this.lastType, true, true, false) + string + '*', csmCompletionExpression, 0, this.isProjectBeeingParsed());
                                break;
                            }
                            String string2 = (this.lastNamespace.isGlobal() ? "" : this.lastNamespace.getQualifiedName() + "::") + string;
                            if (this.findType || !bl2) {
                                CsmNamespace csmNamespace;
                                List list = this.finder.findNestedNamespaces(this.lastNamespace, string, true, false);
                                CsmNamespace csmNamespace2 = csmNamespace = list.isEmpty() ? null : (CsmNamespace)list.get(0);
                                if (csmNamespace != null) {
                                    this.lastNamespace = csmNamespace;
                                    this.lastType = null;
                                    break;
                                }
                                list = this.finder.findNamespaceElements(this.lastNamespace, string, true, false);
                                CsmObject csmObject = list.isEmpty() ? null : (CsmObject)list.iterator().next();
                                this.lastType = CsmCompletion.getObjectType(csmObject);
                                bl3 = this.lastType != null;
                                this.lastNamespace = null;
                                break;
                            }
                            if (!bl2) break block0;
                            List list = this.finder.findNestedNamespaces(this.lastNamespace, string, this.openingSource, false);
                            list.addAll(this.finder.findNamespaceElements(this.lastNamespace, string, this.openingSource, false));
                            this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), list, string2 + '*', csmCompletionExpression, 0, this.isProjectBeeingParsed());
                            break;
                        }
                    }
                    break;
                }
                case 7: {
                    bl3 = this.resolveItem(csmCompletionExpression.getParameter(0), bl, false, ExprKind.NONE);
                    if (!bl3) break;
                    bl3 = false;
                    if (this.lastType == null) break;
                    if (csmCompletionExpression.getParameterCount() == 2) {
                        CsmFunction csmFunction;
                        CsmClassifier csmClassifier;
                        if (this.lastType.getArrayDepth() == 0 && (csmClassifier = CsmCompletionQuery.getClassifier(this.lastType, false)) != null && (csmFunction = CsmBaseUtilities.getOperator((CsmClassifier)csmClassifier, (CsmFunction.OperatorKind)CsmFunction.OperatorKind.ARRAY)) != null) {
                            this.lastType = csmFunction.getReturnType();
                        }
                        this.lastType = CsmCompletion.getType(this.lastType.getClassifier(), Math.max(this.lastType.getArrayDepth() - 1, 0));
                        bl3 = true;
                        break;
                    }
                    this.lastType = CsmCompletion.getType(this.lastType.getClassifier(), this.lastType.getArrayDepth() + 1);
                    bl3 = true;
                    break;
                }
                case 16: {
                    this.lastType = CsmCompletion.BOOLEAN_TYPE;
                    break;
                }
                case 17: {
                    Object object = this.resolveType(csmCompletionExpression.getParameter(0));
                    if (object != null) {
                        this.lastType = object;
                        break;
                    }
                }
                case 2: 
                case 18: {
                    Object object = null;
                    CsmClass csmClass = this.sup.getClass(csmCompletionExpression.getTokenOffset(0));
                    this.compResolver.setResolveTypes(1);
                    if (this.compResolver.refresh() && this.compResolver.resolve(csmCompletionExpression.getTokenOffset(0), "", this.openingSource)) {
                        object = this.compResolver.getResult();
                    }
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), (CompletionResolver.Result)object, "*", csmCompletionExpression, this.endOffset, 0, 0, this.isProjectBeeingParsed());
                    switch (csmCompletionExpression.getTokenID(0).getNumericID()) {
                        case 22: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: {
                            if (csmCompletionExpression.getParameterCount() <= 0) break;
                            this.lastType = this.resolveType(csmCompletionExpression.getParameter(0));
                            this.staticOnly = false;
                            break;
                        }
                        case 23: 
                        case 24: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 52: 
                        case 68: 
                        case 69: {
                            this.lastType = CsmCompletion.BOOLEAN_TYPE;
                            break;
                        }
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: {
                            switch (csmCompletionExpression.getParameterCount()) {
                                case 2: {
                                    CsmType csmType = this.resolveType(csmCompletionExpression.getParameter(0));
                                    CsmType csmType2 = this.resolveType(csmCompletionExpression.getParameter(1));
                                    if (csmType == null || csmType2 == null || csmType.getArrayDepth() != 0 || csmType2.getArrayDepth() != 0 || !CsmCompletion.isPrimitiveClass(csmType.getClassifier()) || !CsmCompletion.isPrimitiveClass(csmType2.getClassifier())) break;
                                    this.lastType = this.sup.getCommonType(csmType, csmType2);
                                    break;
                                }
                                case 1: {
                                    CsmType csmType = this.resolveType(csmCompletionExpression.getParameter(0));
                                    if (csmType == null || !CsmCompletion.isPrimitiveClass(csmType.getClassifier())) break;
                                    this.lastType = csmType;
                                }
                            }
                            break;
                        }
                        case 56: {
                            switch (csmCompletionExpression.getParameterCount()) {
                                case 2: {
                                    CsmType csmType = this.resolveType(csmCompletionExpression.getParameter(0));
                                    CsmType csmType3 = this.resolveType(csmCompletionExpression.getParameter(1));
                                    if (csmType == null || csmType3 == null) break;
                                    this.lastType = this.sup.getCommonType(csmType, csmType3);
                                    break;
                                }
                                case 1: {
                                    this.lastType = this.resolveType(csmCompletionExpression.getParameter(0));
                                }
                            }
                            break;
                        }
                        case 59: {
                            if (csmCompletionExpression.getParameterCount() < 2) break;
                            this.lastType = this.resolveType(csmCompletionExpression.getParameter(1));
                        }
                    }
                    break;
                }
                case 3: {
                    if (csmCompletionExpression.getParameterCount() <= 0) break;
                    this.lastType = this.resolveType(csmCompletionExpression.getParameter(0));
                    this.staticOnly = false;
                    break;
                }
                case 32: {
                    if (csmCompletionExpression.getParameterCount() <= 0) break;
                    this.lastType = this.resolveType(csmCompletionExpression.getParameter(0));
                    this.staticOnly = false;
                    break;
                }
                case 13: {
                    this.lastType = this.resolveType(csmCompletionExpression.getParameter(0));
                    this.staticOnly = false;
                    break;
                }
                case 31: {
                    if (csmCompletionExpression.getParameterCount() <= 0) break;
                    CsmCompletionExpression csmCompletionExpression2 = csmCompletionExpression.getParameter(0);
                    this.lastType = this.resolveType(csmCompletionExpression2);
                    this.staticOnly = false;
                    break;
                }
                case 14: {
                    int n;
                    if (this.findType) {
                        this.lastType = CsmCompletion.getPredefinedType(csmCompletionExpression.getType());
                    }
                    if (this.findType && this.lastType != null || (n = csmCompletionExpression.getTokenCount()) <= 1) break;
                    String string = csmCompletionExpression.getTokenText(n - 1);
                    int n3 = csmCompletionExpression.getTokenOffset(n - 1);
                    this.compResolver.setResolveTypes(66);
                    if (!this.compResolver.refresh() || !this.compResolver.resolve(n3, string, false)) break;
                    CompletionResolver.Result result = this.compResolver.getResult();
                    if (this.findType) {
                        CsmClassifier csmClassifier = null;
                        Iterator<CsmClassifier> iterator = result.getProjectClassesifiersEnums().iterator();
                        if (!iterator.hasNext()) {
                            iterator = result.getLibClassifiersEnums().iterator();
                        }
                        if (iterator.hasNext()) {
                            csmClassifier = iterator.next();
                        }
                        if (csmClassifier != null) {
                            this.lastType = CsmCompletion.getType(csmClassifier, 0);
                        }
                    }
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), result, string + '*', csmCompletionExpression, n3, 0, 0, this.isProjectBeeingParsed());
                    break;
                }
                case 9: {
                    bl3 = this.resolveItem(csmCompletionExpression.getParameter(0), bl, bl2, exprKind);
                    break;
                }
                case 12: {
                    this.isConstructor = true;
                    bl3 = this.resolveExp(csmCompletionExpression.getParameter(0));
                    this.staticOnly = false;
                    break;
                }
                case 10: {
                    bl4 = true;
                }
                case 11: {
                    Object object;
                    CsmCompletionExpression csmCompletionExpression3 = csmCompletionExpression.getParameter(0);
                    String string = csmCompletionExpression3.getTokenText(0);
                    if (this.isConstructor) {
                        object = null;
                        if (bl) {
                            object = this.sup.getClassFromName(string, true);
                        }
                        if (object != null) {
                            this.lastType = CsmCompletion.getType((CsmClassifier)object, 0);
                        } else {
                            this.isConstructor = false;
                        }
                    }
                    if (!bl4 || this.openingSource) {
                        CsmCompletion.SimpleClass simpleClass;
                        object = new ArrayList();
                        if (bl && (!this.isConstructor || this.lastType == null)) {
                            int n = csmCompletionExpression3.getTokenOffset(0);
                            this.compResolver.setResolveTypes(4195368);
                            if (this.compResolver.refresh() && this.compResolver.resolve(n, string, true)) {
                                this.compResolver.getResult().addResulItemsToCol((Collection)object);
                            }
                        } else if (this.lastType != null && CsmKindUtilities.isClass((CsmObject)(simpleClass = this.lastType.getArrayDepth() == 0 ? CsmBaseUtilities.getOriginalClassifier((CsmClassifier)this.lastType.getClassifier()) : CsmCompletion.OBJECT_CLASS_ARRAY))) {
                            object = this.finder.findMethods(this.contextElement, (CsmClass)simpleClass, string, true, false, bl, true, this.scopeAccessedClassifier, this.sort);
                        }
                        if (object == null || object.size() == 0) {
                            this.lastType = null;
                            return false;
                        }
                        String string3 = "*";
                        List list = this.getTypeList(csmCompletionExpression, 1);
                        List list3 = this.sup.filterMethods((List)object, list, bl4);
                        if (list3.size() > 0) {
                            object = list3;
                            string3 = CsmCompletionQuery.formatTypeList(list, bl4);
                        }
                        if (object.size() > 0) {
                            if (bl2 && !this.findType) {
                                this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), (List)object, CsmCompletionQuery.formatType(this.lastType, true, true, false) + string + '(' + string3 + ')', csmCompletionExpression, this.endOffset, 0, 0, this.isProjectBeeingParsed());
                                break;
                            }
                            if (object.size() <= 0) break;
                            CsmFunction csmFunction = (CsmFunction)object.get(0);
                            if (CsmKindUtilities.isConstructor((CsmObject)csmFunction)) {
                                CsmClass csmClass = ((CsmConstructor)csmFunction).getContainingClass();
                                this.lastType = CsmCompletion.getType((CsmClassifier)csmClass, 0);
                            } else {
                                this.lastType = csmFunction.getReturnType();
                            }
                            this.staticOnly = false;
                            break;
                        }
                        this.lastType = null;
                        bl3 = false;
                        break;
                    }
                    int n = this.endOffset;
                    this.compResolver.setResolveTypes(1);
                    if (!this.compResolver.refresh() || !this.compResolver.resolve(n, "", false)) break;
                    CompletionResolver.Result result = this.compResolver.getResult();
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), result, string + '*', csmCompletionExpression3, n, 0, 0, this.isProjectBeeingParsed());
                }
            }
            if (this.lastType == null && this.lastNamespace == null) {
                bl3 = false;
            }
            return bl3;
        }

        private CsmNamespace findExactNamespace(String string, int n) {
            CsmNamespace csmNamespace = null;
            this.compResolver.setResolveTypes(262144);
            if (this.compResolver.refresh() && this.compResolver.resolve(n, string, true)) {
                CompletionResolver.Result result = this.compResolver.getResult();
                Iterator<CsmNamespace> iterator = result.getGlobalProjectNamespaces().iterator();
                CsmNamespace csmNamespace2 = csmNamespace = iterator.hasNext() ? iterator.next() : null;
                if (csmNamespace == null) {
                    CsmNamespaceAlias csmNamespaceAlias;
                    iterator = result.getProjectNamespaceAliases().iterator();
                    CsmNamespaceAlias csmNamespaceAlias2 = csmNamespaceAlias = iterator.hasNext() ? (CsmNamespaceAlias)iterator.next() : null;
                    if (csmNamespaceAlias != null) {
                        csmNamespace = csmNamespaceAlias.getReferencedNamespace();
                    }
                }
            }
            return csmNamespace;
        }

        private CsmClass findExactClass(String string, int n) {
            CsmClass csmClass = null;
            this.compResolver.setResolveTypes(2);
            if (this.compResolver.refresh() && this.compResolver.resolve(n, string, true)) {
                CompletionResolver.Result result = this.compResolver.getResult();
                for (CsmObject csmObject : result.getProjectClassesifiersEnums()) {
                    if (!CsmKindUtilities.isClass((CsmObject)csmObject)) continue;
                    csmClass = (CsmClass)csmObject;
                    break;
                }
            }
            return csmClass;
        }

        private List getTypeList(CsmCompletionExpression csmCompletionExpression, int n) {
            int n2 = csmCompletionExpression.getParameterCount();
            ArrayList<CsmType> arrayList = new ArrayList<CsmType>();
            if (n2 > n) {
                for (int i = n; i < n2; ++i) {
                    CsmCompletionExpression csmCompletionExpression2 = csmCompletionExpression.getParameter(i);
                    CsmType csmType = this.resolveType(csmCompletionExpression2);
                    arrayList.add(csmType);
                }
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ExprKind {
        NONE,
        SCOPE,
        ARROW,
        DOT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueryScope {
        LOCAL_QUERY,
        SMART_QUERY,
        GLOBAL_QUERY;

    }
}

