/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.util.ArrayList;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.TokenID;
import org.netbeans.modules.cnd.editor.cplusplus.CCTokenContext;

public class CsmCompletionExpression {
    private static final int INVALID = -1;
    public static final int CONSTANT = 0;
    public static final int VARIABLE = 1;
    public static final int OPERATOR = 2;
    public static final int UNARY_OPERATOR = 3;
    public static final int DOT = 4;
    public static final int DOT_OPEN = 5;
    public static final int ARRAY_OPEN = 6;
    public static final int ARRAY = 7;
    public static final int PARENTHESIS_OPEN = 8;
    public static final int PARENTHESIS = 9;
    public static final int METHOD_OPEN = 10;
    public static final int METHOD = 11;
    public static final int CONSTRUCTOR = 12;
    public static final int CONVERSION = 13;
    public static final int TYPE = 14;
    public static final int NEW = 15;
    public static final int INSTANCEOF = 16;
    public static final int GENERIC_TYPE = 17;
    public static final int GENERIC_TYPE_OPEN = 18;
    public static final int GENERIC_WILD_CHAR = 19;
    public static final int ANNOTATION = 20;
    public static final int ANNOTATION_OPEN = 21;
    public static final int CPPINCLUDE = 22;
    public static final int CPPINCLUDE_NEXT = 23;
    public static final int CASE = 24;
    public static final int ARROW = 25;
    public static final int ARROW_OPEN = 26;
    public static final int SCOPE = 27;
    public static final int SCOPE_OPEN = 28;
    public static final int TYPE_PREFIX = 29;
    public static final int TYPE_POSTFIX = 30;
    public static final int TYPE_REFERENCE = 31;
    public static final int MEMBER_POINTER = 32;
    public static final int MEMBER_POINTER_OPEN = 33;
    private static final int LAST_ID = 33;
    private static final int cppTokenIDsLength = CCTokenContext.context.getTokenIDs().length;
    private static final int[] OP = new int[cppTokenIDsLength + 33 + 1];
    private static final int RIGHT_ASSOCIATIVE = 32;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private CsmCompletionExpression parent;
    private int expID;
    private String type;
    private int tokenCountM3;
    private Object[] tokenBlocks = EMPTY_OBJECT_ARRAY;
    private ArrayList prmList;

    CsmCompletionExpression(int n) {
        if (n < 0 || n > 33) {
            throw new IllegalArgumentException("expID=" + n);
        }
        this.expID = n;
    }

    static CsmCompletionExpression createEmptyVariable(int n) {
        CsmCompletionExpression csmCompletionExpression = new CsmCompletionExpression(1);
        csmCompletionExpression.addToken((TokenID)CCTokenContext.IDENTIFIER, n, "");
        return csmCompletionExpression;
    }

    static int getOperatorID(TokenID tokenID) {
        int n = -1;
        if (tokenID.getCategory() == CCTokenContext.OPERATORS) {
            n = tokenID.getNumericID();
        } else {
            switch (tokenID.getNumericID()) {
                case 112: {
                    n = cppTokenIDsLength + 15;
                }
            }
        }
        return n;
    }

    static int getOperatorID(CsmCompletionExpression csmCompletionExpression) {
        int n = csmCompletionExpression != null ? csmCompletionExpression.getExpID() : -1;
        switch (n) {
            case 2: {
                return csmCompletionExpression.getTokenID(0).getNumericID();
            }
        }
        return cppTokenIDsLength + n;
    }

    static int getOperatorPrecedence(int n) {
        return OP[n] & 0x1F;
    }

    static boolean isOperatorRightAssociative(int n) {
        return (OP[n] & 0x20) != 0;
    }

    static boolean isValidType(CsmCompletionExpression csmCompletionExpression) {
        switch (csmCompletionExpression.getExpID()) {
            case 7: {
                if (csmCompletionExpression.getParameterCount() == 1) {
                    return CsmCompletionExpression.isValidType(csmCompletionExpression.getParameter(0));
                }
                return false;
            }
            case 29: 
            case 30: 
            case 31: {
                if (csmCompletionExpression.getParameterCount() >= 1) {
                    return CsmCompletionExpression.isValidType(csmCompletionExpression.getParameter(0));
                }
                return false;
            }
            case 4: 
            case 25: 
            case 27: {
                int n = csmCompletionExpression.getParameterCount();
                for (int i = 0; i < n; ++i) {
                    if (csmCompletionExpression.getParameter(i).getExpID() == 1) continue;
                    return false;
                }
                return true;
            }
            case 1: 
            case 14: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public int getExpID() {
        return this.expID;
    }

    void setExpID(int n) {
        this.expID = n;
    }

    public CsmCompletionExpression getParent() {
        return this.parent;
    }

    void setParent(CsmCompletionExpression csmCompletionExpression) {
        this.parent = csmCompletionExpression;
    }

    public String getType() {
        return this.type;
    }

    void setType(String string) {
        this.type = string;
    }

    public int getTokenCount() {
        return this.tokenCountM3 / 3;
    }

    public String getTokenText(int n) {
        return (String)this.tokenBlocks[(n *= 3) + 2];
    }

    public int getTokenOffset(int n) {
        return (Integer)this.tokenBlocks[(n *= 3) + 1];
    }

    public int getTokenLength(int n) {
        return ((String)this.tokenBlocks[(n *= 3) + 2]).length();
    }

    public TokenID getTokenID(int n) {
        return (TokenID)this.tokenBlocks[n *= 3];
    }

    void addToken(TokenID tokenID, int n, String string) {
        if (this.tokenCountM3 == this.tokenBlocks.length) {
            Object[] objectArray = new Object[Math.max(3, this.tokenBlocks.length * 2)];
            if (this.tokenBlocks.length > 0) {
                System.arraycopy(this.tokenBlocks, 0, objectArray, 0, this.tokenBlocks.length);
            }
            this.tokenBlocks = objectArray;
        }
        this.tokenBlocks[this.tokenCountM3++] = tokenID;
        this.tokenBlocks[this.tokenCountM3++] = new Integer(n);
        this.tokenBlocks[this.tokenCountM3++] = string;
    }

    public int getParameterCount() {
        return this.prmList != null ? this.prmList.size() : 0;
    }

    public CsmCompletionExpression getParameter(int n) {
        return (CsmCompletionExpression)this.prmList.get(n);
    }

    void addParameter(CsmCompletionExpression csmCompletionExpression) {
        if (this.prmList == null) {
            this.prmList = new ArrayList();
        }
        csmCompletionExpression.setParent(this);
        this.prmList.add(csmCompletionExpression);
    }

    void swapOperatorParms() {
        if ((this.expID == 2 || this.expID == 16) && this.getParameterCount() == 2) {
            CsmCompletionExpression csmCompletionExpression = (CsmCompletionExpression)this.prmList.remove(0);
            this.prmList.add(csmCompletionExpression);
            csmCompletionExpression.swapOperatorParms();
            ((CsmCompletionExpression)this.prmList.get(0)).swapOperatorParms();
        }
    }

    private static void appendSpaces(StringBuilder stringBuilder, int n) {
        while (--n >= 0) {
            stringBuilder.append(' ');
        }
    }

    static String getIDName(int n) {
        switch (n) {
            case 0: {
                return "CONSTANT";
            }
            case 1: {
                return "VARIABLE";
            }
            case 2: {
                return "OPERATOR";
            }
            case 3: {
                return "UNARY_OPERATOR";
            }
            case 4: {
                return "DOT";
            }
            case 5: {
                return "DOT_OPEN";
            }
            case 25: {
                return "ARROW";
            }
            case 26: {
                return "ARROW_OPEN";
            }
            case 27: {
                return "SCOPE";
            }
            case 28: {
                return "SCOPE_OPEN";
            }
            case 7: {
                return "ARRAY";
            }
            case 6: {
                return "ARRAY_OPEN";
            }
            case 8: {
                return "PARENTHESIS_OPEN";
            }
            case 9: {
                return "PARENTHESIS";
            }
            case 10: {
                return "METHOD_OPEN";
            }
            case 11: {
                return "METHOD";
            }
            case 12: {
                return "CONSTRUCTOR";
            }
            case 13: {
                return "CONVERSION";
            }
            case 14: {
                return "TYPE";
            }
            case 15: {
                return "NEW";
            }
            case 16: {
                return "INSTANCEOF";
            }
            case 17: {
                return "GENERIC_TYPE";
            }
            case 18: {
                return "GENERIC_TYPE_OPEN";
            }
            case 19: {
                return "GENERIC_WILD_CHAR";
            }
            case 20: {
                return "ANNOTATION";
            }
            case 21: {
                return "ANNOTATION_OPEN";
            }
            case 22: {
                return "INCLUDE";
            }
            case 24: {
                return "CASE";
            }
            case 29: {
                return "TYPE_PREFIX";
            }
            case 30: {
                return "TYPE_POSTFIX";
            }
            case 31: {
                return "TYPE_REFERENCE";
            }
            case 32: {
                return "MEMBER_POINTER";
            }
            case 33: {
                return "MEMBER_POINTER_OPEN";
            }
        }
        return "Unknown expID " + n;
    }

    public String toString(int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        CsmCompletionExpression.appendSpaces(stringBuilder, n);
        stringBuilder.append("expID=" + CsmCompletionExpression.getIDName(this.expID));
        if (this.type != null) {
            stringBuilder.append(", result type=");
            stringBuilder.append(this.type);
        }
        int n3 = this.getTokenCount();
        stringBuilder.append(", token count=");
        stringBuilder.append(n3);
        if (n3 > 0) {
            n2 = 0;
            while (n2 < this.tokenCountM3) {
                TokenID tokenID = (TokenID)this.tokenBlocks[n2++];
                int n4 = (Integer)this.tokenBlocks[n2++];
                String string = (String)this.tokenBlocks[n2++];
                stringBuilder.append(", token" + (n2 / 3 - 1) + "='" + EditorDebug.debugString((String)string) + "'");
            }
        }
        n2 = this.getParameterCount();
        stringBuilder.append(", parm count=");
        stringBuilder.append(n2);
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append('\n');
                CsmCompletionExpression.appendSpaces(stringBuilder, n + 4);
                stringBuilder.append("parm" + i + "=[" + this.getParameter(i).toString(n + 4) + "]");
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    static {
        CsmCompletionExpression.OP[22] = 34;
        CsmCompletionExpression.OP[23] = 10;
        CsmCompletionExpression.OP[24] = 10;
        CsmCompletionExpression.OP[25] = 11;
        CsmCompletionExpression.OP[26] = 11;
        CsmCompletionExpression.OP[27] = 12;
        CsmCompletionExpression.OP[28] = 12;
        CsmCompletionExpression.OP[29] = 13;
        CsmCompletionExpression.OP[30] = 13;
        CsmCompletionExpression.OP[31] = 8;
        CsmCompletionExpression.OP[32] = 6;
        CsmCompletionExpression.OP[33] = 7;
        CsmCompletionExpression.OP[34] = 13;
        CsmCompletionExpression.OP[35] = 15;
        CsmCompletionExpression.OP[36] = 15;
        CsmCompletionExpression.OP[37] = 9;
        CsmCompletionExpression.OP[38] = 10;
        CsmCompletionExpression.OP[39] = 10;
        CsmCompletionExpression.OP[40] = 34;
        CsmCompletionExpression.OP[41] = 34;
        CsmCompletionExpression.OP[42] = 34;
        CsmCompletionExpression.OP[43] = 34;
        CsmCompletionExpression.OP[46] = 34;
        CsmCompletionExpression.OP[47] = 34;
        CsmCompletionExpression.OP[48] = 34;
        CsmCompletionExpression.OP[49] = 34;
        CsmCompletionExpression.OP[50] = 34;
        CsmCompletionExpression.OP[51] = 34;
        CsmCompletionExpression.OP[52] = 9;
        CsmCompletionExpression.OP[53] = 16;
        CsmCompletionExpression.OP[54] = 14;
        CsmCompletionExpression.OP[44] = 16;
        CsmCompletionExpression.OP[45] = 14;
        CsmCompletionExpression.OP[57] = 18;
        CsmCompletionExpression.OP[56] = 35;
        CsmCompletionExpression.OP[59] = 35;
        CsmCompletionExpression.OP[62] = 16;
        CsmCompletionExpression.OP[63] = 0;
        CsmCompletionExpression.OP[66] = 16;
        CsmCompletionExpression.OP[67] = 16;
        CsmCompletionExpression.OP[68] = 5;
        CsmCompletionExpression.OP[69] = 4;
        CsmCompletionExpression.OP[55] = 0;
        CsmCompletionExpression.OP[58] = 0;
        CsmCompletionExpression.OP[60] = 17;
        CsmCompletionExpression.OP[61] = 0;
        CsmCompletionExpression.OP[64] = 0;
        CsmCompletionExpression.OP[65] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + -1] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 0] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 1] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 3] = 15;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 4] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 5] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 25] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 26] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 27] = 17;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 28] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 6] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 7] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 8] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 9] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 10] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 11] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 12] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 13] = 47;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 14] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 15] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 16] = 10;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 22] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 33] = 0;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 32] = 47;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 31] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 30] = 1;
        CsmCompletionExpression.OP[CsmCompletionExpression.cppTokenIDsLength + 29] = 1;
        EMPTY_OBJECT_ARRAY = new Object[0];
    }
}

