/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.CompletionView;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ListCompletionView;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCellRenderer;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmFinder;
import org.netbeans.modules.cnd.editor.cplusplus.CCTokenContext;

public abstract class CsmCompletion
extends Completion {
    public static final int PUBLIC_LEVEL = 3;
    public static final int PROTECTED_LEVEL = 2;
    public static final int PACKAGE_LEVEL = 1;
    public static final int PRIVATE_LEVEL = 0;
    public static final SimpleClass BOOLEAN_CLASS;
    public static final SimpleClass BYTE_CLASS;
    public static final SimpleClass CHAR_CLASS;
    public static final SimpleClass DOUBLE_CLASS;
    public static final SimpleClass FLOAT_CLASS;
    public static final SimpleClass INT_CLASS;
    public static final SimpleClass LONG_CLASS;
    public static final SimpleClass SHORT_CLASS;
    public static final SimpleClass VOID_CLASS;
    public static final BaseType BOOLEAN_TYPE;
    public static final BaseType BYTE_TYPE;
    public static final BaseType CHAR_TYPE;
    public static final BaseType DOUBLE_TYPE;
    public static final BaseType FLOAT_TYPE;
    public static final BaseType INT_TYPE;
    public static final BaseType LONG_TYPE;
    public static final BaseType SHORT_TYPE;
    public static final BaseType VOID_TYPE;
    public static final SimpleClass INVALID_CLASS;
    public static final BaseType INVALID_TYPE;
    public static final SimpleClass NULL_CLASS;
    public static final BaseType NULL_TYPE;
    public static final SimpleClass OBJECT_CLASS_ARRAY;
    public static final BaseType OBJECT_TYPE_ARRAY;
    public static final SimpleClass OBJECT_CLASS;
    public static final BaseType OBJECT_TYPE;
    public static final SimpleClass CLASS_CLASS;
    public static final BaseType CLASS_TYPE;
    public static final SimpleClass STRING_CLASS;
    public static final BaseType STRING_TYPE;
    public static final SimpleClass CONST_STRING_CLASS;
    public static final BaseType CONST_STRING_TYPE;
    static final int INTERFACE_BIT = 0x40000000;
    public static final int LOCAL_MEMBER_BIT = 0x20000000;
    public static final int DEPRECATED_BIT = 0x100000;
    private static final HashMap str2PrimitiveClass;
    private static final HashMap str2PrimitiveType;
    private static final HashMap str2PredefinedType;
    public static final CsmParameter[] EMPTY_PARAMETERS;
    public static final CsmClassifier[] EMPTY_CLASSES;
    public static final CsmNamespace[] EMPTY_NAMESPACES;
    public static final CsmField[] EMPTY_FIELDS;
    public static final CsmConstructor[] EMPTY_CONSTRUCTORS;
    public static final CsmMethod[] EMPTY_METHODS;
    public static final String SCOPE = "::";
    private static CsmFinder finder;
    private static int debugMode;
    private static HashMap typeCache;
    public static final int DEBUG_EXP = 1;
    public static final int DEBUG_FIND = 2;
    private static CsmFinderInitializer initializer;

    public static synchronized CsmFinder getFinder() {
        if (finder == null) {
            if (initializer == null) {
                throw new IllegalStateException("Editor: Java completion can't be initialized.");
            }
            initializer.initCsmFinder();
        }
        return finder;
    }

    public static synchronized void setFinder(CsmFinder csmFinder) {
        finder = csmFinder;
    }

    public CsmCompletion(ExtEditorUI extEditorUI) {
        super(extEditorUI);
    }

    protected CompletionView createView() {
        return new ListCompletionView((ListCellRenderer)new CsmCellRenderer());
    }

    protected abstract CompletionQuery createQuery();

    public static int getLevel(int n) {
        if ((n & 1) != 0) {
            return 3;
        }
        if ((n & 4) != 0) {
            return 2;
        }
        if ((n & 2) == 0) {
            return 1;
        }
        return 0;
    }

    public static boolean isPrimitiveClassName(String string) {
        return CCTokenContext.isTypeOrVoid((String)string);
    }

    public static boolean isPrimitiveClass(CsmClassifier csmClassifier) {
        return CsmCompletion.isPrimitiveClassName(((Object)csmClassifier.getName()).toString());
    }

    public static CsmClassifier getPrimitiveClass(String string) {
        return (CsmClassifier)str2PrimitiveClass.get(string);
    }

    public static CsmType getPrimitiveType(String string) {
        return (CsmType)str2PrimitiveType.get(string);
    }

    public static CsmType getPredefinedType(String string) {
        CsmType csmType = CsmCompletion.getPrimitiveType(string);
        if (csmType == null) {
            csmType = (CsmType)str2PredefinedType.get(string);
        }
        return csmType;
    }

    public static Iterator getPrimitiveClassIterator() {
        return str2PrimitiveClass.values().iterator();
    }

    public static CsmClassifier getSimpleClass(CsmClassifier csmClassifier) {
        CharSequence charSequence = csmClassifier.getQualifiedName();
        SimpleClass simpleClass = null;
        if (csmClassifier != null) {
            simpleClass = new SimpleClass(csmClassifier);
        }
        return simpleClass;
    }

    public static CsmClassifier createSimpleClass(String string) {
        int n = string.lastIndexOf(SCOPE) + 1;
        return CsmCompletion.createSimpleClass(string.substring(n), n > 0 ? string.substring(0, n - 1) : "");
    }

    public static CsmClassifier createSimpleClass(String string, String string2) {
        return new SimpleClass(string, string2, CsmDeclaration.Kind.CLASS);
    }

    public static CsmType createType(CsmClassifier csmClassifier, int n) {
        return new BaseType(csmClassifier, 0, false, n);
    }

    public static CsmType getObjectType(CsmObject csmObject) {
        Object object = null;
        if (CsmKindUtilities.isClassifier((CsmObject)csmObject)) {
            object = CsmCompletion.getType((CsmClassifier)csmObject, 0);
        } else if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
            CsmFunction csmFunction = (CsmFunction)csmObject;
            if (CsmKindUtilities.isConstructor((CsmObject)csmFunction)) {
                CsmClass csmClass = ((CsmConstructor)csmObject).getContainingClass();
                object = CsmCompletion.getType((CsmClassifier)csmClass, 0);
            } else {
                object = csmFunction.getReturnType();
            }
        } else {
            object = CsmKindUtilities.isVariable((CsmObject)csmObject) ? ((CsmVariable)csmObject).getType() : (CsmKindUtilities.isEnumerator((CsmObject)csmObject) ? INT_TYPE : null);
        }
        return object;
    }

    public static CsmType getType(CsmClassifier csmClassifier, int n) {
        if (csmClassifier == null) {
            return null;
        }
        CsmType[] csmTypeArray = (CsmType[])typeCache.get(csmClassifier);
        if (csmTypeArray != null) {
            if (n < csmTypeArray.length) {
                if (csmTypeArray[n] == null) {
                    csmTypeArray[n] = new BaseType(csmClassifier, n);
                }
            } else {
                csmClassifier = csmTypeArray[0].getClassifier();
                CsmType[] csmTypeArray2 = new CsmType[n + 1];
                System.arraycopy(csmTypeArray, 0, csmTypeArray2, 0, csmTypeArray.length);
                csmTypeArray = csmTypeArray2;
                csmTypeArray[n] = new BaseType(csmClassifier, n);
                typeCache.put(csmClassifier, csmTypeArray);
            }
        } else {
            csmClassifier = CsmCompletion.getSimpleClass(csmClassifier);
            if (n > 0) {
                csmTypeArray = new CsmType[n + 1];
                csmTypeArray[n] = new BaseType(csmClassifier, n);
            } else {
                csmTypeArray = new CsmType[2];
            }
            csmTypeArray[0] = new BaseType(csmClassifier, 0);
            typeCache.put(csmClassifier, csmTypeArray);
        }
        return csmTypeArray[n];
    }

    public static int getDebugMode() {
        return debugMode;
    }

    public static void setDebugMode(int n) {
        debugMode = n;
    }

    static {
        String string;
        int n;
        BOOLEAN_CLASS = new SimpleClass("boolean", "");
        BYTE_CLASS = new SimpleClass("byte", "");
        CHAR_CLASS = new SimpleClass("char", "");
        DOUBLE_CLASS = new SimpleClass("double", "");
        FLOAT_CLASS = new SimpleClass("float", "");
        INT_CLASS = new SimpleClass("int", "");
        LONG_CLASS = new SimpleClass("long", "");
        SHORT_CLASS = new SimpleClass("short", "");
        VOID_CLASS = new SimpleClass("void", "");
        BOOLEAN_TYPE = new BaseType(BOOLEAN_CLASS, 0);
        BYTE_TYPE = new BaseType(BYTE_CLASS, 0);
        CHAR_TYPE = new BaseType(CHAR_CLASS, 0);
        DOUBLE_TYPE = new BaseType(DOUBLE_CLASS, 0);
        FLOAT_TYPE = new BaseType(FLOAT_CLASS, 0);
        INT_TYPE = new BaseType(INT_CLASS, 0);
        LONG_TYPE = new BaseType(LONG_CLASS, 0);
        SHORT_TYPE = new BaseType(SHORT_CLASS, 0);
        VOID_TYPE = new BaseType(VOID_CLASS, 0);
        INVALID_CLASS = new SimpleClass("", "");
        INVALID_TYPE = new BaseType(INVALID_CLASS, 0);
        NULL_CLASS = new SimpleClass("null", "");
        NULL_TYPE = new BaseType(NULL_CLASS, 0);
        OBJECT_CLASS_ARRAY = new SimpleClass("java.lang.Object[]", "java.lang".length(), true);
        OBJECT_TYPE_ARRAY = new BaseType(OBJECT_CLASS_ARRAY, 0);
        OBJECT_CLASS = new SimpleClass("java.lang.Object", "java.lang".length(), true);
        OBJECT_TYPE = new BaseType(OBJECT_CLASS, 0);
        CLASS_CLASS = new SimpleClass("java.lang.Class", "java.lang".length(), true);
        CLASS_TYPE = new BaseType(CLASS_CLASS, 0);
        STRING_CLASS = new SimpleClass("char", 0, true);
        STRING_TYPE = new BaseType(STRING_CLASS, 1, false, 0);
        CONST_STRING_CLASS = new SimpleClass("const char", 0, true);
        CONST_STRING_TYPE = new BaseType(CONST_STRING_CLASS, 1, false, 0);
        str2PrimitiveClass = new HashMap();
        str2PrimitiveType = new HashMap();
        str2PredefinedType = new HashMap();
        BaseType[] baseTypeArray = new BaseType[]{BOOLEAN_TYPE, BYTE_TYPE, CHAR_TYPE, DOUBLE_TYPE, FLOAT_TYPE, INT_TYPE, LONG_TYPE, SHORT_TYPE, VOID_TYPE};
        for (n = baseTypeArray.length - 1; n >= 0; --n) {
            string = ((Object)baseTypeArray[n].getClassifier().getName()).toString();
            str2PrimitiveClass.put(string, baseTypeArray[n].getClassifier());
            str2PrimitiveType.put(string, baseTypeArray[n]);
        }
        baseTypeArray = new BaseType[]{NULL_TYPE, OBJECT_TYPE_ARRAY, OBJECT_TYPE, CLASS_TYPE, STRING_TYPE, CONST_STRING_TYPE};
        for (n = baseTypeArray.length - 1; n >= 0; --n) {
            string = ((Object)baseTypeArray[n].getClassifier().getName()).toString();
            str2PredefinedType.put(string, baseTypeArray[n]);
            str2PredefinedType.put(baseTypeArray[n].getClassifier().getQualifiedName(), baseTypeArray[n]);
            str2PredefinedType.put(baseTypeArray[n].format(true), baseTypeArray[n]);
        }
        EMPTY_PARAMETERS = new CsmParameter[0];
        EMPTY_CLASSES = new CsmClassifier[0];
        EMPTY_NAMESPACES = new CsmNamespace[0];
        EMPTY_FIELDS = new CsmField[0];
        EMPTY_CONSTRUCTORS = new CsmConstructor[0];
        EMPTY_METHODS = new CsmMethod[0];
        typeCache = new HashMap(5003);
    }

    public static interface CsmFinderInitializer {
        public void initCsmFinder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BaseType
    implements CsmType {
        protected CsmClassifier clazz;
        protected int arrayDepth;
        protected int pointerDepth;
        protected boolean reference;

        public BaseType(CsmClassifier csmClassifier, int n) {
            this.clazz = csmClassifier;
            this.arrayDepth = n;
            this.pointerDepth = 0;
            this.reference = false;
            if (n < 0) {
                throw new IllegalArgumentException("Array depth " + n + " < 0.");
            }
        }

        public BaseType(CsmClassifier csmClassifier, int n, boolean bl, int n2) {
            this.clazz = csmClassifier;
            this.arrayDepth = n2;
            this.pointerDepth = n;
            this.reference = bl;
            if (n2 < 0) {
                throw new IllegalArgumentException("Array depth " + n2 + " < 0.");
            }
        }

        BaseType() {
        }

        public int getArrayDepth() {
            return this.arrayDepth;
        }

        public String format(boolean bl) {
            StringBuilder stringBuilder = new StringBuilder(bl ? this.getClassifier().getQualifiedName() : this.getClassifier().getName());
            for (int i = this.pointerDepth; i > 0; --i) {
                stringBuilder.append("*");
            }
            for (int i = this.arrayDepth; i > 0; --i) {
                stringBuilder.append("[]");
            }
            return stringBuilder.toString();
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            CsmType csmType = (CsmType)object;
            int n = ((Object)this.clazz.getQualifiedName()).toString().compareTo(((Object)csmType.getClassifier().getQualifiedName()).toString());
            if (n == 0) {
                n = this.arrayDepth - csmType.getArrayDepth();
            }
            return n;
        }

        public int hashCode() {
            return this.clazz.hashCode() + this.arrayDepth;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof CsmType) {
                CsmType csmType = (CsmType)object;
                return this.clazz.equals(csmType.getClassifier()) && this.arrayDepth == csmType.getArrayDepth();
            }
            return false;
        }

        public String toString() {
            return this.format(true);
        }

        public CsmClassifier getClassifier() {
            if (this.clazz instanceof SimpleClass) {
                return ((SimpleClass)this.clazz).clazz == null ? this.clazz : ((SimpleClass)this.clazz).clazz;
            }
            return this.clazz;
        }

        public List<CsmType> getInstantiationParams() {
            return Collections.emptyList();
        }

        public boolean isInstantiation() {
            return false;
        }

        public CharSequence getClassifierText() {
            return this.clazz.getName();
        }

        public boolean isPointer() {
            return this.pointerDepth > 0;
        }

        public int getPointerDepth() {
            return this.pointerDepth;
        }

        public boolean isReference() {
            return this.reference;
        }

        public boolean isConst() {
            return false;
        }

        public String getText() {
            return this.format(true);
        }

        public String getCanonicalText() {
            return this.getText();
        }

        public CsmFile getContainingFile() {
            return null;
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return 0;
        }

        public CsmOffsetable.Position getStartPosition() {
            return null;
        }

        public CsmOffsetable.Position getEndPosition() {
            return null;
        }

        public boolean isBuiltInBased(boolean bl) {
            return CsmKindUtilities.isBuiltIn((CsmObject)this.clazz);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleClass
    implements CsmClassifier {
        protected CharSequence name;
        protected String packageName = "";
        protected CharSequence fullName;
        protected CsmDeclaration.Kind kind;
        private String stringValue;
        private CsmClassifier clazz;

        public SimpleClass(CsmClassifier csmClassifier) {
            this.clazz = csmClassifier;
            this.name = csmClassifier.getName();
            this.fullName = csmClassifier.getQualifiedName();
        }

        public SimpleClass(String string, String string2, CsmDeclaration.Kind kind) {
            this.name = string;
            this.packageName = string2 != null ? string2 : "";
            this.kind = kind;
            if (string == null || kind == null) {
                throw new NullPointerException("className=" + string + ", kind=" + kind);
            }
        }

        public SimpleClass(String string, String string2) {
            this(string, string2, CsmDeclaration.Kind.BUILT_IN);
        }

        public SimpleClass(String string, int n, boolean bl) {
            this.fullName = string;
            if (n <= 0 || n >= string.length()) {
                this.name = string;
                this.packageName = "";
            } else {
                this.name = string.substring(n + 1);
                this.packageName = string.substring(0, n);
                if (bl) {
                    this.name = ((String)this.name).intern();
                    this.packageName = this.packageName.intern();
                }
            }
        }

        SimpleClass() {
        }

        public final CharSequence getName() {
            if (this.clazz != null) {
                return this.clazz.getName();
            }
            return this.name;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public CharSequence getQualifiedName() {
            if (this.clazz != null) {
                return this.clazz.getQualifiedName();
            }
            if (this.fullName == null) {
                this.fullName = this.packageName.length() > 0 ? this.packageName + "." + this.name : this.name;
            }
            return this.fullName;
        }

        public CharSequence getUniqueName() {
            return this.getQualifiedName();
        }

        public int getTagOffset() {
            return -1;
        }

        public boolean isInterface() {
            return false;
        }

        public int getModifiers() {
            return 0;
        }

        public CsmClassifier getSuperclass() {
            return null;
        }

        public CsmClassifier[] getInterfaces() {
            return EMPTY_CLASSES;
        }

        public CsmField[] getFields() {
            return EMPTY_FIELDS;
        }

        public CsmConstructor[] getConstructors() {
            return EMPTY_CONSTRUCTORS;
        }

        public CsmMethod[] getMethods() {
            return EMPTY_METHODS;
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            CsmClassifier csmClassifier = (CsmClassifier)object;
            int n = 0;
            if (n == 0) {
                n = ((Object)this.name).toString().compareTo(((Object)csmClassifier.getName()).toString());
            }
            return n;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.packageName.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof CsmClassifier) {
                CsmClassifier csmClassifier = (CsmClassifier)object;
                String string = csmClassifier.getName() == null ? null : ((Object)csmClassifier.getName()).toString().replace('.', '$');
                String string2 = ((Object)this.name).toString().replace('.', '$');
                return string2.equals(string);
            }
            return false;
        }

        public String toString() {
            if (this.stringValue == null) {
                this.stringValue = this.getPackageName().length() > 0 ? this.getPackageName() + '.' + ((Object)this.getName()).toString().replace('.', '$') : ((Object)this.getName()).toString().replace('.', '$');
            }
            return this.stringValue;
        }

        public CsmDeclaration.Kind getKind() {
            if (this.clazz != null) {
                return this.clazz.getKind();
            }
            return this.kind;
        }

        public CsmScope getScope() {
            if (this.clazz != null) {
                return this.clazz.getScope();
            }
            return null;
        }

        public CsmUID<CsmClass> getUID() {
            if (this.clazz != null) {
                return this.clazz.getUID();
            }
            return null;
        }
    }
}

