/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionJavaDoc;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.JavaDocPane;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.completion.cplusplus.CCScrollDocPane;
import org.netbeans.modules.cnd.completion.cplusplus.NbCsmSyntaxSupport;
import org.netbeans.modules.cnd.completion.spi.dynhelp.CCHelpManager;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class NbCompletionJavaDoc
extends CompletionJavaDoc {
    ParsingThread task = null;
    public static final String CONTENT_NOT_FOUND = NbBundle.getMessage(NbCompletionJavaDoc.class, (String)"javadoc_content_not_found");
    private static boolean javaSourcesMounted = true;
    private static boolean inited = false;
    private String lastBase = "";
    private boolean goToSourceEnabled = false;
    private NbCsmSyntaxSupport jmiSup;

    public NbCompletionJavaDoc(ExtEditorUI extEditorUI) {
        super(extEditorUI);
    }

    protected boolean isGoToSourceEnabled() {
        return this.goToSourceEnabled;
    }

    protected void setGoToSourceEnabled(boolean bl) {
        JavaDocPane javaDocPane = this.getJavaDocPane();
        if (javaDocPane instanceof CCScrollDocPane) {
            ((CCScrollDocPane)javaDocPane).setGoToSourceEnabled(bl);
        }
    }

    protected ParsingThread setInRequestProcessorThread(Object object) {
        ParsingThread parsingThread = new ParsingThread(object);
        RequestProcessor.getDefault().post((Runnable)parsingThread);
        return parsingThread;
    }

    public void cancelPerformingThread() {
        super.cancelPerformingThread();
        if (this.task != null) {
            this.task.stopTask();
        }
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (this.task != null) {
            this.task.stopTask();
        }
        this.task = this.setInRequestProcessorThread(this.getCurrentContent());
    }

    public void goToSource() {
        SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)this.extEditorUI.getComponent());
        NbCsmSyntaxSupport nbCsmSyntaxSupport = (NbCsmSyntaxSupport)syntaxSupport.get(NbCsmSyntaxSupport.class);
    }

    public void openInExternalBrowser() {
        Object object;
        SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)this.extEditorUI.getComponent());
        NbCsmSyntaxSupport nbCsmSyntaxSupport = (NbCsmSyntaxSupport)syntaxSupport.get(NbCsmSyntaxSupport.class);
        Object object2 = this.getCurrentContent();
        if (object2 instanceof URL) {
            HtmlBrowser.URLDisplayer.getDefault().showURL((URL)object2);
        } else if (object2 instanceof String && (object = this.mergeRelLink(this.lastBase, (String)object2)) != null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL((URL)object);
        }
        object = nbCsmSyntaxSupport.getJavaDocURLs(object2);
        if (object != null && ((URL[])object).length > 0) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(object[0]);
        }
    }

    public boolean isExternalJavaDocMounted() {
        FileObject fileObject;
        SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)this.extEditorUI.getComponent());
        NbCsmSyntaxSupport nbCsmSyntaxSupport = (NbCsmSyntaxSupport)syntaxSupport.get(NbCsmSyntaxSupport.class);
        Object object = this.getCurrentContent();
        if (object instanceof URL || object instanceof String) {
            try {
                if (this.lastBase == null || this.lastBase.length() == 0) {
                    return false;
                }
                fileObject = URLMapper.findFileObject((URL)new URL(this.lastBase));
                if (fileObject != null) {
                    return true;
                }
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return false;
            }
        }
        return (fileObject = nbCsmSyntaxSupport.getJavaDocURLs(object)) != null && ((URL[])fileObject).length >= 1;
    }

    public Object parseLink(String string, String string2, String string3) {
        if (string3 == null) {
            string3 = "";
        }
        string = string.trim();
        return null;
    }

    protected URL mergeRelLink(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            return new URL(new URL(string), string2);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    protected NbCsmSyntaxSupport getCsmSyntaxSupport() {
        if (this.jmiSup == null) {
            SyntaxSupport syntaxSupport = Utilities.getSyntaxSupport((JTextComponent)this.extEditorUI.getComponent());
            this.jmiSup = (NbCsmSyntaxSupport)syntaxSupport.get(NbCsmSyntaxSupport.class);
        }
        return this.jmiSup;
    }

    class JavaDocTagItemImpl
    implements CompletionJavaDoc.JavaDocTagItem {
        String name;
        String text;

        public JavaDocTagItemImpl(String string, String string2) {
            this.name = string;
            this.text = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getText() {
            return this.text;
        }

        public int compareTo(Object object) {
            if (this == object) {
                return 0;
            }
            JavaDocTagItemImpl javaDocTagItemImpl = (JavaDocTagItemImpl)object;
            return this.name.compareTo(javaDocTagItemImpl.getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof JavaDocTagItemImpl) {
                return this.name.equals(((JavaDocTagItemImpl)object).getName());
            }
            if (object instanceof String) {
                return this.name.equals((String)object);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }

    class ParsingThread
    implements Runnable {
        Object content;
        boolean running = true;

        public ParsingThread(Object object) {
            this.content = object;
        }

        void stopTask() {
            this.running = false;
        }

        protected String getBoldName(String string, String string2) {
            if (string.indexOf(string2) > -1) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string.substring(0, string.indexOf(string2)));
                stringBuilder.append("<b>" + string2 + "</b>");
                stringBuilder.append(string.substring(string.indexOf(string2) + string2.length()));
                return stringBuilder.toString().replace('$', '.');
            }
            return string;
        }

        protected String getLastBase(String string) {
            if (string == null) {
                return null;
            }
            return string.substring(0, string.lastIndexOf(47) + 1);
        }

        protected void javaDocNotFound() {
            if (NbCompletionJavaDoc.this.alwaysDisplayPopup()) {
                this.showJavaDoc(CONTENT_NOT_FOUND);
            }
        }

        protected void showJavaDoc(final String string) {
            if (string == null) {
                this.javaDocNotFound();
                return;
            }
            if (this.running) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        NbCompletionJavaDoc.this.getJavaDocView().setContent(string);
                        NbCompletionJavaDoc.this.setGoToSourceEnabled(NbCompletionJavaDoc.this.isGoToSourceEnabled());
                        if (ParsingThread.this.running) {
                            NbCompletionJavaDoc.this.setJavaDocVisible(true);
                        }
                    }
                };
                Utilities.runInEventDispatchThread((Runnable)runnable);
            }
        }

        private void setCsmQualified(CsmQualifiedNamedElement csmQualifiedNamedElement) {
            if (csmQualifiedNamedElement == null) {
                this.javaDocNotFound();
            } else {
                this.setCsmDoc(((Object)csmQualifiedNamedElement.getQualifiedName()).toString());
            }
        }

        private void setCsmDoc(String string) {
            CCHelpManager cCHelpManager = (CCHelpManager)Lookup.getDefault().lookup(CCHelpManager.class);
            if (cCHelpManager == null) {
                this.javaDocNotFound();
            } else {
                String string2 = cCHelpManager.getHelp(string);
                this.showJavaDoc(string2);
            }
        }

        public void run() {
            NbCompletionJavaDoc.this.goToSourceEnabled = true;
            if (this.content instanceof CsmQualifiedNamedElement) {
                this.setCsmQualified((CsmQualifiedNamedElement)this.content);
            } else if (this.content instanceof URL) {
                URL uRL = (URL)this.content;
                if ("http".equals(uRL.getProtocol())) {
                    return;
                }
                if (NbCompletionJavaDoc.this.addToHistory) {
                    NbCompletionJavaDoc.this.addToHistory(this.content);
                }
            } else if (this.content instanceof String) {
                NbCompletionJavaDoc.this.goToSourceEnabled = false;
                String string = (String)this.content;
                URL uRL = NbCompletionJavaDoc.this.mergeRelLink(NbCompletionJavaDoc.this.lastBase, string);
                if (uRL == null) {
                    return;
                }
                if ("http".equals(uRL.getProtocol())) {
                    return;
                }
                if (NbCompletionJavaDoc.this.addToHistory) {
                    NbCompletionJavaDoc.this.addToHistory(uRL);
                }
            } else {
                NbCompletionJavaDoc.this.goToSourceEnabled = false;
            }
        }
    }
}

