/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus;

import java.util.List;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;

public class CsmCodeTemplateFilter
implements CodeTemplateFilter {
    private static boolean enabled = true;
    private int startOffset;
    private int endOffset;
    private CppTokenId id;

    static void enableAbbreviations(boolean bl) {
        enabled = bl;
    }

    private CsmCodeTemplateFilter(JTextComponent jTextComponent, int n) {
        this.startOffset = n;
        this.endOffset = jTextComponent.getSelectionStart() == n ? jTextComponent.getSelectionEnd() : this.startOffset;
        this.id = this.getID(jTextComponent, n);
    }

    public synchronized boolean accept(CodeTemplate codeTemplate) {
        return enabled && this.startOffset == this.endOffset && this.isTemplateContext(codeTemplate);
    }

    private CppTokenId getID(JTextComponent jTextComponent, int n) {
        TokenSequence tokenSequence = CndLexerUtilities.getCppTokenSequence((JTextComponent)jTextComponent, (int)n);
        if (tokenSequence != null && tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            return (CppTokenId)token.id();
        }
        return CppTokenId.ERROR;
    }

    private boolean isTemplateContext(CodeTemplate codeTemplate) {
        List list = codeTemplate.getContexts();
        boolean bl = true;
        switch (this.id) {
            case DOT: 
            case DOTMBR: 
            case SCOPE: 
            case ARROW: 
            case ARROWMBR: {
                bl = false;
            }
        }
        return bl;
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent jTextComponent, int n) {
            return new CsmCodeTemplateFilter(jTextComponent, n);
        }
    }
}

