/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus;

import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmHyperlinkProvider;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmIncludeHyperlinkProvider;
import org.netbeans.modules.cnd.completion.cplusplus.utils.Token;
import org.netbeans.modules.cnd.completion.cplusplus.utils.TokenUtilities;
import org.netbeans.modules.cnd.editor.cplusplus.CCTokenContext;
import org.openide.util.NbBundle;

public class CCGoToDeclarationAction
extends ExtKit.GotoDeclarationAction {
    static final long serialVersionUID = 1L;
    private static CCGoToDeclarationAction instance;

    public CCGoToDeclarationAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public static synchronized CCGoToDeclarationAction getInstance() {
        if (instance == null) {
            instance = new CCGoToDeclarationAction();
            String string = NbBundle.getBundle(CCGoToDeclarationAction.class).getString("goto-definition-declaration");
            instance.putValue("trimmed-text", string);
            instance.putValue("PopupMenuText", string);
        }
        return instance;
    }

    public String getName() {
        return NbBundle.getBundle(CCGoToDeclarationAction.class).getString("NAME_GoToDeclarationAction");
    }

    public boolean isEnabled() {
        JTextComponent jTextComponent = this.getFocusedComponent();
        if (jTextComponent != null && jTextComponent.getDocument() instanceof BaseDocument) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            int n = jTextComponent.getCaret().getDot();
            if (new CsmIncludeHyperlinkProvider().isHyperlinkPoint((Document)baseDocument, n = TokenUtilities.correctOffsetToID(baseDocument, n))) {
                return true;
            }
            if (new CsmHyperlinkProvider().isHyperlinkPoint((Document)baseDocument, n)) {
                return true;
            }
        }
        return false;
    }

    protected boolean asynchonous() {
        return false;
    }

    public boolean gotoDeclaration(final JTextComponent jTextComponent) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (SwingUtilities.isEventDispatchThread()) {
                    CsmModelAccessor.getModel().enqueue((Runnable)this, (CharSequence)"Go to declaration");
                    return;
                }
                if (jTextComponent != null && jTextComponent.getDocument() instanceof BaseDocument) {
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n = jTextComponent.getCaret().getDot();
                    if (!new CsmIncludeHyperlinkProvider().goToInclude(baseDocument, jTextComponent, n = TokenUtilities.correctOffsetToID(baseDocument, n))) {
                        new CsmHyperlinkProvider().goToDeclaration(baseDocument, jTextComponent, n);
                    }
                }
            }
        };
        CsmModelAccessor.getModel().enqueue(runnable, (CharSequence)"Go to declaration");
        return false;
    }

    public String getPopupMenuText(JTextComponent jTextComponent) {
        String string = NbBundle.getBundle(CCGoToDeclarationAction.class).getString("goto-identifier-declaration");
        if (jTextComponent != null && jTextComponent.getDocument() instanceof BaseDocument) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            int n = jTextComponent.getCaret().getDot();
            Token token = TokenUtilities.getToken((Document)baseDocument, n = TokenUtilities.correctOffsetToID(baseDocument, n));
            if (token != null) {
                if (CsmIncludeHyperlinkProvider.isSupportedToken(token)) {
                    string = NbBundle.getBundle(CCGoToDeclarationAction.class).getString("goto-included-file");
                } else if (CsmHyperlinkProvider.isSupportedToken(token)) {
                    Token token2 = TokenUtilities.getToken((Document)baseDocument, token.getEndOffset());
                    if (token2 != null && token2.getTokenID() == CCTokenContext.WHITESPACE) {
                        token2 = TokenUtilities.getToken((Document)baseDocument, token2.getEndOffset());
                    }
                    if (token2 != null && token2.getTokenID() == CCTokenContext.LPAREN) {
                        string = NbBundle.getBundle(CCGoToDeclarationAction.class).getString("goto-definition-declaration");
                    }
                }
            }
        }
        return string;
    }
}

