/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.gsf.embedding;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.html.editor.gsf.embedding.CssModel;

public class CssJspModel
extends CssModel {
    private static final Logger LOGGER = Logger.getLogger(CssJspModel.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);

    public static CssJspModel get(Document document) {
        CssJspModel cssJspModel = (CssJspModel)((Object)document.getProperty(CssJspModel.class));
        if (cssJspModel == null) {
            cssJspModel = new CssJspModel(document);
            document.putProperty(CssJspModel.class, (Object)cssJspModel);
        }
        return cssJspModel;
    }

    private CssJspModel(Document document) {
        super(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCode() {
        if (this.documentDirty) {
            this.documentDirty = false;
            this.codeBlocks.clear();
            StringBuilder stringBuilder = new StringBuilder();
            BaseDocument baseDocument = (BaseDocument)this.doc;
            try {
                baseDocument.readLock();
                this.extractCssFromJSP(this.doc, stringBuilder);
            }
            finally {
                baseDocument.readUnlock();
            }
            this.code = stringBuilder.toString();
        }
        if (LOG) {
            LOGGER.log(Level.FINE, this.dumpCode());
        }
        return this.code;
    }

    private void extractCssFromJSP(Document document, StringBuilder stringBuilder) {
        HashMap hashMap = new HashMap(6);
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.moveStart();
        block0: while (tokenSequence.moveNext()) {
            int n;
            int n2;
            Object object;
            Token token = tokenSequence.token();
            if (token.id() == JspTokenId.TEXT) {
                object = tokenSequence.embedded();
                object.moveStart();
                this.extractCssFromHTML((TokenSequence)object, stringBuilder, hashMap);
                continue;
            }
            if (hashMap.get("in_style") == null && hashMap.get("in_inlined_style") == null) continue;
            if (token.id() == JspTokenId.EL || token.id() == JspTokenId.SCRIPTLET) {
                int n3 = tokenSequence.offset();
                n2 = tokenSequence.offset() + token.length();
                int n4 = stringBuilder.length();
                stringBuilder.append(token.id() == JspTokenId.EL ? "EXPRESSION_LANGUAGE" : "JAVA_CODE");
                n = stringBuilder.length();
                CssModel.CodeBlockData codeBlockData = new CssModel.CodeBlockData((CssModel)this, n3, n2, n4, n);
                this.codeBlocks.add(codeBlockData);
                continue;
            }
            if (token.id() != JspTokenId.TAG) continue;
            object = ((Object)token.text()).toString();
            n2 = tokenSequence.offset() - 1;
            StringBuilder stringBuilder2 = new StringBuilder();
            while (tokenSequence.moveNext() && ((token = tokenSequence.token()).id() != JspTokenId.SYMBOL || !"/>".equals(((Object)token.text()).toString()))) {
                if (token.id() == JspTokenId.TEXT) {
                    stringBuilder2.append(token.text());
                    continue;
                }
                if (token.id() != JspTokenId.ENDTAG || !((Object)token.text()).toString().equals(object)) continue;
                tokenSequence.moveNext();
                n = tokenSequence.offset() + tokenSequence.token().length();
                int n5 = stringBuilder.length();
                stringBuilder.append((CharSequence)stringBuilder2);
                int n6 = stringBuilder.length();
                CssModel.CodeBlockData codeBlockData = new CssModel.CodeBlockData((CssModel)this, n2, n, n5, n6);
                this.codeBlocks.add(codeBlockData);
                continue block0;
            }
        }
    }
}

