/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.awt.Color;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.SyntaxElement;
import org.netbeans.modules.web.core.syntax.completion.AttributeValueSupport;
import org.netbeans.modules.web.core.syntax.completion.JavaJSPCompletionProvider;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionItem;
import org.netbeans.modules.web.core.syntax.completion.JspCompletionQuery;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;

public class AttrSupports {
    private static final Logger logger = Logger.getLogger(AttrSupports.class.getName());

    public static class EncodingSupport
    extends AttributeValueSupport.Default {
        public EncodingSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        protected List possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator<String> iterator = Charset.availableCharsets().keySet().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList;
        }
    }

    public static class PageLanguage
    extends AttributeValueSupport.Default {
        public PageLanguage() {
            super(false, "page", "language");
        }

        protected List possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("java");
            return arrayList;
        }
    }

    public static class TrueFalseSupport
    extends AttributeValueSupport.Default {
        public TrueFalseSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        protected List possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("false");
            arrayList.add("true");
            return arrayList;
        }
    }

    public static class FilenameSupport
    extends AttributeValueSupport.Default {
        static final ImageIcon PACKAGE_ICON = new ImageIcon(Utilities.loadImage((String)"org/openide/loaders/defaultFolder.gif"));
        private int itemOffset;
        private int itemLength;

        public FilenameSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        protected List possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            return new ArrayList();
        }

        public CompletionQuery.Result getResult(JTextComponent jTextComponent, int n, JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective, String string) {
            List list = this.completionResults(n, jspSyntaxSupport, tagDirective, string);
            return new JspCompletionQuery.JspCompletionResult(jTextComponent, this.completionTitle(), list, this.itemOffset, this.itemLength, -1);
        }

        private List completionResults(int n, JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective, String string) {
            List<JspCompletionItem.FileAttributeValue> list = new ArrayList();
            String string2 = "";
            String string3 = string;
            int n2 = string.lastIndexOf(47);
            if (n2 == 0) {
                string2 = "/";
                string3 = string.substring(1);
            } else if (n2 > 0) {
                string2 = string.substring(0, n2);
                string3 = n2 == string.length() ? "" : string.substring(n2 + 1);
            }
            try {
                FileObject fileObject = jspSyntaxSupport.getFileObject();
                FileObject object = JspUtils.guessWebModuleRoot((Document)jspSyntaxSupport.getDocument(), fileObject);
                String string4 = JspUtils.resolveRelativeURL("/" + fileObject.getPath(), string2);
                string4 = string2.startsWith("/") ? object.getPath() + string2 : string4.substring(1);
                FileSystem fileSystem = fileObject.getFileSystem();
                FileObject fileObject2 = fileSystem.findResource(string4);
                if (fileObject2 != null) {
                    list = this.files(fileObject2, string3, jspSyntaxSupport);
                    if (!(fileObject2.equals(object) || string2.startsWith("/") || string2.length() != 0 && string2.lastIndexOf("../") + 3 != string2.length())) {
                        list.add(0, new JspCompletionItem.FileAttributeValue("../", Color.BLUE, PACKAGE_ICON));
                    }
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.itemOffset = n - string.length() + n2 + 1;
            this.itemLength = string3.length();
            for (JspCompletionItem.JspResultItem jspResultItem : list) {
                jspResultItem.setSubstituteOffset(this.itemOffset);
            }
            return list;
        }

        private List files(FileObject fileObject, String string, JspSyntaxSupport jspSyntaxSupport) {
            ArrayList arrayList = new ArrayList();
            TreeMap<String, JspCompletionItem.FileAttributeValue> treeMap = new TreeMap<String, JspCompletionItem.FileAttributeValue>();
            TreeMap<String, JspCompletionItem.FileAttributeValue> treeMap2 = new TreeMap<String, JspCompletionItem.FileAttributeValue>();
            Enumeration enumeration = fileObject.getChildren(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                String string2 = fileObject2.getNameExt();
                if (!string2.startsWith(string) || "cvs".equalsIgnoreCase(string2)) continue;
                if (fileObject2.isFolder()) {
                    treeMap.put(fileObject2.getNameExt(), new JspCompletionItem.FileAttributeValue(fileObject2.getNameExt() + "/", Color.BLUE, PACKAGE_ICON));
                    continue;
                }
                Image image = JspUtils.getIcon((Document)jspSyntaxSupport.getDocument(), fileObject2);
                if (image != null) {
                    treeMap2.put(fileObject2.getNameExt(), new JspCompletionItem.FileAttributeValue(fileObject2.getNameExt(), Color.BLACK, new ImageIcon(image)));
                    continue;
                }
                treeMap2.put(fileObject2.getNameExt(), new JspCompletionItem.FileAttributeValue(fileObject2.getNameExt(), Color.BLACK));
            }
            arrayList.addAll(treeMap.values());
            arrayList.addAll(treeMap2.values());
            return arrayList;
        }
    }

    public static class TaglibTagdir
    extends AttributeValueSupport.Default {
        public TaglibTagdir() {
            super(false, "taglib", "tagdir");
        }

        protected List possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            FileObject fileObject;
            ArrayList<String> arrayList = new ArrayList<String>();
            FileObject fileObject2 = jspSyntaxSupport.getFileObject();
            FileObject fileObject3 = JspUtils.guessWebModuleRoot((Document)jspSyntaxSupport.getDocument(), fileObject2);
            if (fileObject3 != null && (fileObject = JspUtils.findRelativeFileObject(fileObject3, "WEB-INF/tags")) != null) {
                if (this.isValidTagDir(fileObject)) {
                    arrayList.add(JspUtils.findRelativeContextPath(fileObject3, fileObject));
                }
                Enumeration enumeration = fileObject.getFolders(true);
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject4 = (FileObject)enumeration.nextElement();
                    if (!this.isValidTagDir(fileObject4)) continue;
                    arrayList.add(JspUtils.findRelativeContextPath(fileObject3, fileObject4));
                }
            }
            Collections.sort(arrayList);
            return arrayList;
        }

        private boolean isValidTagDir(FileObject fileObject) {
            return fileObject.getChildren(false).hasMoreElements();
        }
    }

    public static class TaglibURI
    extends AttributeValueSupport.Default {
        public TaglibURI() {
            super(false, "taglib", "uri");
        }

        protected List possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Map map = jspSyntaxSupport.getTagLibraryMappings();
            if (map != null) {
                for (String string : map.keySet()) {
                    arrayList.add(string);
                }
            }
            Collections.sort(arrayList);
            return arrayList;
        }
    }

    public static class SetPropertyProperty
    extends GetSetPropertyProperty {
        public SetPropertyProperty() {
            super(true, "jsp:setProperty", "property");
        }

        protected List possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            List list = this.possibleValues(jspSyntaxSupport, tagDirective, true);
            list.add(0, "*");
            return list;
        }
    }

    public static class GetPropertyProperty
    extends GetSetPropertyProperty {
        public GetPropertyProperty() {
            super(true, "jsp:getProperty", "property");
        }

        public List possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            return this.possibleValues(jspSyntaxSupport, tagDirective, false);
        }
    }

    public static abstract class GetSetPropertyProperty
    extends AttributeValueSupport.Default {
        public GetSetPropertyProperty(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        protected List possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective, boolean bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = (String)tagDirective.getAttributes().get("name");
            if (string != null) {
                String string2 = null;
                PageInfo.BeanData[] beanDataArray = jspSyntaxSupport.getBeanData();
                for (int i = 0; i < beanDataArray.length; ++i) {
                    if (beanDataArray[i] == null || beanDataArray[i].getId() == null || !beanDataArray[i].getId().equals(string)) continue;
                    string2 = beanDataArray[i].getClassName();
                    break;
                }
                if (string2 != null) {
                    try {
                        FileObject fileObject = NbEditorUtilities.getDataObject((Document)jspSyntaxSupport.getDocument()).getPrimaryFile();
                        URLClassLoader uRLClassLoader = JspUtils.getModuleClassLoader((Document)jspSyntaxSupport.getDocument(), fileObject);
                        Class<?> clazz = Class.forName(string2, false, uRLClassLoader);
                        Introspector.flushFromCaches(clazz);
                        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                            if (bl && propertyDescriptorArray[i].getWriteMethod() != null) {
                                arrayList.add(propertyDescriptorArray[i].getName());
                            }
                            if (bl || propertyDescriptorArray[i].getReadMethod() == null || propertyDescriptorArray[i].getName().equals("class")) continue;
                            arrayList.add(propertyDescriptorArray[i].getName());
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (IntrospectionException introspectionException) {
                        // empty catch block
                    }
                }
            }
            return arrayList;
        }
    }

    public static class GetSetPropertyName
    extends AttributeValueSupport.Default {
        public GetSetPropertyName(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        protected List possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            PageInfo.BeanData[] beanDataArray = jspSyntaxSupport.getBeanData();
            if (beanDataArray != null) {
                for (int i = 0; i < beanDataArray.length; ++i) {
                    arrayList.add(beanDataArray[i].getId());
                }
            }
            return arrayList;
        }
    }

    public static class PackageListSupport
    extends ClassNameSupport {
        public PackageListSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        protected String getFakedClassBody(String string) {
            int n = string.lastIndexOf(",");
            if (n > -1) {
                string = string.substring(n + 1);
            }
            return "import " + string;
        }
    }

    public static class ClassNameSupport
    extends AttributeValueSupport.Default {
        public ClassNameSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        protected List possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            return new ArrayList();
        }

        protected String getFakedClassBody(String string) {
            return "class Foo extends " + string;
        }

        public CompletionQuery.Result getResult(JTextComponent jTextComponent, int n, JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective, String string) {
            String string2 = this.getFakedClassBody(string);
            int n2 = string2.length();
            logger.fine("JSP CC: delegating CC query to java file:\n" + string2.substring(0, n2) + "|" + string2.substring(n2) + "\n");
            JavaJSPCompletionProvider.CompletionQueryDelegatedToJava completionQueryDelegatedToJava = new JavaJSPCompletionProvider.CompletionQueryDelegatedToJava(n, n2, 1);
            completionQueryDelegatedToJava.create(jTextComponent.getDocument(), string2);
            List<? extends CompletionItem> list = completionQueryDelegatedToJava.getCompletionItems();
            JspCompletionQuery.JspCompletionResult jspCompletionResult = new JspCompletionQuery.JspCompletionResult(jTextComponent, null, list, n + (string.lastIndexOf(46) + 1), string.length(), -1);
            return jspCompletionResult;
        }

        private List completionResults(int n, JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective, String string) {
            return null;
        }
    }

    public static class YesNoTrueFalseSupport
    extends AttributeValueSupport.Default {
        public YesNoTrueFalseSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        protected List possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("false");
            arrayList.add("no");
            arrayList.add("true");
            arrayList.add("yes");
            return arrayList;
        }
    }

    public static class VariableScopeSupport
    extends AttributeValueSupport.Default {
        public VariableScopeSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        protected List possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("AT_BEGIN");
            arrayList.add("AT_END");
            arrayList.add("NESTED");
            return arrayList;
        }
    }

    public static class PluginTypeSupport
    extends AttributeValueSupport.Default {
        public PluginTypeSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        protected List possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("bean");
            arrayList.add("applet");
            return arrayList;
        }
    }

    public static class RootVersionSupport
    extends AttributeValueSupport.Default {
        public RootVersionSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        protected List possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("1.2");
            arrayList.add("2.0");
            return arrayList;
        }
    }

    public static class ScopeSupport
    extends AttributeValueSupport.Default {
        public ScopeSupport(boolean bl, String string, String string2) {
            super(bl, string, string2);
        }

        protected List possibleValues(JspSyntaxSupport jspSyntaxSupport, SyntaxElement.TagDirective tagDirective) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("application");
            arrayList.add("page");
            arrayList.add("request");
            arrayList.add("session");
            return arrayList;
        }
    }
}

