/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.ejb.load;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.visualweb.ejb.load.EjbLoadException;
import org.netbeans.modules.visualweb.ejb.load.StdDeploymentDescriptorParser;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebsphereDeploymentDescriptorParser
extends DefaultHandler {
    private static final String EJB_BINDINGS_TAG = "ejbBindings";
    private static final String ENTERPRISE_BEAN_TAG = "enterpriseBean";
    private static final String JNDI_NAME_ATTR = "jndiName";
    private static final String HREF_ATTR = "href";
    private String xmlFileName;
    private String jndiName;
    private String beanId;
    private Map nameMapping = new HashMap();

    public WebsphereDeploymentDescriptorParser(String string) {
        this.xmlFileName = string;
    }

    public Map parse() throws EjbLoadException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(this.xmlFileName, (DefaultHandler)this);
            return this.nameMapping;
        }
        catch (IOException iOException) {
            String string = "Error occured when trying to parse the vendor EJB deployment descriptor. Cannot read file " + this.xmlFileName;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.WebsphereDeploymentDescriptorParser").log(16, string);
            iOException.printStackTrace();
            throw new EjbLoadException(iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = "Error occured when trying to parse the vendor EJB deployment descriptor file " + this.xmlFileName;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.WebsphereDeploymentDescriptorParser").log(16, string);
            parserConfigurationException.printStackTrace();
            String string2 = NbBundle.getMessage(StdDeploymentDescriptorParser.class, (String)"CANNOT_PARSE_VENDOR_DD");
            throw new EjbLoadException(1, string2);
        }
        catch (SAXException sAXException) {
            String string = "Error occured when trying to parse the vendor EJB deployment descriptor file " + this.xmlFileName;
            ErrorManager.getDefault().getInstance("org.netbeans.modules.visualweb.ejb.load.WebsphereDeploymentDescriptorParser").log(16, string);
            sAXException.printStackTrace();
            String string3 = NbBundle.getMessage(StdDeploymentDescriptorParser.class, (String)"CANNOT_PARSE_VENDOR_DD");
            throw new EjbLoadException(1, string3);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase(EJB_BINDINGS_TAG)) {
            this.jndiName = attributes.getValue(JNDI_NAME_ATTR);
        }
        if (string3.equalsIgnoreCase(ENTERPRISE_BEAN_TAG)) {
            String string4 = attributes.getValue(HREF_ATTR);
            this.beanId = string4.substring(string4.indexOf(35) + 1);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase(EJB_BINDINGS_TAG)) {
            this.nameMapping.put(this.beanId, this.jndiName);
            this.beanId = null;
            this.jndiName = null;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public InputSource resolveEntity(String string, String string2) {
        return new InputSource(new StringReader(""));
    }
}

