/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.uihandler;

import java.util.logging.LogRecord;

public final class ProjectOp {
    private final String name;
    private final String type;
    private final int number;

    private ProjectOp(String string, String string2, int n) {
        this.name = ProjectOp.fixName(string, true);
        this.type = ProjectOp.fixName(string2, false);
        this.number = n;
    }

    private static String fixName(String string, boolean bl) {
        if (bl && string.indexOf("Maven") >= 0) {
            return "Maven";
        }
        return string;
    }

    public String getProjectDisplayName() {
        return this.name;
    }

    public String getProjectType() {
        return this.type;
    }

    public int getDelta() {
        return this.number;
    }

    public static ProjectOp valueOf(LogRecord logRecord) {
        if ("UI_CLOSED_PROJECTS".equals(logRecord.getMessage())) {
            int n;
            String string = ProjectOp.getStringParam(logRecord, 0, "unknown");
            String string2 = ProjectOp.getStringParam(logRecord, 1, "unknown");
            try {
                n = Integer.parseInt(ProjectOp.getStringParam(logRecord, 2, "0"));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return new ProjectOp(string2, string, -n);
        }
        if ("UI_OPEN_PROJECTS".equals(logRecord.getMessage())) {
            int n;
            String string = ProjectOp.getStringParam(logRecord, 0, "unknown");
            String string3 = ProjectOp.getStringParam(logRecord, 1, "unknown");
            try {
                n = Integer.parseInt(ProjectOp.getStringParam(logRecord, 2, "0"));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return new ProjectOp(string3, string, n);
        }
        return null;
    }

    private static String getStringParam(LogRecord logRecord, int n, String string) {
        if (logRecord == null) {
            return string;
        }
        Object[] objectArray = logRecord.getParameters();
        if (objectArray == null || objectArray.length <= n) {
            return string;
        }
        if (objectArray[n] instanceof String) {
            return (String)objectArray[n];
        }
        return string;
    }
}

