/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.debugger.jpda.projects.MainProjectManager;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.project.ActionProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class FixActionProvider
extends ActionsProviderSupport {
    private JPDADebugger debugger;
    private Listener listener;

    public FixActionProvider(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.listener = new Listener();
        MainProjectManager.getDefault().addPropertyChangeListener(this.listener);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this.listener);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this.listener);
        this.setEnabled(ActionsManager.ACTION_FIX, this.shouldBeEnabled());
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this.listener);
        MainProjectManager.getDefault().removePropertyChangeListener(this.listener);
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this.listener);
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_FIX);
    }

    public void doAction(Object object) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        FixActionProvider.this.invokeAction();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorManager.getDefault().notify((Throwable)invocationTargetException);
            }
        } else {
            this.invokeAction();
        }
    }

    private void invokeAction() {
        ((ActionProvider)this.getCurrentProject().getLookup().lookup(ActionProvider.class)).invokeAction("debug.fix", this.getLookup());
    }

    private Project getCurrentProject() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray == null || nodeArray.length == 0) {
            return MainProjectManager.getDefault().getMainProject();
        }
        DataObject dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class);
        if (dataObject == null) {
            return MainProjectManager.getDefault().getMainProject();
        }
        return FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
    }

    private boolean shouldBeEnabled() {
        int n;
        if (!this.debugger.canFixClasses()) {
            return false;
        }
        Project project = this.getCurrentProject();
        if (project == null) {
            return false;
        }
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (actionProvider == null) {
            return false;
        }
        String[] stringArray = actionProvider.getSupportedActions();
        int n2 = stringArray.length;
        for (n = 0; n < n2 && !"debug.fix".equals(stringArray[n]); ++n) {
        }
        if (n == n2) {
            return false;
        }
        return ((ActionProvider)project.getLookup().lookup(ActionProvider.class)).isActionEnabled("debug.fix", this.getLookup());
    }

    private Lookup getLookup() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        int n = nodeArray.length;
        ArrayList<Node.Cookie> arrayList = new ArrayList<Node.Cookie>();
        for (int i = 0; i < n; ++i) {
            Node.Cookie cookie = nodeArray[i].getCookie(DataObject.class);
            if (cookie == null) continue;
            arrayList.add(cookie);
        }
        return Lookups.fixed((Object[])arrayList.toArray(new DataObject[arrayList.size()]));
    }

    private class Listener
    implements PropertyChangeListener,
    DebuggerManagerListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = FixActionProvider.this.shouldBeEnabled();
            FixActionProvider.this.setEnabled(ActionsManager.ACTION_FIX, bl);
            if (FixActionProvider.this.debugger.getState() == 4) {
                FixActionProvider.this.destroy();
            }
        }

        public void sessionRemoved(Session session) {
        }

        public void breakpointAdded(Breakpoint breakpoint) {
        }

        public void breakpointRemoved(Breakpoint breakpoint) {
        }

        public Breakpoint[] initBreakpoints() {
            return new Breakpoint[0];
        }

        public void initWatches() {
        }

        public void sessionAdded(Session session) {
        }

        public void watchAdded(Watch watch) {
        }

        public void watchRemoved(Watch watch) {
        }

        public void engineAdded(DebuggerEngine debuggerEngine) {
        }

        public void engineRemoved(DebuggerEngine debuggerEngine) {
        }
    }
}

