/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.IllegalComponentStateException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Elements;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.JumpList;
import org.netbeans.modules.debugger.jpda.projects.AST2Bytecode;
import org.netbeans.modules.debugger.jpda.projects.ClassScanner;
import org.netbeans.modules.debugger.jpda.projects.DebuggerAnnotation;
import org.netbeans.modules.debugger.jpda.projects.DebuggerBreakpointAnnotation;
import org.netbeans.modules.debugger.jpda.projects.ExpressionScanner;
import org.netbeans.modules.debugger.jpda.projects.LineTranslations;
import org.netbeans.modules.debugger.jpda.projects.MethodArgumentsScanner;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorContextImpl
extends EditorContext {
    private static String fronting = System.getProperty("netbeans.debugger.fronting");
    private PropertyChangeSupport pcs;
    private Map annotationToURL = new HashMap();
    private PropertyChangeListener editorObservableListener;
    private PropertyChangeListener tcListener;
    private RequestProcessor refreshProcessor;
    private Lookup.Result resDataObject;
    private Lookup.Result resEditorCookie;
    private Lookup.Result resNode;
    private Object currentLock = new Object();
    private String currentURL = null;
    private EditorCookie currentEditorCookie = null;

    public EditorContextImpl() {
        this.pcs = new PropertyChangeSupport((Object)this);
        this.refreshProcessor = new RequestProcessor("Refresh Editor Context", 1);
        this.resDataObject = Utilities.actionsGlobalContext().lookup(new Lookup.Template(DataObject.class));
        this.resDataObject.addLookupListener((LookupListener)new EditorLookupListener(DataObject.class));
        this.resEditorCookie = Utilities.actionsGlobalContext().lookup(new Lookup.Template(EditorCookie.class));
        this.resEditorCookie.addLookupListener((LookupListener)new EditorLookupListener(EditorCookie.class));
        this.resNode = Utilities.actionsGlobalContext().lookup(new Lookup.Template(Node.class));
        this.resNode.addLookupListener((LookupListener)new EditorLookupListener(Node.class));
        this.tcListener = new EditorLookupListener(TopComponent.class);
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.tcListener, (Object)TopComponent.getRegistry()));
    }

    public boolean showSource(String string, int n, Object object) {
        Line line = EditorContextImpl.showSourceLine(string, n, object);
        if (line != null) {
            this.addPositionToJumpList(string, line, 0);
        }
        return line != null;
    }

    static Line showSourceLine(String string, int n, Object object) {
        Line line = LineTranslations.getTranslations().getLine(string, n, object);
        if (line == null) {
            ErrorManager.getDefault().log(16, "Show Source: Have no line for URL = " + string + ", line number = " + n);
            return null;
        }
        if ("true".equalsIgnoreCase(fronting) || Utilities.isWindows()) {
            line.show(4);
            line.show(3);
        } else {
            line.show(4);
        }
        return line;
    }

    public boolean showSource(String string, int n, int n2, int n3, Object object) {
        Line line = LineTranslations.getTranslations().getLine(string, n, object);
        if (line == null) {
            ErrorManager.getDefault().log(16, "Show Source: Have no line for URL = " + string + ", line number = " + n);
            return false;
        }
        if ("true".equalsIgnoreCase(fronting) || Utilities.isWindows()) {
            line.show(3, n2);
        } else {
            line.show(2, n2);
        }
        this.addPositionToJumpList(string, line, n2);
        return true;
    }

    private void addPositionToJumpList(String string, Line line, int n) {
        EditorCookie editorCookie;
        DataObject dataObject = EditorContextImpl.getDataObject(string);
        if (dataObject != null && (editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class)) != null) {
            try {
                StyledDocument styledDocument = editorCookie.openDocument();
                JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
                if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                    JumpList.addEntry((JTextComponent)jEditorPaneArray[0], (int)(NbDocument.findLineOffset((StyledDocument)styledDocument, (int)line.getLineNumber()) + n));
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    public void createTimeStamp(Object object) {
        LineTranslations.getTranslations().createTimeStamp(object);
    }

    public void disposeTimeStamp(Object object) {
        LineTranslations.getTranslations().disposeTimeStamp(object);
    }

    public Object annotate(String string, int n, String string2, Object object) {
        Line line = LineTranslations.getTranslations().getLine(string, n, object instanceof JPDABreakpoint ? null : object);
        if (line == null) {
            return null;
        }
        Object object2 = object instanceof JPDABreakpoint ? new DebuggerBreakpointAnnotation(string2, line, (JPDABreakpoint)object) : new DebuggerAnnotation(string2, line);
        this.annotationToURL.put(object2, string);
        return object2;
    }

    public Object annotate(String string, int n, int n2, String string2, Object object) {
        DebuggerAnnotation debuggerAnnotation;
        Coloring coloring = "LastOperation".equals(string2) ? new Coloring(null, 7, null, null, EditorContextImpl.getColor(string2), null, null) : new Coloring(null, null, EditorContextImpl.getColor(string2));
        OperationHighlight operationHighlight = new OperationHighlight(coloring, n, n2);
        try {
            debuggerAnnotation = new DebuggerAnnotation(string2, operationHighlight, URLMapper.findFileObject((URL)new URL(string)));
        }
        catch (MalformedURLException malformedURLException) {
            RuntimeException runtimeException = new RuntimeException("Bad URL: " + string);
            runtimeException.initCause(malformedURLException);
            throw runtimeException;
        }
        this.annotationToURL.put(debuggerAnnotation, string);
        return debuggerAnnotation;
    }

    private static Color getColor(String string) {
        if (string.endsWith("_broken")) {
            string = string.substring(0, string.length() - "_broken".length());
        }
        if ("Breakpoint".equals(string)) {
            return new Color(16555423);
        }
        if ("CurrentPC".equals(string) || "StepOutOperation".equals(string)) {
            return new Color(12445354);
        }
        if ("CurrentExpressionLine".equals(string)) {
            return new Color(15335398);
        }
        if ("LastOperation".equals(string)) {
            return new Color(10075018);
        }
        return new Color(255);
    }

    public void removeAnnotation(Object object) {
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.removeAnnotation((Annotation)iterator.next());
            }
        } else {
            this.removeAnnotation((Annotation)object);
        }
    }

    private void removeAnnotation(Annotation annotation) {
        annotation.detach();
        this.annotationToURL.remove(annotation);
    }

    public int getLineNumber(Object object, Object object2) {
        if (object instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)object;
            return LineTranslations.getTranslations().getOriginalLineNumber(lineBreakpoint, object2);
        }
        Line line = object instanceof DebuggerBreakpointAnnotation ? ((DebuggerBreakpointAnnotation)((Object)object)).getLine() : ((DebuggerAnnotation)((Object)object)).getLine();
        if (object2 == null) {
            return line.getLineNumber() + 1;
        }
        String string = (String)this.annotationToURL.get(object);
        Line.Set set = LineTranslations.getTranslations().getLineSet(string, object2);
        return set.getOriginalLineNumber(line) + 1;
    }

    public void updateTimeStamp(Object object, String string) {
        LineTranslations.getTranslations().updateTimeStamp(object, string);
    }

    public int getCurrentLineNumber() {
        if (SwingUtilities.isEventDispatchThread()) {
            return this.getCurrentLineNumber_();
        }
        final int[] nArray = new int[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    nArray[0] = EditorContextImpl.this.getCurrentLineNumber_();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify(invocationTargetException.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return nArray[0];
    }

    private int getCurrentLineNumber_() {
        EditorCookie editorCookie = this.getCurrentEditorCookie();
        if (editorCookie == null) {
            return -1;
        }
        JEditorPane jEditorPane = this.getCurrentEditor();
        if (jEditorPane == null) {
            return -1;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return -1;
        }
        Caret caret = jEditorPane.getCaret();
        if (caret == null) {
            return -1;
        }
        int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)caret.getDot());
        return n + 1;
    }

    public int getCurrentOffset() {
        if (SwingUtilities.isEventDispatchThread()) {
            return this.getCurrentOffset_();
        }
        final int[] nArray = new int[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    nArray[0] = EditorContextImpl.this.getCurrentOffset_();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify(invocationTargetException.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return nArray[0];
    }

    private int getCurrentOffset_() {
        EditorCookie editorCookie = this.getCurrentEditorCookie();
        if (editorCookie == null) {
            return -1;
        }
        JEditorPane jEditorPane = this.getCurrentEditor();
        if (jEditorPane == null) {
            return -1;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return -1;
        }
        Caret caret = jEditorPane.getCaret();
        if (caret == null) {
            return -1;
        }
        return caret.getDot();
    }

    public String getCurrentClassName() {
        String string = this.getCurrentElement(ElementKind.CLASS);
        if (string == null) {
            return "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentURL() {
        DataObject[] dataObjectArray = this.currentLock;
        synchronized (this.currentLock) {
            if (this.currentURL != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.currentURL;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            dataObjectArray = this.resDataObject.allInstances().toArray(new DataObject[0]);
            Object object = this.currentLock;
            synchronized (object) {
                if (this.currentURL == null) {
                    this.currentURL = "";
                    if (dataObjectArray.length != 1) {
                        return this.currentURL;
                    }
                    DataObject dataObject = dataObjectArray[0];
                    if (dataObject instanceof DataShadow) {
                        dataObject = ((DataShadow)dataObject).getOriginal();
                    }
                    try {
                        this.currentURL = dataObject.getPrimaryFile().getURL().toString();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        // empty catch block
                    }
                }
                return this.currentURL;
            }
        }
    }

    public String getCurrentMethodName() {
        String string = this.getCurrentElement(ElementKind.METHOD);
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getCurrentMethodSignature() {
        final javax.lang.model.element.Element[] elementArray = new javax.lang.model.element.Element[]{null};
        try {
            this.getCurrentElement(ElementKind.METHOD, elementArray);
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            throw new IllegalComponentStateException(){

                public String getMessage() {
                    illegalComponentStateException.getMessage();
                    return EditorContextImpl.createSignature((ExecutableElement)elementArray[0]);
                }
            };
        }
        if (elementArray[0] != null) {
            return EditorContextImpl.createSignature((ExecutableElement)elementArray[0]);
        }
        return null;
    }

    public String getCurrentFieldName() {
        String string = this.getCurrentElement(ElementKind.FIELD);
        if (string == null) {
            return "";
        }
        return string;
    }

    public String getSelectedIdentifier() {
        if (SwingUtilities.isEventDispatchThread()) {
            return this.getSelectedIdentifier_();
        }
        final String[] stringArray = new String[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    stringArray[0] = EditorContextImpl.this.getSelectedIdentifier_();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify(invocationTargetException.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return stringArray[0];
    }

    private String getSelectedIdentifier_() {
        JEditorPane jEditorPane = this.getCurrentEditor();
        if (jEditorPane == null) {
            return null;
        }
        String string = jEditorPane.getSelectedText();
        if (string == null) {
            return null;
        }
        if (Utilities.isJavaIdentifier((String)string)) {
            return string;
        }
        return null;
    }

    public String getSelectedMethodName() {
        if (SwingUtilities.isEventDispatchThread()) {
            return this.getSelectedMethodName_();
        }
        final String[] stringArray = new String[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    stringArray[0] = EditorContextImpl.this.getSelectedMethodName_();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify(invocationTargetException.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return stringArray[0];
    }

    private String getSelectedMethodName_() {
        EditorCookie editorCookie = this.getCurrentEditorCookie();
        if (editorCookie == null) {
            return "";
        }
        JEditorPane jEditorPane = this.getCurrentEditor();
        if (jEditorPane == null) {
            return "";
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return "";
        }
        int n = jEditorPane.getCaret().getDot();
        String string = null;
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        try {
            int n4;
            int n5;
            Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(n2);
            if (element == null) {
                return "";
            }
            int n6 = element.getStartOffset();
            int n7 = element.getEndOffset() - n6;
            string = styledDocument.getText(n6, n7);
            for (n5 = n3; n5 > 0 && Character.isJavaIdentifierPart(string.charAt(n5 - 1)); --n5) {
            }
            for (n4 = n3; n4 < n7 && Character.isJavaIdentifierPart(string.charAt(n4)); ++n4) {
            }
            int n8 = string.indexOf(40, n4);
            if (n8 < 0) {
                return "";
            }
            if (string.substring(n4, n8).trim().length() > 0) {
                return "";
            }
            if (n5 == n4) {
                return "";
            }
            return string.substring(n5, n4);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private static TypeElement getTypeElement(CompilationController compilationController, String string, String[] stringArray) {
        ClassScanner classScanner = new ClassScanner(compilationController.getTrees(), compilationController.getElements(), string, stringArray);
        TypeElement typeElement = (TypeElement)classScanner.scan(compilationController.getCompilationUnit(), null);
        if (typeElement != null) {
            return typeElement;
        }
        return null;
    }

    public int getFieldLineNumber(String string, String string2, String string3) {
        DataObject dataObject = EditorContextImpl.getDataObject(string);
        if (dataObject == null) {
            return -1;
        }
        return EditorContextImpl.getFieldLineNumber(dataObject.getPrimaryFile(), string2, string3);
    }

    static int getFieldLineNumber(FileObject fileObject, final String string, final String string2) {
        DataObject dataObject;
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return -1;
        }
        final int[] nArray = new int[]{-1};
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return -1;
        }
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        ErrorManager.getDefault().log(16, "Unable to resolve " + compilationController.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + compilationController.getPhase() + "\nDiagnostics = " + compilationController.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        return;
                    }
                    Elements elements = compilationController.getElements();
                    TypeElement typeElement = EditorContextImpl.getTypeElement(compilationController, string, null);
                    if (typeElement == null) {
                        return;
                    }
                    List<? extends javax.lang.model.element.Element> list = elements.getAllMembers(typeElement);
                    for (javax.lang.model.element.Element element : list) {
                        String string3;
                        if (element.getKind() != ElementKind.FIELD || !(string3 = ((VariableElement)element).getSimpleName().toString()).equals(string2)) continue;
                        SourcePositions sourcePositions = compilationController.getTrees().getSourcePositions();
                        Tree tree = compilationController.getTrees().getTree(element);
                        int n = (int)sourcePositions.getStartPosition(compilationController.getCompilationUnit(), tree);
                        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                        nArray[0] = NbDocument.findLineNumber((StyledDocument)editorCookie.openDocument(), (int)n) + 1;
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return -1;
        }
        return nArray[0];
    }

    public int getMethodLineNumber(String string, String string2, String string3, String string4) {
        DataObject dataObject = EditorContextImpl.getDataObject(string);
        if (dataObject == null) {
            return -1;
        }
        int[] nArray = EditorContextImpl.getMethodLineNumbers(dataObject.getPrimaryFile(), string2, null, string3, string4);
        if (nArray.length == 0) {
            return -1;
        }
        return nArray[0];
    }

    static int[] getMethodLineNumbers(FileObject fileObject, final String string, final String[] stringArray, final String string2, final String string3) {
        DataObject dataObject;
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return new int[0];
        }
        final ArrayList arrayList = new ArrayList();
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return new int[0];
        }
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        ErrorManager.getDefault().log(16, "Unable to resolve " + compilationController.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + compilationController.getPhase() + "\nDiagnostics = " + compilationController.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        return;
                    }
                    TypeElement typeElement = EditorContextImpl.getTypeElement(compilationController, string, stringArray);
                    if (typeElement == null) {
                        return;
                    }
                    List<? extends javax.lang.model.element.Element> list = compilationController.getElements().getAllMembers(typeElement);
                    for (javax.lang.model.element.Element element : list) {
                        int n;
                        String string4;
                        if (element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.CONSTRUCTOR || !(string4 = element.getKind() == ElementKind.CONSTRUCTOR && !string2.equals("<init>") ? element.getEnclosingElement().getSimpleName().toString() : element.getSimpleName().toString()).equals(string2) || string3 != null && !EditorContextImpl.egualMethodSignatures(string3, EditorContextImpl.createSignature((ExecutableElement)element))) continue;
                        SourcePositions sourcePositions = compilationController.getTrees().getSourcePositions();
                        Tree tree = compilationController.getTrees().getTree(element);
                        String string22 = compilationController.getText();
                        int n2 = string22.length();
                        char c = '\u0000';
                        for (n = (int)sourcePositions.getStartPosition(compilationController.getCompilationUnit(), tree); n < n2 && (c = string22.charAt(n)) != '(' && c != ')'; ++n) {
                        }
                        if (n >= n2) {
                            c = '\u0000';
                            n = (int)sourcePositions.getStartPosition(compilationController.getCompilationUnit(), tree);
                        }
                        if (c == '(') {
                            --n;
                            while (n > 0 && Character.isWhitespace(string22.charAt(n))) {
                                --n;
                            }
                        }
                        string22 = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                        arrayList.add(new Integer(NbDocument.findLineNumber((StyledDocument)string22.openDocument(), (int)n) + 1));
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return new int[0];
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    private static boolean egualMethodSignatures(String string, String string2) {
        int n = string.lastIndexOf(")");
        if (n > 0) {
            string = string.substring(0, n);
        }
        if ((n = string2.lastIndexOf(")")) > 0) {
            string2 = string2.substring(0, n);
        }
        return string.equals(string2);
    }

    public String[] getCurrentMethodDeclaration() {
        String[] stringArray;
        block11: {
            Node[] nodeArray = TopComponent.getRegistry().getCurrentNodes();
            if (nodeArray == null) {
                return null;
            }
            if (nodeArray.length != 1) {
                return null;
            }
            DataObject dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class);
            if (dataObject == null) {
                return null;
            }
            JavaSource javaSource = JavaSource.forFileObject((FileObject)dataObject.getPrimaryFile());
            if (javaSource == null) {
                return null;
            }
            EditorCookie editorCookie = (EditorCookie)nodeArray[0].getCookie(EditorCookie.class);
            JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
            JTextComponent jTextComponent = jEditorPaneArray != null && jEditorPaneArray.length >= 1 ? jEditorPaneArray[0] : null;
            final int n = jTextComponent == null ? 0 : jTextComponent.getCaretPosition();
            stringArray = new String[]{null, null, null};
            try {
                final Future future = javaSource.runWhenScanFinished((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        javax.lang.model.element.Element element;
                        Tree tree;
                        int n3;
                        if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                            ErrorManager.getDefault().log(16, "Unable to resolve " + compilationController.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + compilationController.getPhase() + "\nDiagnostics = " + compilationController.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                            return;
                        }
                        String string = compilationController.getText();
                        int n2 = string.length();
                        char c = '\u0000';
                        for (n3 = n; n3 < n2 && (c = string.charAt(n3)) != '(' && c != ')' && c != '\n' && c != '\r'; ++n3) {
                        }
                        if (n3 >= n2) {
                            return;
                        }
                        if (c == '(') {
                            --n3;
                        }
                        if ((tree = compilationController.getTreeUtilities().pathFor(n3).getLeaf()).getKind() == Tree.Kind.METHOD && (element = compilationController.getTrees().getElement(compilationController.getTrees().getPath(compilationController.getCompilationUnit(), tree))) != null && (element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR)) {
                            stringArray[0] = element.getSimpleName().toString();
                            if (stringArray[0].equals("<init>")) {
                                stringArray[0] = element.getEnclosingElement().getSimpleName().toString();
                            }
                            stringArray[1] = EditorContextImpl.createSignature((ExecutableElement)element);
                            TypeElement typeElement = null;
                            for (javax.lang.model.element.Element element2 = element; element2 != null; element2 = element2.getEnclosingElement()) {
                                ElementKind elementKind = element2.getKind();
                                if (elementKind != ElementKind.CLASS && elementKind != ElementKind.INTERFACE) continue;
                                typeElement = (TypeElement)element2;
                                break;
                            }
                            if (typeElement != null) {
                                stringArray[2] = ElementUtilities.getBinaryName(typeElement);
                            }
                        }
                    }
                }, true);
                if (future.isDone()) break block11;
                if (EventQueue.isDispatchThread()) {
                    throw new IllegalComponentStateException(){

                        private void waitScanFinished() {
                            try {
                                future.get();
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (ExecutionException executionException) {
                                ErrorManager.getDefault().notify((Throwable)executionException);
                            }
                        }

                        public String getMessage() {
                            this.waitScanFinished();
                            return stringArray[0];
                        }

                        public String getLocalizedMessage() {
                            this.waitScanFinished();
                            return stringArray[1];
                        }
                    };
                }
                try {
                    future.get();
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
                catch (ExecutionException executionException) {
                    ErrorManager.getDefault().notify((Throwable)executionException);
                    return null;
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return null;
            }
        }
        if (stringArray[0] != null) {
            return stringArray;
        }
        return null;
    }

    private static String createSignature(ExecutableElement executableElement) {
        StringBuilder stringBuilder = new StringBuilder("(");
        for (VariableElement variableElement : executableElement.getParameters()) {
            String string = ((Object)variableElement.asType()).toString();
            stringBuilder.append(EditorContextImpl.getSignature(string));
        }
        stringBuilder.append(')');
        String string = ((Object)executableElement.getReturnType()).toString();
        stringBuilder.append(EditorContextImpl.getSignature(string));
        return stringBuilder.toString();
    }

    private static String getSignature(String string) {
        if (string.equals("boolean")) {
            return "Z";
        }
        if (string.equals("byte")) {
            return "B";
        }
        if (string.equals("char")) {
            return "C";
        }
        if (string.equals("short")) {
            return "S";
        }
        if (string.equals("int")) {
            return "I";
        }
        if (string.equals("long")) {
            return "J";
        }
        if (string.equals("float")) {
            return "F";
        }
        if (string.equals("double")) {
            return "D";
        }
        if (string.endsWith("[]")) {
            return "[" + EditorContextImpl.getSignature(string.substring(0, string.length() - 2));
        }
        return "L" + string.replace('.', '/') + ";";
    }

    public String getClassName(String string, int n) {
        StyledDocument styledDocument;
        DataObject dataObject = EditorContextImpl.getDataObject(string);
        if (dataObject == null) {
            return null;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)dataObject.getPrimaryFile());
        if (javaSource == null) {
            return "";
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return "";
        }
        try {
            styledDocument = editorCookie.openDocument();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return "";
        }
        try {
            final int n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n - 1));
            final String[] stringArray = new String[]{""};
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        ErrorManager.getDefault().log(16, "Unable to resolve " + compilationController.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + compilationController.getPhase() + "\nDiagnostics = " + compilationController.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        return;
                    }
                    Scope scope = compilationController.getTreeUtilities().scopeFor(n2);
                    TypeElement typeElement = scope.getEnclosingClass();
                    if (typeElement != null) {
                        stringArray[0] = ElementUtilities.getBinaryName((TypeElement)typeElement);
                    } else {
                        ErrorManager.getDefault().log(16, "No enclosing class for " + compilationController.getFileObject() + ", offset = " + n2);
                    }
                }
            }, true);
            return stringArray[0];
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return "";
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public EditorContext.Operation[] getOperations(String string, final int n, EditorContext.BytecodeProvider bytecodeProvider) {
        StyledDocument styledDocument;
        DataObject dataObject = EditorContextImpl.getDataObject(string);
        if (dataObject == null) {
            return null;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)dataObject.getPrimaryFile());
        if (javaSource == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        try {
            styledDocument = editorCookie.openDocument();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        final int n2 = EditorContextImpl.findLineOffset(styledDocument, n);
        final EditorContext.Operation[][] operationArrayArray = new EditorContext.Operation[1][];
        final CompilationController[] compilationControllerArray = new CompilationController[1];
        final List[] listArray = new List[1];
        final ExpressionScanner.ExpressionsInfo[] expressionsInfoArray = new ExpressionScanner.ExpressionsInfo[1];
        final Tree[] treeArray = new Tree[1];
        final int[] nArray = new int[1];
        final int[] nArray2 = new int[1];
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    ExpressionScanner.ExpressionsInfo expressionsInfo;
                    CompilationUnitTree compilationUnitTree;
                    ExpressionScanner expressionScanner;
                    if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        ErrorManager.getDefault().log(16, "Unable to resolve " + compilationController.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + compilationController.getPhase() + "\nDiagnostics = " + compilationController.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        operationArrayArray[0] = new EditorContext.Operation[0];
                        return;
                    }
                    Scope scope = compilationController.getTreeUtilities().scopeFor(n2);
                    ExecutableElement executableElement = scope.getEnclosingMethod();
                    if (executableElement == null) {
                        operationArrayArray[0] = new EditorContext.Operation[0];
                        return;
                    }
                    Tree tree = compilationController.getTrees().getTree((javax.lang.model.element.Element)executableElement);
                    List<Tree> list = tree.accept(expressionScanner = new ExpressionScanner(n, compilationUnitTree = compilationController.getCompilationUnit(), compilationController.getTrees().getSourcePositions()), expressionsInfo = new ExpressionScanner.ExpressionsInfo());
                    if (list == null || list.size() == 0) {
                        operationArrayArray[0] = new EditorContext.Operation[0];
                        return;
                    }
                    listArray[0] = list;
                    expressionsInfoArray[0] = expressionsInfo;
                    compilationControllerArray[0] = compilationController;
                    treeArray[0] = tree;
                    SourcePositions sourcePositions = compilationController.getTrees().getSourcePositions();
                    nArray[0] = (int)compilationUnitTree.getLineMap().getLineNumber(sourcePositions.getStartPosition(compilationUnitTree, list.get(0)));
                    nArray2[0] = (int)compilationUnitTree.getLineMap().getLineNumber(sourcePositions.getEndPosition(compilationUnitTree, list.get(list.size() - 1)));
                }
            }, false);
            if (operationArrayArray[0] != null) {
                return operationArrayArray[0];
            }
            int n3 = nArray[0];
            int n4 = nArray2[0];
            int[] nArray3 = bytecodeProvider.indexAtLines(n3, n4);
            if (nArray3 == null) {
                return null;
            }
            HashMap<Tree, EditorContext.Operation> hashMap = new HashMap<Tree, EditorContext.Operation>();
            CompilationController compilationController = compilationControllerArray[0];
            CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
            List list = listArray[0];
            operationArrayArray[0] = AST2Bytecode.matchSourceTree2Bytecode(compilationUnitTree, compilationController, list, expressionsInfoArray[0], bytecodeProvider.byteCodes(), nArray3, bytecodeProvider.constantPool(), new OperationCreationDelegateImpl(), hashMap);
            if (operationArrayArray[0] != null) {
                this.assignNextOperations(treeArray[0], compilationUnitTree, compilationController, bytecodeProvider, list, expressionsInfoArray[0], hashMap);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        return operationArrayArray[0];
    }

    private void assignNextOperations(Tree tree, CompilationUnitTree compilationUnitTree, CompilationController compilationController, EditorContext.BytecodeProvider bytecodeProvider, List<Tree> list, ExpressionScanner.ExpressionsInfo expressionsInfo, Map<Tree, EditorContext.Operation> map) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Tree tree2 = list.get(i);
            Set<Tree> set = expressionsInfo.getNextExpressions(tree2);
            if (set == null) continue;
            EditorContext.Operation operation = map.get(tree2);
            if (operation == null) {
                for (int j = i - 1; j >= 0 && (operation = map.get(tree2 = list.get(j))) == null; --j) {
                }
            }
            if (operation == null) continue;
            for (Tree tree3 : set) {
                EditorContext.Operation operation2 = map.get(tree3);
                if (operation2 == null) {
                    ExpressionScanner.ExpressionsInfo expressionsInfo2;
                    SourcePositions sourcePositions = compilationController.getTrees().getSourcePositions();
                    int n2 = (int)compilationUnitTree.getLineMap().getLineNumber(sourcePositions.getStartPosition(compilationUnitTree, tree3));
                    ExpressionScanner expressionScanner = new ExpressionScanner(n2, compilationUnitTree, compilationController.getTrees().getSourcePositions());
                    List<Tree> list2 = tree.accept(expressionScanner, expressionsInfo2 = new ExpressionScanner.ExpressionsInfo());
                    if (list2 == null) continue;
                    n2 = (int)compilationUnitTree.getLineMap().getLineNumber(sourcePositions.getStartPosition(compilationUnitTree, list2.get(0)));
                    int n3 = (int)compilationUnitTree.getLineMap().getLineNumber(sourcePositions.getEndPosition(compilationUnitTree, list2.get(list2.size() - 1)));
                    int[] nArray = bytecodeProvider.indexAtLines(n2, n3);
                    HashMap<Tree, EditorContext.Operation> hashMap = new HashMap<Tree, EditorContext.Operation>();
                    EditorContext.Operation[] operationArray = AST2Bytecode.matchSourceTree2Bytecode(compilationUnitTree, compilationController, list2, expressionsInfo2, bytecodeProvider.byteCodes(), nArray, bytecodeProvider.constantPool(), new OperationCreationDelegateImpl(), hashMap);
                    operation2 = (EditorContext.Operation)hashMap.get(tree3);
                    if (operation2 == null) {
                        System.err.println("Next operation not found!");
                        continue;
                    }
                }
                this.addNextOperationTo(operation, operation2);
            }
        }
    }

    private static int findLineOffset(StyledDocument styledDocument, int n) {
        int n2;
        try {
            n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)(n - 1));
            int n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
            try {
                String string = styledDocument.getText(n2, n3 - n2);
                for (int i = 0; i < string.length(); ++i) {
                    if (Character.isWhitespace(string.charAt(i))) continue;
                    n2 += i;
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
        return n2;
    }

    public EditorContext.MethodArgument[] getArguments(String string, final EditorContext.Operation operation) {
        DataObject dataObject = EditorContextImpl.getDataObject(string);
        if (dataObject == null) {
            return null;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)dataObject.getPrimaryFile());
        if (javaSource == null) {
            return null;
        }
        final EditorContext.MethodArgument[][] methodArgumentArrayArray = new EditorContext.MethodArgument[1][];
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        ErrorManager.getDefault().log(16, "Unable to resolve " + compilationController.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + compilationController.getPhase() + "\nDiagnostics = " + compilationController.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        return;
                    }
                    int n = operation.getMethodEndPosition().getOffset();
                    Scope scope = compilationController.getTreeUtilities().scopeFor(n);
                    ExecutableElement executableElement = scope.getEnclosingMethod();
                    if (executableElement == null) {
                        return;
                    }
                    Tree tree = compilationController.getTrees().getTree((javax.lang.model.element.Element)executableElement);
                    CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                    MethodArgumentsScanner methodArgumentsScanner = new MethodArgumentsScanner(n, compilationUnitTree, compilationController.getTrees().getSourcePositions(), true, new OperationCreationDelegateImpl());
                    methodArgumentArrayArray[0] = tree.accept(methodArgumentsScanner, null);
                    methodArgumentArrayArray[0] = methodArgumentsScanner.getArguments();
                }
            }, true);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        return methodArgumentArrayArray[0];
    }

    public EditorContext.MethodArgument[] getArguments(String string, final int n) {
        StyledDocument styledDocument;
        DataObject dataObject = EditorContextImpl.getDataObject(string);
        if (dataObject == null) {
            return null;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)dataObject.getPrimaryFile());
        if (javaSource == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        try {
            styledDocument = editorCookie.openDocument();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        final int n2 = EditorContextImpl.findLineOffset(styledDocument, n);
        final EditorContext.MethodArgument[][] methodArgumentArrayArray = new EditorContext.MethodArgument[1][];
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        ErrorManager.getDefault().log(16, "Unable to resolve " + compilationController.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + compilationController.getPhase() + "\nDiagnostics = " + compilationController.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        return;
                    }
                    Scope scope = compilationController.getTreeUtilities().scopeFor(n2);
                    TypeElement typeElement = scope.getEnclosingClass();
                    if (typeElement == null) {
                        return;
                    }
                    Tree tree = compilationController.getTrees().getTree((javax.lang.model.element.Element)typeElement);
                    CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                    MethodArgumentsScanner methodArgumentsScanner = new MethodArgumentsScanner(n, compilationUnitTree, compilationController.getTrees().getSourcePositions(), false, new OperationCreationDelegateImpl());
                    methodArgumentArrayArray[0] = tree.accept(methodArgumentsScanner, null);
                    methodArgumentArrayArray[0] = methodArgumentsScanner.getArguments();
                }
            }, true);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        return methodArgumentArrayArray[0];
    }

    public String[] getImports(String string) {
        DataObject dataObject = EditorContextImpl.getDataObject(string);
        if (dataObject == null) {
            return new String[0];
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)dataObject.getPrimaryFile());
        if (javaSource == null) {
            return new String[0];
        }
        final ArrayList arrayList = new ArrayList();
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    if (compilationController.toPhase(JavaSource.Phase.PARSED).compareTo((Enum)JavaSource.Phase.PARSED) < 0) {
                        ErrorManager.getDefault().log(16, "Unable to resolve " + compilationController.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + compilationController.getPhase() + "\nDiagnostics = " + compilationController.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        return;
                    }
                    List<? extends ImportTree> list = compilationController.getCompilationUnit().getImports();
                    int n = 0;
                    for (ImportTree importTree : list) {
                        String string = importTree.getQualifiedIdentifier().toString();
                        arrayList.add(string);
                        ++n;
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return new String[0];
        }
        return arrayList.toArray(new String[0]);
    }

    private JavaSource getJavaSource(SourcePathProvider sourcePathProvider) {
        ClassPath classPath = sourcePathProvider.getOriginalSourceRoots();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (String string : classPath) {
            FileObject fileObject = FileUtil.toFileObject((File)new File(string));
            if (fileObject != null && FileUtil.isArchiveFile((FileObject)fileObject)) {
                fileObject = FileUtil.getArchiveRoot((FileObject)fileObject);
            }
            arrayList.add(fileObject);
        }
        ClassPath classPath2 = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClassPath classPath3 = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClassPath classPath4 = ClassPathSupport.createClassPath((FileObject[])arrayList.toArray(new FileObject[0]));
        return JavaSource.create((ClasspathInfo)ClasspathInfo.create((ClassPath)classPath2, (ClassPath)classPath3, (ClassPath)classPath4), (FileObject[])new FileObject[0]);
    }

    public <R, D> R parseExpression(final String string, String string2, final int n, TreePathScanner<R, D> treePathScanner, final D d, SourcePathProvider sourcePathProvider) {
        TreePath[] treePathArray;
        JavaSource javaSource = null;
        if (string2 != null) {
            try {
                treePathArray = URLMapper.findFileObject((URL)new URL(string2));
                if (treePathArray != null) {
                    javaSource = JavaSource.forFileObject((FileObject)treePathArray);
                }
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify(16, (Throwable)malformedURLException);
            }
        }
        if (javaSource == null) {
            javaSource = this.getJavaSource(sourcePathProvider);
        }
        treePathArray = new TreePath[]{null};
        final Tree[] treeArray = new Tree[]{null};
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    Object object;
                    if (compilationController.toPhase(JavaSource.Phase.PARSED).compareTo((Enum)JavaSource.Phase.PARSED) < 0) {
                        return;
                    }
                    Scope scope = null;
                    int n2 = 0;
                    StyledDocument styledDocument = (StyledDocument)compilationController.getDocument();
                    if (styledDocument != null) {
                        n2 = EditorContextImpl.findLineOffset(styledDocument, n);
                        scope = compilationController.getTreeUtilities().scopeFor(n2);
                    }
                    SourcePositions[] sourcePositionsArray = new SourcePositions[]{null};
                    ExpressionTree expressionTree = compilationController.getTreeUtilities().parseExpression(string, sourcePositionsArray);
                    if (scope != null) {
                        compilationController.getTreeUtilities().attributeTree((Tree)expressionTree, scope);
                    }
                    try {
                        object = d.getClass().getMethod("setTrees", Trees.class);
                        ((Method)object).invoke(d, compilationController.getTrees());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        object = d.getClass().getMethod("setCompilationUnit", CompilationUnitTree.class);
                        ((Method)object).invoke(d, compilationController.getCompilationUnit());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    object = null;
                    try {
                        Method method = d.getClass().getMethod("setTreePath", TreePath.class);
                        if (styledDocument != null) {
                            object = compilationController.getTreeUtilities().pathFor(n2);
                            object = new TreePath((TreePath)object, expressionTree);
                            method.invoke(d, object);
                        }
                    }
                    catch (Exception exception) {
                        return;
                    }
                    treePathArray[0] = object;
                    treeArray[0] = expressionTree;
                }
            }, false);
            TreePath treePath = treePathArray[0];
            Tree tree = treeArray[0];
            R r = treePath != null ? treePathScanner.scan(treePath, d) : tree.accept(treePathScanner, d);
            return r;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    private String getCurrentElement(ElementKind elementKind) {
        return this.getCurrentElement(elementKind, null);
    }

    private String getCurrentElement(final ElementKind elementKind, javax.lang.model.element.Element[] elementArray) throws IllegalComponentStateException {
        String[] stringArray;
        block13: {
            String[] stringArray2;
            int n;
            JTextComponent jTextComponent;
            Node[] nodeArray = TopComponent.getRegistry().getCurrentNodes();
            if (nodeArray == null) {
                return null;
            }
            if (nodeArray.length != 1) {
                return null;
            }
            DataObject dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class);
            if (dataObject == null) {
                return null;
            }
            JavaSource javaSource = JavaSource.forFileObject((FileObject)dataObject.getPrimaryFile());
            if (javaSource == null) {
                return null;
            }
            EditorCookie editorCookie = (EditorCookie)nodeArray[0].getCookie(EditorCookie.class);
            JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
            JTextComponent jTextComponent2 = jTextComponent = jEditorPaneArray != null && jEditorPaneArray.length >= 1 ? jEditorPaneArray[0] : null;
            if (jTextComponent != null) {
                stringArray = jTextComponent.getSelectedText();
                n = jTextComponent.getCaretPosition();
                if (jTextComponent.getSelectionStart() > n || jTextComponent.getSelectionEnd() < n) {
                    stringArray = null;
                }
                stringArray2 = stringArray != null && Utilities.isJavaIdentifier((String)stringArray) ? stringArray : null;
            } else {
                stringArray2 = null;
                n = 0;
            }
            stringArray = new String[]{null};
            try {
                final Future future = javaSource.runWhenScanFinished((Task)new CancellableTask<CompilationController>((String)stringArray2, n, stringArray, elementArray){
                    final /* synthetic */ String val$selectedIdentifier;
                    final /* synthetic */ int val$currentOffset;
                    final /* synthetic */ String[] val$currentElementPtr;
                    final /* synthetic */ javax.lang.model.element.Element[] val$elementPtr;
                    {
                        this.val$selectedIdentifier = string;
                        this.val$currentOffset = n;
                        this.val$currentElementPtr = stringArray;
                        this.val$elementPtr = elementArray;
                    }

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                            ErrorManager.getDefault().log(16, "Unable to resolve " + compilationController.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + compilationController.getPhase() + "\nDiagnostics = " + compilationController.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                            return;
                        }
                        javax.lang.model.element.Element element = null;
                        if (elementKind == ElementKind.CLASS) {
                            AnnotatedConstruct annotatedConstruct;
                            Tree tree;
                            Object object;
                            boolean bl = false;
                            if (this.val$selectedIdentifier != null && (object = compilationController.getTreeUtilities().pathFor(this.val$currentOffset).getLeaf()).getKind() == Tree.Kind.MEMBER_SELECT) {
                                tree = (MemberSelectTree)object;
                                element = compilationController.getTrees().getElement(compilationController.getTrees().getPath(compilationController.getCompilationUnit(), tree.getExpression()));
                                annotatedConstruct = element.asType();
                                if (annotatedConstruct.getKind().equals((Object)TypeKind.DECLARED)) {
                                    this.val$currentElementPtr[0] = annotatedConstruct.toString();
                                    bl = true;
                                }
                            }
                            if (!bl) {
                                object = compilationController.getTreeUtilities().pathFor(this.val$currentOffset);
                                tree = ((TreePath)object).getLeaf();
                                if (tree.getKind() == Tree.Kind.CLASS) {
                                    annotatedConstruct = (TypeElement)compilationController.getTrees().getElement((TreePath)object);
                                } else {
                                    Scope scope = compilationController.getTreeUtilities().scopeFor(this.val$currentOffset);
                                    annotatedConstruct = scope.getEnclosingClass();
                                }
                                if (annotatedConstruct != null) {
                                    this.val$currentElementPtr[0] = ElementUtilities.getBinaryName((TypeElement)annotatedConstruct);
                                }
                                element = annotatedConstruct;
                            }
                        } else if (elementKind == ElementKind.METHOD) {
                            Scope scope = compilationController.getTreeUtilities().scopeFor(this.val$currentOffset);
                            element = scope.getEnclosingMethod();
                            if (element != null) {
                                this.val$currentElementPtr[0] = element.getSimpleName().toString();
                                if (this.val$currentElementPtr[0].equals("<init>")) {
                                    this.val$currentElementPtr[0] = element.getEnclosingElement().getSimpleName().toString();
                                }
                            }
                        } else if (elementKind == ElementKind.FIELD) {
                            int n;
                            Object object;
                            if (this.val$selectedIdentifier == null) {
                                object = compilationController.getText();
                                int n2 = ((String)object).length();
                                char c = '\u0000';
                                for (n = this.val$currentOffset; n < n2 && (c = ((String)object).charAt(n)) != ';' && c != ',' && c != '\n' && c != '\r'; ++n) {
                                }
                                if (n < n2 && c == ';' || c == ',') {
                                    int n3 = --n;
                                    int n4 = -1;
                                    while (n >= 0 && (c = ((String)object).charAt(n)) != ';' && c != ',' && c != '\n' && c != '\r') {
                                        if (c == '=') {
                                            n4 = n;
                                        }
                                        --n;
                                    }
                                    for (n = n4 > -1 ? n4 : n3; n >= 0 && Character.isWhitespace(((String)object).charAt(n)); --n) {
                                    }
                                }
                                if (n < 0) {
                                    n = 0;
                                }
                            }
                            if ((object = compilationController.getTreeUtilities().pathFor(n).getLeaf()).getKind() == Tree.Kind.VARIABLE) {
                                element = compilationController.getTrees().getElement(compilationController.getTrees().getPath(compilationController.getCompilationUnit(), (Tree)object));
                                if (element.getKind() == ElementKind.FIELD || element.getKind() == ElementKind.ENUM_CONSTANT) {
                                    this.val$currentElementPtr[0] = ((VariableTree)object).getName().toString();
                                }
                            } else if (object.getKind() == Tree.Kind.IDENTIFIER && this.val$selectedIdentifier != null) {
                                IdentifierTree identifierTree = (IdentifierTree)object;
                                String string = identifierTree.getName().toString();
                                Scope scope = compilationController.getTreeUtilities().scopeFor(n);
                                TypeElement typeElement = scope.getEnclosingClass();
                                List<? extends javax.lang.model.element.Element> list = typeElement.getEnclosedElements();
                                for (javax.lang.model.element.Element element2 : list) {
                                    if (!element2.getKind().equals((Object)ElementKind.FIELD) || !element2.getSimpleName().contentEquals(string)) continue;
                                    this.val$currentElementPtr[0] = string;
                                    break;
                                }
                            } else if (object.getKind() == Tree.Kind.MEMBER_SELECT && this.val$selectedIdentifier != null) {
                                MemberSelectTree memberSelectTree = (MemberSelectTree)object;
                                String string = memberSelectTree.getIdentifier().toString();
                                element = compilationController.getTrees().getElement(compilationController.getTrees().getPath(compilationController.getCompilationUnit(), memberSelectTree.getExpression()));
                                if (element.asType().getKind().equals((Object)TypeKind.DECLARED)) {
                                    List<? extends javax.lang.model.element.Element> list = ((DeclaredType)element.asType()).asElement().getEnclosedElements();
                                    for (javax.lang.model.element.Element element3 : list) {
                                        if (!element3.getKind().equals((Object)ElementKind.FIELD) || !element3.getSimpleName().contentEquals(string)) continue;
                                        this.val$currentElementPtr[0] = string;
                                        break;
                                    }
                                }
                            }
                        }
                        if (this.val$elementPtr != null) {
                            this.val$elementPtr[0] = element;
                        }
                    }
                }, true);
                if (future.isDone()) break block13;
                if (EventQueue.isDispatchThread()) {
                    throw new IllegalComponentStateException(){

                        private void waitScanFinished() {
                            try {
                                future.get();
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (ExecutionException executionException) {
                                ErrorManager.getDefault().notify((Throwable)executionException);
                            }
                        }

                        public String getMessage() {
                            this.waitScanFinished();
                            return stringArray[0];
                        }
                    };
                }
                try {
                    future.get();
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
                catch (ExecutionException executionException) {
                    ErrorManager.getDefault().notify((Throwable)executionException);
                    return null;
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return null;
            }
        }
        return stringArray[0];
    }

    private JEditorPane getCurrentEditor() {
        EditorCookie editorCookie = this.getCurrentEditorCookie();
        if (editorCookie == null) {
            return null;
        }
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length < 1) {
            return null;
        }
        return jEditorPaneArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EditorCookie getCurrentEditorCookie() {
        Object object = this.currentLock;
        synchronized (object) {
            if (this.currentEditorCookie == null) {
                TopComponent topComponent = TopComponent.getRegistry().getActivated();
                if (topComponent != null) {
                    this.currentEditorCookie = (EditorCookie)topComponent.getLookup().lookup(EditorCookie.class);
                    if (this.currentEditorCookie != null && this.currentEditorCookie.getOpenedPanes() == null) {
                        this.currentEditorCookie = null;
                    }
                }
                if (this.currentEditorCookie instanceof EditorCookie.Observable) {
                    if (this.editorObservableListener == null) {
                        this.editorObservableListener = new EditorLookupListener(EditorCookie.Observable.class);
                    }
                    ((EditorCookie.Observable)this.currentEditorCookie).addPropertyChangeListener(this.editorObservableListener);
                }
            }
            return this.currentEditorCookie;
        }
    }

    private static DataObject getDataObject(String string) {
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        if (fileObject == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    private class OperationCreationDelegateImpl
    implements AST2Bytecode.OperationCreationDelegate {
        private OperationCreationDelegateImpl() {
        }

        public EditorContext.Operation createMethodOperation(EditorContext.Position position, EditorContext.Position position2, EditorContext.Position position3, EditorContext.Position position4, String string, String string2, int n) {
            return EditorContextImpl.this.createMethodOperation(position, position2, position3, position4, string, string2, n);
        }

        public EditorContext.Position createPosition(int n, int n2, int n3) {
            return EditorContextImpl.this.createPosition(n, n2, n3);
        }

        public void addNextOperationTo(EditorContext.Operation operation, EditorContext.Operation operation2) {
            EditorContextImpl.this.addNextOperationTo(operation, operation2);
        }
    }

    private static final class OperationHighlight
    implements Highlight {
        private Coloring coloring;
        private int start;
        private int end;

        public OperationHighlight(Coloring coloring, int n, int n2) {
            this.coloring = coloring;
            this.start = n;
            this.end = n2;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public Coloring getColoring() {
            return this.coloring;
        }
    }

    private class EditorLookupListener
    implements LookupListener,
    PropertyChangeListener,
    Runnable {
        private Class type;

        public EditorLookupListener(Class clazz) {
            this.type = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            if (this.type == DataObject.class) {
                Object object = EditorContextImpl.this.currentLock;
                synchronized (object) {
                    EditorContextImpl.this.currentURL = null;
                    if (EditorContextImpl.this.currentEditorCookie instanceof EditorCookie.Observable) {
                        ((EditorCookie.Observable)EditorContextImpl.this.currentEditorCookie).removePropertyChangeListener(EditorContextImpl.this.editorObservableListener);
                    }
                    EditorContextImpl.this.currentEditorCookie = null;
                }
                EditorContextImpl.this.refreshProcessor.post((Runnable)this);
            } else if (this.type == EditorCookie.class) {
                Object object = EditorContextImpl.this.currentLock;
                synchronized (object) {
                    EditorContextImpl.this.currentURL = null;
                    if (EditorContextImpl.this.currentEditorCookie instanceof EditorCookie.Observable) {
                        ((EditorCookie.Observable)EditorContextImpl.this.currentEditorCookie).removePropertyChangeListener(EditorContextImpl.this.editorObservableListener);
                    }
                    EditorContextImpl.this.currentEditorCookie = null;
                }
                EditorContextImpl.this.refreshProcessor.post((Runnable)this);
            } else if (this.type == Node.class) {
                Object object = EditorContextImpl.this.currentLock;
                synchronized (object) {
                }
                EditorContextImpl.this.refreshProcessor.post((Runnable)this);
            }
        }

        public void run() {
            EditorContextImpl.this.pcs.firePropertyChange("currentNodes", null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.type == TopComponent.class) {
                EditorContextImpl.this.refreshProcessor.post((Runnable)this);
            } else if (propertyChangeEvent.getPropertyName().equals("openedPanes")) {
                Object object = EditorContextImpl.this.currentLock;
                synchronized (object) {
                    if (EditorContextImpl.this.currentEditorCookie != null && EditorContextImpl.this.currentEditorCookie.getOpenedPanes() == null) {
                        EditorContextImpl.this.currentEditorCookie = null;
                    }
                }
                EditorContextImpl.this.pcs.firePropertyChange("openedPanes", null, null);
            }
        }
    }
}

