/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.netbeans.modules.editor.highlights.spi.Highlighter;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class DebuggerAnnotation
extends Annotation {
    private Line line;
    private String type;

    DebuggerAnnotation(String string, Line line) {
        this.type = string;
        this.line = line;
        this.attach((Annotatable)line);
    }

    DebuggerAnnotation(String string, Line.Part part) {
        this.type = string;
        this.line = part.getLine();
        this.attach((Annotatable)part);
    }

    DebuggerAnnotation(String string, Highlight highlight, FileObject fileObject) {
        this.type = string;
        this.attach(new HighlightAnnotatable(highlight, fileObject));
    }

    public String getAnnotationType() {
        return this.type;
    }

    Line getLine() {
        return this.line;
    }

    public String getShortDescription() {
        if (this.type.endsWith("_broken")) {
            return NbBundle.getBundle(DebuggerAnnotation.class).getString("TOOLTIP_BREAKPOINT_BROKEN");
        }
        if (this.type == "Breakpoint") {
            return NbBundle.getBundle(DebuggerAnnotation.class).getString("TOOLTIP_BREAKPOINT");
        }
        if (this.type == "DisabledBreakpoint") {
            return NbBundle.getBundle(DebuggerAnnotation.class).getString("TOOLTIP_DISABLED_BREAKPOINT");
        }
        if (this.type == "CondBreakpoint") {
            return NbBundle.getBundle(DebuggerAnnotation.class).getString("TOOLTIP_CONDITIONAL_BREAKPOINT");
        }
        if (this.type == "DisabledCondBreakpoint") {
            return NbBundle.getBundle(DebuggerAnnotation.class).getString("TOOLTIP_DISABLED_CONDITIONAL_BREAKPOINT");
        }
        if (this.type == "CurrentPC") {
            return NbBundle.getMessage(DebuggerAnnotation.class, (String)"TOOLTIP_CURRENT_PC");
        }
        if (this.type == "CurrentExpressionLine") {
            return NbBundle.getMessage(DebuggerAnnotation.class, (String)"TOOLTIP_CURRENT_EXP_LINE");
        }
        if (this.type == "CallSite") {
            return NbBundle.getBundle(DebuggerAnnotation.class).getString("TOOLTIP_CALLSITE");
        }
        if (this.type == "FieldBreakpoint") {
            return NbBundle.getBundle(DebuggerAnnotation.class).getString("TOOLTIP_FIELD_BREAKPOINT");
        }
        if (this.type == "DisabledFieldBreakpoint") {
            return NbBundle.getBundle(DebuggerAnnotation.class).getString("TOOLTIP_DISABLED_FIELD_BREAKPOINT");
        }
        if (this.type == "MethodBreakpoint") {
            return NbBundle.getBundle(DebuggerAnnotation.class).getString("TOOLTIP_METHOD_BREAKPOINT");
        }
        if (this.type == "DisabledMethodBreakpoint") {
            return NbBundle.getBundle(DebuggerAnnotation.class).getString("TOOLTIP_DISABLED_METHOD_BREAKPOINT");
        }
        ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unknown breakpoint type '" + this.type + "'."));
        return null;
    }

    private static final class HighlightAnnotatable
    extends Annotatable {
        private static Map highlightsByFiles = new HashMap();
        private Highlight highlight;
        private FileObject fo;

        public HighlightAnnotatable(Highlight highlight, FileObject fileObject) {
            this.highlight = highlight;
            this.fo = fileObject;
        }

        public String getText() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addAnnotation(Annotation annotation) {
            HashSet<Highlight> hashSet;
            Map map = highlightsByFiles;
            synchronized (map) {
                hashSet = (HashSet<Highlight>)highlightsByFiles.get(this.fo);
                if (hashSet == null) {
                    hashSet = new HashSet<Highlight>();
                    highlightsByFiles.put(this.fo, hashSet);
                }
                hashSet.add(this.highlight);
            }
            Highlighter.getDefault().setHighlights(this.fo, ((Object)((Object)this)).getClass().getName(), hashSet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeAnnotation(Annotation annotation) {
            Collection collection;
            Map map = highlightsByFiles;
            synchronized (map) {
                collection = (Collection)highlightsByFiles.get(this.fo);
                if (collection == null) {
                    collection = Collections.EMPTY_SET;
                } else {
                    collection.remove(this.highlight);
                    if (collection.isEmpty()) {
                        highlightsByFiles.remove(this.fo);
                    }
                }
            }
            Highlighter.getDefault().setHighlights(this.fo, ((Object)((Object)this)).getClass().getName(), collection);
        }
    }
}

