/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.modules.debugger.jpda.projects.ExpressionScanner;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AST2Bytecode {
    private AST2Bytecode() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static EditorContext.Operation[] matchSourceTree2Bytecode(CompilationUnitTree compilationUnitTree, CompilationController compilationController, List<Tree> list, ExpressionScanner.ExpressionsInfo expressionsInfo, byte[] byArray, int[] nArray, byte[] byArray2, OperationCreationDelegate operationCreationDelegate, Map<Tree, EditorContext.Operation> map) {
        int n;
        Trees trees = compilationController.getTrees();
        Types types = compilationController.getTypes();
        SourcePositions sourcePositions = trees.getSourcePositions();
        if (list == null) {
            return null;
        }
        if (nArray == null) {
            return null;
        }
        int n2 = list.size();
        ArrayList<EditorContext.Operation> arrayList = new ArrayList<EditorContext.Operation>(n2);
        LineMap lineMap = compilationUnitTree.getLineMap();
        int n3 = 0;
        int n4 = nArray[n3];
        int n5 = nArray[n3 + 1];
        for (n = 0; n < n2; ++n) {
            Tree tree = list.get(n);
            Tree.Kind kind = tree.getKind();
            EditorContext.Operation operation = null;
            if (kind.equals((Object)Tree.Kind.METHOD_INVOCATION) || kind.equals((Object)Tree.Kind.NEW_CLASS)) {
                int n6;
                while (true) {
                    if (!AST2Bytecode.isMethodCall(n6 = byArray[n4] & 0xFF) && (n4 += AST2Bytecode.getInstrSize(n6, byArray, n4)) < n5) {
                        continue;
                    }
                    if (n4 < n5 || n3 + 2 >= nArray.length) break;
                    n4 = nArray[n3 += 2];
                    n5 = nArray[n3 + 1];
                }
                if (n4 >= n5) return null;
                if (!compilationController.getTreeUtilities().isSynthetic(compilationController.getTrees().getPath(compilationUnitTree, tree))) {
                    String string;
                    AnnotatedConstruct annotatedConstruct;
                    Object object;
                    Object object2;
                    String string2;
                    ExpressionTree expressionTree;
                    int n7 = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
                    EditorContext.Position position = operationCreationDelegate.createPosition(n7, (int)lineMap.getLineNumber(n7), (int)lineMap.getColumnNumber(n7));
                    n7 = (int)sourcePositions.getEndPosition(compilationUnitTree, tree);
                    EditorContext.Position position2 = operationCreationDelegate.createPosition(n7, (int)lineMap.getLineNumber(n7), (int)lineMap.getColumnNumber(n7));
                    boolean bl = false;
                    if (kind.equals((Object)Tree.Kind.NEW_CLASS)) {
                        expressionTree = ((NewClassTree)tree).getIdentifier();
                        string2 = "<init>";
                        object2 = TreePath.getPath(compilationUnitTree, (Tree)expressionTree);
                        object = trees.getTypeMirror((TreePath)object2);
                        if (object.getKind() == TypeKind.ERROR) {
                            return null;
                        }
                        assert (object.getKind() == TypeKind.DECLARED);
                        annotatedConstruct = (TypeElement)types.asElement((TypeMirror)object);
                        string = ElementUtilities.getBinaryName((TypeElement)annotatedConstruct);
                    } else {
                        expressionTree = ((MethodInvocationTree)tree).getMethodSelect();
                        if (expressionTree.getKind() == Tree.Kind.IDENTIFIER) {
                            string2 = ((IdentifierTree)expressionTree).getName().toString();
                            object2 = TreePath.getPath(compilationUnitTree, (Tree)expressionTree);
                            object = trees.getScope((TreePath)object2).getEnclosingClass();
                            if (object == null) {
                                return null;
                            }
                            string = ElementUtilities.getBinaryName((TypeElement)object);
                        } else {
                            TypeElement typeElement;
                            string2 = ((MemberSelectTree)expressionTree).getIdentifier().toString();
                            bl = true;
                            object2 = ((MemberSelectTree)expressionTree).getExpression();
                            object = TreePath.getPath(compilationUnitTree, (Tree)object2);
                            annotatedConstruct = trees.getTypeMirror((TreePath)object);
                            if (annotatedConstruct.getKind() == TypeKind.ERROR) {
                                return null;
                            }
                            String string3 = "";
                            while (annotatedConstruct.getKind() == TypeKind.ARRAY) {
                                annotatedConstruct = ((ArrayType)annotatedConstruct).getComponentType();
                                string3 = string3 + "[]";
                            }
                            if (annotatedConstruct.getKind() == TypeKind.DECLARED) {
                                typeElement = (TypeElement)types.asElement((TypeMirror)annotatedConstruct);
                            } else if (annotatedConstruct.getKind() == TypeKind.TYPEVAR) {
                                TypeParameterElement typeParameterElement = (TypeParameterElement)types.asElement((TypeMirror)annotatedConstruct);
                                List<? extends TypeMirror> list2 = typeParameterElement.getBounds();
                                if (list2.size() != 1) return null;
                                annotatedConstruct = list2.get(0);
                                if (annotatedConstruct.getKind() != TypeKind.DECLARED) return null;
                                typeElement = (TypeElement)types.asElement((TypeMirror)annotatedConstruct);
                            } else {
                                ErrorManager.getDefault().notify((Throwable)new IllegalStateException("Unexpected type " + annotatedConstruct + " in " + list));
                                return null;
                            }
                            string = ElementUtilities.getBinaryName((TypeElement)typeElement) + string3;
                        }
                    }
                    n7 = (int)sourcePositions.getEndPosition(compilationUnitTree, expressionTree);
                    object2 = operationCreationDelegate.createPosition(n7, (int)lineMap.getLineNumber(n7), (int)lineMap.getColumnNumber(n7));
                    n7 = bl ? (n7 -= string2.length()) : (int)sourcePositions.getStartPosition(compilationUnitTree, expressionTree);
                    object = operationCreationDelegate.createPosition(n7, (int)lineMap.getLineNumber(n7), (int)lineMap.getColumnNumber(n7));
                    operation = operationCreationDelegate.createMethodOperation(position, position2, (EditorContext.Position)object, (EditorContext.Position)object2, string2, string, n4);
                    arrayList.add(operation);
                }
                n4 += AST2Bytecode.getInstrSize(n6, byArray, n4);
            }
            if (operation == null) continue;
            map.put(tree, operation);
        }
        while (true) {
            if (n4 < n5) {
                n = byArray[n4] & 0xFF;
                if (AST2Bytecode.isMethodCall(n)) {
                    return null;
                }
                n4 += AST2Bytecode.getInstrSize(n, byArray, n4);
                continue;
            }
            if (n3 + 2 >= nArray.length) return arrayList.toArray(new EditorContext.Operation[0]);
            n4 = nArray[n3 += 2];
            n5 = nArray[n3 + 1];
        }
    }

    private static boolean isMethodCall(int n) {
        return n >= 182 && n <= 185;
    }

    private static int getInstrSize(int n, byte[] byArray, long l) {
        if (n <= 15) {
            return 1;
        }
        if (n == 16) {
            return 2;
        }
        if (n == 17) {
            return 3;
        }
        if (n == 18) {
            return 2;
        }
        if (n <= 20) {
            return 3;
        }
        if (n <= 25) {
            return 2;
        }
        if (n <= 53) {
            return 1;
        }
        if (n <= 58) {
            return 2;
        }
        if (n <= 86) {
            return 1;
        }
        if (n <= 94) {
            return 1;
        }
        if (n <= 131) {
            return 1;
        }
        if (n <= 132) {
            return 3;
        }
        if (n <= 147) {
            return 1;
        }
        if (n <= 152) {
            return 1;
        }
        if (n <= 168) {
            return 3;
        }
        if (n <= 169) {
            return 2;
        }
        if (n == 170) {
            return AST2Bytecode.tableswitchSize(byArray, l);
        }
        if (n == 171) {
            return AST2Bytecode.lookupswitchSize(byArray, l);
        }
        if (n <= 177) {
            return 1;
        }
        if (n <= 184) {
            return 3;
        }
        if (n == 185) {
            return 5;
        }
        if (n == 187) {
            return 3;
        }
        if (n == 188) {
            return 2;
        }
        if (n == 189) {
            return 3;
        }
        if (n <= 191) {
            return 1;
        }
        if (n <= 193) {
            return 3;
        }
        if (n <= 195) {
            return 1;
        }
        if (n == 196) {
            return AST2Bytecode.wideSize(byArray, l);
        }
        if (n == 197) {
            return 4;
        }
        if (n <= 199) {
            return 3;
        }
        if (n <= 201) {
            return 5;
        }
        return 1;
    }

    private static int tableswitchSize(byte[] byArray, long l) {
        int n = 4 - (int)l % 4;
        int n2 = (int)l + n;
        int n3 = AST2Bytecode.readInt(byArray, n2 += 4);
        int n4 = AST2Bytecode.readInt(byArray, n2 += 4);
        n2 += 4;
        return (n2 += n4 - n3 + 1 << 2) - (int)l;
    }

    private static int lookupswitchSize(byte[] byArray, long l) {
        int n = 4 - (int)l % 4;
        int n2 = (int)l + n;
        int n3 = AST2Bytecode.readInt(byArray, n2 += 4);
        n2 += 4;
        return (n2 += n3 << 3) - (int)l;
    }

    private static int wideSize(byte[] byArray, long l) {
        int n = byArray[(int)l + 1] & 0xFF;
        if (n == 132) {
            return 6;
        }
        return 4;
    }

    private static int readUnsignedShort(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private static int readInt(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    static interface OperationCreationDelegate {
        public EditorContext.Operation createMethodOperation(EditorContext.Position var1, EditorContext.Position var2, EditorContext.Position var3, EditorContext.Position var4, String var5, String var6, int var7);

        public EditorContext.Position createPosition(int var1, int var2, int var3);

        public void addNextOperationTo(EditorContext.Operation var1, EditorContext.Operation var2);
    }
}

