/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.wsdlextensions.jms.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.wsdlextensions.jms.validator.ValidationException;

public class RedeliveryHandlingParser {
    public static boolean checkValid(String string) {
        try {
            RedeliveryHandlingParser.parse(string, "nothing", "Queue");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Action[] parse(String string, String string2, String string3) throws Exception {
        if (string.trim().length() == 0) {
            return new Action[]{new VoidAction()};
        }
        String[] stringArray = string.split("\\s*;\\s*");
        Action[] actionArray = new Action[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string4;
                String string5;
                boolean bl = i == stringArray.length - 1;
                Matcher matcher = Delay.sPattern.matcher(stringArray[i]);
                if (matcher.matches()) {
                    string5 = matcher.group(1);
                    string4 = matcher.group(2);
                    actionArray[i] = new Delay(Integer.parseInt(string5), Long.parseLong(string4));
                    n = actionArray[i].checkLast(n);
                    continue;
                }
                matcher = Delete.sPattern.matcher(stringArray[i]);
                if (matcher.matches()) {
                    string5 = matcher.group(1);
                    if (!bl) {
                        throw new Exception("Move command should be last command");
                    }
                    actionArray[i] = new Delete(Integer.parseInt(string5));
                    n = actionArray[i].checkLast(n);
                    continue;
                }
                matcher = Move.sPattern.matcher(stringArray[i]);
                if (matcher.matches()) {
                    string5 = matcher.group(1);
                    string4 = matcher.group(2);
                    Matcher matcher2 = Move.sArgPattern.matcher(string4);
                    if (!matcher2.matches()) {
                        throw new Exception("Wrong arguments: should match " + Move.ARGPATTERN);
                    }
                    String string6 = matcher2.group(1);
                    String string7 = matcher2.group(2);
                    if (!bl) {
                        throw new Exception("Move command should be last command");
                    }
                    string7 = string7.replaceAll("\\$", string2);
                    actionArray[i] = new Move(Integer.parseInt(string5), string6, string7, string3);
                    n = actionArray[i].checkLast(n);
                    continue;
                }
                throw new ValidationException("Action '" + stringArray[i] + "' is not a valid action");
            }
            catch (Exception exception) {
                throw new ValidationException("Could not parse [" + string + "]: error [" + exception + "] in element number " + i + ": [" + stringArray[i] + "]", exception);
            }
        }
        return actionArray;
    }

    public static class Delete
    extends Action {
        public static final String PATTERN = "(\\d+):\\s?delete";
        public static Pattern sPattern = Pattern.compile("(\\d+):\\s?delete");

        public Delete(int n) throws Exception {
            super(n);
        }

        public String toString() {
            return "At " + this.getAt() + ": delete";
        }
    }

    public static class Move
    extends Action {
        public static final String PATTERN = "(\\d+):\\s?move\\((.*)\\)";
        public static Pattern sPattern = Pattern.compile("(\\d+):\\s?move\\((.*)\\)");
        public static String ARGPATTERN = "(queue|same|topic)\\s?:\\s?(.+)";
        public static Pattern sArgPattern = Pattern.compile(ARGPATTERN);
        private String mType;
        private String mName;

        public Move(int n, String string, String string2, String string3) throws ValidationException {
            super(n);
            this.mName = string2;
            if (!"Queue".equals(string3) && !"Topic".equals(string3)) {
                throw new ValidationException("Invalid destination type [" + string3 + "]");
            }
            if ("same".equals(string)) {
                this.mType = string3;
            } else if ("queue".equals(string)) {
                this.mType = "Queue";
            } else if ("topic".equals(string)) {
                this.mType = "Topic";
            } else {
                throw new ValidationException("Invalid type [" + string + "]");
            }
        }

        public String getDestinationType() {
            return this.mType;
        }

        public boolean isQueue() {
            return this.mType.equals("Queue");
        }

        public boolean isTopic() {
            return this.mType.equals("Topic");
        }

        public String getDestinationName() {
            return this.mName;
        }

        public String toString() {
            return "At " + this.getAt() + ": move to " + this.mType + " with name [" + this.mName + "]";
        }
    }

    public static class Delay
    extends Action {
        public static final String PATTERN = "(\\d+):\\s?(\\d+)";
        public static Pattern sPattern = Pattern.compile("(\\d+):\\s?(\\d+)");
        private long mDelay;

        public Delay(int n, long l) throws Exception {
            super(n);
            if (l > 5000L && l != Integer.MAX_VALUE) {
                throw new Exception("Delay of [" + l + "] exceeds maximum of 5000 ms");
            }
            this.mDelay = l;
        }

        public long getHowLong() {
            return this.mDelay;
        }

        public String toString() {
            return "At " + this.getAt() + ": delay for " + this.mDelay + " ms";
        }
    }

    public static class VoidAction
    extends Action {
        public VoidAction() throws ValidationException {
            super(1);
        }

        public String toString() {
            return "Void";
        }
    }

    public static abstract class Action {
        private int mAt;

        public Action(int n) throws ValidationException {
            if (n <= 0) {
                throw new ValidationException("Index " + n + " should be > 0");
            }
            if (n > 5000) {
                throw new ValidationException("Index " + n + " should be <= 5000");
            }
            this.mAt = n;
        }

        public int getAt() {
            return this.mAt;
        }

        public int checkLast(int n) throws Exception {
            if (n == this.mAt) {
                throw new Exception("Duplicate entry at: " + n);
            }
            if (n >= this.mAt) {
                throw new Exception("Should be properly ordered: " + n + " >= " + this.mAt);
            }
            return this.mAt;
        }
    }
}

