/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.ui;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.xml.jaxb.cfg.schema.Schema;
import org.netbeans.modules.xml.jaxb.ui.JAXBWizBindingCfgPanel;
import org.netbeans.modules.xml.jaxb.util.ProjectHelper;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBWizardIterator
implements TemplateWizard.Iterator {
    private WizardDescriptor wizardDescriptor;
    private WizardDescriptor.Panel[] panels = null;
    private int cursor;
    private Project project;

    public JAXBWizardIterator() {
    }

    public JAXBWizardIterator(Project project) {
        this.project = project;
        this.initWizardPanels();
    }

    public static JAXBWizardIterator create() {
        return new JAXBWizardIterator();
    }

    private void initWizardPanels() {
        this.cursor = 0;
        this.panels = new WizardDescriptor.Panel[]{new JAXBWizBindingCfgPanel()};
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.cursor];
    }

    public boolean hasNext() {
        return this.cursor < this.panels.length - 1;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public String name() {
        return NbBundle.getMessage(this.getClass(), (String)"LBL_JAXBWizTitle");
    }

    public void nextPanel() {
        ++this.cursor;
    }

    public void previousPanel() {
        --this.cursor;
    }

    public boolean hasPrevious() {
        return this.cursor > 0;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
        Object object = wizardDescriptor.getProperty("WizardPanel_contentData");
        String[] stringArray = null;
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = this.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
    }

    public Set instantiate() throws IOException {
        return new HashSet();
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = null;
    }

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)templateWizard);
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        try {
            Schema schema = ProjectHelper.importResources(this.project, (WizardDescriptor)templateWizard, null);
            ProjectHelper.addSchema2Model(this.project, schema);
            ProjectHelper.compileXSDs(this.project, true);
        }
        catch (Throwable throwable) {
            String string = NbBundle.getMessage(JAXBWizardIterator.class, (String)"MSG_ErrorReadingSchema");
            templateWizard.putProperty("WizardPanel_errorMessage", (Object)string);
            throw new IOException(string);
        }
        return Collections.singleton(dataObject);
    }

    private String[] createSteps(String[] stringArray, WizardDescriptor.Panel[] panelArray) {
        int n = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        } else if (stringArray.length > 0) {
            n = "...".equals(stringArray[stringArray.length - 1]) ? 1 : 0;
        }
        String[] stringArray2 = new String[stringArray.length - n + panelArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - n ? stringArray[i] : panelArray[i - stringArray.length + n].getComponent().getName();
        }
        return stringArray2;
    }

    public void initialize(TemplateWizard templateWizard) {
        this.project = Templates.getProject((WizardDescriptor)templateWizard);
        List<String> list = ProjectHelper.getSchemaNames(this.project);
        templateWizard.putProperty("jaxb.cfg.existingSchemaNames", list);
        this.initWizardPanels();
        Object object = templateWizard.getProperty("WizardPanel_contentData");
        String[] stringArray = null;
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = this.createSteps(stringArray, this.panels);
        String string = ProjectUtils.getInformation((Project)this.project).getName();
        templateWizard.putProperty("project.name", (Object)string);
        templateWizard.putProperty("project.dir", (Object)FileUtil.toFile((FileObject)this.project.getProjectDirectory()));
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
    }

    public void uninitialize(TemplateWizard templateWizard) {
        if (templateWizard.getValue() == TemplateWizard.FINISH_OPTION) {
            this.project = null;
        }
    }
}

