/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxws.spi;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.project.config.ServiceAlreadyExistsExeption;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperGenerator;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperHandler;
import org.netbeans.modules.websvc.jaxws.spi.JAXWSSupportImpl;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectJAXWSSupport
implements JAXWSSupportImpl {
    private Project project;
    private AntProjectHelper antProjectHelper;

    public ProjectJAXWSSupport(Project project, AntProjectHelper antProjectHelper) {
        this.project = project;
        this.antProjectHelper = antProjectHelper;
    }

    @Override
    public void removeService(String string) {
        Service service;
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && (service = jaxWsModel.findServiceByName(string)) != null) {
            jaxWsModel.removeService(string);
            this.writeJaxWsModel(jaxWsModel);
            WSUtils.removeImplClass((Project)this.project, (String)service.getImplementationClass());
        }
    }

    @Override
    public void serviceFromJavaRemoved(String string) {
    }

    @Override
    public boolean isFromWSDL(String string) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        Service service = jaxWsModel.findServiceByName(string);
        return service != null && service.getWsdlUrl() != null;
    }

    @Override
    public String getServiceImpl(String string) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            Service service = jaxWsModel.findServiceByName(string);
            return service == null ? null : service.getImplementationClass();
        }
        return null;
    }

    @Override
    public AntProjectHelper getAntProjectHelper() {
        return this.antProjectHelper;
    }

    @Override
    public void addService(String string, String string2, boolean bl) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            Boolean bl2 = jaxWsModel.getJsr109();
            if ((bl2 == null || Boolean.TRUE.equals(bl2)) && !bl) {
                jaxWsModel.setJsr109(Boolean.FALSE);
                this.writeJaxWsModel(jaxWsModel);
            } else if (Boolean.FALSE.equals(bl2) && bl) {
                jaxWsModel.setJsr109(Boolean.TRUE);
                this.writeJaxWsModel(jaxWsModel);
            }
        }
        if (!bl) {
            try {
                this.addJaxwsArtifacts(this.project, string, string2);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        } else {
            try {
                this.addServletElement(this.project, string, string2);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    protected abstract void addJaxwsArtifacts(Project var1, String var2, String var3) throws Exception;

    protected void addServletElement(Project project, String string, String string2) throws IOException {
    }

    @Override
    public String addService(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            WsdlWrapperHandler wsdlWrapperHandler;
            FileObject fileObject;
            boolean bl3;
            String string7;
            block36: {
                string7 = WSUtils.findProperServiceName((String)string, (JaxWsModel)jaxWsModel);
                bl3 = false;
                FileObject fileObject2 = this.project.getProjectDirectory();
                FileObject fileObject3 = fileObject2.getFileObject("build/generated/wsimport/service");
                if (fileObject3 != null) {
                    fileObject3.getChildren(true);
                } else {
                    try {
                        FileUtil.createFolder((FileObject)fileObject2, (String)"build/generated/wsimport/service");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                FileObject fileObject4 = null;
                try {
                    File file;
                    Object object;
                    fileObject = this.getLocalWsdlFolderForService(string7, true);
                    fileObject4 = WSUtils.retrieveResource((FileObject)fileObject, (URI)new URI(string3));
                    if (fileObject4 == null) break block36;
                    wsdlWrapperHandler = null;
                    try {
                        wsdlWrapperHandler = WsdlWrapperGenerator.parse(fileObject4.getURL().toExternalForm());
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        ErrorManager.getDefault().notify(1, (Throwable)parserConfigurationException);
                    }
                    catch (SAXException sAXException) {
                        ErrorManager.getDefault().notify(1, (Throwable)sAXException);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                    if (!wsdlWrapperHandler.isServiceElement()) {
                        object = new StreamSource(fileObject4.getURL().toExternalForm());
                        try {
                            file = new File(FileUtil.toFile((FileObject)fileObject4.getParent()), WsdlWrapperGenerator.getWrapperName(fileObject4.getURL()));
                            if (!file.exists()) {
                                try {
                                    file.createNewFile();
                                }
                                catch (IOException iOException) {
                                    ErrorManager.getDefault().notify(4096, (Throwable)iOException);
                                }
                            }
                            if (file.exists()) {
                                WsdlWrapperGenerator.generateWrapperWSDLContent(file, (StreamSource)object, wsdlWrapperHandler.getTargetNsPrefix(), fileObject4.getNameExt());
                                fileObject4 = FileUtil.toFileObject((File)file);
                            }
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                    }
                    if (((object = jaxWsModel.getJsr109()) == null || Boolean.TRUE.equals(object)) && !bl) {
                        jaxWsModel.setJsr109(Boolean.FALSE);
                    } else if (Boolean.FALSE.equals(object) && bl) {
                        jaxWsModel.setJsr109(Boolean.TRUE);
                    }
                    file = null;
                    try {
                        file = jaxWsModel.addService(string7, string2, string3, string4, string5, string6);
                    }
                    catch (ServiceAlreadyExistsExeption serviceAlreadyExistsExeption) {
                        ErrorManager.getDefault().notify((Throwable)serviceAlreadyExistsExeption);
                    }
                    file.setUseProvider(bl2);
                    String string8 = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject4);
                    file.setLocalWsdlFile(string8);
                    FileObject fileObject5 = this.getCatalogFileObject();
                    if (fileObject5 != null) {
                        file.setCatalogFile("catalog.xml");
                    }
                    this.writeJaxWsModel(jaxWsModel);
                    bl3 = true;
                }
                catch (URISyntaxException uRISyntaxException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)uRISyntaxException);
                }
                catch (UnknownHostException unknownHostException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)unknownHostException);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)iOException);
                }
            }
            if (bl3) {
                if (!bl) {
                    try {
                        this.addJaxwsArtifacts(this.project, string4, string2);
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                    }
                } else {
                    try {
                        this.addServletElement(this.project, string4, string2);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
                fileObject = this.project.getProjectDirectory().getFileObject("nbproject/build-impl.xml");
                try {
                    wsdlWrapperHandler = ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{"wsimport-service-" + string7}, null);
                    wsdlWrapperHandler.waitFinished();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().log(iOException.getLocalizedMessage());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().log(illegalArgumentException.getLocalizedMessage());
                }
                return string7;
            }
        }
        return null;
    }

    @Override
    public List<Service> getServices() {
        Service[] serviceArray;
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && (serviceArray = jaxWsModel.getServices()) != null) {
            ArrayList<Service> arrayList = new ArrayList<Service>();
            for (int i = 0; i < serviceArray.length; ++i) {
                arrayList.add(serviceArray[i]);
            }
            return arrayList;
        }
        return new ArrayList<Service>();
    }

    private void writeJaxWsModel(final JaxWsModel jaxWsModel) {
        try {
            final FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject/jax-ws.xml");
            if (fileObject != null) {
                fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        FileLock fileLock = null;
                        OutputStream outputStream = null;
                        try {
                            fileLock = fileObject.lock();
                            outputStream = fileObject.getOutputStream(fileLock);
                            jaxWsModel.write(outputStream);
                            outputStream.close();
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify((Throwable)iOException);
                        }
                        finally {
                            if (outputStream != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (fileLock != null) {
                                fileLock.releaseLock();
                            }
                        }
                    }
                });
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    @Override
    public FileObject getLocalWsdlFolderForService(String string, boolean bl) {
        return this.getArtifactsFolder(string, bl, true);
    }

    @Override
    public FileObject getBindingsFolderForService(String string, boolean bl) {
        return this.getArtifactsFolder(string, bl, false);
    }

    private FileObject getArtifactsFolder(String string, boolean bl, boolean bl2) {
        String string2 = bl2 ? "wsdl" : "bindings";
        FileObject fileObject = this.getXmlArtifactsRoot();
        if (fileObject == null) {
            assert (!bl) : "Cannot create XML artifacts folder";
            return null;
        }
        FileObject fileObject2 = fileObject.getFileObject("xml-resources/web-services/" + string + "/" + string2);
        if (fileObject2 == null && bl) {
            try {
                FileObject fileObject3;
                FileObject fileObject4;
                FileObject fileObject5 = fileObject.getFileObject("xml-resources");
                if (fileObject5 == null) {
                    fileObject5 = fileObject.createFolder("xml-resources");
                }
                if ((fileObject4 = fileObject5.getFileObject("web-services")) == null) {
                    fileObject4 = fileObject5.createFolder("web-services");
                }
                if ((fileObject3 = fileObject4.getFileObject(string)) == null) {
                    fileObject3 = fileObject4.createFolder(string);
                }
                if ((fileObject2 = fileObject3.getFileObject(string2)) == null) {
                    fileObject2 = fileObject3.createFolder(string2);
                }
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return fileObject2;
    }

    protected FileObject getXmlArtifactsRoot() {
        return this.project.getProjectDirectory();
    }

    private FileObject getCatalogFileObject() {
        return this.project.getProjectDirectory().getFileObject("catalog.xml");
    }

    @Override
    public URL getCatalog() {
        try {
            FileObject fileObject = this.getCatalogFileObject();
            return fileObject == null ? null : fileObject.getURL();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getWsdlFolderForService(String string) throws IOException {
        FileObject fileObject = this.getWsdlFolder(true);
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            FileLock fileLock = fileObject2.lock();
            try {
                fileObject2.delete(fileLock);
            }
            finally {
                fileLock.releaseLock();
            }
        }
        return fileObject.createFolder(string);
    }

    @Override
    public abstract FileObject getWsdlFolder(boolean var1) throws IOException;

    @Override
    public abstract String getWsdlLocation(String var1);

    @Override
    public abstract MetadataModel<WebservicesMetadata> getWebservicesMetadataModel();
}

