/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardPanel;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicWizardIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator<WizardDescriptor> {
    private int position = 0;
    private PrivateWizardPanel[] wizardPanels;

    protected BasicWizardIterator() {
    }

    protected abstract Panel[] createPanels(WizardDescriptor var1);

    public void initialize(WizardDescriptor wizardDescriptor) {
        String[] stringArray = null;
        Object object = wizardDescriptor.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        this.position = 0;
        Panel[] panelArray = this.createPanels(wizardDescriptor);
        String[] stringArray2 = BasicWizardIterator.createSteps(stringArray, panelArray);
        this.wizardPanels = new PrivateWizardPanel[panelArray.length];
        for (int i = 0; i < panelArray.length; ++i) {
            this.wizardPanels[i] = new PrivateWizardPanel(panelArray[i], stringArray2, i);
        }
    }

    private static String[] createSteps(String[] stringArray, Panel[] panelArray) {
        assert (panelArray != null);
        int n = 0;
        if (stringArray == null) {
            stringArray = new String[]{};
        } else if (stringArray.length > 0) {
            n = "...".equals(stringArray[stringArray.length - 1]) ? 1 : 0;
        }
        String[] stringArray2 = new String[stringArray.length - n + panelArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - n ? stringArray[i] : panelArray[i - stringArray.length + n].getPanelName();
        }
        return stringArray2;
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wizardPanels = null;
    }

    public String name() {
        return ((PrivateWizardPanel)this.current()).getPanel().getPanelName();
    }

    public boolean hasNext() {
        return this.position < this.wizardPanels.length - 1;
    }

    public boolean hasPrevious() {
        return this.position > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.position;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.position;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.wizardPanels[this.position];
    }

    protected final String getMessage(String string) {
        return NbBundle.getMessage(this.getClass(), (String)string);
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    public static Set<FileObject> getCreatedFiles(CreatedModifiedFiles createdModifiedFiles, Project project) throws IOException {
        HashSet<DataObject> hashSet = new HashSet<DataObject>();
        HashSet<FileObject> hashSet2 = new HashSet<FileObject>();
        for (String string : createdModifiedFiles.getCreatedPaths()) {
            FileObject fileObject = project.getProjectDirectory().getFileObject(string);
            assert (fileObject != null) : string;
            BasicWizardIterator.formatFile(fileObject);
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject == null || hashSet.size() >= 10 || !hashSet.add(dataObject)) continue;
            hashSet2.add(fileObject);
        }
        return hashSet2;
    }

    private static BaseDocument getDocument(FileObject fileObject) throws DataObjectNotFoundException, IOException {
        EditorCookie editorCookie;
        BaseDocument baseDocument = null;
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        if (dataObject != null && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null) {
            baseDocument = (BaseDocument)editorCookie.openDocument();
        }
        return baseDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void formatFile(FileObject fileObject) {
        assert (fileObject != null);
        BaseDocument baseDocument = null;
        boolean bl = false;
        try {
            baseDocument = BasicWizardIterator.getDocument(fileObject);
            if (baseDocument == null) {
                return;
            }
            Reformat reformat = Reformat.get((Document)baseDocument);
            reformat.lock();
            try {
                baseDocument.atomicLock();
                try {
                    reformat.reformat(0, baseDocument.getLength());
                }
                finally {
                    baseDocument.atomicUnlock();
                }
            }
            finally {
                reformat.unlock();
            }
            try {
                ((EditorCookie)DataObject.find((FileObject)fileObject).getCookie(EditorCookie.class)).saveDocument();
            }
            catch (IOException iOException) {
                Util.err.notify(1, (Throwable)iOException);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().log(16, "Cannot reformat the file: " + fileObject.getPath());
        }
    }

    private static final class PrivateWizardPanel
    extends BasicWizardPanel {
        private Panel panel;

        PrivateWizardPanel(Panel panel, String[] stringArray, int n) {
            super(panel.getSettings());
            panel.addPropertyChangeListener(this);
            panel.setName(panel.getPanelName());
            this.panel = panel;
            panel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(n));
            panel.putClientProperty("WizardPanel_contentData", stringArray);
        }

        private Panel getPanel() {
            return this.panel;
        }

        public Component getComponent() {
            return this.getPanel();
        }

        public void storeSettings(WizardDescriptor wizardDescriptor) {
            if (WizardDescriptor.NEXT_OPTION.equals(wizardDescriptor.getValue()) || WizardDescriptor.FINISH_OPTION.equals(wizardDescriptor.getValue())) {
                this.panel.storeToDataModel();
            }
            wizardDescriptor.putProperty("NewFileWizard_Title", null);
        }

        public void readSettings(WizardDescriptor wizardDescriptor) {
            Object object = this.getPanel().getClientProperty("NewFileWizard_Title");
            if (object != null) {
                wizardDescriptor.putProperty("NewFileWizard_Title", object);
            }
            if (WizardDescriptor.NEXT_OPTION.equals(wizardDescriptor.getValue()) || wizardDescriptor.getValue() == null) {
                this.panel.readFromDataModel();
            }
        }

        public HelpCtx getHelp() {
            return this.getPanel().getHelp();
        }
    }

    public static class BasicDataModel {
        private Project project;
        private NbModuleProvider module;
        private SourceGroup sourceRootGroup;
        private String packageName;

        public BasicDataModel(WizardDescriptor wizardDescriptor) {
            Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
            if (project == null) {
                throw new IllegalArgumentException();
            }
            this.module = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
            if (this.module == null) {
                throw new IllegalArgumentException(project.getClass().toString());
            }
            this.project = project;
            FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)wizardDescriptor);
            if (fileObject != null) {
                Sources sources = ProjectUtils.getSources((Project)this.project);
                SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
                for (int i = 0; i < sourceGroupArray.length; ++i) {
                    if (!FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject)) continue;
                    String string = FileUtil.getRelativePath((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject);
                    string = string.replace('/', '.');
                    this.setPackageName(string);
                    break;
                }
            }
        }

        public Project getProject() {
            return this.project;
        }

        public NbModuleProvider getModuleInfo() {
            return this.module;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setPackageName(String string) {
            this.packageName = string;
        }

        public SourceGroup getSourceRootGroup() {
            if (this.sourceRootGroup == null) {
                FileObject fileObject = this.getModuleInfo().getSourceDirectory();
                assert (fileObject != null);
                Sources sources = ProjectUtils.getSources((Project)this.project);
                SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
                for (int i = 0; this.sourceRootGroup == null && i < sourceGroupArray.length; ++i) {
                    if (!sourceGroupArray[i].getRootFolder().equals(fileObject)) continue;
                    this.sourceRootGroup = sourceGroupArray[i];
                }
            }
            return this.sourceRootGroup;
        }

        public String getDefaultPackagePath(String string, boolean bl) {
            return (bl ? this.getModuleInfo().getResourceDirectoryPath(false) : this.getModuleInfo().getSourceDirectoryPath()) + '/' + this.getPackageName().replace('.', '/') + '/' + string;
        }

        public String addCreateIconOperation(CreatedModifiedFiles createdModifiedFiles, String string) {
            FileObject fileObject = FileUtil.toFileObject((File)new File(string));
            String string2 = null;
            if (!FileUtil.isParentOf((FileObject)Util.getResourceDirectory(this.getProject()), (FileObject)fileObject)) {
                String string3 = this.getDefaultPackagePath(fileObject.getNameExt(), true);
                createdModifiedFiles.add(createdModifiedFiles.createFile(string3, fileObject));
                string2 = this.getPackageName().replace('.', '/') + '/' + fileObject.getNameExt();
            } else {
                string2 = FileUtil.getRelativePath((FileObject)Util.getResourceDirectory(this.getProject()), (FileObject)fileObject);
            }
            return string2;
        }
    }

    public static abstract class Panel
    extends BasicVisualPanel {
        protected Panel(WizardDescriptor wizardDescriptor) {
            super(wizardDescriptor);
        }

        protected abstract String getPanelName();

        protected abstract void storeToDataModel();

        protected abstract void readFromDataModel();

        protected abstract HelpCtx getHelp();
    }
}

